C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stack (trace, stkt, sum, wrk1, wrk2, V, nsampo,
     1                  dt, off, mute, xm, tm, nm, si, stk, nsamp,
     2                  joff, nattr, nit, li, di, work, freqs,
     3                  c_amp_spec,sig,ifc,qq,pf,thresh,mstart,it1,
     4                  mlast,v_mem,vc_mem,s_mem,sc_mem,mdim,a_mem,
     5                  m_mem,ssq_mem,fsr,nfreq,fwork,ngrp,pkthr,
     6                  ifmin,ifmax,ifdel,fwrk1,fwrk2,coefs,xnorm,
     7                  ierr,nmoap,mfreqo,amp_spec,iord,reftim,
     8                  itime,iatrwrd)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real     trace (*), stkt (*), wrk1 (*), wrk2 (*)
      real     V (*), sum (*), xm (*), tm (*)
      real     freqs(*), fwrk1(*), fwrk2(*), coefs(2,32)
      real     c_amp_spec(*),sig(*),work(*),amp_spec(*)
      real     v_mem(*),vc_mem(*),s_mem(*),sc_mem(*),a_mem(*)
      real     fwork(*), attr(19)
      integer  li, di
      logical  mute, stk, reverse, nmoap

      ierr = 0

c----
c   Input trace is NMO corrected if prestack
c----
      if (.not. stk .AND. nmoap) then
         reverse = .false.
         call nmo  (trace, V, wrk1, off, nsamp, dt, wrk2, reverse)
      else
         call vmov (trace, 1, wrk2, 1, nsamp)
      endif

c----
c   filter input trace (corrected or not) to freq limits of interest
c----
      init = 1
      call bwfilt (wrk2, trace, fwrk1, fwrk2, coefs,
     1             xnorm, 2, nsamp, init, 0)
      init = 0
      call vrvrs  (trace, 1, nsamp)
      call bwfilt (trace, wrk2, fwrk1, fwrk2, coefs,
     1             xnorm, 2, nsamp, init, 0)
      call vrvrs  (wrk2, 1, nsamp)

c----
c  option time-distance mute with 48ms ramp
c  as each trace comes in the offset is checked to set where within
c  the spread it lies and the time is linearly interpolated between
c  the 2 straddling distances
c----
      IF (mute .AND. .not.stk) THEN

         imr = ifix (48. / si)
         if (off .lt. xm(1) .OR. off .gt. xm(nm)) then
            tmute = 0
         else
            do  i = 2, nm
                if (off .ge. xm(i-1) .AND. off .le. xm(i)) then
                   s = (tm(i) - tm(i-1)) / (xm(i) - xm(i-1))
                   tmute = tm(i-1) + (off - xm(i-1)) * s
                endif
            enddo
         endif
         im = tmute / si

         if (im .gt. 0 .AND. im .le. nsamp) then
            im2 = im
            im1 = im - imr
            if (im1 .lt. 1) im1 = 1
            imm = im2 - im1 + 1

            do  i = 1, im1
                wrk2 (i) = 0.
            enddo
            do  i = im1+1, im2
                rmp = float(i-im1) / float(imm)
                wrk2 (i) = rmp * wrk2 (i)
            enddo
         endif

      ENDIF

      call vclr (trace, 1, nsamp)
      call vmov (wrk2(it1), 1, trace, 1, nit)
c----
c  take the nmo corrected filtered (and perhaps muted) trace and compute
c  desired attributes for offset bins (if prestack)
c  update the normalization vector
c----

      do  i = 1, nfreq
          sig (i) = 1.0
      enddo

c----
c   compute max entropy spectrum. extract peak frequency, Q, and decimated
c   frequency spectrum ( pf, qq, fwork[i=1,nfreqo]
c----
c----
c   first compute absolute peak amplitude and its location within window
c   if we encounter zeroes then exit and go on to next trace
c----
      call maxmgv (trace, 1, amax, locmax, nit)
      ireftim = reftim
      tmax = si * (ireftim - it1 + locmax - 1)

      if (amax .eq. 0.0) then
         write(LERR,*)'LI/DI ',li,di,' bypassed because of zeroes'
         ierr = 999
         return
      endif

c----
c   Now compute the peak and trough extreme values and their times
c----
      call maxv (trace, 1, pmax, locp, nit)
      pmaxt = si * (ireftim - it1 + locp -1)
      call minv (trace, 1, pmin, loct, nit)
      pmint = si * (ireftim - it1 + loct -1)

c----
c   Now compute the standard deviation over the window
c----
      call stddev (trace, std, nit)

c----
c   now compute attributes according to table:

C          = 1 Carrier
C          = 2 QUADRATURE
C          = 3 ENVELOPE
C          = 4 INST. PHASE
C          = 5 RESPONSE PHASE
C          = 6 INST. FREQUENCY
C          = 7 RESPONSE FREQUENCY
C          = 8 0-PHASE DECOMPOSITION
C          = 9 90-PHASE DECOMPOSITION
C          = 10 RESPONSE AMPLITUDE
C          = 11 RESPONSE LENGTH
C          = 12 ENVELOPE SKEWNESS
C          = 13 ENVELOPE RISE TIME
C          = 14 Instantaneous Bandwidth

c    Grab the value of these quantities at the location of maximum
c    absolute amplitude
c----
      NOP = 3
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      call maxmgv (wrk2, 1, emax, loce, nit)
      envmax = emax
      etime  = si * (ireftim - it1 + loce - 1)

      NOP = 5
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      rphmax = wrk2 (locmax)

      NOP = 6
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      xstfreq = wrk2 (loce)

      NOP = 7
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      rspfreq = wrk2 (loce)

      NOP = 10
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      rammax = wrk2 (locmax)

      NOP = 11
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      rlnmax = wrk2 (locmax)

      NOP = 14
      call asig3  (trace, wrk1, dt, nit, NOP, wrk2, pkthr)
      ribmax = wrk2 (locmax)

      call memqpf (trace,nit,work,freqs,ifmin,ifmax,ifdel,
     1    c_amp_spec,sig,dt,ifc,qq,pf,thresh,nfreqo,mfreqo,
     2    mstart,mlast,v_mem,vc_mem,s_mem,sc_mem,mdim,
     3    a_mem,m_mem,ssq_mem,nfreq,fwork,pwr,amp_spec,iord,tamp)

      attr (1)  = amax
      attr (2)  = tmax
      attr (3)  = pmax
      attr (4)  = pmaxt
      attr (5)  = pmin
      attr (6)  = pmint
      attr (7)  = std
      attr (8)  = pf
      attr (9)  = qq
      attr (10)  = envmax
      attr (11)  = etime
      attr (12)  = rphmax
      attr (13) = rammax
      attr (14) = rlnmax
      attr (15) = ribmax
      attr (16) = iatrwrd
      attr (17) = tamp
      attr (18) = xstfreq
      attr (19) = rspfreq

      call vclr (wrk2, 1, nsampo)

      do  i = 1, nattr
          wrk2 (i) = attr (i)
      enddo

      do  i = 1, mfreqo
          wrk2 (i + nattr) = fwork (i)
      enddo

      ioff = nattr + mfreqo

      IF (ngrp .gt. 1) THEN

         do  i = 1, nattr
             npntr = (joff-1) * nattr + ioff
             wrk2 (npntr + i) = attr (i)
         enddo

         ioff = ioff + nattr * ngrp + 2 * nattr

         do  i = 1, mfreqo
             npntr = (joff-1) * mfreqo + ioff
             wrk2 (npntr + i) = fwork (i)
         enddo

      ENDIF

      ii = 0
      do  i = nsampo-nit+1, nsampo
          ii = ii + 1
          wrk2 (i) = trace (ii)
      enddo
c----
c   stuff output attributes into output vector if this is a live attribute
c----
      DO  i = 1, nsampo

          add = wrk2 (i)
          stkt (i) = stkt (i) + add
          if (abs(add) .gt. 0.0) sum (i) = sum (i) + 1.0

      ENDDO

      return
      end
