C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine trp2d (limin, limax, dimin, dimax, nli, ndi,
     1                  times)

c-----
c  simple 2Dx2D interpolation of a matrix of values. matrix is
c  dimensioned nli columns by ndi rows.
c-----

#include <f77/lhdrsz.h>

      real     times (ndi, nli)
      real     tm (SZLNHD)
      integer  km (SZLNHD)
      integer  nli, ndi, limax, limin, dimax, dimin

c-----
c  interpolate down each live column. values before the first live
c  sample will be set to that sample; values after the last live
c  sample will be set to that sample. values in between will be
c  linearly interpolated
c-----
      DO  J = limin, limax
          im = 0
          do  i = dimin, dimax
 
              if (times(i,j) .ne. 0.0) then
                 is = i
                 do  ii = 1, is-1
                     times (ii,j) = times (is,j)
                 enddo
                 im = im + 1
                 tm (im) = times (is,j)
                 km (im) = is
                 go to 1
              endif
          enddo
          if (im .eq. 0) go to 10
1         continue
 
          do  i = is+1, dimax
              if (times(i,j) .ne. 0.) then
                 im = im + 1
                 tm (im) = times (i,j)
                 km (im) = i
              endif
          enddo

          if (im .gt. 1) then
 
             do  ii = 2, im
                 t1 = tm (ii-1)
                 t2 = tm (ii)
                 x1 = km (ii-1)
                 x2 = km (ii)
                 s = (t2 - t1) / (x2 - x1)
                 do  k = km(ii-1)+1, km(ii)
                     tt = t1 + s * (k - x1)
                     times (k,j) = tt
                 enddo
             enddo
          endif
 
          if (km(im) .lt. dimax) then
             do  ii = km(im)+1, dimax
                 times (ii,j) = tm (im)
             enddo
          endif

10        continue
 
      ENDDO

c-----
c  now interpolate rows using the same schema as above
c-----
      DO  I = dimin, dimax
          jm = 0
          do  j = limin, limax
 
              if (times(i,j) .ne. 0.0) then
                 js = j
                 do  jj = 1, js
                     times (i,jj) = times (i,js)
                 enddo
                 jm = jm + 1
                 tm (jm) = times (i,js)
                 km (jm) = js
                 go to 2
              endif
          enddo
          if (jm .eq. 0) go to 20
2         continue
 
          do  j = js+1, limax
              if (times(i,j) .ne. 0.) then
                 jm = jm + 1
                 tm (jm) = times (i,j)
                 km (jm) = j
              endif
          enddo

          if (jm .gt. 1) then
 
             do  jj = 2, jm
                 t1 = tm (jj-1)
                 t2 = tm (jj)
                 x1 = km (jj-1)
                 x2 = km (jj)
                 s = (t2 - t1) / (x2 - x1)
                 do  k = km(jj-1)+1, km(jj)
                     tt = t1 + s * (k - x1)
                     times (i,k) = tt
                 enddo
             enddo
          endif
 
          if (km(jm) .lt. limax) then
             do  jj = km(jm)+1, limax
                 times (i,jj) = tm (jm)
             enddo
          endif

20        continue
 
      ENDDO

      return
      end
