C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c     program module sisort3d
c
c**********************************************************************c
c
c     sisort3d reads a siesmic trace from the command line,
c     and creates an output in the order of entries in
c     a table to create an output stream ordered on the
c     gi, si, di or distance
c
c subroutine calls: rtape, hlh, wrtape, save, dagc, odd
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c
      integer     itr ( SZLNHD ), ltr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc(100), nrec(100), iform, rind, tind
      integer     luin(100) , luout, lbytes, nbytes
      integer     istart,iend, nsampo,obytes
#include <f77/pid.h>
      integer     reccnt(5),trccnt(5),fld(5)
      integer     trc,rec,l1,l2,nli,d1,d2,ndi
      integer     currec, curtrc, srcind, dphind, recind, dstsgn
      integer     linind
      integer     gimin, gidel,gival
      real        tri ( SZLNHD )
      character   name * 8,   ntap(100) * 256, otap * 256, tnam * 256
      character   hdrwd6 * 6, hdrwd7 * 6, type * 2
      real        lri ( SZLNHD )
      logical     verbos, query, G, S, D, EL, X, leave, first
      integer     argis

      equivalence ( itr(  1), lhed(1) )
c     equivalence ( ltr(129), lri (1) )
      data name     /'SISORT3D'/
      data lbytes / 0 /, nbytes / 0 /, leave / .false. /
      data ltr/ SZLNHD * 0/, tri/SZLNHD * 0.0/
      data first/.true./
      
c-----
c     get help if necessary
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout files
c-----
#include <f77/open.h>

c-----
c     read program parameters from command line card image file
c-----
      call gcmdln(ntap,otap,tnam,G,S,D,EL,X,verbos,leave,
     &             istart,iend,idel,nsampo,nu)

c-----
c     get logical unit numbers for input and output
c-----
      IF (nu .ne. 0) THEN
         do 1 i = 1, nu
            call getln(luin(i),ntap(i),'r',0)
      write(LER,*)'ntap= ',i,ntap(i),luin(i)
          if (luin(i) .eq. 0) then
             write(LERR,*)'Cannot pipe into sisort3d'
             write(LERR,*)'Use -Nindata on command line where indata'
             write(LERR,*)'refers to a disk file (including full path)'
             write(LERR,*)'if data not in current working directory'
             write(LER ,*)'Cannot pipe into sisort3d'
             write(LER ,*)'Use -Nindata on command line where indata'
             write(LER ,*)'refers to a disk file (including full path)'
             write(LER ,*)'if data not in current working directory'
             stop
          endif
          call sislgbuf( luin(i), 'off' )
1        continue
      ELSE
         write(LERR,*)'sisort3d: no input data found: FATAL'
         write(LER ,*)'sisort3d: no input data found: FATAL'
         stop
      ENDIF

      call getln(luout, otap,'w', 1)

c-----
c     guarantee that we can work with the files
c-----
       if(tnam(1:1).eq.' ')then
              luns = LIN
       else
              luns = 22
              open(luns,file=tnam,status='old',
     1                     form='formatted',access='sequential')
              rewind luns
       endif

c-----
c     read line header of input
c     save certain parameters
c-----
      nrect = 0
      do  i = 1, nu
          call rtape  ( luin(i), itr, lbytes                  )
          if(lbytes .eq. 0) then
             write(LOT,*)'sisort3d: no header read from unit ',luin(i)
             write(LOT,*)'FATAL'
             stop
          endif
          call saver(itr, 'NumTrc', ntrc(i) , LINHED)
          call saver(itr, 'NumRec', nrec(i) , LINHED)
          nrect = nrect + nrec(i)
      enddo

      call hlhprt ( itr , lbytes, name, 8, LERR        )
#include <f77/saveh.h>

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      nsampo = nsampo/nsi
      if(nsampo .le. 0) nsampo = nsamp
      obytes = SZTRHD + SZSMPD * nsampo

c-----
c     modify line header to reflect actual number of traces output
c-----
c  check for old table & abort if necessary
      read(luns,'(a6,1x,a6)',end=7) hdrwd6, hdrwd7

      write(LERR,*)' '
      write(LERR,*)'Secondary sort header word = ',hdrwd6
      write(LERR,*)'tertiary sort header word  = ',hdrwd7
      write(LERR,*)' '

      if (hdrwd6 .eq. 'DphInd') then

          if (S .or. D) then
             write(LERR,*)' '
             write(LERR,*)'FATAL ERROR:'
             write(LERR,*)'You are using the wrong presort3d table for'
             write(LERR,*)'this type of sort.  You are allowed to use'
             write(LERR,*)'-G (grp sort) or -L (line, LI, sort) only'
             write(LERR,*)'with this sort table.'
             write(LERR,*)'To generate the proper table run:'
             write(LERR,*)'presort3d -N',ntap,' -O',otap,' -Hw6LinInd'
             write(LERR,*)' '
             stop
          endif
          type = 'LD'

      elseif (hdrwd6 .eq. 'LinInd') then

          if (G .or. EL) then
             write(LERR,*)' '
             write(LERR,*)'FATAL ERROR:'
             write(LERR,*)'You are using the wrong presort3d table for'
             write(LERR,*)'this type of sort.  You are allowed to use'
             write(LERR,*)'-S (sht sort) or -D (depth, DI, sort) only'
             write(LERR,*)'with this sort table.'
             write(LERR,*)'To generate the proper table run:'
             write(LERR,*)'presort3d -N',ntap,' -O',otap,' -Hw6DphInd'
             write(LERR,*)' '
             stop
          endif
          type = 'DL'

      else
             write(LERR,*)' '
             write(LERR,*)'WARNING:'
             write(LERR,*)'you are using a nonstandard sort table'
             write(LERR,*)' '
      endif

      go to 9

    7 continue
      write(LERR,*)'Premature end of file on sort table'
      write(LERR,*)'check presort3d run & repeat if necessary'
      stop
    9 continue

c-------
c  read presort table header
c-------
      read(luns,*)ndat
      write(LERR,*)'number entries in sort table= ',ndat
      read(luns,*)(reccnt(i),trccnt(i),fld(i), i=1,5)
      write(LERR,*)(reccnt(i),trccnt(i),fld(i), i=1,5)
      read(luns,*)gimin,gidel
      if(G)then
            nrecc = reccnt(1)
            jtr   = trccnt(1)
            ifld  = fld   (1)
            call savew (itr, 'APIWN9', 'G'  , LINHED)
            call savew (itr, 'APIWNA', 'L'  , LINHED)
            call savew (itr, 'APIWNB', 'D'  , LINHED)
      elseif(S)then
            nrecc = reccnt(2)
            jtr   = trccnt(2)
            ifld  = fld   (2)
            call savew (itr, 'APIWN9', 'S'  , LINHED)
            call savew (itr, 'APIWNA', 'D'  , LINHED)
            call savew (itr, 'APIWNB', 'L'  , LINHED)
      elseif(D)then
            nrecc = reccnt(3)
            jtr   = trccnt(3)
            ifld  = fld   (3)
            call savew (itr, 'APIWN9', 'D'  , LINHED)
            call savew (itr, 'APIWNA', 'D'  , LINHED)
            call savew (itr, 'APIWNB', 'L'  , LINHED)
      elseif(EL)then
            nrecc = reccnt(4)
            jtr   = trccnt(4)
            ifld  = fld   (4)
            call savew (itr, 'APIWN9', 'L'  , LINHED)
            call savew (itr, 'APIWNA', 'L'  , LINHED)
            call savew (itr, 'APIWNB', 'D'  , LINHED)
      elseif(X)then
            nrecc = reccnt(5)
            jtr   = trccnt(5)
            ifld  = fld   (5)
            call savew (itr, 'APIWN9', 'X'  , LINHED)
            call savew (itr, 'APIWNA', ' '  , LINHED)
            call savew (itr, 'APIWNB', ' '  , LINHED)
      endif

      ndi  = reccnt(3)
      d1   = 1
      d2   = ndi
      nli  = reccnt(4)
      l1   = 1
      l2   = nli

      if     (EL) then

             l1 = istart
             if(iend .ne. 0) then
                l2 = iend
              else
                l2 = nli
              endif
              nli = l2 - l1 + 1

      elseif (D) then

             d1 = istart
             if(iend .ne. 0) then
                d2 = iend
              else
                d2 = ndi
              endif
              ndi = d2 - d1 + 1
      endif
         
      call savew(itr, 'MnLnIn',  l1  , LINHED)
      call savew(itr, 'MxLnIn',  l2  , LINHED)
      call savew(itr, 'MnDpIn',  d1  , LINHED)
      call savew(itr, 'MxDpIn',  d2  , LINHED)

c--------
c  save new line header values
c  adjust hist header
c  write line header
c--------
      if(iend .ne. 0) then
         nrecc = iend - istart + 1
      else
         iend = 10000000
      endif

      nrecc = nrecc / idel

      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savew(itr, 'NumSmp', nsampo,LINHED)
      call savew(itr, 'CDPFld', ifld  ,LINHED)
      call savew(itr, 'NTrLnS', jtr   ,LINHED)

      call savhlh( itr, lbytes, lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      ntrc1 = ntrc(1)
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc1, nrect,iform,nu,nrec,
     1           ntap,otap,tnam,G,S,D,L,X,istart,iend,nsampo,
     2           idel)
c     end if

c-----
c     BEGIN PROCESSING
c     process desired trace records
c-----

      currec = 1
      curtrc = 1
      gival  = gimin
      if(verbos)write(LERR,*)'# recs= ',nrecc, ' # trc/rec= ',jtr,
     1           ' istart= ',istart,' iend= ',iend

c----------
c  read each line of presort table
c  pick off appropriate index and its associated rec & trc #'s
c  these #'s are then used to pick off the correct sorted trace
c  from somewhere in the input disk data set
c----------

      DO  1000 jjj = 1, ndat

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)'New presort line  ',jjj
         write(LERR,*)' '
      endif
      read(luns,*,end=9999)i1,i2,i3,i4,i5,iu1,i6,i7,iu2,i8,i9,
     1                     iu3,i10,i11,iu4,i12,i13,iu5,i14,i15
            if(X)then

                  newrec = i5
                  rec = i14
                  trc = i15
                  jj  = i5
                  iu  = iu5

            elseif(S)then

                  newrec = i2
                  rec = i8
                  trc = i9
                  jj = i2
                  iu  = iu2

          if (i8 .eq. 0 .or. i9 .eq. 0) then
             write(LERR,*)'Source indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Source indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(G)then

                  newrec = i1
                  rec = i6
                  trc = i7
                  jj = i1
                  iu  = iu1

          if (i6 .eq. 0 .or. i7 .eq. 0) then
             write(LERR,*)'Group index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Group indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(D)then

                  newrec = i3
                  rec = i10
                  trc = i11
                  jj = i3
                  iu  = iu3

          if (i10 .eq. 0 .or. i11 .eq. 0) then
             write(LERR,*)'Depth index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Depth indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(EL)then

                  newrec = i4
                  rec = i12
                  trc = i13
                  jj  = i4
                  iu  = iu4

          if (i12 .eq. 0 .or. i13 .eq. 0) then
             write(LERR,*)'Line indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Offst indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            endif



c-------------
c  is the sort index within the user
c  specified range?
c-------------
         IF (jj .ge. istart .and. jj .le. iend .AND.
     1       ( mod(jj,idel) .eq. 0 )                  ) THEN

            call dif(irccnt,itrcnt,jjj,jj,jump,first)
            if(verbos) then
                      write(LERR,*)' '
                      write(LERR,*)' '
                      write(LERR,*)'irccnt= ',irccnt,'  itrcnt= ',
     1                itrcnt,'  jjj= ',jjj,'  jj= ',jj,'  jump= ',jump
                      write(LERR,*)' '
            endif
c-----
c      if we have jumped to a new record or if we are at
c      the end of a data set, output necessary blank
c      traces at the end to fill in the record
c-----
            if(jump.eq.1 )then

              if(verbos)
     1        write(LERR,*)'Start new record: jtr= ',jtr

              if(jj .ge. istart .and. jj .le. iend) then

                  if(curtrc.ge.1 .and. curtrc.le.jtr)then

                  if(verbos)
     1            write(LERR,*)'currec= ',currec,' curtrc= ',curtrc

                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                        currec,curtrc-1,jtr,nsamp,iform,
     2                        ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3                        ifmt_RecNum,l_RecNum,ln_RecNum,
     4                        ifmt_StaCor,l_StaCor,ln_StaCor)
                  endif

              endif

                  currec = currec + 1
                  curtrc = 1
                  gival = gimin

            endif

            if(verbos)write(LERR,*)i1,i2,i3,i4,i5,i6,i7,
     1            i8,i9,i10,i11,i12,i13,i14,i15

            ioff = (rec-1) * ntrc1 + trc
            call sisseek (luin(iu), ioff)

            nbytes = 0
            call rtape( luin(iu), itr, nbytes)
            if(nbytes .eq. 0) then
              write(LERR,*)'FATAL ERROR'
              write(LERR,*)' '
              write(LERR,*)'read failed for rec, trc= ',rec,trc
              write(LERR,*)' '
              write(LERR,*)'presort table line...'
              write(LERR,*)i1,i2,i3,i4,i5,iu1,i6,i7,iu2,i8,i9,

     1                     iu3,i10,i11,iu4,i12,i13,iu5,i14,i15
              write(LERR,*)' '
              write(LERR,*)'Try rerunning presort on your data to build'
              write(LERR,*)'a new table.  Has your data changed since'
              write(LERR,*)'sort table was built?'
              stop
            endif
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        rind   , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        tind   , TRACEHEADER)
                  call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcind , TRACEHEADER)
                  call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        dstsgn , TRACEHEADER)
                  call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        linind , TRACEHEADER)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)
               if (istatic .eq. 30000) then
                  istatic = 0
                  call vmov (tri, 1, lhed(ITHWP1), 1, nsamp)
                  call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)
               endif

            if (verbos) write(LERR,*) 'rind=',rind,' tind= ',tind,
     1         ' srcind= ',srcind,' recind= ',recind,' dphind= ',
     1         dphind,' linind= ',linind,' dstsgn= ',dstsgn

            if(.not. leave) then
                  call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        currec , TRACEHEADER)
                  call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        curtrc , TRACEHEADER)
            endif
            curtrc = curtrc + 1

c------------
c  write out sorted trace
c  or padded trace
c------------
            call wrtape( luout, itr, obytes)

            gival = gival + 1
            if(verbos)write(LERR,*)'rec trc gival  ',currec, 
     1            curtrc, gival,recind

         ENDIF

 1000    CONTINUE

            currec = currec + 1
            if(curtrc-1.lt.jtr)then
                  if(verbos)
     1            write(LERR,*)'End of line:  currec= ',currec,
     2                          ' curtrc= ',curtrc,' jtr= ',jtr
                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                         currec-1,curtrc-1,jtr,nsamp,iform,
     2                        ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3                        ifmt_RecNum,l_RecNum,ln_RecNum,
     4                        ifmt_StaCor,l_StaCor,ln_StaCor)
            endif

 9999 continue
c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )

      if(verbos) then
            write(LERR,*)'end of sisort3d, processed ',nrec,' recrd(s)',
     1            ' with ',ntrc1, ' traces'
      endif
      end

       subroutine dif(ir,it,i,j,jump,first)
c-----
c      increment record count (ir) and trace count (it)
c      whenever j changes
c      i is the initialization flag
c      jump indicates that a transition to a new record has occurred
c-----
       logical first
c      static oldj, nt, nr
       save oldj, nt, nr
       if(first)then
              ir = 1
              it = 1
              nt = 1
              nr = 1
              oldj = j
              jump = 0
              first = .false.
       else
c--------------------------------------------
c  oldj is last
c  sort index #
c  nt = new trc seq
c  nr = new rec seq

              if(j .le. oldj)then
                     nt = nt + 1
                     it = it + 1
                     jump=0
              else
                     nr = nr + 1
                     if(nt.gt.it)it=nt
                     nt = 1
                     it = 1
                     ir = nr
                     oldj = j
                     jump = 1
              endif
       endif
       return
       end

      subroutine nultrc(itr,tri,verbos,obytes,luout,
     1                  currec,j1,j2,nsamp,iform,
     2                  ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3                  ifmt_RecNum,l_RecNum,ln_RecNum,
     4                  ifmt_StaCor,l_StaCor,ln_StaCor)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD )
      integer     nsamp, iform, j1, j2, stacor
      integer     currec
      integer     luout, obytes
      logical     verbos

            stacor = 30000
            call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  stacor , 1)

            do 1001  i = j1+1, j2

                  if(verbos)write(LERR,*)'Null outputting rec='
     1                  ,currec,' trace=',i
                  call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        currec , 1)
                  call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        i      , 1)

                  call wrtape( luout, itr, obytes)
 1001       continue

      return
      end

      subroutine help
#include <f77/iounit.h>
         write(LOT,*)
     1'***************************************************************'
      write(LOT,*)
     1'execute sisort3d by typing sisort3d and  list of program params'
      write(LOT,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LOT,*)
     1'a character(s) corresponding to some parameter.'
        write(LOT,*)
     1'users enter the following parameters, or use the default values'
        write(LOT,*)' '
        write(LOT,*)
     1' -N [ntap]    (no default)         : input data file name'
        write(LOT,*)
     1' -O [otap]    (default = stdout )  : output data file name'
       write(LOT,*)
     1' -n [tnam]    (default = stdin)    : sort table name'
        write(LOT,*)' '
        write(LOT,*)
     1' -e [time]    (default = input )   : output trace length (ms)'
        write(LOT,*)
     1' -l [istart]  (default = first )   : starting index to sort'
        write(LOT,*)
     1' -m [iend]    (default = last )    : ending index to sort'
        write(LOT,*)
     1' -d [idel]    (default = 1 )       : index increment'
       write(LOT,*)
     1' -orig        (default = false)    : leave original rec/trc nos.'
       write(LOT,*)
     1' -G           (default = false)    : sort on receiver index'
       write(LOT,*)
     1' -S           (default = false)    : sort on source index  '
       write(LOT,*)
     1' -D           (default = false)    : sort on depth index (DI)'
       write(LOT,*)
     1' -L           (default = false)    : sort on line index (LI)'
       write(LOT,*)
     1' -X           (default = false)    : sort on distance'
        write(LOT,*)' '
        write(LOT,*)
     1' NOTE only one of -G -R -S -D or -L can be given'
       write(LOT,*)
     1'usage:   sisort3d -N[ntap] -O[otap] -n[tnam] -e[] [-G -L -S -D -X  
     2 -V -l[] -m[] -d[]]'
         write(LOT,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,tnam,G,S,D,EL,X,verbos, leave,
     &                       istart, iend, idel, nsampo,nu)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table file name
c   istart  - I         start sort record
c    iend   - I         stop sort record
c   leave   - L         leave trace & record number the same as input
c     G     - L         Sort on receiver index
c     S     - L         Sort on source index
c     D     - L         Sort on depth index
c     R     - L         Sort on distance
c     X     - L         Sort on distance - no null trace padding
c     verbos- L   verbose output or not
c-----
#include <f77/iounit.h>
      character*256 ntap(*), otap, tnam
      logical verbos, leave, G, S, D, EL, X
      integer argis,istart,iend

            nu = 0
            do  i = 1, 100
                call argstr( '-N', ntap(i), ' ', ' ' )
                if (ntap(i) .eq. ' ') go to 1
                nu = nu + 1
            enddo
1           continue
            call argi4('-P', pmax, 100, 100)

            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-n', tnam, ' ', ' ' )
            call argi4('-e',nsampo,0,0)
c           call argi4('-l',istart,-999999,-999999)
            call argi4('-l',istart,1, 1)
            call argi4('-m',iend,0,0)
            call argi4('-d',idel,1,1)
            verbos = ( argis( '-V' ) .gt. 0 )
            leave = ( argis( '-orig' ) .gt. 0 )
            G  = ( argis( '-G' ) .gt. 0 )
            D  = ( argis( '-D' ) .gt. 0 )
            EL = ( argis( '-L' ) .gt. 0 )
            S  = ( argis( '-S' ) .gt. 0 )
            X  = ( argis( '-X' ) .gt. 0 )
c-----
c     ensure than no more than one processing option is taken
            icmd = 0
            if(G)icmd=icmd+1
            if(D)icmd=icmd+1
            if(EL)icmd=icmd+1
            if(S)icmd=icmd+1
            if(X)icmd=icmd+1
            if(icmd.ne.1)then
                  write(LOT,*)'FATAL ERROR: can only have 1 sort type'
                  call help()
                  stop
            endif
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrect,iform, nu,nrec,
     1        ntap,otap,tnam,G,S,D,L,X,istart,iend,nsampo,
     2        idel)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table name
c     G     - L     arrange by receiver index
c     S     - L     arrange by source index
c     D     - L     arrange by CDP index
c     L     - L     arrange by Line index
c     X     - L     arrange by distance no trace padding
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec(*), istart, iend, idel, nrect
      character*256 ntap(*), otap, tnam
      logical D, S, L, G, X

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' total records      =  ', nrect
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set names=  ', (ntap(i),
     1      i=1,nu)
            write(LERR,*) ' records per data set=  ', (nrec(i),
     1      i=1,nu)
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' sort table name     =  ',tnam
            write(LERR,*) ' output trace lenght =  ',nsampo
            write(LERR,*) ' start index         =  ',istart
            write(LERR,*) ' end index           =  ',iend
            write(LERR,*) ' index increment     =  ',idel
            write(LERR,*) ' sort by receiver ind=  ',G
            write(LERR,*) ' sort by source index=  ',S
            write(LERR,*) ' sort by depth index =  ',D
            write(LERR,*) ' sort by line index  =  ',L
            write(LERR,*) ' sort by dist-no fill=  ',X
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
