C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
         subroutine trpsub ( SeismicRecord, ntrc, nsamp,
     :                       index, index0, NumIter)

c----
c trpsub takes each slice (record) and locates interior holes (zeros)
c filling them in using the star-pattern interpolator
c----

c  variables passed from main 

      integer ntrc, nsamp, NumIter

      real    SeismicRecord (ntrc*nsamp)
      integer index  (nsamp*ntrc)
      integer index0 (nsamp*ntrc)

c  local variables 

      integer i, j, ij, ijnext, ijlast
      integer ijtop_last, ijbot_last, ij2_last, ij2top_last, ij2bot_last
      integer ijtop_next, ijbot_next, ij2_next, ij2top_next, ij2bot_next

      real    sum1, sum2, sum3, sum

c  variable definitions 

c integer

c       NumIter : number of iterations to make on record
c                 (usefull for adjacent dead traces)
c	ij,ijnext,ijlast : sample location indices
c       isum : contains averaged static for output to revived trace
c	ijtop_last - through - ij2bot_next : sample indices used in star search

c real
c
c	dot : scalar result of dot product
c	sum : star search output adjacent sample sum
c	sum1 : top left - bottom right sum
c       sum2 : adjacent sample sum
c       sum3 : bottom left - top right sum

c----
c  locate interior zero cells
c----

      DO  J = 2, ntrc-1

          ipntr = (J-1) * nsamp

          do  i = 2, nsamp-1

              amp = SeismicRecord (ipntr+i)

              if (amp .eq. 0.) then
                 index (ipntr+i) = 0
              else
                 index  (ipntr+i) = 1
                 index0 (ipntr+i) = index0 (ipntr+i) + 1
              endif
          enddo
      ENDDO


c----
c  iterate...
c----
      DO Iter = 1, NumIter

c----
c  ... over all interior traces...
c----
         do i = 2, ntrc-1

            ipntr = (i-1) * nsamp

c----
c  ... and all interior samples ...
c----
            do j = 2, nsamp-1

c----
c  ... and for all zero cells
c----
               if ( index (ipntr+j) .eq. 0) then

c----
c perform adjacent sample average with samples chosen from 
c star pattern based on measure of sameness (like sign) 
c----

                        ij = ipntr + j
                        ijlast = ipntr - nsamp + j
                        ijtop_last = ipntr - nsamp + j - 1
                        ijbot_last = ipntr - nsamp + j + 1
                        ij2_last = ipntr - 2*nsamp + j
                        ij2top_last = ipntr - 2*nsamp + j - 2
                        ij2bot_last = ipntr - 2*nsamp + j + 2

                        ijnext = ipntr + nsamp + j
                        ijtop_next = ipntr + nsamp + j - 1
                        ijbot_next = ipntr + nsamp + j + 1
                        ij2_next = ipntr + 2*nsamp + j
                        ij2top_next = ipntr + 2*nsamp + j - 2
                        ij2bot_next = ipntr + 2*nsamp + j + 2

c----
c In this approach the choice of which samples to average is 
c a function of the sign of the pair.  like signs outweigh
c unlike signs.  If all signs are alike or different the
c the choice is made on the basis of amplitude.
c----

                        same1 = 0
                        same2 = 0
                        same3 = 0
                        sum = 0.

c----
c assign star pattern amplitudes 
c----

                        sum1 = ( SeismicRecord(ijtop_last) + 
     :                       SeismicRecord(ijbot_next) )
                        sum2 = ( SeismicRecord(ijnext) + 
     :                       SeismicRecord(ijlast) )
                        sum3 = ( SeismicRecord(ijbot_last) + 
     :                       SeismicRecord(ijtop_next) )

                        if ( sign( 1.0, SeismicRecord(ijtop_next) ) .eq. 
     :                       sign( 1.0, SeismicRecord (ijbot_last) ) ) 
     :                       same1 = 1
                        if ( sign( 1.0, SeismicRecord(ijnext) ) .eq. 
     :                       sign( 1.0, SeismicRecord(ijlast) ) ) 
     :                       same2 = 1
                        if ( sign( 1.0, SeismicRecord(ijbot_next) ) .eq. 
     :                       sign( 1.0, SeismicRecord(ijtop_last) ) ) 
     :                       same3 = 1

                        IF ( ( same1 .eq. 1 
     :                       .and. same2 .eq. 1 
     :                       .and. same3 .eq. 1 ) .or. 
     :                       ( same1 .eq. 0 
     :                       .and. same2 .eq. 0
     :                       .and. same3. eq. 0 ) ) then
                           
                           sum = sum1
                           if( abs(sum2) .gt. abs(sum) ) sum = sum2
                           if( abs(sum3) .gt. abs(sum) ) sum = sum3

                        ELSEIF( same1 .eq. 1 
     :                          .and. same2 .eq. 1
     :                          .and. same3 .ne. 1 ) then
  
                           sum = sum1
                           if( abs(sum2) .gt. abs(sum) ) sum = sum2

                        ELSEIF( same1 .eq. 1
     :                          .and. same3 .eq. 1
     :                          .and. same2 .ne. 1 ) then

                           sum = sum1
                           if( abs(sum3) .gt. abs(sum) ) sum = sum3

                        ELSEIF( same2 .eq. 1
     :                          .and. same3 .eq. 1
     :                          .and. same1 .ne. 1 ) then
 
                           sum = sum2
                           if( abs(sum3) .gt. abs(sum) ) sum = sum3

                        ELSEIF( same1 .eq. 1 
     :                          .and. same2 .ne. 1 
     :                          .and. same3 .ne. 1 ) then

                           sum = sum1

                        ELSEIF( same1 .ne. 1 
     :                          .and. same2 .eq. 1 
     :                          .and. same3 .ne. 1 ) then
 
                           sum = sum2

                        ELSEIF( same1 .ne. 1 
     :                          .and. same2 .ne. 1 
     :                          .and. same3 .eq. 1 ) then

                           sum = sum3

                        ENDIF

c----
c load output sample
c----
                        SeismicRecord(ij) = sum / 2.0
            endif

            enddo
         enddo

      ENDDO

      return
      end
