C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FKKFilter(nxIN,nyIN,nIN,nIN2,
     :                     Input, Output, Filter,
     :                     Xpad,Ypad,med,avmed,pass)

      integer nxIN,nyIN,nIN,FilterCenter,StartRow,StartColumn
      integer nrows,ncols,Xpad,Ypad

      real    Input(nxIN,nyIN), Output(nxIN,nyIN)
      real    Filter(nIN,nIN)

      logical med, avmed, pass

c -----
c convolve Input with Filter
c -----

      if (.not.avmed .AND. .not.med) then

           FilterCenter = nint((float(nIN)**2)/2.)
           StartRow = NIN/2 + 1
           StartColumn = NIN/2 + 1
           nrows = nxIN - nIN
           ncols = nyIN - nIN

           call conv2d(Input,nxIN,StartRow,StartColumn,nrows,ncols,
     :                 Filter,nIN,nIN,FilterCenter,Output,nxIN,
     :                 StartRow,StartColumn,0)
               
      else

           call avemed (Input, Output, nxIN, nyIN, nIN, nIN2, 
     :                  Filter, med)

      endif

      IF(.not.pass)then
 
c -----
c remove flat events
c -----
 
         do j = 1,nyIN
            do i = 1,nxIN
 
               Output(i,j) = Input(i,j) - Output(i,j)
 
            enddo
         enddo
 
      ENDIF


      return
      end
