C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XYFilter(Intercept,CosTaper,FilterLength,nf,nf2,J0,
     2                    Filter,a,edge,med,avmed,nts,wate)

#include <f77/iounit.h>

c
c  routine to form a symmetrical (dx = dy = intercept) j0 
c  N x N filter. 
c  
c

      integer FilterLength

      real Filter (FilterLength,FilterLength,nts)
      real wate (nts)
      real Rtaper, CosTaper, a, J0, Intercept, PIby2

      logical edge, med, avmed

      external J0

      PIby2 = 3.14159265/2.0
      nf  = FilterLength
      nf2 = FilterLength / 2

c----
c   build simple edge detection Laplacian filter (from Two Dimensional Signal &
c   Image Processing by J.S. Lim, Prentice Hall, 1990, pp 481-6
c----
      IF ( edge ) THEN

             sgn = - sign (.1, a)
             a = .1 * a

             filter (1,1,1) =  sgn
             filter (2,1,1) =  sgn
             filter (3,1,1) =  sgn
             filter (1,2,1) =  sgn
             filter (2,2,1) =  sgn
             filter (3,2,1) =  sgn
             filter (1,3,1) =  sgn
             filter (2,3,1) =  sgn
             filter (3,3,1) =  sgn

             filter (1,1,2) =  sgn
             filter (2,1,2) =  sgn
             filter (3,1,2) =  sgn
             filter (1,2,2) =  sgn
             filter (2,2,2) =  a
             filter (3,2,2) =  sgn
             filter (1,3,2) =  sgn
             filter (2,3,2) =  sgn
             filter (3,3,2) =  sgn

             filter (1,1,3) =  sgn
             filter (2,1,3) =  sgn
             filter (3,1,3) =  sgn
             filter (1,2,3) =  sgn
             filter (2,2,3) =  sgn
             filter (3,2,3) =  sgn
             filter (1,3,3) =  sgn
             filter (2,3,3) =  sgn
             filter (3,3,3) =  sgn

             write(LERR,*)' '
             write(LERR,*)'Laplacian'
             write(LERR,*)' '
             write(LERR,*)'top plane:'
             write(LERR,*)filter(1,1,1),filter(2,1,1),filter(3,1,1)
             write(LERR,*)filter(1,2,1),filter(2,2,1),filter(3,2,1)
             write(LERR,*)filter(1,3,1),filter(2,3,1),filter(3,3,1)
             write(LERR,*)'mid plane:'
             write(LERR,*)filter(1,1,2),filter(2,1,2),filter(3,1,2)
             write(LERR,*)filter(1,2,2),filter(2,2,2),filter(3,2,2)
             write(LERR,*)filter(1,3,2),filter(2,3,2),filter(3,3,2)
             write(LERR,*)'bottom plane:'
             write(LERR,*)filter(1,1,3),filter(2,1,3),filter(3,1,3)
             write(LERR,*)filter(1,2,3),filter(2,2,3),filter(3,2,3)
             write(LERR,*)filter(1,3,3),filter(2,3,3),filter(3,3,3)
             write(LERR,*)' '

      ELSE

         ic = nts / 2 + 1
         ia = FilterLength / 2 + 1
         Rtaper = CosTaper * float(ia)
         Filter(ia,ia,ic) = J0(0.0)

         do i = 1,ia-1
            R = float(i) * Intercept
            Filter(ia+i,ia,ic) = J0(R)
            Filter(ia-i,ia,ic) = Filter(ia+i,ia,ic)
            Filter(ia,ia+i,ic) = Filter(ia+i,ia,ic)
            Filter(ia,ia-i,ic) = Filter(ia+i,ia,ic)
         enddo

c
c Compute positive Quadrant
c
 
         do i = 1,ia-1
            do j = 1,ia-1
               X = float(i) * Intercept
               Y = float(j) * Intercept
               R = sqrt(X**2 + Y**2)
 
               Filter(ia+j,ia+i,ic) = J0(R)
 
            enddo
         enddo
 
c
c Assign Symmetrical Quadrants
c
 
         do i = 1,ia-1
            do j = 1,ia-1
               Filter(i,j,ic)   = Filter(2*ia-i,2*ia-j,ic)
               Filter(2*ia-i,j,ic) = Filter(i,j,ic)
               Filter(i,2*ia-j,ic) = Filter(i,j,ic)
            enddo
         enddo
 
c
c cosine taper on filter and circular symmetry
c
         do i = 1,2*ia-1
            do j = 1,2*ia-1
 
               R = sqrt(float(ia - i)**2 + float(ia - j)**2)
               if(R.ge.Rtaper.and.R.le.float(ia))then
 
                  filter(i,j,ic) = filter(i,j,ic)*cos(R/float(ia)*PIby2)
 
               elseif(R.gt.float(ia))then
 
                  filter(i,j,ic) = 0.0
 
               endif
    
            enddo
         enddo

c
c Compute Sum of All Weights
c
 
         SumWeights = 0.0
 
         do i = 1,2*ia-1
            do j = 1,2*ia-1
               SumWeights = SumWeights + Filter(i,j,ic)
            enddo
         enddo
 
c
c  Normalize time center Filter
c
         do i = 1,2*ia-1
            do j = 1,2*ia-1
               Filter(i,j,ic) = filter(i,j,ic) / abs(SumWeights)
            enddo
         enddo


      ENDIF


      return
      end
