C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c changes
c
c     Dec 2000 Garossino - added a policeman to watch for the case when the line header
c                          lies about the number of actual traces in the dataset.  If
c                          there are more traces than expected the xcoordr[] and ycoordr[]
c                          arrays will overflow when calculating azimuthal stats.  The 
c                          policeman watches the total number of traces and if that number
c                          becomes greater than NumRec * NumTrc it sets rots = .false.
c
c                          also installed implicit none in the main and found a couple
c                          of first letter rules gotchas that were corrected
c
c     July 2000 Garossino - changed max number of samples per trace to 8192 from 4096
c                           which is required to handle Foinaven [and others]
c
c     Feb 99 Garossino - fixed offset histogram logic not to overflow memory if 
c                        user specified a max dist less than the max dist in the
c                        data.  Same corrections for angle histogram.
c
c     Jan 98 Garossino - changed the offset and azimuth reports to contain 
c                        data from traces within the parallelogram only. Previously
c                        contained data for all live traces regardless of 
c                        whether or not they would end up in the sr3d2 volume.
c
c     Sept 96 Garossino - changed angle measurement from receiver - source to
c                         source to receiver                       
c
c     Dec  95 Garossino - put in screen message to alert user to existence
c                           of old sort file.

C***********************************************************************
C
C     PROGRAM NAME: SR3D (3-D TRACE SORTING) - STEP 1 OF 2
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: GARY RUCKGABER & GARY DONATHAN
C
C     DATE WRITTEN: 02/??/77
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SORTS TRACES INTO COMMON MIDPOINT (CDP), COMMON
C               RECEIVER GROUP, OR COMMON SOURCE POINT ORDER OVER
C               A USER-DEFINED AREAL GRID.
C               STEP 1 DOES THE COORDINATE TRANSFORMATION AND OUTPUTS
C               THE FOLD DISTRIBUTION.
C               STEP 2 DOES THE ACTUAL TRACE SORTING.
C
C     INPUT PARAMETERS: (MINIMUM, MAXIMUM, DEFAULT)
C                 - 1SR3D
C            MODE - TYPE OF SORTING TO BE PERFORMED (1, 5, NONE)
C                      1 = COMMON MIDPOINT (CDP)
C                      2 = COMMON RECEIVER GROUP
C                      3 = COMMON SOURCE POINT
C                      4 = COMMON MIDPOINT CENTROID
C                      5 = COMMON MIDPOINT BIN CENTER
C           IFOLD - OUTPUT FOLD (1, 256, 256)
C           IFILL - FILL FLAG (0, 1, 0)
C                      0 = REDUCE OUTPUT FOLD TO MAXIMUM FOLD ON INPUT
C                      1 = FILL CELL W/ DEAD TRACES TO GET OUTPUT FOLD
C           ISTOP - HALT FLAG (0, 1, 0)
C                      0 = PROCEED TO TRACE SORTING STEP
C                      1 = HALT AFTER PRINTING FOLD DISTRIBUTION
c
c not any more...stripped it out: Garossino feb 11, 1999
c
c
C             IX1 - CORNER 1 X-COORDINATE (0, 99999999, 0)
C             IY1 - CORNER 1 Y-COORDINATE (0, 99999999, 0)
C             IX2 - CORNER 2 X-COORDINATE (0, 99999999, 0)
C             IY2 - CORNER 2 Y-COORDINATE (0, 99999999, 0)
C             IDY - SIDE 1-2 CELL INCREMENT (1, 999999, NONE)
C             IDX - SIDE 2-3 CELL INCREMENT (1, 999999, NONE)
C          NTROUT - NO. TRACES PER RECORD OUTPUT (1,99999,FOLD*NX)
C          CRDJOB - JOB IDENTIFICATION NUMBER
C
C                 - 2SR3D
C             IX3 - CORNER 3 X-COORDINATE (0, 99999999, 0)
C             IY3 - CORNER 3 Y-COORDINATE (0, 99999999, 0)
C             IX4 - CORNER 4 X-COORDINATE (0, 99999999, 0)
C             IY4 - CORNER 4 Y-COORDINATE (0, 99999999, 0)
C          IWNDWS - WINDOW START TIME (0, 99999, 0)
C          IWNDWE - WINDOW  END  TIME (IWNDWS, 99999, TRACE LENGTH)
C           IRT3D - FLAG FOR RT3D-TYPE OUTPUT (0,1,0)
C                      0 = NO SERPENTINE OUTPUT

C                      1 = WRITE OUTPUT DATA SET IN RT3D FORMAT
C

C                 - 3SR3D

C             RI1 - STARTING RECORD NUMBER FOR GRID (0, 99999, 1)

C          RIINCR - RECORD NUMBER INCREMENT (0, 99999, 1)
C           LINE1 - STARTING LINE NUMBER FOR GRID (0, 99999, 1)
C          LININC - LINE NUMBER INCREMENT (0, 99999, 1)
C             DI1 - STARTING DEPTH POINT NUMBER FOR GRID (0, 99999, 1)
C          DIINCR - DEPTH POINT INCREMENT (0, 99999, 1)
C
C     PROGRAM RESTRICTIONS:
C          1- INPUT DATA SET FORMAT MUST BE 1 OR 3
C          2- MAXIMUM NUMBER OF SAMPLES PER TRACE IS 9000 (4500 FMT 3)
C          3- MAXIMUM FOLD IS 256
C          4- MAXIMUM NUMBER OF CELLS IN SORTING GRID IS 32000
C
C     SUBROUTINES USED: SELF-CONTAINED
C
C     LOADERIZED ROUTINES USED:
C          CCEXIT     GAMOCO     HLH        LBCLOS
C          LBOPEN     MOVE       NACCT      NACCT2
C          RTAPE      STRING     WRCARD
C
C     MODIFICATION HISTORY: 05/??/78 - M.MARTIN
C                           06/??/79 - G.RUCKGABER
C                           07/??/79 - G.RUCKGABER
C                           03/??/80 - G.RUCKGABER
C                           04/??/80 - G.RUCKGABER
C          WRITE CELL NUMBER INTO TRACE DEPTH INDEX.
C                           07/02/82 - G.SHIBA
C          WRITE "NUMBER OF TRACES PER LINE" IN LINE HEADER BYTES
C          165-168 TO BE USED FOR MULTIPLE RECORDS PER LINE.
C          INCREASE MAXIMUM NUMBER OF CELLS PER EXECUTION FROM 20000
C          TO 32000.
C                           07/19/82 - G.SHIBA
C          REMOVE "ONE RECORD PER LINE" RESTRICTION.
C          ALLOW FLOATING POINT CELL INCREMENT.
C                           10/06/82 - G.SHIBA
C          REMOVE 31 CELL RESTRICTION FOR FOLD PRINTER PLOT.
C          IMPLEMENT 2-D CDP NUMBERING SCHEME (CURRENTLY COMMENTED OUT
C          UNTIL OTHER PROGRAMS CAN ACCEPT IT).
C          ALLOW USER SPECIFIED STARTING RECORD NUMBER, LINE NUMBER, &
C          DEPTH POINT NUMBER FOR THE GRID, & ASSOCIATED INCREMENTS.
C          ALLOW FORMAT 3 DATA SETS.
C          INCREASE NUMBER OF DISC UNITS TO 10.
C                           11/12/82 - G.SHIBA
C          IMPLEMENT 2-D CDP NUMBERING SCHEME (UNCOMMENT STATEMENTS).
C                           04/15/83 - G.SHIBA
C          WINDOWING CAPABILITY.
C                           06/20/83 - D.BODDY
C          CHANGE X-COORDINATE & Y-COORDINATE LOCATIONS IN THE TRACE
C          HEADER.
C          ADDED OPTION FOR COMMON MIDPOINT BIN CENTER
C                           09/19/83 - G.SHIBA
C          ADD OPTION TO OUTPUT DATA SET IN "RT3D" (SERPENTINE)
C          FORMAT.
C                           05/28/85 - G.SHIBA
C          SPECIAL VERSION FOR JOEY HAMMOND, DENVER REGION
C          INCREASE MAXIMUM FOLD FROM 256 TO 512.
C
C***********************************************************************
C
C     DEFINE, DECLARE, & INITIALIZE VARIABLES
C
C-----------------------------------------------------------------------

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare varibles tripped on by implicit none

      integer jerr, icc, maxrec, lucrd, luin, luout, ierr, nline
      integer mode, ifold, ifill, ntrout, istop, irt3d, iwndws
      integer iwndwe, ix1, ix2,  ix3, ix4, iy1, iy2, iy3, iy4
      integer j, np, ii, ngrp, ngrp2, nang, idx, idy, i, ibytes
      integer lbyout, nsamp, nsi, ntrc, nrec, iform, ifor, item
      integer item_coord
      integer errcd, abort, irecp, idxwnd, ns, imult, nbyteso
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_DstUsg, l_DstUsg, ln_DstUsg
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC
      integer ifmt_SrRcMx, l_SrRcMx, ln_SrRcMx
      integer ifmt_SrRcMy, l_SrRcMy, ln_SrRcMy
      integer ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY

      integer ifmt_indexx, l_indexx, ln_indexx
      integer ifmt_indexy, l_indexy, ln_indexy

      integer ix, iy, isgn, nx, ny, nxy, itemk, itemj, loc
      integer indx, indy, ic, il, itrc, irec, istatic, ivalrx, ivalry
      integer ivalsx, ivalsy, mvalx, mvaly, ivalx, ivaly, joff
      integer iag, ixx, ntot, nlive, maxx, ntr, ir, nxout, nyout
      integer isrptxmax, isrptxmin, isrptymax, isrptymin
      integer ircptxmax, ircptxmin, ircptymax, ircptymin
      integer isrrcxmax, isrrcxmin, isrrcymin, isrrcymax
      integer icdpbxmax, icdpbxmin, icdpbymax, icdpbymin

      real chg, pi, deg, xmin, xmax, ymin, ymax, delx, dely
      real slope, xpmax, xpmin, ypmax, ypmin, dx, dy, dxl, dyl
      real dstmin, dstmax, dstdel, dxg, azmin, azmax, azdel
      real tfs, xs, ys, x1, x2, x3, x4, y1, y2, y3, y4
      real difx, dify, valrx, valry, val, dxt, dyt, dsta
      real phi, trcept, siga, sigb, chi2, qq, angr
      real valsx, valsy

C
      REAL*8    P41L
      REAL*8    COS0  , SIN0  , SCOS0 , SSIN0
      REAL*8    TANPHI, DYCPHI
      REAL*8    X     , Y     , XX    , XY    , YX    , YY

      REAL*8    CRDJOB
C
      INTEGER   DATA4(SZLNHD)
      INTEGER   DATSV(SZLNHD)
c     INTEGER   SR3D

      character*4 SR3D
      character   name*5, srtwdx * 6, srtwdy * 6
      integer   argis, intbin

      integer   data33,data14,data15,data16

      integer   dindexx, dindexy, lupik, lufold, obytes

      real      srptxmax, srptxmin, srptymax, srptymin
      real      rcptxmax, rcptxmin, rcptymax, rcptymin
      real      srrcxmax, srrcxmin, srrcymax, srrcymin
      real      cdpbxmax, cdpbxmin, cdpbymax, cdpbymin
      real      dismax, dismin
      real      ndx, ndy
      real      xp (SZLNHD), yp (SZLNHD)


      character ntap * 256, otap * 256, maptap * 256
      character ftap * 256, dtap * 256, atap * 256

      character indexx*6, indexy*6

C
      INTEGER   DATA2(SZLNHD)


      INTEGER   KOUNT, JOUNT, idist (SZLNHD), iangs (SZLNHD)
      REAL      XTR  (SZLNHD), spread (SZLNHD), angs (SZLNHD)

      pointer   (wkkount,   kount(1))
      pointer   (wkjount,   jount(1))

      real      xcoordr, ycoordr
      pointer   (wkxcoordr,  xcoordr(1))
      pointer   (wkycoordr,  ycoordr(1))

c     INTEGER   INDXVL(5)

C
      INTEGER   RI1   , RIINCR, LINE1 , LININC, DI1   , DIINCR
      INTEGER   lugrp, luang


      LOGICAL   heap, line, xgraph, plotxy, xsd, verbos
      LOGICAL   edges, xline, off, azm, stack, rots, restart

C
      CHARACTER*1 PARR(66)
      CHARACTER*1 LIST(22)
      CHARACTER*1 DASH(19)
      CHARACTER*1 SPACE(17)
C
      external function killit
      EQUIVALENCE (DATA2(1),DATA4(1))

      DATA        PARR    /17*' ','3','-','D',' ','T','R','A','C','E',
     $  ' ','S','O','R','T','I','N','G',' ','(','S','T','E','P',' ','1',
     $  ' ','O','F',' ','2',')',18*' '/
      DATA        LIST    /'(','1','X',',','I','4',',','''',
     $  ' ','|','''',',',' ',' ','I','4',',','''',' ','|','''',')'/
      DATA        DASH    /'(','6','X',',','I','1',',',' ',' ',' ','(',
     $ '''','-','''',')',',','I','1',')'/
      DATA        SPACE    /'(','6','X',',','''','|','''',',',
     $ ' ',' ',' ','X',',','''','|','''',')'/
C
      DATA line/.false./
      DATA restart/.false./
      DATA CHG/1.0/
      DATA ICC/0/
      DATA SR3D/'SR3D'/
c
c - the lowercase is intentional - rmprint should not remove the print file
c
      DATA name/'sr3d1'/
      DATA CRDJOB/0.0/

      data      srptxmax/-999999999./, srptxmin/999999999./
      data      srptymax/-999999999./, srptymin/999999999./
      data      rcptxmax/-999999999./, rcptxmin/999999999./
      data      rcptymax/-999999999./, rcptymin/999999999./
      data      srrcxmax/-999999999./, srrcxmin/999999999./
      data      srrcymax/-999999999./, srrcymin/999999999./
      data      cdpbxmax/-999999999./, cdpbxmin/999999999./
      data      cdpbymax/-999999999./, cdpbymin/999999999./
      data      dismax  /-999999999./, dismin  /999999999./

      data      lupik/41/
      data      lugrp/51/
      data      luang/61/

c      ieeer = ieee_handler ('set','invalid',killit)

      maxrec = 0
      pi  = 3.14159265
      deg = 180. / pi

      LUCRD = LUCARD

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

#include <f77/open.h>

C-----------------------------------------------------------------------
C
C     WRITE THE BANNER PAGE & OPEN THE INPUT LOGICAL UNIT
C
C-----------------------------------------------------------------------

      CALL GAMOCO (PARR,1,LERR)

      restart = ( argis( '-moredata' )   .gt. 0 )

      call argstr ('-N', ntap, ' ', ' ')

      call getln(luin , ntap,'r', 0)



      call argstr ('-O', otap, ' ', ' ')

      if (otap .eq. ' ') then

c        luout = LOT
         write(LERR,*)'Must include sort table name:'
         write(LERR,*)'use -O[] cmd line arg and rerun'
         stop

      else
         luout = LUDISK
         if ( .not. restart ) then
            open (unit = luout, file = otap, form = 'unformatted',
     1            access = 'sequential', status = 'new', iostat = ierr)
         else
            open (unit = luout, file = otap, form = 'unformatted',
     1            access = 'sequential', status = 'old', iostat = ierr)
         endif

         if(ierr .ne. 0) then
         write(LERR,*)'Could not open output disk file'
         write(LERR,*)'for some damned reason, i.e. it already exists'
         write(LERR,*)'If it does better remove it'
         write(LER,*)' '
         write(LER,*)'SR3D1: Could not open output disk file'
         write(LER,*)'       for some damned reason, i.e. it'
         write(LER,*)'       already exists.  If you really want to'
         write(LER,*)'       do this then remove the old file.'
         write(LER,*)'FATAL'
         stop
         endif
         rewind LUDISK
      endif


      call argstr ('-M', maptap, ' ', ' ')
      call argstr ('-F', ftap, ' ', ' ')
      call argstr ('-S', dtap, ' ', ' ')
      call argstr ('-A', atap, ' ', ' ')

      if (ftap(1:1) .ne. ' ') then
         call getln (lufold, ftap, 'w', -1)
         if (lufold .lt. 0) then
            write(LERR,*)'FATAL EROR in sr3d1:'
            write(LERR,*)'Cannot open fold output unit for file ',
     1                   ftap
            write(LERR,*)'Check directory perms'
            write(LER ,*)'FATAL EROR in sr3d1:'
            write(LER ,*)'Cannot open fold output unit for file ',
     1                   ftap
            write(LER ,*)'Check directory perms'
            stop
         endif
      endif

      if (dtap(1:1) .ne. ' ') then
         open (unit = lugrp, file = dtap, status = 'unknown',
     1         iostat = ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'FATAL EROR in sr3d1:'
            write(LERR,*)'Cannot open offset output unit for file ',
     1                   dtap
            write(LERR,*)'Check directory perms'
            write(LER ,*)'FATAL EROR in sr3d1:'
            write(LER ,*)'Cannot open offset output unit for file ',
     1                   dtap
            write(LER ,*)'Check directory perms'
            stop
         endif
      endif

      if (atap(1:1) .ne. ' ') then
         open (unit = luang, file = atap, status = 'unknown',
     1         iostat = ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'FATAL EROR in sr3d1:'
            write(LERR,*)'Cannot open azimuth output unit for file ',
     1                   atap
            write(LERR,*)'Check directory perms'
            write(LER ,*)'FATAL EROR in sr3d1:'
            write(LER ,*)'Cannot open azimuth output unit for file ',
     1                   atap
            write(LER ,*)'Check directory perms'
            stop
         endif
      endif



      verbos  = ( argis( '-V') .gt. 0 )
      xgraph  = ( argis( '-xgraph') .gt. 0 )
      plotxy  = ( argis( '-plotxy') .gt. 0 )
      xsd     = ( argis( '-xsd'   ) .gt. 0 )
      edges   = ( argis( '-E'   )   .gt. 0 )
      xline   = ( argis( '-X'   )   .gt. 0 )
      stack   = ( argis( '-stk' )   .gt. 0 )

      if (stack) then
         call argstr ('-swx', srtwdx, 'CDPBCX', 'CDPBCX')
         call argstr ('-swy', srtwdy, 'CDPBCY', 'CDPBCY')
      endif

      if (xline) then
         write(LERR,*)'Sort is crossline'
         write(LER ,*)'Sort is crossline'
      else
         write(LERR,*)'Sort is inline'
         write(LER ,*)'Sort is inline'
      endif

      if (xgraph .or. plotxy .or. xsd) then
         call argi4 ('-line', nline, 1, 1)
      endif

C-----------------------------------------------------------------------
C
C     READ THE PARAMETERS
C
C-----------------------------------------------------------------------

      call argi4 ('-mode', mode, 5, 5)
      call argi4 ('-fold', ifold, 0, 0)
      call argi4 ('-fill', ifill, 0, 0)
      call argi4 ('-ntrc', ntrout, 0, 0)
      call argi4 ('-istop', istop, 0, 0)
      call argi4 ('-type', irt3d, 0, 0)
      call argi4 ('-s', iwndws, 0, 0)
      call argi4 ('-e', iwndwe, 0, 0)
      call argi4 ('-ris', RI1, 0, 0)
      call argi4 ('-rii', RIINCR, 0, 0)
      call argi4 ('-lis', LINE1, 0, 0)
      call argi4 ('-lii', LININC, 0, 0)
      call argi4 ('-dis', DI1, 0, 0)
      call argi4 ('-dii', DIINCR, 0, 0)


      if (maptap(1:1) .eq. ' ') then
         call argi4 ('-x1', ix1, -9999999, -9999999)
         call argi4 ('-y1', iy1, -9999999, -9999999)

         call argi4 ('-x2', ix2, -9999999, -9999999)
         call argi4 ('-y2', iy2, -9999999, -9999999)

         call argi4 ('-x3', ix3, -9999999, -9999999)
         call argi4 ('-y3', iy3, -9999999, -9999999)

         call argi4 ('-x4', ix4, -9999999, -9999999)
         call argi4 ('-y4', iy4, -9999999, -9999999)
      else
         ix1 = -9999999
         iy1 = -9999999
         ix2 = -9999999
         iy2 = -9999999
         ix3 = -9999999
         iy3 = -9999999
         ix4 = -9999999
         iy4 = -9999999
         open(unit=lupik, file=maptap, status='old', iostat=ierr)
             if(ierr .ne. 0) then
                write(LER,*)'sr3d1: Could not open survey pick file'
                write(LER,*)'Check existence'
                stop
             endif
         rewind lupik

         write(LER,*)' '
         if (plotxy) then

            do  j = 1, nline+1

                call GetPlotXY (lupik, xp, yp, np, ierr, j)
                if (ierr .ne. 0) then
                   write(LER,*)'sr3d1: Problem with plotxy file format:'
                   write(LER,*)'attempting to read segment ',j,' err= ',
     1             ierr
                   write(LER,*)'May not be plotxy type format.  Check'
                   write(LER,*)'to see if it was written using plotxy.'
                   stop
                endif
                if (j .eq. 1) then
                    call minv (xp, 1, xmin, loc, np)
                    call minv (yp, 1, ymin, loc, np)
                    call maxv (xp, 1, xmax, loc, np)
                    call maxv (yp, 1, ymax, loc, np)
                    write(LER,*)' '
                    write(LER,*)'Maximum Corners of Survey:'
                    write(LER,*)'Min X = ',xmin,'  Max X = ',xmax
                    write(LER,*)'Min Y = ',ymin,'  Max Y = ',ymax
                    write(LERR,*)' '
                    write(LERR,*)'Maximum Corners of Survey:'
                    write(LERR,*)'Min X = ',xmin,'  Max X = ',xmax
                    write(LERR,*)'Min Y = ',ymin,'  Max Y = ',ymax
                else
                    write(LER,*)' '
                    write(LER,*)'Segment= ',j,' np= ',np,' ierr= ',ierr
                    write(LER,*)(xp(ii),ii=1,np)
                    write(LER,*)(yp(ii),ii=1,np)
                    write(LERR,*)' '
                    write(LERR,*)'Segment= ',j,' np= ',np,' ierr= ',ierr
                    write(LERR,*)(xp(ii),ii=1,np)
                    write(LERR,*)(yp(ii),ii=1,np)
                endif
            enddo

         elseif (xgraph) then

            do  j = 1, nline+1
                call GetXgraph (lupik, xp, yp, np, ierr,J)
                if (ierr .ne. 0) then
                   write(LER,*)'sr3d1: Problem with pick file format:'
                   write(LER,*)'attempting to read segment ',j,' err= ',
     1                          ierr
                   write(LER,*)'May not be xgraph type format.  Check'
                   write(LER,*)'to see if it was written using xgraph.'
                   stop
                endif
                if (j .eq. 1) then
                    call minv (xp, 1, xmin, loc, np)
                    call minv (yp, 1, ymin, loc, np)
                    call maxv (xp, 1, xmax, loc, np)
                    call maxv (yp, 1, ymax, loc, np)
                    write(LER,*)' '
                    write(LER,*)'Maximum Corners of Survey:'
                    write(LER,*)'Min X = ',xmin,'  Max X = ',xmax
                    write(LER,*)'Min Y = ',ymin,'  Max Y = ',ymax
                    write(LERR,*)' '
                    write(LERR,*)'Maximum Corners of Survey:'
                    write(LERR,*)'Min X = ',xmin,'  Max X = ',xmax
                    write(LERR,*)'Min Y = ',ymin,'  Max Y = ',ymax
                else
                    write(LER,*)' '
                    write(LER,*)'Segment= ',j,' np= ',np,' ierr= ',ierr
                    write(LER,*)(xp(ii),ii=1,np)
                    write(LER,*)(yp(ii),ii=1,np)
                    write(LERR,*)' '
                    write(LERR,*)'Segment= ',j,' np= ',np,' ierr= ',ierr
                    write(LERR,*)(xp(ii),ii=1,np)
                    write(LERR,*)(yp(ii),ii=1,np)
                endif
            enddo

         elseif (xsd) then

            do  j = 1, nline
                call GetXsd (lupik, xp, yp, np, ierr,J)
                if (ierr .ne. 0) then
                   write(LER,*)'sr3d1: Problem with pick file format:'
                   write(LER,*)'attempting to read segment ',j,' err= ',
     1                          ierr
                   write(LER,*)'May not be xgraph type format.  Check'
                   write(LER,*)'to see if it was written using xgraph.'
                   stop
                endif
                if (j .eq. 1) then
                    call minv (xp, 1, xmin, loc, np)
                    call minv (yp, 1, ymin, loc, np)
                    call maxv (xp, 1, xmax, loc, np)
                    call maxv (yp, 1, ymax, loc, np)
                    write(LER,*)' '
                    write(LER,*)'Maximum Corners of Survey:'
                    write(LER,*)'Min X = ',xmin,'  Max X = ',xmax
                    write(LER,*)'Min Y = ',ymin,'  Max Y = ',ymax
                    write(LERR,*)' '
                    write(LERR,*)'Maximum Corners of Survey:'
                    write(LERR,*)'Min X = ',xmin,'  Max X = ',xmax
                    write(LERR,*)'Min Y = ',ymin,'  Max Y = ',ymax
                else
                    write(LER,*)' '
                    write(LER,*)'Segment= ',j,' np= ',np,' ierr= ',ierr
                    write(LER,*)(xp(ii),ii=1,np)
                    write(LER,*)(yp(ii),ii=1,np)
                    write(LERR,*)' '
                    write(LERR,*)'Segment= ',j,' np= ',np,' ierr= ',ierr
                    write(LERR,*)(xp(ii),ii=1,np)
                    write(LERR,*)(yp(ii),ii=1,np)
                endif
            enddo
        endif
        write(LER,*)' '

         if (np .eq. 2) then

             line = .true.
             dely = yp(2) - yp(1)
             delx = xp(2) - xp(1)

             if     (dely .eq. 0. .and. delx .ne. 0.) then

                ix1 = nint ( amin1(xp(1), xp(2)) )
                ix4 = nint ( amax1(xp(1), xp(2)) )
                iy1 = yp(1)
                iy4 = yp(2)

             elseif (delx .eq. 0. .and. dely .ne. 0.) then

                iy1 = nint ( amin1(yp(1), yp(2)) )
                iy2 = nint ( amax1(yp(1), yp(2)) )
                ix1 = xp(1)
                ix2 = xp(2)

             elseif (delx .ne. 0. .and. dely .ne. 0.) then

                slope = dely / delx
                if (slope .gt. 0.0) then
                   ix1 = nint ( amin1(xp(1), xp(2)) )
                   ix2 = nint ( amax1(xp(1), xp(2)) )
                   iy1 = nint ( amin1(yp(1), yp(2)) )
                   iy3 = nint ( amax1(yp(1), yp(2)) )
                else
                   ix4 = nint ( amax1(xp(1), xp(2)) )
                   ix3 = nint ( amin1(xp(1), xp(2)) )
                   iy4 = nint ( amin1(yp(1), yp(2)) )
                   iy2 = nint ( amax1(yp(1), yp(2)) )
                endif
             endif

         elseif (np .ge. 3) then
 
             line = .false.
             np = 4
             call maxv (xp, 1, xpmax, loc, np)
             call minv (xp, 1, xpmin, loc, np)
             call maxv (yp, 1, ypmax, loc, np)
             call minv (yp, 1, ypmin, loc, np)
             ix1 = nint ( xpmin )
             iy1 = nint ( ypmin )
             ix3 = nint ( xpmax )
             iy3 = nint ( ypmax )
             ix2 = nint ( xpmin )
             iy2 = nint ( ypmax )
             ix4 = nint ( xpmax )
             iy4 = nint ( ypmin )
         endif
      endif

      call argr4 ('-dx', dx, 0., 0.)
      call argr4 ('-dy', dy, 0., 0.)
      call argr4 ('-ndx', ndx, 1.0, 1.0)
      call argr4 ('-ndy', ndy, 1.0, 1.0)

                dxl = dx
                dyl = dy


      call argr4 ('-dmin', dstmin, 0.0, 0.0)
      call argr4 ('-dmax', dstmax, 0.0, 0.0)
      call argr4 ('-ddel', dstdel, 0.0, 0.0)

      IF (dstdel .gt. 0.0 .AND. dtap(1:1) .ne. ' ') THEN

         if (DSTMAX .eq. 0.0 .AND. DSTMIN .eq. 0.0) then
            write(LER,*)'ERROR in sr3d1:'
            write(LER,*)'Must specify maximum offset using -dmax[]'
            stop
         endif

         off = .true.
 
         dxg  = DSTDEL
         ngrp = (DSTMAX - DSTMIN) / DSTDEL + 1

c-------
c compute spread model
c-------
         ngrp2 = ngrp / 2
         call vfill (0.0, spread, 1, ngrp)
 
         do  j = 1, ngrp
 
             spread (j) = DSTMIN + (j-1) * dxg
             idist (j)  = 0
         enddo

      ELSE

         off = .false.

      ENDIF

      call argr4 ('-amin', azmin, 0.0, 0.0)
      call argr4 ('-amax', azmax, 360.0, 360.0)
      call argr4 ('-adel', azdel, 15.0, 15.0)
 
      IF (atap(1:1) .ne. ' ') THEN
 
         azm = .true.
 
         nang = (azmax - azmin) / azdel
 
c-------
c compute spread model
c-------
         call vfill (0.0, angs, 1, nang)
 
         do  j = 1, nang
 
             angs (j)  = azmin + (j-1) * azdel
             iangs (j) = 0
         enddo
 
      ELSE
 
         azm = .false.
 
      ENDIF


      write(LER,*)' '
      write(LER ,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER ,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4
      if (edges) then
          idx = dx
          idy = dy
          ix1 = isign(1,ix1) * (iabs(ix1) - idy/2)
          ix2 = isign(1,ix2) * (iabs(ix2) - idy/2)
          ix3 = isign(1,ix3) * (iabs(ix3) + idy/2)
          ix4 = isign(1,ix4) * (iabs(ix4) + idy/2)
          iy1 = isign(1,iy1) * (iabs(iy1) + idx/2)
          iy2 = isign(1,iy2) * (iabs(iy2) - idx/2)
          iy3 = isign(1,iy3) * (iabs(iy3) - idx/2)
          iy4 = isign(1,iy4) * (iabs(iy4) + idx/2)
      endif
      write(LER ,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER ,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4
      write(LER ,*)'midpoint coords already exist? ',stack
      write(LER,*)' '

      if     (ix2 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy2 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                ix4 = ix1 + .5 * dxl * ndx
                ix1 = ix1 - .5 * dxl * ndx
                ix2 = ix3 - .5 * dxl * ndx
                ix3 = ix3 + .5 * dxl * ndx
                iy4 = iy1
                iy2 = iy3

      elseif (ix1 .eq. -9999999 .and. ix3 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy3 .eq. -9999999        ) then

                ix1 = ix2 - .5 * dxl * ndx
                ix2 = ix2 + .5 * dxl * ndx
                ix3 = ix4 + .5 * dxl * ndx
                ix4 = ix4 - .5 * dxl * ndx
                iy1 = iy4
                iy3 = iy2

      elseif (ix3 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy3 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                ix4 = ix1 + .5 * dxl * ndx
                ix1 = ix1 - .5 * dxl * ndx
                ix3 = ix2 + .5 * dxl * ndx
                ix2 = ix2 - .5 * dxl * ndx
                iy4 = iy1
                iy3 = iy2

      elseif (ix1 .eq. -9999999 .and. ix2 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy2 .eq. -9999999        ) then

                ix1 = ix4 - .5 * dxl * ndx
                ix4 = ix4 + .5 * dxl * ndx
                ix2 = ix3 - .5 * dxl * ndx
                ix3 = ix3 + .5 * dxl * ndx
                iy1 = iy4
                iy2 = iy3

      elseif (ix3 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy2 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                ix3 = ix2 + .5 * dxl * ndx
                ix2 = ix2 - .5 * dxl * ndx
                ix4 = ix1 + .5 * dxl * ndx
                ix1 = ix1 - .5 * dxl * ndx
                iy4 = iy1
                iy2 = iy3

      elseif (ix1 .eq. -9999999 .and. ix2 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy3 .eq. -9999999        ) then

                ix2 = ix3 - .5 * dxl * ndx
                ix3 = ix3 + .5 * dxl * ndx
                ix1 = ix4 - .5 * dxl * ndx
                ix4 = ix4 + .5 * dxl * ndx
                iy1 = iy4
                iy3 = iy2


      elseif (ix1 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                iy1 = iy2 - .5 * dyl * ndy
                iy2 = iy2 + .5 * dyl * ndy
                iy4 = iy3 - .5 * dyl * ndy
                iy3 = iy3 + .5 * dyl * ndy
                ix1 = ix2
                ix4 = ix3

      elseif (ix2 .eq. -9999999 .and. ix3 .eq. -9999999  .AND.
     1        iy2 .eq. -9999999 .and. iy3 .eq. -9999999        ) then

                iy2 = iy1 + .5 * dyl * ndy
                iy1 = iy1 - .5 * dyl * ndy
                iy3 = iy4 + .5 * dyl * ndy
                iy4 = iy4 - .5 * dyl * ndy
                ix2 = ix1
                ix3 = ix4

      elseif (ix1 .eq. -9999999 .and. ix3 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy3 .eq. -9999999  .AND.
     2        ix2 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     3        iy2 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

              write(LER,*)'sr3d1: FATAL ERROR'
              write(LER,*)'No coordinates given either on command line'
              write(LER,*)'or in pick file.  Rerun with this info'
              stop

      endif


      write(LER,*)' '
      write(LER ,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER ,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4

      if (ix1 .eq. -9999999) then
         write(LERR,*)'Must supply proper X1 (corner 1) coordinate'
         write(LERR,*)'using -x1[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy1 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y1 (corner 1) coordinate'
         write(LERR,*)'using -y1[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (ix2 .eq. -9999999) then
         write(LERR,*)'Must supply proper X2 (corner 2) coordinate'
         write(LERR,*)'using -x2[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy2 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y2 (corner 2) coordinate'
         write(LERR,*)'using -y2[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (ix3 .eq. -9999999) then
         write(LERR,*)'Must supply proper X3 (corner 3) coordinate'
         write(LERR,*)'using -x3[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy3 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y3 (corner 3) coordinate'
         write(LERR,*)'using -y3[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (ix4 .eq. -9999999) then
         write(LERR,*)'Must supply proper X4 (corner 4) coordinate'
         write(LERR,*)'using -x4[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy4 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y4 (corner 4) coordinate'
         write(LERR,*)'using -y4[] cmd line arg -- FATAL'
         go to 4800
      endif

      if (dx .eq. 0.) then
         write(LERR,*)'Must supply proper DX cell dimension using'
         write(LERR,*)'-dx[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (dy .eq. 0.) then
         write(LERR,*)'Must supply proper DY cell dimension using'
         write(LERR,*)'-dy[] cmd line arg -- FATAL'
         go to 4800
      endif

      write(LER ,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER ,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4
      write(LER,*)' '

      icc = 0

      if (off) then
         write(LER ,*)' '
         write(LER ,*)'dmin, dmax, ddel= ',dstmin, dstmax, dstdel
         write(LER ,*)'Number groups= ',ngrp
         write(LER ,*)'Spread:'
         write(LER ,*)(spread(i),i=1,ngrp)
         write(LER ,*)' '
      endif

      if (azm) then
         write(LER ,*)' '
         write(LER ,*)'amin, amax, adel= ',azmin, azmax, azdel
         write(LER ,*)'Number groups= ',nang
         write(LER ,*)'Angle Ranges:'
         write(LER ,*)(angs(i),i=1,nang)
         write(LER ,*)' '
      endif

C
C-----------------------------------------------------------------------
C
C     READ THE INPUT LINE HEADER
C
C-----------------------------------------------------------------------
C
      IBYTES            = 0
      CALL RTAPE (luin  ,DATA2,IBYTES)
      IF (IBYTES.NE.0) GO TO 200
      WRITE (LERR,100)
  100 FORMAT ('0** M3001 ** ERROR DETECTED BY PROGRAM SR3D:'/
     $ 13X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ ',
     $              'INPUT DATA SET LINE HEADER' /
     $ 13X, 'VERIFY THE INPUT DATA SET NAME, AND IN THE ',
     $              'CASE OF MULTI-VOLUME INPUT' /
     $ 13X, 'DATA SETS, VERIFY THE ORDER IN WHICH THE '  ,
     $              'VOLUMES WERE CATALOGED' /)
      ICC               = 100
      GO TO 4900
C
C-----------------------------------------------------------------------
C
C     UPDATE THE PROCESS HISTORY INFORMATION & START THE ACCOUNTING
C
C-----------------------------------------------------------------------
C

200   continue

      call hlhprt (DATA2, IBYTES, name, 5, LERR)
      call savhlh (DATA2, IBYTES, LBYOUT)
      call move   (1, DATSV, DATA4, LBYOUT)

      call saver(DATA2, 'NumSmp', nsamp, LINHED)
      call saver(DATA2, 'SmpInt', nsi  , LINHED)
      call saver(DATA2, 'NumTrc', ntrc , LINHED)
      call saver(DATA2, 'NumRec', nrec , LINHED)
      call saver(DATA2, 'Format', iform, LINHED)
      ifor = iform

      data33 = iform
      data14 = nrec
      data15 = nsi
      data16 = nsamp

      heap = .true.

      if (.not. stack) then

         item_coord  =  ntrc * nrec 

         call galloc (wkxcoordr, item_coord* SZSMPD, errcd, abort)
         if (errcd .ne. 0.) heap = .false.
         call galloc (wkycoordr, item_coord* SZSMPD, errcd, abort)
         if (errcd .ne. 0.) heap = .false.

         if (.not.heap) then
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace for XY azimuth'
            write(LER ,*)'analysis. The rest of sr3d1 will proceed.'
            write(LER ,*) item_coord* SZSMPD,'  bytes'
            write(LER ,*) item_coord* SZSMPD,'  bytes'
            write(LER ,*)' '
            rots = .false.
   
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) item_coord* SZSMPD,'  bytes'
            write(LERR,*) item_coord* SZSMPD,'  bytes'
            write(LERR,*)' '
            rots = .true.
         endif

      else

         rots = .false.

      endif


c----
c   For post-stack work we choose the working sort indexes on the
c   command line
c----
      IF (.not. stack) THEN

         if     (mode .eq. 1) then

                indexx = 'SrRcMX'
                indexy = 'SrRcMY'

         elseif (mode .eq. 2) then

                indexx = 'RcPtXC'
                indexy = 'RcPtYC'
   
         elseif (mode .eq. 3) then

                indexx = 'SrPtXC'
                indexy = 'SrPtYC'

         elseif (mode .eq. 4) then
   
                indexx = 'CDPBCX'
                indexy = 'CDPBCY'

         elseif (mode .eq. 5) then

                indexx = 'SrRcMX'
                indexy = 'SrRcMY'
         endif
      ELSE

         indexx = srtwdx
         indexy = srtwdy

      ENDIF


      write(LERR,*)'Sort index mnemonic X= ',indexx
      write(LERR,*)'Sort index mnemonic Y= ',indexy
      write(LER ,*)'Sort index mnemonic X= ',indexx
      write(LER ,*)'Sort index mnemonic Y= ',indexy

      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)

      call savelu(indexx,ifmt_indexx,l_indexx,ln_indexx,TRACEHEADER)
      call savelu(indexy,ifmt_indexy,l_indexy,ln_indexy,TRACEHEADER)

C-----------------------------------------------------------------------
C
C     ERROR CHECK - FORMAT 1 WITH A MAXIMUM OF 9000 SAMPLES
C                   FORMAT 3 WITH A MAXIMUM OF 4500 SAMPLES
C
C-----------------------------------------------------------------------
C
      IF (DATA33.EQ.1 .OR. DATA33.EQ.3) GO TO 400

      WRITE (LERR,300)

  300 FORMAT ('0** M3002 ** ERROR DETECTED BY PROGRAM SR3D:'/
     $ 13X, 'THE FORMAT CODE FILED IN THE INPUT DATA SET ',
     $      'LINE HEADER IS NOT A 1 OR 3' /
     $ 13X, 'PROGRAM SR3D ONLY ACCEPTS FORMAT 1 AND ',
     $      'FORMAT 3 INPUT DATA SETS' /
     $ 13X, 'VERIFY THE FORMAT CODE FILED IN THE INPUT ',
     $      'DATA SET LINE HEADER' /)

      ICC               = 100

C

  400 IF (DATA16.LE.8192) GO TO 600

      IF (DATA33.EQ.1 .AND. DATA16.LE.9000) GO TO 600

      WRITE (LERR,500)

  500 FORMAT ('0** M3003 ** ERROR DETECTED BY PROGRAM SR3D:'/
     $ 13X, 'THE NUMBER OF SAMPLES PER TRACE ENTRY FILED ',
     $      'IN THE INPUT DATA SET LINE' /
     $ 13X, 'HEADER EXCEEDS THE PROGRAM LIMITATIONS' /
     $ 13X, 'PROGRAM SR3D IS RESTRICTED TO A MAXIMUM OF ',
     $      '9000 FORMAT 1 SAMPLES PER TRACE' /
     $ 13X, 'AND 4500 FORMAT 3 SAMPLES PER TRACE' /
     $ 13X, 'EITHER CHANGE THE LINE HEADER ENTRY IF IT '  ,
     $      'IS IN ERROR, OR WINDOW THAT' /
     $ 13X, 'PORTION OF THE DATA OF INTEREST SUCH THAT ' ,
     $      'THE NUMBER OF SAMPLES' /
     $ 13X, 'CONFORMS TO PROGRAM RESTRICTIONS' /)
      ICC               = 100

C

C-----------------------------------------------------------------------
C
C     RETRIEVE THE "NO. OF RECORDS PER JOB" FROM THE INPUT LINE HEADER
C     INITIALIZE THE BUFFER TO STORE THE "JOB NO." FROM INPUT DATA SET
C
C-----------------------------------------------------------------------
C
  600 IRECP             = DATA14

      if (IWNDWE .eq. 0) IWNDWE = nsi * (nsamp - 1)



      IF (RI1   .EQ.0) RI1    = 1
      IF (RIINCR.EQ.0) RIINCR = 1
      IF (LINE1 .EQ.0) LINE1  = 1
      IF (LININC.EQ.0) LININC = 1
      IF (DI1   .EQ.0) DI1    = 1
      IF (DIINCR.EQ.0) DIINCR = 1


      TFS               =  IWNDWS
      IDXWND            = (IWNDWS / NSI) + 2 * ITHWP1 - 1
      IF (IFOR .EQ. 3)     IDXWND = (IWNDWS / NSI) + ITHWP1
      NS                = (IWNDWE - IWNDWS) / NSI + 1
      IMULT             = SZHFWD
      IF (IFOR.EQ.3)      IMULT = SZSMPD
      write(LERR,*)' '
      write(LERR,*)'TFS, IDXWND, NS, IMULT= ',TFS,IDXWND,NS,IMULT
      write(LERR,*)' '

c-----

c  the number of bytes in a windowed trace

c-----
      NBYTESO           = IMULT * NS + SZTRHD





C-----------------------------------------------------------------------
C
C
C     ERROR CHECK - VALID MODES ARE 1 THRU 5
C     INITIALIZE THE BUFFER FOR THE "JOB NO." FROM PARAMETER CARDS
C     ERROR CHECK - JOB IDENTIFICATION NUMBERS MUST MATCH
C     SET DEFAULT CONDITIONS
C         1- REDUCE OUTPUT FOLD TO MAXIMUM FOLD ON INPUT DATA SET
C         2- MAXIMUM FOLD EQUAL TO 512; DEFAULT CONDITION EQUAL TO 256
C
C-----------------------------------------------------------------------
C
      IF (MODE.GE.1.AND.MODE.LE.5) GO TO 1700
      WRITE (LERR,1600)
 1600 FORMAT ('0** M3007 ** ERROR DETECTED BY PROGRAM SR3D:'/
     $ 13X, 'THE SORT TYPE (1SR3D CC 7) HAS ONLY FIVE VALID OPTIONS:' /
     $         26X, '1 = COMMON MIDPOINT (CDP)'   , /
     $         26X, '2 = COMMON RECEIVER GROUP'   , /
     $         26X, '3 = COMMON SOURCE POINT'     , /
     $         26X, '4 = COMMON MIDPOINT CENTROID', /
     $         26X, '5 = COMMON MIDPOINT BIN CENTER', /
     $         26X, 'VERIFY THIS ENTRY - A BLANK IS INVALID' /)
      ICC               = 100
C
 1700 continue

C
      IF (IFOLD.NE.0) GO TO 1900
      IFILL = 0
      IFOLD = 256
C
C-----------------------------------------------------------------------
C
C     ENSURE THAT USER SPECIFIED COORDINATES DEFINE A PARALLELOGRAM
C
C-----------------------------------------------------------------------
C
 1900 COS0              = IX4  - IX1
      SIN0              = IY4  - IY1
      P41L              = COS0 * COS0  +  SIN0 * SIN0
      XX                = IX2  - IX1
      YY                = IY2  - IY1
       X                = P41L + 0.5
       Y                = XX   * XX    +  YY   * YY    + 0.5
      Xs = X
      Ys = Y
c debug : hmmmm  this was coming up as an invalid operation when dealing in
c                feet in the input GOM deepwater dataset.  I looked around and
c                saw that this was never used again.  In fact IX and IY are
c                reassigned below before ever being used.  So I commented this
c                out and will see what happens.
c      IX = Xs
c      IY = Ys
      X1 = IX1
      X2 = IX2
      X3 = IX3
      X4 = IX4
      Y1 = IY1
      Y2 = IY2
      Y3 = IY3
      Y4 = IY4

      write(LER,*)'COS0, SIN0, P41L= ',COS0,SIN0,P41L
      write(LER,*)'XX, YY, IX, IY, X, Y= ',XX,YY,IX,IY,Xs,Ys
      write(LER,*)'x1,x2,x3,x4= ',x1,x2,x3,x4
      write(LER,*)'y1,y2,y3,y4= ',y1,y2,y3,y4
      write(LER,*)'(IX3-IX2)*(IX3-IX2)= ',(X3-X2)*(X3-IX2)
      write(LER,*)'(IY3-IY2)*(IY3-IY2)= ',(Y3-Y2)*(Y3-IY2)
      write(LER,*)'sum = ',(X3-X2)*(X3-X2)+(Y3-Y2)*(Y3-Y2)
      write(LER,*)'(IX4-IX3)*(IX4-IX3)= ',(X4-X3)*(X4-X3)
      write(LER,*)'(IY4-IY3)*(IY4-IY3)= ',(Y4-Y3)*(Y4-Y3)
      write(LER,*)'sum = ',(X4-X3)*(X4-X3)+(Y4-Y3)*(Y4-Y3)
      difx = abs (Xs - (X3-X2)*(X3-X2)-(Y3-Y2)*(Y3-Y2) )
      dify = abs (Ys - (X4-X3)*(X4-X3)-(Y4-Y3)*(Y4-Y3) )
      write(LER,*)'difx, dify= ',difx,dify
      if (difx .le. dx) difx = 0.
      if (dify .le. dy) dify = 0.
C
c     IF (IX.EQ.(IX3-IX2)*(IX3-IX2)+(IY3-IY2)*(IY3-IY2).AND.
c    $    IY.EQ.(IX4-IX3)*(IX4-IX3)+(IY4-IY3)*(IY4-IY3))    GO TO 2100

      IF ( difx .eq. 0. .AND. dify .eq. 0.) GO TO 2100
      WRITE (LER ,2000)
      WRITE (LERR,2000)
 2000 FORMAT ('0** M3009 ** WARNING ISSUED BY PROGRAM SR3D:'/
     $ 13X, 'THE COORDINATES SPECIFIED FOR THE FOUR CORNERS ' /
     $ 13X, 'OF THE SORTING GRID DOES NOT DEFINE A PARALLELOGRAM'/
     $ 13X, 'VERIFY THE COORDINATES ENTERED ON THE PARAMETER '/
     $ 13X, 'CARDS (1SR3D CC 15-30, 33-48, AND 2SR3D CC 15-30, 33-48)')
c     ICC               = 100
c     GO TO 2250
C
C-----------------------------------------------------------------------
C
C     COMPUTE CONSTANTS NEEDED TO PERFORM THE FOLLOWING TRANSFORMATION
C         1- MAP CORNER 1 ONTO ORIGIN
C         2- MAP CORNER 2 ONTO POSITIVE Y-AXIS
C         3- MAP CORNER 3 ONTO QUADRANT 1
C         4- MAP CORNER 4 ONTO POSITIVE X-AXIS
C
C-----------------------------------------------------------------------
C
2100  CONTINUE

      P41L              = DSQRT(P41L)
      write(LER,*)'P41L= ',P41L,' DX, DY= ',dx,dy
      COS0              = COS0 / P41L
      write(LER,*)'COS0= ',COS0
      SIN0              = SIN0 / P41L
      write(LER,*)'SIN0= ',SIN0
C
      ISGN              = 1
      IF (XX*SIN0.GT.YY*COS0) ISGN = -1
C
      SCOS0             = ISGN * COS0
      SSIN0             = ISGN * SIN0
C
      X                 = YY * SIN0   +  XX * COS0
      Y                 = YY * SCOS0  -  XX * SSIN0
      write(LER,*)'X, Y= ',X,Y
C
      TANPHI            = X / Y
      write(LER,*)'TANPHI= ',TANPHI
C
      DYCPHI            = DY * DABS(Y)  /  DSQRT(X*X+Y*Y)
      write(LER,*)'DYCPHI= ',DYCPHI,'  DY= ',DY
C
      XX                = (COS0 + SSIN0 * TANPHI) / DX
      XY                = (SIN0 - SCOS0 * TANPHI) / DX
      YX                = -SSIN0 / DYCPHI
      YY                =  SCOS0 / DYCPHI
      write(LER,*)'XX, XY, YX, YY= ',XX,XY,YX,YY
C
C-----------------------------------------------------------------------
C
C     COMPUTE THE CELL DIMENSIONS & NUMBER OF CELLS IN THE GRID
C     ERROR CHECK - MAXIMUM NUMBER OF CELLS IN THE GRID IS 32000
C
C-----------------------------------------------------------------------
C
      X                  = (IX4 - IX1) * XX  +  (IY4 - IY1) * XY  +  1.
      Y                  = (IX2 - IX1) * YX  +  (IY2 - IY1) * YY  +  1.
C
      NX                 = X
      IF (X-NX.LT.0.5) NX = NX - 1
      if (NX .eq. 0)   NX = 1
      NY                 = Y
      IF (Y-NY.LT.0.5) NY = NY - 1
      if (NY .eq. 0)   NY = 1
      NXY                = NX * NY

      write(LERR,*)' '
      write(LERR,*)'Survey Parallelogram Size:'
      write(LERR,*)'X =  ',NX,'  Y =  ',NY,' XX,XY,YX,YY= ',XX,XY,YX,YY
      write(LERR,*)'NX x NY =  ',NX*NY,' cells (LI dimension x DI dimens
     1ion or [2-3] x [1-2])'
      write(LERR,*)'X4-X1 =  ',IX4 - IX1
      write(LERR,*)'X2-X1 =  ',IX2 - IX1
      write(LERR,*)'Y4-Y1 =  ',IY4 - IY1
      write(LERR,*)'Y2-Y1 =  ',IY2 - IY1
      write(LERR,*)' '
      write(LER ,*)' '
      write(LER ,*)'Survey Parallelogram Size:'
      write(LER ,*)'X =  ',NX,'  Y =  ',NY,' XX,XY,YX,YY= ',XX,XY,YX,YY
      write(LER ,*)'NX x NY =  ',NX*NY,' cells (LI dimension x DI dimens
     1ion or [2-3] x [1-2])'
      write(LER ,*)'X4-X1 =  ',IX4 - IX1
      write(LER ,*)'X2-X1 =  ',IX2 - IX1
      write(LER ,*)'Y4-Y1 =  ',IY4 - IY1
      write(LER ,*)'Y2-Y1 =  ',IY2 - IY1
      write(LER ,*)' '



      heap = .true.

      itemk = (NXY + 2) * SZSMPD
      item  =  NXY + 2 

      call galloc (wkkount, itemk, errcd, abort)

      if ( restart ) then
         itemj = max (NX,NY) * SZSMPD
         call galloc (wkjount, itemj, errcd, abort)
      else
         itemj = SZSMPD
         call galloc (wkjount, itemj, errcd, abort)
      endif

      if (errcd .ne. 0.) heap = .false.

      if (.not.heap) then
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemk,'  bytes'
         write(LER ,*) itemj,'  bytes'
         write(LER ,*)' '
         go to 4800

      else
         write(LER ,*)' '
         write(LER ,*)'Allocating workspace:'
         write(LER ,*) itemk,'  bytes'
         write(LER ,*) itemj,'  bytes'
         write(LER ,*)' '
      endif

      call vclr (kount, 1, item)


      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)


      IF (NXY.LE.100000000)    GO TO 2250

      WRITE (LERR,2200) NXY,NX,NY

 2200 FORMAT ('0** M3010 ** ERROR DETECTED BY PROGRAM SR3D:'/

     $ 13X,'SORTING GRID CONTAINS MORE THAN 100 million CELLS WITH THE'/

     $ 13X,'CELL INCREMENTS (1SR3D CC 51-62) SPECIFIED' /
     $ 13X,'REDUCE THE CELL INCREMENTS ON EITHER OR BOTH OF THE ENTRIES'
     $/13X,'OR DEFINE THE GRID COORDINATES SUCH THAT THE '  ,
     $     'SORTING GRID IS SMALLER' /)
      ICC               = 100


C-----------------------------------------------------------------------
C
C     PRINT USER PARAMETERS IN TABLE FORM
C
C-----------------------------------------------------------------------
C
 2250 WRITE (LERR,2251) MODE  , IFOLD , IFILL , ISTOP , NTROUT,
     $                   DY    , DX
      WRITE (LERR,2252) IX1   , IY1   , IX2   , IY2   , IX3   ,
     $                   IY3   , IX4   , IY4   , IWNDWS, IWNDWE,
     $                   IRT3D
      WRITE (LERR,2253) RI1   ,
     $                   LINE1 ,
     $                   DI1   ,         CRDJOB
 2251 FORMAT (//25X,'INPUT PARAMETERS:'                   ,
     $        //25X,'TYPE OF SORTING . . . . . . . . . . ', 7X,   I1,
     $        / 25X,'   1 = COMMON MIDPOINT'              ,
     $        / 25X,'   2 = COMMON RECEIVER GROUP'        ,
     $        / 25X,'   3 = COMMON SOURCE POINT'          ,
     $        / 25X,'   4 = COMMON MIDPOINT CENTROID'     ,
     $        / 25X,'   5 = COMMON MIDPOINT BIN CENTER'   ,
     $        //25X,'OUTPUT FOLD . . . . . . . . . . . . ', 5X,   I3,
     $        / 25X,'FILL FLAG . . . . . . . . . . . . . ', 7X,   I1,
     $        / 25X,'   0 = MAXIMUM FOLD ON INPUT TAPE'   ,
     $        / 25X,'   1 = FILL CELL TO OUTPUT FOLD'     ,
     $        //25X,'TRACE SORTING . . . . . . . . . . . ', 7X,   I1,
     $        / 25X,'   0 = PROCEED TO TRACE SORTING STEP',
     $        / 25X,'   1 = HALT AFTER FOLD DISTRIBUTION' ,
     $        //25X,'TRACES PER OUTPUT RECORD  . . . . . ', 4X,   I4,
     $        //25X,'CELL INCREMENTS'                     ,
     $        / 25X,'   SIDE 1-2 . . . . . . . . . . . . ', 2X, F6.1,
     $        / 25X,'   SIDE 2-3 . . . . . . . . . . . . ', 2X, F6.1)
 2252 FORMAT (  25X,'CORNER COORDINATES'                  ,
     $        / 25X,'   CORNER 1 - X . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 1 - Y . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 2 - X . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 2 - Y . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 3 - X . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 3 - Y . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 4 - X . . . . . . . . . . ',       I8,
     $        / 25X,'   CORNER 4 - Y . . . . . . . . . . ',       I8,
     $        //25X,'WINDOW START TIME . . . . . . . . . ', 3X,   I5,
     $        / 25X,'WINDOW  END  TIME . . . . . . . . . ', 3X,   I5,
     $        //25X,'SERPENTINE (RT3D) OUTPUT  . . . . . ', 3X,   I5,
     $        / 25X,'   0 = NO RT3D-TYPE OUTPUT          ',
     $        / 25X,'   1 = SERPENTINE   OUTPUT          ')
 2253 FORMAT (/ 25X,'STARTING RECORD NUMBER FOR GRID . . ', 3X,   I5,
     $        / 25X,'STARTING LINE NUMBER FOR GRID . . . ', 3X,   I5,
     $        / 25X,'STARTING DEPTH POINT NUMBER FOR GRID', 3X,   I5,
     $        //25X,'JOB IDENTIFICATION NUMBER . . . . . ', 1X,   A7,
     $       //)
C
C-----------------------------------------------------------------------
C
C     IF ANY PRELIMINARY ERRORS HAVE BEEN FOUND PRIOR TO SPINNING TAPE,
C     TERMINATE THE JOB
C
C-----------------------------------------------------------------------
C
      IF (ICC.EQ.0) GO TO 2350
      IRECP = 0
      GO TO 4800
C
C-----------------------------------------------------------------------
C
C     DETERMINE TRACE HEADER LOCATIONS OF COORDINATES TO BE USED
C
C-----------------------------------------------------------------------
C
c2350 INDX = INDXVL(MODE)
c     INDY                = INDX + 1
 2350 INDX = l_indexx

      INDY = l_indexy

C
C-----------------------------------------------------------------------
C
C     READ A TRACE FROM THE INPUT DATA SET
C
C-----------------------------------------------------------------------
C
      ic = 0
      il = 0
      itrc = 0
      irec = 1

 2400 IBYTES = 0

      CALL RTAPE (luin  ,DATA4,IBYTES)
      IF (IBYTES.EQ.0) GO TO 2500

c increment total traces read counter

      ic = ic + 1

c this is trace report logic for the run time verbos output
c of where the process is at any point in time

      itrc = itrc + 1
      if ((itrc .eq. ntrc) .AND. verbos) then
         write(LER,*)'Read input record ',irec,
     1        '  Max live trcs/cell so far= ',maxrec
         itrc = 0
         irec = irec + 1
      endif

c determine if we have a live trace and if trace is dead 
c .... skip it

      call saver2(data4,ifmt_StaCor,l_StaCor, ln_StaCor,
     1     istatic , TRACEHEADER)

      IF ( istatic .EQ. 30000 ) GO TO 2400

c increment total live trace counter

      il = il + 1

c-----
c  extract receiver XYs
c-----

      call saver2(data4,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1     ivalrx  , TRACEHEADER)
      call saver2(data4,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1     ivalry  , TRACEHEADER)

c    build stats on max & min coordinates 

      valrx = ivalrx
      valry = ivalry

c POLICEMAN : watch out for case where line header and data are not in sync.
c             it may be that the input stream has way more data than described
c             by NumRec and NumTrc.  If so then il may become bigger than item_coord
c             and cause an array overflow of xcoordr and ycoordr.  

      if ( il .gt. item_coord .and. rots ) then
         rots = .false.
         write(lerr,*)'   '
         write(lerr,*)'   il = ',il,' item_coord = ',item_coord
         write(lerr,*)'SR3D1: The actual number of traces read '
         write(lerr,*)'       is greater than predicted by the  '
         write(lerr,*)'       lineheader.  For this reason the '
         write(lerr,*)'       azimuthal statistics report is being'
         write(lerr,*)'       suppressed before an array overflow'
         write(lerr,*)'       occurs.  You can get your azimuthal'
         write(lerr,*)'       stats by fixing the line header '
         write(lerr,*)'       to describe a dataset at least as large'
         write(lerr,*)'       as what you have.  If you describe more'
         write(lerr,*)'       traces than exist that is not a problem'
         write(lerr,*)'       You can make this correction using an '
         write(lerr,*)'       in-situ utop -R[] -L[] where -N[] and '
         write(lerr,*)'       -O[] both refer to your input dataset.  '
         write(lerr,*)'       You could also slide a utop into the flow'
         write(lerr,*)'   '
      endif

c end of POLICEMAN

      if (rots .AND. .not. stack) then
         xcoordr (il) = valrx
         ycoordr (il) = valry
      endif

      if (valrx .ge. rcptxmax) rcptxmax = valrx
      if (valrx .le. rcptxmin) rcptxmin = valrx
      if (valry .ge. rcptymax) rcptymax = valry
      if (valry .le. rcptymin) rcptymin = valry

c-----
c  and shot XYs
c-----

      call saver2(data4,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1     ivalsx, TRACEHEADER)
      call saver2(data4,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1     ivalsy, TRACEHEADER)

c    build stats on max & min coordinates 

      valsx = ivalsx
      if (valsx .ge. srptxmax) srptxmax = valsx
      if (valsx .le. srptxmin) srptxmin = valsx

      valsy = ivalsy
      if (valsy .ge. srptymax) srptymax = valsy
      if (valsy .le. srptymin) srptymin = valsy

c-----
c  midpoint XYs
c-----
      if (stack) then
         call saver2(data4,ifmt_indexx,l_indexx, ln_indexx,
     1        mvalx , TRACEHEADER)
         
         call saver2(data4,ifmt_indexy,l_indexy, ln_indexy,
     1        mvaly , TRACEHEADER)
      else
         mvalx = .5 * float (ivalsx + ivalrx) + 0.5
         mvaly = .5 * float (ivalsy + ivalry) + 0.5
      endif

c    build stats on max & min coordinates 

      val = mvalx
      if (val .ge. srrcxmax) srrcxmax = val
      if (val .le. srrcxmin) srrcxmin = val

      val = mvaly
      if (val .ge. srrcymax) srrcymax = val
      if (val .le. srrcymin) srrcymin = val

c-----
c  midpoint bin center XYs
c-----
      call saver2(data4,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1     ivalx, TRACEHEADER)
      call saver2(data4,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1     ivaly, TRACEHEADER)

c    build stats on max & min coordinates 

      val = ivalx
      if (val .ge. cdpbxmax) cdpbxmax = val
      if (val .le. cdpbxmin) cdpbxmin = val

      val = ivaly
      if (val .ge. cdpbymax) cdpbymax = val
      if (val .le. cdpbymin) cdpbymin = val

c-----
c  sort index XYs
c-----
      if (mode .eq. 1 .OR. mode .eq. 5) then
         dindexx = mvalx
         dindexy = mvaly
      else
         call saver2(data4,ifmt_indexx,l_indexx, ln_indexx,
     1        dindexx , TRACEHEADER)
         
         call saver2(data4,ifmt_indexy,l_indexy, ln_indexy,
     1        dindexy , TRACEHEADER)
      endif

c-----
c SKIP TRACE IF NOT INSIDE POLYGON
c-----

      IX = (dindexx - IX1) * XX  +  (dindexy - IY1) * XY + .999999
      IF (IX .LE. 0 .OR. IX .GT. NX ) THEN
         if (verbos)
     1        write(LERR,*)'Trace X-value= ',IX,' out of range: 1-',
     2        NX,' ...Skipped'
         GO TO 2400
      ENDIF

      IY = (dindexx - IX1) * YX  +  (dindexy - IY1) * YY + .999999
      IF (IY .LE. 0 .OR. IY .GT. NY ) THEN
         if (verbos)
     1        write(LERR,*)'Trace Y-value= ',IY,' out of range: 1-',
     2        NY,' ...Skipped'
         GO TO 2400
      ENDIF

c-----
c  update the offset histogram for the current offset
c-----

      dxt = valsx - valrx
      dyt = valsy - valry
      val = sqrt ( dxt * dxt + dyt * dyt )
      if (val .ge. dismax) dismax = val
      if (val .le. dismin) dismin = val
      
      if (off) then
         dsta = val
         joff = intbin (ngrp, dxg, spread, dsta)

         if ( joff .ge. 1 .and. joff .le. ngrp ) then
            idist (joff) = idist (joff) + 1
         endif
      endif

c-----
c  update the azimuth histogram for the current azimuth
c-----

      if (azm) then
         dxt = valrx - valsx 
         dyt = valry - valsy
         phi = deg * atan2 ( dxt, dyt )
         if (phi .lt. 0.0) phi = abs (360. + phi)
         iag = intbin (nang, azdel, angs, phi)

         if ( iag .ge. 1 .and. iag .le. nang ) then
            iangs (iag) = iangs (iag) + 1
         endif
      endif

C-----------------------------------------------------------------------
C
C     KEEP COUNT OF LIVE TRACES WITHIN EACH CELL
C
C-----------------------------------------------------------------------
C
      if (xline) then
         IXX               =(IY-1) * NX + IX
      else
         IXX               =(IX-1) * NY + IY
      endif

      call keep_kount(KOUNT, item, IXX, maxrec)
c      KOUNT(IXX)        = KOUNT(IXX)  + 1
c      if (KOUNT(IXX) .ge. maxrec) maxrec = KOUNT(IXX)
      
      GO TO 2400
 
 2500 CONTINUE

c here is where we cover the global parameter reports:
c
c il --> the number of live traces read
c ntr --> the number of live traces within the grid
c max --> the greatest number of traces in a bin
c nxy --> the number of bins

      ntot  = ic
      nlive = il
      MAXX              = 0
      NTR               = 0
 
      call final_kount(kount, nxy, maxx, ntr)
c      DO 2600 IX = 1,NXY
c         IF (KOUNT(IX).GE.MAXX) MAXX= KOUNT(IX)
c         NTR            =     NTR + KOUNT(IX)
c 2600 CONTINUE

      write(LERR,*)' '
      write(LERR,*)'NXY,NTR,MAX= ',NXY,NTR,MAXX
      write(LERR,*)'Totel # traces read from input= ',ntot
      write(LERR,*)' '

      isrptxmax = srptxmax
      isrptxmin = srptxmin
      isrptymax = srptymax
      isrptymin = srptymin

      ircptxmax = rcptxmax
      ircptxmin = rcptxmin
      ircptymax = rcptymax
      ircptymin = rcptymin

      isrrcxmax = srrcxmax
      isrrcxmin = srrcxmin
      isrrcymax = srrcymax
      isrrcymin = srrcymin

      icdpbxmax = cdpbxmax
      icdpbxmin = cdpbxmin
      icdpbymax = cdpbymax
      icdpbymin = cdpbymin

      write(LERR,*)' '
      write(LERR,*)'Maximum source point X-coordinate    = ',isrptxmax
      write(LERR,*)'Minimum source point X-coordinate    = ',isrptxmin
      write(LERR,*)'Maximum source point Y-coordinate    = ',isrptymax
      write(LERR,*)'Minimum source point Y-coordinate    = ',isrptymin
      write(LERR,*)' '
      write(LERR,*)'Maximum receiver point X-coordinate   = ',ircptxmax
      write(LERR,*)'Minimum receiver point X-coordinate   = ',ircptxmin
      write(LERR,*)'Maximum receiver point Y-coordinate   = ',ircptymax
      write(LERR,*)'Minimum receiver point Y-coordinate   = ',ircptymin
      write(LERR,*)' '
      write(LERR,*)'Maximum src/rcvr midpoint X-coordinate= ',isrrcxmax
      write(LERR,*)'Minimum src/rcvr midpoint X-coordinate= ',isrrcxmin
      write(LERR,*)'Maximum src/rcvr midpoint Y-coordinate= ',isrrcymax
      write(LERR,*)'Minimum src/rcvr midpoint Y-coordinate= ',isrrcymin
      write(LERR,*)' '
      write(LERR,*)'Maximum CDP bin center X-coordinate   = ',icdpbxmax
      write(LERR,*)'Minimum CDP bin center X-coordinate   = ',icdpbxmin
      write(LERR,*)'Maximum CDP bin center Y-coordinate   = ',icdpbymax
      write(LERR,*)'Minimum CDP bin center Y-coordinate   = ',icdpbymin
      write(LERR,*)' '
      write(LERR,*)'Maximum trace distance = ', dismax
      write(LERR,*)'Minimum trace distance = ', dismin
      write(LERR,*)' '
C-----------------------------------------------------------------------
C
C     PRINT INFORMATION ABOUT THE GRID
C
C-----------------------------------------------------------------------
C
      WRITE (LERR,3700) NX,NY
 3700 FORMAT (///, 1X, 'NO. OF CELLS ALONG SIDE 1-4 = ', I5,
     $             5X, 'NO. OF CELLS ALONG SIDE 1-2 = ', I5, /)
C
C-----------------------------------------------------------------------
C
C     WRITE SOME FINAL STATISTICS
C
C-----------------------------------------------------------------------
C
      WRITE (LERR,4100) NTR,MAXX
 4100 FORMAT ( / 1X, 'NO. OF LIVE TRACES CONTAINED IN AREA = ', I9,
     $       5X, 'MAX. NO. OF LIVE TRACES/CELL = ', I6)
C
C-----------------------------------------------------------------------
C
C     DETERMINE THE OUTPUT FOLD
C
C-----------------------------------------------------------------------
C
      IF (IFILL.EQ.0) IFOLD = MAXX

C=======================================================================
C
C     GENERATE FOLD PLOT FOR xsd
C
C=======================================================================

      IF (ftap(1:1) .ne. ' ') THEN

          if (.not. xline) then
             ntrc  = NX
             nsamp = NY
          else
             ntrc  = NY
             nsamp = NX
          endif
   
          call savew( datSV, 'NumTrc', ntrc  , LINHED)
          call savew( datSV, 'NumRec',   1   , LINHED)
          call savew( datSV, 'SmpInt',   1   , LINHED)
          call savew( datSV, 'NumSmp', nsamp , LINHED)
          call savew( datSV, 'Format',   3   , LINHED)

          obytes = SZTRHD + SZSMPD * nsamp
          CALL WRTAPE ( LUFOLD, datSV, LBYOUT)
      ENDIF


C
C
C-----------------------------------------------------------------------
C
C     WRITE PARAMETERS TO TEMPORARY DISK DATA SET FOR PHASE 2 OF SR3D
C
C-----------------------------------------------------------------------


      IF ( .not. restart ) THEN

         WRITE (LUOUT ) MODE  , NX    , NY    , MAXX  , IFOLD ,
     $                  IX1   , IY1   , IX2   , IY2   , IX3   ,
     $                  IY3   , IX4   , IY4   , DX    , DY    ,
     $                  ISGN  , XX     , XY    , YX    , YY   ,
     $                  NTR   , NTROUT, RI1   , RIINCR, LINE1 ,
     $                  LININC, DI1   , DIINCR, IWNDWS, IWNDWE,
     $                  IRT3D , ifmt_indexx, l_indexx, ln_indexx,
     $                          ifmt_indexy, l_indexy, ln_indexy,
     $                  TFS   , IDXWND, NS    , IMULT , NBYTESO,
     $                  DISMIN, DISMAX, XLINE, stack
      ELSE

         READ  (LUOUT ) MODE  , NX    , NY    , MAXX  , IFOLD ,
     $                  IX1   , IY1   , IX2   , IY2   , IX3   ,
     $                  IY3   , IX4   , IY4   , DX    , DY    ,
     $                  ISGN  , XX     , XY    , YX    , YY   ,
     $                  NTR   , NTROUT, RI1   , RIINCR, LINE1 ,
     $                  LININC, DI1   , DIINCR, IWNDWS, IWNDWE,
     $                  IRT3D , ifmt_indexx, l_indexx, ln_indexx,
     $                          ifmt_indexy, l_indexy, ln_indexy,
     $                  TFS   , IDXWND, NS    , IMULT , NBYTESO,
     $                  DISMIN, DISMAX, XLINE, stack

      ENDIF

         write(LERR,*)' '
         write(LERR,*)'Fold Chart'
         call savew2(data4,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 0    , TRACEHEADER)
         IF (.not. xline) THEN
   
            if ( restart ) then

            DO IX = 1,NX
 
               IL             =(IX-1) * NY + 1
               IR             = IX    * NY
               READ  (LUOUT  ) (JOUNT(II), II = 1, NY)
               II = 0
               do  IY = IL,IR
                   II = II + 1
                   KOUNT(IY) = KOUNT(IY) + JOUNT(II)
               enddo
 
            ENDDO

            REWIND LUOUT
            READ  (LUOUT ) MODE  , NX    , NY    , MAXX  , IFOLD ,
     $                     IX1   , IY1   , IX2   , IY2   , IX3   ,
     $                     IY3   , IX4   , IY4   , DX    , DY    ,
     $                     ISGN  , XX     , XY    , YX    , YY   ,
     $                     NTR   , NTROUT, RI1   , RIINCR, LINE1 ,
     $                     LININC, DI1   , DIINCR, IWNDWS, IWNDWE,
     $                     IRT3D , ifmt_indexx, l_indexx, ln_indexx,
     $                             ifmt_indexy, l_indexy, ln_indexy,
     $                     TFS   , IDXWND, NS    , IMULT , NBYTESO,
     $                     DISMIN, DISMAX, XLINE, stack
            endif


            DO IX = 1,NX

               IL             =(IX-1) * NY + 1
               IR             = IX    * NY

               WRITE (LUOUT  ) (KOUNT(IY), IY = IL,IR)

               if (verbos) then
               write (LERR,*)'Printing line ',ix,' from cells ',il,
     1                       ' to ',ir
               WRITE (LERR,111 ) (KOUNT(IY), IY = IL,IR)
               WRITE (LERR,* ) ' '
               endif
               if (ftap(1:1) .ne. ' ') then
                  ic = 0
                  do  ii = IL, IR
                      ic = ic + 1
                      xtr (ic) = KOUNT(ii)
                  enddo
                  call vmov (xtr, 1, data4(ITHWP1), 1, ic)
                  call savew2(data4,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          1    , TRACEHEADER)
                  call savew2(data4,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          IX   , TRACEHEADER)
                  call wrtape (lufold, data2, obytes)
               endif
            ENDDO
   
         ELSE

            if ( restart ) then
 
               DO IY = 1,NY
 
                  IL             =(IX-1) * NX + 1
                  IR             = IX    * NX
                  READ  (LUOUT  ) (JOUNT(II), II = 1, NX)
                  II = 0
                  do  IX = IL,IR
                      II = II + 1
                      KOUNT(IX) = KOUNT(IX) + JOUNT(II)
                  enddo
 
               ENDDO
 
               REWIND LUOUT
               READ  (LUOUT ) MODE  , NX    , NY    , MAXX  , IFOLD ,
     $                     IX1   , IY1   , IX2   , IY2   , IX3   ,
     $                     IY3   , IX4   , IY4   , DX    , DY    ,
     $                     ISGN  , XX     , XY    , YX    , YY   ,
     $                     NTR   , NTROUT, RI1   , RIINCR, LINE1 ,
     $                     LININC, DI1   , DIINCR, IWNDWS, IWNDWE,
     $                     IRT3D , ifmt_indexx, l_indexx, ln_indexx,
     $                             ifmt_indexy, l_indexy, ln_indexy,
     $                     TFS   , IDXWND, NS    , IMULT , NBYTESO,
     $                     DISMIN, DISMAX, XLINE, stack
            endif

   
            DO IY = 1,NY

               IL             =(IY-1) * NX + 1
               IR             = IY    * NX

               WRITE (LUOUT  ) (KOUNT(IX), IX = IL,IR)

               if (verbos) then
               write (LERR,*)'Printing line ',ix,' from cells ',il,
     1                       ' to ',ir
               WRITE (LERR,111 ) (KOUNT(IX),IX=IL,IR)
               WRITE (LERR,* ) ' '
               endif
               if (ftap(1:1) .ne. ' ') then
                  ic = 0
                  do  ii = IL, IR
                      ic = ic + 1
                      xtr (ic) = KOUNT(ii)
                  enddo
                  call vmov (xtr, 1, data4(ITHWP1), 1, ic)
                  call savew2(data4,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          1    , TRACEHEADER)
                  call savew2(data4,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          IY   , TRACEHEADER)
                  call wrtape (lufold, data2, obytes)
               endif
            ENDDO
         ENDIF
111   format (20I4)

      if (dtap(1:1) .ne. ' ') then
         rewind lugrp
         do  joff = 1, ngrp
             write ( lugrp, *) spread (joff), idist (joff)
         enddo
         close (lugrp)
      endif

      if (atap(1:1) .ne. ' ') then
         rewind luang
         do  joff = 1, nang
             write ( luang, *) angs (joff), iangs (joff)
         enddo
         close (luang)
      endif


      write(LERR,*)' '


C-----------------------------------------------------------------------
C
C     GO TO SORTING STEP IF THE USER HAS REQUESTED IT
C     OTHERWISE, DO THE ACCOUNTING & CLOSE THE INPUT LOGICAL UNIT
C
C-----------------------------------------------------------------------
C

      WRITE (LERR,4300)
 4300 FORMAT (//'USER HAS FINISHED EXECUTION OF FIRST SORTING STEP')
      WRITE (LER  ,4300)
C
      GO TO 4800
C
C-----------------------------------------------------------------------
C
C     ERROR CHECK - MAXIMUM FOLD ALLOWED IS 512
C
C-----------------------------------------------------------------------
C
C4400 IF (IFOLD.LE.32000)    GO TO 4600
c     IF (IFOLD.LE.32000)    GO TO 4600
c     WRITE (LERR,4500) IFOLD
c4500 FORMAT ('0** M3011 ** ERROR DETECTED BY PROGRAM SR3D:'/
c    $ 13X, 'THE FOLD GENERATED FROM THE GIVEN SET OF PARAMETERS (',I5,
c    $      ')'/
c    $ 13X, 'EXCEEDS THE MAXIMUM ALLOWABLE FOR THE SORTING PHASE OF ',
c    $      'PROGRAM SR3D' /
c    $ 13X, 'REDUCE THE CELL INCREMENTS (1SR3D CC 51-62) SUCH THAT THE'/
c    $ 13X, 'NUMBER OF LIVE TRACES WITHIN A CELL DOES NOT EXCEED ',
c    $      'THE PROGRAM LIMIT OF 32000' /)
c     ICC               = 100
c     GO TO 4800
C
 4600 MAXX              = IFOLD * NX
      IF (NTROUT .NE. 0)   MAXX  = NTROUT
C
C-----------------------------------------------------------------------
C
C     DO ACCOUNTING FOR PHASE 1 OF SR3D & CLOSE THE INPUT LOGICAL UNIT
C
C-----------------------------------------------------------------------
C
      NXOUT             = MAXX / IFOLD
      NYOUT             = (NXY + NXOUT - 1) / NXOUT
C
      WRITE (LERR,4700) IFOLD,MAXX,NYOUT
 4700 FORMAT (/ ' OUTPUT FOLD = ', I4,
     $        / ' NO. OF OUTPUT TRACES/RECORD = ', I5,
     $        / ' NO. OF OUTPUT RECORDS = ', I5,
     $        //'0EXECUTION OF PRELIMINARY STEP COMPLETE -- READY FOR',
     $          ' SORTING STEP')
C
      ICC               = 0
C
 4800 continue

      if (rots) then

         call lfit (xcoordr, ycoordr, nlive, slope, trcept,
     1              siga, sigb, chi2, qq, angr)

         write(LERR,*)'**********************************************'
         write(LERR,*)'Solve Ax + B through the receiver XYs'
         write(LERR,*)'Number live traces                 =  ',nlive
         write(LERR,*)'Angle of rotation found for groups =  ',angr
         write(LERR,*)'Slope                              =  ',slope
         write(LERR,*)'X=0 intercept                      =  ',trcept
         write(LERR,*)'**********************************************'
      endif

C
 4900 CALL LBCLOS (luin  )
      if (ftap(1:1) .ne. ' ') call lbclos (lufold)
      close (LUOUT )
      write(LERR,*)'**********************************************'
      write(LERR,*)'      Normal completion of sr3d1...'
      write(LERR,*)'      ... ready for sr3d2'
      write(LERR,*)'**********************************************'
      close (LERR  )

      write(LER ,*)'**********************************************'
      write(LER ,*)'      Normal completion of sr3d1...'
      write(LER ,*)'      ... ready for sr3d2'
      write(LER ,*)'**********************************************'

      CALL CCEXIT (ICC)
      END
C
C***********************************************************************
C     SUBROUTINE NAME: BINBCD
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: GARY RUCKGABER & GARY DONATHAN
C
C     DATE WRITTEN: 02/??/77
C
C     MODIFICATION HISTORY:
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: CONVERTS A NUMBER INTO ITS EQUIVALENT IN ALPHANUMERIC
C               CHARACTERS.
C
C     CALLING SEQUENCE: CALL BINBCD (IN , IA)
C          IN - NUMBER TO BE CONVERTED
C          IA - ALPHANUMERIC CHARACTERS RETURNED
C
C***********************************************************************
C
C
      SUBROUTINE BINBCD (IN,IA)
C
C
C-----------------------------------------------------------------------
C
C     DEFINE, DECLARE, & INITIALIZE VARIABLES
C
C-----------------------------------------------------------------------
C
      INTEGER*4 IN
C
      INTEGER*2 IA2, EB2
C
      character*1 IA(4), EB(10), BL, IA1

C
      EQUIVALENCE (IA1,IA2)
C
      DATA EB/'0','1','2','3','4','5','6','7','8','9'/
      DATA BL/' '/, EB2/'0 '/, IA2/'  '/
C
C-----------------------------------------------------------------------
C
C     SET INITIAL PARAMETER VALUES
C
C-----------------------------------------------------------------------
C
      II        = 4
      IJ        = IN
C
C-----------------------------------------------------------------------
C
C     STRIP OFF CHARACTERS OF INPUT NUMBER & STUFF ALPHA EQUIVALENT
C
C-----------------------------------------------------------------------
C
      DO 100 I = 1,4
         KJ     = IJ / 10
         LJ     = IJ - (KJ * 10)
         IA(II) = EB(LJ+1)
         II     = II - 1
         IJ     = KJ
  100 CONTINUE
C
C-----------------------------------------------------------------------
C
C     REPLACE ANY PRECEEDING ZEROS IN NUMBER WITH ALPHA BLANKS
C
C-----------------------------------------------------------------------
C
      DO 200 I = 1,4
         IA1 = IA(I)
         IF (IA2.EQ.EB2) GO TO 300
         IA(I)   = BL
  200 CONTINUE
C
C-----------------------------------------------------------------------
C
  300 RETURN
      END

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'sr3d1:  3D sorting to build sort table for use in sr3d2'
      write(LER,*)
     :'execute sr3d1 by typing sr3d1 and a list of program parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)  : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout) : output sort table'
        write(LER,*)
     :' -M [mtap]   (optional): graphical input coordinate file'
        write(LER,*)
     :' -F [mtap]   (optional): seismic format file of fold'
        write(LER,*)
     :' -S [dtap]   (optional): xgraph format file of offset distributio
     :n (need dmin,dmax,ddel)'
        write(LER,*)
     :' -dmin [dmin] (0)   : min model spread offset'
        write(LER,*)
     :' -dmax [dmax] (none): max model spread offset'
        write(LER,*)
     :' -ddel [ddel] (none): model spread group interval'
        write(LER,*)
     :' -A [atap]   (optional): xgraph format file of azimuth distributi
     :on (need amin,amax,adel)'
        write(LER,*)
     :' -amin [amin] (0)   : min src-rcvr azimuth'
        write(LER,*)
     :' -amax [amax] (360) : max src-rcvr azimuth'
        write(LER,*)
     :' -adel [adel] (15)  : azimuth bin size'
      write(LER,*)' '
        write(LER,*)
     :' -dx [dx]    (none)    : cross-line (side 3-4) cell dimension'
        write(LER,*)
     :' -dy [dy]    (none)    : in-line (side 1-2) cell dimension'
        write(LER,*)
     :' Note: for CDP sorts the cell dimensions will be 1/2 the line &'
        write(LER,*)
     :' group (receiver spacing in Y-direction) spacing'
        write(LER,*)
     :' -moredata    restart using more input data'
      write(LER,*)' '
        write(LER,*)
     :' Sort over area:'
        write(LER,*)
     :' -x1 [x1]    (none)    : x-coord Corner 1'
        write(LER,*)
     :' -y1 [y1]    (none)    : y-coord Corner 1'
        write(LER,*)
     :' -x2 [x2]    (none)    : x-coord Corner 2'
        write(LER,*)
     :' -y2 [y2]    (none)    : y-coord Corner 2'
        write(LER,*)
     :' -x3 [x3]    (none)    : x-coord Corner 3'
        write(LER,*)
     :' -y3 [y3]    (none)    : y-coord Corner 3'
        write(LER,*)
     :' -x4 [x4]    (none)    : x-coord Corner 4'
        write(LER,*)
     :' -y4 [y4]    (none)    : y-coord Corner 4'
      write(LER,*)' '
        write(LER,*)
     :' Sort along line or swath:'
        write(LER,*)
     :' -xgraph          coordinates in xgraph file format, or...'
        write(LER,*)
     :' -plotxy          coordinates in plotxy file format, or...'
        write(LER,*)
     :' -xsd             coordinates in xsd pick file format, or...'
        write(LER,*)
     :' -line [line] (1)      : segment to use (xgraph, plotxy, or xsd)'
        write(LER,*)
     :'                  coordinates read in on command line...'
        write(LER,*)
     :'                     ... either input (x1,y1) & (x3,y3), or'
        write(LER,*)
     :'                     ... input (x2,y2) & (x4,y4), or'
        write(LER,*)
     :'This defines area of interest over survey area.  We also need...'
      write(LER,*)' '
        write(LER,*)
     :' -ndx [ndx] (1)        : In-line or swath width in Y-cell units'
        write(LER,*)
     :' -ndy [ndy] (1)        : X-line or swath width in X-cell units'
      write(LER,*)' '
        write(LER,*)
     :' -mode [mode]  (5)     : sort type: 1=CMP; 2=CRP; 3=CSP; 5=CDP'
        write(LER,*)
     :' -fold [fld] (computed): user fold override'
        write(LER,*)
     :' -fill [fll] (computed): 0 = output recs padded to max live trcs'
        write(LER,*)
     :'                         1 = output recs padded to fold above'
        write(LER,*)
     :' -type [typ] (0)       : 0 = gathers vary in LI-increasing order'
        write(LER,*)
     :'                         1 = gathers vary in serpentine order'
        write(LER,*)
     :' -ntrc [ntr] (fold)    : override # trcs per rec in line header'
        write(LER,*)
     :' -X                    : sr3d2 will output data in crossline'
        write(LER,*)
     :'                         order, else the output is inline order'
        write(LER,*)
     :' -stk                  : for stacked data - midpoint XYs exist in
     : in headers'
        write(LER,*)
     :'                         (they do not exist in the headers)'
        write(LER,*)
     :' -swx [srtwdx] (CDPBCX): for stack option specify X-coord word'
        write(LER,*)
     :' -swy [srtwdy] (CDPBCY): for stack option specify Y-coord word'

      write(LER,*)' '
         write(LER,*)
     :'usage:'
         write(LER,*)
     :'   sr3d1 -N[ntp] -O[otp] '
         write(LER,*)
     :'         -F[] -S[] -dmin[] -dmax[] -ddel[] '
         write(LER,*)
     :'         -A[] -amin[] -amax[] -adel[] '
         write(LER,*)
     :'         -x1[] -y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[] '
         write(LER,*)
     :'         -dx[] -dy[] -xsd -xgraph -plotxy -line[] '
         write(LER,*)
     :'         -mode[] -fill[] -ntrc[] -type[] -nd[]'
         write(LER,*)
     :'         [-moredata] -X -stk -swx[] -swy[] [-R]'
         write(LER,*)
     :'***************************************************************'
      return
      end

