C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine flex_min_radial_dist ( IFOLD, FoldNm, itemd, 
     :     gather, num_flex_traces, flex_dist_required, 
     :     iteme, flex_radial_dist, flex_pointer, flex_lui, 
     :     dstdel, flex_trdist, flex_count, itemi, 
     :     trdist, LinInd, DphInd, lentrc, off, off_found,
     :     radius)

#include <f77/iounit.h>

c the logic in this routine is the first pass that I wrote fast to test the
c veracity of the approach.  If it works I will make it much more efficient
c by sorting the flex arrays based on flex_trdist and search over a much 
c smaller subset of the input data when looking for offsets to fill missing
c bins

c declare variables passed from calling routine

      integer IFOLD, FoldNm, itemd, num_flex_traces, iteme, flex_count 
      integer itemi, LinInd, DphInd, lentrc
      integer flex_pointer(iteme), flex_trdist(iteme), gather(itemd)
      integer flex_lui(iteme)

      real flex_dist_required(num_flex_traces), flex_radial_dist(iteme)
      real dstdel, trdist(itemi), radius

      logical off, off_found

c declare local variables

      integer pointer, luin, i, j, DstSgn, trndx

      real half_incr, min_dist

c initialize variables

      half_incr = dstdel / 2.0
      off_found = .false.

      DO i = 1, num_flex_traces

         min_dist = radius
         pointer = 0

         do j = 1, flex_count

            if ( ( float (flex_trdist(j)) .le. ( flex_dist_required(i) + 
     :           half_incr ) ) .and. ( float (flex_trdist(j)) .gt. 
     :           ( flex_dist_required(i) - half_incr ) ) ) then
               
               if ( flex_radial_dist(j) .lt. min_dist ) then
                  min_dist = flex_radial_dist(j)
                  pointer = flex_pointer(j)
                  luin = flex_lui(j)
                  DstSgn = flex_trdist(j)
               endif
                  
            endif
         enddo

         if ( off ) then

            if ( pointer .ne. 0 ) then
            
c have a trace to output for this offset so load the gather
c with the single trace required.  Remember for an offset
c sort there will never be more than a single trace in 
c gather.
    
               call sisseek (luin, pointer)
               call rtape ( luin, gather(1), nbytes )
               trdist(1) = float(DstSgn)
               FoldNm = 1
               off_found = .true.
            endif
            
         else

            if ( pointer .ne. 0 ) then
            
c have a trace to add to gather so add it
            
               trndx = FoldNm * lentrc + 1
               FoldNm = FoldNm + 1

               if ( FoldNm .le. IFOLD ) then
                  call sisseek (luin, pointer)
                  call rtape ( luin, gather(trndx), nbytes )
                  trdist(FoldNm) = float(DstSgn)
               else

                  write(LERR,*)' flexing LI ',LinInd,' DI ',DphInd
                  write(LERR,*)' when fold exceeded ',IFOLD,' for now'
                  write(LERR,*)' will cease flexing this bin'
                  write(LERR,*)'WARNING'
                  write(LER,*)' '
                  write(LER,*)'FLEXBIN: '
                  write(LER,*)' flexing LI ',LinInd,' DI ',DphInd
                  write(LER,*)' when fold exceeded ',IFOLD,' for now'
                  write(LER,*)' will cease flexing this bin'
                  write(LER,*)'WARNING'
                  write(LER,*)' '
                  FoldNm = IFOLD
                  return
               endif
            endif
         endif
      ENDDO

      return
      end
            
            
