C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getwgt(taper,theta,xoff,ntr,
     1                  lerr,hamming,blackman,tnorm,snorm,verbos)
c
      parameter  (pi=3.14159265,twopi=2.*pi)
c
      real taper(ntr,ntr)  
      real theta(ntr)
      real xoff(ntr)
c
      logical hamming,blackman,tnorm,snorm,verbos
c
      dx=1.
      do 90000 noffset=1,ntr
       if(hamming .or. blackman .or. tnorm .or. snorm) then
c_____________________________________________________________________
c         calculate normalized weights for constant trace separation.
c
c         cf Gijs Vermeer
c            Seismic Wavefield Sampling
c            SEG 1990.
c_____________________________________________________________________
          xoffmin=1.*dx
          xoffmax=noffset*dx
          do 10000 itr=1,ntr
           xoff(itr)=itr*dx  
10000     continue
          xavg=.5*(xoffmax+xoffmin)
          xdiff=xoffmax-xoffmin
          if(noffset .gt. 1) then
            do 27000 k=1,noffset
             theta(k)=twopi*(xoff(k)-xavg)/xdiff
27000       continue
          else
            theta(1)=0.
          endif
          if(hamming) then
             do 28000 k=1,noffset
              taper(k,noffset)=(.54+.46*cos(theta(k)))
28000        continue
          elseif(blackman) then
             do 29000 k=1,noffset
              taper(k,noffset)=(.42+.5*cos(theta(k))
     1                       +.08*cos(2.*theta(k)))
29000        continue
          else
              do 29500 k=1,noffset
               taper(k,noffset)=1.
29500         continue
          endif
c_____________________________________________________________________
c         normalize weights.
c_____________________________________________________________________
          sum=0.
          do 29700 k=1,noffset
           sum=sum+taper(k,noffset)
29700     continue
          do 29600 k=1,noffset
           taper(k,noffset)=taper(k,noffset)/sum
29600     continue
       else
c_____________________________________________________________________
c         unnormalized, unitary weights.
c_____________________________________________________________________
          do 30000 k=1,noffset
           taper(k,noffset)=1.
30000     continue
       endif
       if(verbos) then
          write(lerr,*) 'number of nonzero samples = ',noffset
          write(lerr,'(3a12)') 'k','taper(k,noffset)'
          write(lerr,'(i12,f12.6)')
     1                (k,taper(k,noffset),k=1,noffset)
       endif
90000 continue
c
      return
      end
