C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( x1, y1, il_azimuth, cl_azimuth, NumRec, 
     :     NumTrc, NumSmp, NumLI, NumDI, OverLap, AvailableDisk, 
     :     ildm, cldm, graphtap, verbos )

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer NumRec, NumTrc, NumSmp, NumLI, NumDI, OverLap
      integer AvailableDisk

      real il_azimuth, cl_azimuth, ildm, cldm
      real*8 x1, y1

      character graphtap*255

      logical verbos

c declare local variables

      integer argis

      call argr4 ( '-clazim', cl_azimuth, 9999., 9999. )
      call argr4 ( '-cldm', cldm, 40.0, 40.0 )

      call argi4 ( '-disk', AvailableDisk, 0, 0 )

      call argr4 ( '-ilazim', il_azimuth, 9999., 9999. )
      call argr4 ( '-ildm', ildm, 12.5, 12.5 )

      call argi4 ( '-nsamp', NumSmp, 1, 1 )
      call argi4 ( '-nrec', NumRec, 1, 1 )
      call argi4 ( '-ntrc', NumTrc, 1, 1 )
      call argi4 ( '-ndi', NumDI, 0, 0 )
      call argi4 ( '-nli', NumLI, 0, 0 )

      call argi4 ( '-pad', OverLap, 0, 0 )

      verbos = (argis('-V') .gt. 0)

      call argr8 ( '-x1', x1, 0.0d0, 0.0d0 )
      call argstr ( '-X', graphtap, ' ', ' ' ) 

      call argr8 ( '-y1', y1, 0.0d0, 0.0d0 )

c Policemen

      if ( abs(il_azimuth - 9999.) .lt. 1.e-30 .or.
     :     abs(cl_azimuth - 9999.) .lt. 1.e-30 ) then
         write(LERR,*)' '
         write(LERR,*)' Both a -ilazim and -clazim entry'
         write(LERR,*)' are required on the command line'
         write(LERR,*)' Make the appropriate entries and '
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'DSWATH: '
         write(LER,*)' Both a -ilazim and -clazim entry'
         write(LER,*)' are required on the command line'
         write(LER,*)' Make the appropriate entries and '
         write(LER,*)'FATAL'
         stop
      endif

      if ( AvailableDisk .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' A desired size of each output swath'
         write(LERR,*)' is required.  "Resubmit with -disk '
         write(LERR,*)' entry completed on command line'
         write(LERR,*)'FATAL'
         write(LER,*)'DSWATH:'
         write(LER,*)' A desired size of each output swath'
         write(LER,*)' is required.  "Resubmit with -disk '
         write(LER,*)' entry completed on command line'
         write(LER,*)'FATAL'
         stop
      endif

      if ( NumDI  .eq. 0 .or.
     :     NumLI  .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' It is necessary to fully describe the'
         write(LERR,*)' input volume in terms of the number of LIs and'
         write(LERR,*)' DIs.  Check that the following are included'
         write(LERR,*)' [and non-zero] on the command line:'
         write(LERR,*)' '
         write(LERR,*)' -nli[] -ndi[] '
         write(LERR,*)' '
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)' It is necessary to fully describe the'
         write(LER,*)' input volume in terms of the number of'
         write(LER,*)' LIs and DIs.  Check that the following are '
         write(LER,*)' included [and non-zero] on the command line:'
         write(LER,*)' '
         write(LER,*)' -nli[] -ndi[] '
         write(LER,*)' '
         write(LER,*)'FATAL'
      endif

      return
      end
