C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( x1, y1, il_azimuth, cl_azimuth, NumRec, 
     :     NumTrc, NumSmp, NumLI, NumDI, OverLap, AvailableDisk, 
     :     ildm, cldm, graphtap, NumSwaths, NumLI_PerSwath, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer NumRec, NumTrc, NumSmp, NumLI, NumDI, OverLap
      integer AvailableDisk, NumSwaths, NumLI_PerSwath

      real il_azimuth, cl_azimuth, ildm, cldm
      real*8 x1, y1

      character graphtap*(*)

      logical verbos

      write(LERR,*)' '
      write(LERR,*)' Data Volume Specifications'
      write(LERR,*)' --------------------------'
      write(LERR,*)' '
      write(LERR,*)' samples per trace     =  ', NumSmp
      write(LERR,*)' traces per record     =  ', NumTrc
      write(LERR,*)' number of records     =  ', NumRec
      write(LERR,*)' number of LIs         =  ', NumLI
      write(LERR,*)' number of DIs         =  ', NumDI
      write(LERR,*)' overlap pad between swaths     =  ', OverLap
      write(LERR,*)' desired size of swath (Mbytes) = ',AvailableDisk
      if ( verbos ) write(LERR,*)' Verbose Printout Requested'
      write(LERR,*)' '
      write(LERR,*)' Data Orientation Specifications'
      write(LERR,*)' -------------------------------'
      write(LERR,*)' '
      write(LERR,*)' x1                    =  ', x1
      write(LERR,*)' y1                    =  ', y1
      write(LERR,*)' in-line azimuth       =  ', il_azimuth
      write(LERR,*)' cross-line azimuth    =  ', cl_azimuth
      write(LERR,*)' in-line spacing       =  ', ildm
      write(LERR,*)' cross-line spacing    =  ', cldm
      write(LERR,*)' '
      write(LERR,*)' Swath Calculations'
      write(LERR,*)' ------------------'
      write(LERR,*)' '
      write(LERR,*)' number of swaths required = ',NumSwaths
      write(LERR,*)' number of LIs per swath   = ',NumLI_PerSwath
      write(LERR,*)' '
      write(LERR,*)' Swath Corner Report'
      write(LERR,*)' -------------------'
      write(LERR,*)' '
      if ( verbos ) then
         write(LER,*)' '
         write(LER,*)' Swath Calculations'
         write(LER,*)' ------------------'
         write(LER,*)' '
         write(LER,*)' number of swaths required = ',NumSwaths
         write(LER,*)' number of LIs per swath   = ',NumLI_PerSwath
         write(LER,*)' '
         write(LER,*)' Swath Corner Report'
         write(LER,*)' -------------------'
         write(LER,*)' '
      endif  
       
      return
      end

