C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c	8-26-97 changed call to subroutine subs....missing parameters
c               in the second call statement.  mamiller
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer     shed ( SZLNHD )
      integer     itr  ( SZLNHD )
      integer     str  ( SZLNHD )
      real        head ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        lines, linee
      integer     index
      pointer     (wkadrs , lines(1))
      pointer     (wkadre , linee(1))
      pointer     (wkindex, index(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     linnum, trcnum
      integer     lin1(SZLNHD), trc1(SZLNHD)
      integer     lin2(SZLNHD), trc2(SZLNHD)
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri  ( SZLNHD ), velw ( SZLNHD ), velx ( SZLNHD )
      real        w1 ( SZLNHD ), w2 ( SZLNHD )
      real        x1 ( SZLNHD ), x2 ( SZLNHD )
      character   ntap * 256, otap * 256, name*5, job*7
      character   hdrwrd * 6
      logical     verbos, query, heap1, heap2, first, last, twod
      logical     short
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )
      equivalence ( str( 1), shed (1) )

      data lbytes / 0 /, nbytes / 0 /, name/'VELINT'/
      data first /.true./
      data last  /.false./
      data short  /.false./
      data job /'*LM3DV*'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     1             hdrwrd, twod, verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'VELINT: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs. 
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)

      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)

      write(LERR,*)'MutVel,ifmt,l_MutVel,length= ',
     1             ifmt_MutVel,l_MutVel,ln_MutVel
      write(LERR,*)'WatVel,ifmt,l_WatVel,length= ',
     1             ifmt_WatVel,l_WatVel,ln_WatVel
      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 5, LERR)
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.
 
      IF (twod) THEN

         if (irs .ne. 0 .AND. ire .ne. 0) then

            nrecc = max (ire,irs) - min (ire,irs) + 1
            nreco = nrecc
            ntrco = 1
            if (ire .ge. irs) then
               ione = +1
            else
               ione = -1
            endif
            nvel = nrec

         elseif (ns .ne. 0 .AND. ne .ne. 0) then

            nrecc = max (ne,ns) - min (ne,ns) + 1
            nreco = 1
            ntrcc = nrecc
            ntrco = nrecc
            if (ire .ge. irs) then
               ione = +1
            else
               ione = -1
            endif
            irs = ns
            ire = ne
            nvel = ntrc

         endif

         item = nrec * SZSMPD
         call galloc (wkindex, item, errcd1, abort1)

         if (errcd1 .ne. 0.) heap1 = .false.
         if (.not. heap1) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) item,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*) item,'  bytes'
            go to 999
         else
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) item,'  bytes'
         endif


      ELSE

c--------------------------
c  note: these don't
c  have to be the same size

         nline = ire - irs + 1
         ntrce = ne - ns + 1
 
         item  = ntrc * nsamp  * SZSMPD
         ntrcc = nrec * ntrc
         nvel  = ntrcc
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
         call galloc (wkadrs, item, errcd1, abort1)
         call galloc (wkadre, item, errcd2, abort2)
 
         if (errcd1 .ne. 0.) heap1 = .false.
         if (errcd2 .ne. 0.) heap2 = .false.
 
         if (.not. heap1 .or. .not. heap2) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) item,'  bytes'
            write(LERR,*) item,'  bytes'
            write(LERR,*)' '
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*) item,'  bytes'
            write(LER ,*) item,'  bytes'
            go to 999
            else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) item,'  bytes'
            write(LERR,*) item,'  bytes'
            write(LERR,*)' '
         endif

      ENDIF
c---------------------------------------------------
 
 
c-----
c     modify line header to reflect actual number of traces output
c-----

      IF ( twod ) THEN

         call savew(itr, 'NumRec', nreco, LINHED)
         call savew(itr, 'NumTrc', ntrco, LINHED)

      ELSE

         call savew(itr, 'MnLnIn',  irs , LINHED)
         call savew(itr, 'MxLnIn',  ire , LINHED)
         call savew(itr, 'MnDpIn',  ns  , LINHED)
         call savew(itr, 'MxDpIn',  ne  , LINHED)
         call savew(itr, 'NumRec', nline, LINHED)
         call savew(itr, 'NumTrc', ntrce, LINHED)
         call savew(itr, 'JobNum', job  , LINHED)

      ENDIF
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  hdrwrd,irs,ire,ns,ne,ntap,otap,twod)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read velocity traces, interpolate onto a grid of indexes,
c     write out interpolated velocity traces
c-----

c***********
c first part is for 2D data sets: the input data are read and the
c appropriate index is stored (one index per record). The velocity
c data set is read trace by trace and the indexes are used to position
c the trace within the overall numbering scheme. The velocity traces
c between these control points are linearly interpolated.
c***********

      IF (twod) THEN


         ic = 0
         do  jj = irs, ire, ione
             ic = ic + 1
             index (ic) = jj
         enddo

         DO  JJ = 1, nvel
 
             call rtape ( luin, shed, nbytes )
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
             if(nbytes .eq. 0) then
                write(LERR,*)'End of file on input:'
                write(LERR,*)'  rec= ',jj
                short = .true.
             endif
             call saver2(shed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                   ipos , TRACEHEADER)

             call vmov   (shed(ITHWP1), 1, tri, 1, nsamp)
             if (JJ .eq. nvel) last = .true.

             call veltrp (index, ipos, nrecc, nsamp, first, last,
     1                    iposl, iposr, tri, velw, velx, luout, shed,
     2                    ITHWP1, ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     3                    obytes, short, ione)

         ENDDO

c***********
c the next option is for 3D data. Given a regular set of line & trace
c indexes (forming a 2D survey gird) read each velocity trace, locate
c it in the grid and interpolate the functions areally
c***********
 
      ELSE

c-----
c     process desired trace records
c-----
      DO  JJ = 1, nrec
 
            ic = 0
            do  kk = 1, ntrc
 
                  nbytes = 0
                  call rtape( luin, str, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 111
                  endif

 
c------
c     use previously derived pointers to trace header values
                  call saver2(shed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)
                  call saver2(shed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        linnum , TRACEHEADER)
                  call saver2(shed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  lincur = linnum
                  if (KK .eq. 1) linlst = linnum
                  if (lincur .ne. linlst .AND. KK .lt. ntrc) then
                     write(LERR,*)'Input record ',linlst,' was short'
                     write(LERR,*)' Run pad ... | velint ...'
                     write(LERR,*)' to pad out short records'
                     write(LERR,*)'Stopping velint'
                     write(LER ,*)'Input record ',linlst,' was short'
                     write(LER ,*)' Run pad ... | velint ...'
                     write(LER ,*)' to pad out short records'
                     write(LER ,*)'Stopping velint'
                     go to 999
                  endif
c------

c----------------------
c  pack data into array
c  if it is desired area
               IF (istatic .ne. 30000) THEN

                  if ( trcnum .ge. ns  .AND. trcnum .le. ne    .AND.
     1                 linnum .ge. irs .AND. linnum .le. ire ) then

                       call move (1, lhed, shed, nbytes)
                       call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
                       ic = ic + 1
                       istrc = (ic-1) * nsamp
                       if (first) then
                          lin1  (ic) = linnum 
                          trc1  (ic) = trcnum 
                          call vmov (tri,1, lines (istrc+1),1, nsamp)
                       else
                          lin2  (ic) = linnum 
                          trc2  (ic) = trcnum 
                          call vmov (tri,1, linee (istrc+1),1, nsamp)
                       endif
                  endif
               ENDIF
 
            enddo

111         continue

c-----
c  if there are no live velocity traces in an input line
c  go on to the next line
c-----
            if (ic .eq. 0) then
               go to 555
c-----
c  if there is only one live velocity traces in an input line
c  fill out the indexes to force the same function over the
c  whole line from traces ns to ne
c-----
            elseif (ic .eq. 1) then
               trc1 (1) = ns
               trc1 (2) = ne
               trc2 (1) = ns
               trc2 (2) = ne
               lin1 (2) = lin1 (1)
               lin2 (2) = lin2 (1)
               ic = 2
               if (first) then
                  call vmov (tri, 1, lines(nsamp+1), 1, nsamp)
               else
                  call vmov (tri, 1, linee(nsamp+1), 1, nsamp)
               endif
            endif

c-----
c  if there is only one line then set up the indexing to force this
c  line over the whole volume from irs to ire
c-----
            if (nrec .eq. 1) then
                do  i = 1, ic
                    lin1 (i) = ire
                enddo
                linnum = ire
            endif

            if (first) then
               nt1 = ic
               nt2 = 1
            else
               nt2 = ic
            endif

c-----------------------
c  here's the meat...
c  interpolate (in 2D bwteen lines) and
c  write out vels
                     call subs (ntrc, nt1, nt2, nsamp, irs, ire, ns, ne,
     1                          lin1, trc1, lin2, trc2, lines, linee,
     2                          itr, lhed, tri, ITHWP1, ITRWRD, luout,
     3                          ifmt_TrcNum,l_TrcNum,ln_TrcNum, first,
     4                          ifmt_RecNum,l_RecNum,ln_RecNum, last,
     5                          ifmt_LinInd,l_LinInd,ln_LinInd,
     6                          ifmt_DphInd,l_DphInd,ln_DphInd,
     7                          SZLNHD, SZSMPD, obytes, w1, w2, x1, x2,
     8                          velw, velx)
c-----------------------

            if (.not. first) then
               nt1 = nt2
               do  j = 1, nt2
                   lin1 (j) = lin2 (j)
                   trc1 (j) = trc2 (j)
               enddo
               call move (1, lines, linee, item)
            endif
 
            first = .false.
 
      ENDDO

555   continue
c-----------------------
c  get the last line to
c  the end of the survey
            if (linnum .lt. ire) then
                     last = .true.
                     call subs (ntrc, nt1, nt2, nsamp, irs, ire, ns, ne,
     1                          lin1, trc1, lin2, trc2, lines, linee,
     2                          itr, lhed, tri, ITHWP1, ITRWRD, luout,
     3                          ifmt_TrcNum,l_TrcNum,ln_TrcNum, first,
     4                          ifmt_RecNum,l_RecNum,ln_RecNum, last,
     5                          ifmt_LinInd,l_LinInd,ln_LinInd,
     6                          ifmt_DphInd,l_DphInd,ln_DphInd,
     7                          SZLNHD, SZSMPD, obytes, w1, w2, x1, x2,
     8                          velw, velx)

cmam                 call subs (nt1, nt2, nsamp, irs, ire, ns, ne,
cmam 1                          lin1, trc1, lin2, trc2, lines, linee,
cmam 2                          itr, lhed, tri, ITHWP1, ITRWRD, luout,
cmam 3                          ifmt_TrcNum,l_TrcNum,ln_TrcNum, first,
cmam 4                          ifmt_RecNum,l_RecNum,ln_RecNum, last,
cmam 5                          SZLNHD, SZSMPD, obytes, w1, w2, x1, x2,
cmam 6                          velw, velx)
            endif
c-----------------------
 
      ENDIF

  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of velint, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'end of velint, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'velint does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute velint by typing velint and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)   : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)   : output data file name'
        write(LER,*)' '
        write(LER,*)
     :'  The next 4 entries define the X-Y dimensions of the cube in'
        write(LER,*)
     :'  of lines & traces'
        write(LER,*)
     :' -ns[ns]    (default = none) : starting trace number'
        write(LER,*)
     :' -ne[ne]    (default = none) : ending trace number'
        write(LER,*)
     :' -rs[irs]   (default = none) : starting line number'
        write(LER,*)
     :' -ne[ire]   (default = none) : ending line number'
        write(LER,*) ' '
        write(LER,*)
     :' -twod  include on command line if 2D data set'
        write(LER,*)
     :' -hw[hdrwrd] (default = RecNum) : 2D indexing header word'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   velint -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'                 -re[ire] [ -twod [ -hw[] ] -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,
     1                  hdrwrd, twod, verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), hdrwrd *(*)
      integer     ns, ne, irs, ire
      logical     verbos, twod
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program velint might be invoked in the following way:
 
c     velint  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into velint and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-hw', hdrwrd, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            twod   =   (argis('-twod') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
            if (twod .AND. hdrwrd(1:1) .eq. ' ') then

               if (irs .ne. 0 .AND. ire .ne. 0) then

                  hdrwrd = 'RecNum'

               elseif (ns .ne. 0 .AND. ne .ne.  0) then

                  hdrwrd = 'TrcNum'

               else

                  write(LERR,*)' '
                  write(LERR,*)'FATAL ERROR in velint (2D):'
                  write(LERR,*)'Must specify record or trace limits,'
                  write(LERR,*)'i.e., -rs[] -re[]  or  -ns[] -ne[]'
                  write(LER ,*)' '
                  write(LER ,*)'FATAL ERROR in velint (2D):'
                  write(LER ,*)'Must specify record or trace limits,'
                  write(LER ,*)'i.e., -rs[] -re[]  or  -ns[] -ne[]'
                  call ccexit (666)

               endif

            elseif (.not.twod .AND. hdrwrd(1:1) .eq. ' ') then

               hdrwrd = 'RecNum'

            endif
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  hdrwrd,irs,ire,ns,ne,ntap,otap,twod)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, irs,ire,ns,ne
      character   ntap*(*), otap*(*), hdrwrd*(*)
      integer     length, lenth
      logical     twod
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' starting line      =  ',irs
            write(LERR,*) ' ending line        =  ',ire
            write(LERR,*) ' tot number lines   =  ', ire-irs+1
            write(LERR,*) ' starting trace     =  ',ns
            write(LERR,*) ' ending trace       =  ',ne
            write(LERR,*) ' tot number traces  =  ', ne-ns+1
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (twod) then
              write(LERR,*) ' 2D data set'
	      length = lenth(hdrwrd)
	      if (length .gt. 0) then
                write(LERR,*) ' using header word   =  ',
     1                      hdrwrd(1:lenth(hdrwrd))
	      else
                write(LERR,*) ' using header word   =  N/A'
	      endif
            else
             write(LERR,*) ' 3D data set'
            endif
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
