C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Double_Taper ( v, v1, v2, v3, v4, a, a1, a2, a3, a4, 
     :     pass, pi, Taper )

c variables passed from calling routine

      real v, v1, v2, v3, v4, a, a1, a2, a3, a4, pi, Taper

      logical pass

c local variables

      integer On, Off
      real    Ataper, Vtaper

c initialize variables

      if ( pass ) then
         On = 0
         Off = 1
      else
         On = 1
         Off = 0
      endif

c determine Taper

c watch out for aperture stradling origin

      if ( a4 .lt. a1 ) then

c completely outside filter 

         if ( ( a .lt. a1 .and. a .gt. a4) .or. 
     :        v .lt. v1 .or. v .gt. v4 ) then

            if ( pass ) then
               Taper = 0.0
            else
               Taper = 1.0
            endif
            return
         endif

c completely inside pass/reject zone

         if ( ( v .ge. v2 .and. v .le. v3 ) .and.
     :        ( a .ge. a2 .or. a .le. a3 ) ) then
            if ( pass ) then
               Taper = 1.0
            else
               Taper = 0.0
            endif
            return
         endif
      else

         if ( a .lt. a1 .or. a .gt. a4 .or. v .lt. v1 .or. v .gt. v4 ) 
     :        then
            if ( pass ) then
               Taper = 0.0
            else
               Taper = 1.0
            endif
            return
         endif

c completely inside pass/reject zone

         if ( ( v .ge. v2 .and. v .le. v3 ) .and.
     :        ( a .ge. a2 .and. a .le. a3 ) ) then
            if ( pass ) then
               Taper = 1.0
            else
               Taper = 0.0
            endif
            return
         endif
      endif

c in on/off taper zone

      if ( v .ge. v1 .and. v .lt. v2 ) then

c v --> on , a --> on

         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper ( v, v1, v2, Vtaper, pi, On )
            call CosTaper ( a, a1, a2, Ataper, pi, On )
            Taper = (Vtaper**2 + Ataper**2) ** 0.5
         endif

c v --> on , a --> pass

         if ( a4 .lt. a1 ) then

c stradling the origin

            if ( a .ge. a2 .or. a .le. a3 ) then
               call CosTaper ( v, v1, v2, Taper, pi, On )
               return
            endif
         else
            if ( a .ge. a2 .and. a .le. a3 ) then
               call CosTaper ( v, v1, v2, Taper, pi, On )
               return
            endif
         endif

c v --> on , a --> off

         if ( a .gt. a3 .and. a .le. a4 ) then
            call CosTaper ( v, v1, v2, Vtaper, pi, On )
            call CosTaper ( a, a3, a4, Ataper, pi, Off )
            Taper = (Vtaper**2 + Ataper**2) ** 0.5
         endif

      elseif ( v .ge. v2 .and. v .le. v3 ) then

c v --> pass , a --> on

         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper ( a, a1, a2, Taper, pi, On )
            return
         endif

c v --> pass , a --> off

         if ( a .gt. a3 .and. a .le. a4 ) then
            call CosTaper ( a, a3, a4, Taper, pi, Off )
            return
         endif

      elseif ( v .gt. v3 .and. v .le. v4 ) then

c v --> off , a --> on

         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper ( v, v3, v4, Vtaper, pi, Off )
            call CosTaper ( a, a1, a2, Ataper, pi, On )
            Taper = (Vtaper**2 + Ataper**2) ** 0.5
         endif

c v --> off , a --> pass

         if ( a4 .lt. a1 ) then

c stradling the origin

            if ( a .ge. a2 .or. a .le. a3 ) then
               call CosTaper ( v, v3, v4, Taper, pi, Off )
               return
            endif
         else
            if ( a .ge. a2 .and. a .le. a3 ) then
               call CosTaper ( v, v3, v4, Taper, pi, Off )
               return
            endif
         endif

c v --> off , a --> off

         if ( a .gt. a3 .and. a .le. a4 ) then
            call CosTaper ( v, v3, v4, Vtaper, pi, Off )
            call CosTaper ( a, a3, a4, Ataper, pi, Off )
            Taper = (Vtaper**2 + Ataper**2) **0.5
         endif

      endif

      if ( Taper .gt. 1.0 ) Taper = 1.0
      if ( Taper .lt. 0.0 ) Taper = 0.0
      return

      end


