C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, dt, dx, dy, dz, v1, v2, v3, v4, 
     :     a1, a2, a3, a4, f1, f2, f3, f4, Exponent, r1, r2, r3, r4, 
     :     pass, verbos )

#include <f77/iounit.h>

c variables to be parsed and passed back to calling routine

      integer     argis

      real        dt, dx, dy, dz
      real        v1, v2, v3, v4
      real        a1, a2, a3, a4
      real        f1, f2, f3, f4, Exponent

      character   ntap*(*), otap*(*)

      logical     pass, verbos

C parse away

      call argr4( '-a1', a1, 0.0, 0.0 )
      call argr4( '-a2', a2, 0.0, 0.0 )
      call argr4( '-a3', a3, 0.0, 0.0 )
      call argr4( '-a4', a4, 0.0, 0.0 )

      call argr4( '-dt', dt, 0.0, 0.0 )
      call argr4( '-dx', dx, 25.0, 25.0 )
      call argr4( '-dy', dy, 25.0, 25.0 )
      call argr4( '-dz', dz, 0.0, 0.0 )

      call argr4( '-exp', Exponent, 0.0, 0.0 )

      call argr4( '-f1', f1, 0.0, 0.0 )
      call argr4( '-f2', f2, 0.0, 0.0 )
      call argr4( '-f3', f3, 0.0, 0.0 )
      call argr4( '-f4', f4, 0.0, 0.0 )

      call argstr ( '-N', ntap, ' ', ' ' )

      call argstr ( '-O', otap, ' ', ' ' )

      pass = ( argis ('-pass') .gt. 0 )

      call argr4( '-v1', v1, 0.0, 0.0 )
      call argr4( '-v2', v2, 0.0, 0.0 )
      call argr4( '-v3', v3, 0.0, 0.0 )
      call argr4( '-v4', v4, 0.0, 0.0 )

      call argr4( '-r1', r1, 0.0, 0.0 )
      call argr4( '-r2', r2, 0.0, 0.0 )
      call argr4( '-r3', r3, 0.0, 0.0 )
      call argr4( '-r4', r4, 0.0, 0.0 )

      verbos = ( argis ('-V') .gt. 0 )

      if ( abs(dt) .lt. 1.e-32 .and. abs(dz) .lt. 1.e-32 ) then
         write(LERR,*)' '
         write(LERR,*)'VFILT3DA: You must supply the sample interval '
         write(LERR,*)'          of your pre-fftpack (x,y,t) volume '
         write(LERR,*)'          on the command line.  Use the -dt or '
         write(LERR,*)'          -dz entry and resubmit. '
         write(LERR,*)'FATAL '
         write(LER,*)' '
         write(LER,*)'VFILT3DA: You must supply the sample interval '
         write(LER,*)'          of your pre-fftpack (x,y,t) volume '
         write(LER,*)'          on the command line.  Use the -dt or '
         write(LER,*)'          -dz entry and resubmit. '
         write(LER,*)'FATAL '
         stop
      endif

      if ( abs(dz) .gt. 1.e-30 ) then
c this will make depth units kilometers or kilofeet
c         dt = dz / 1000.
         dt = dz
      endif
         
      return
      end



