C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, nsamp, ntrc, nrec, dt, dx, dy, dz, 
     :     v1, v2, v3, v4, a1, a2, a3, a4, f1, f2, f3, f4, Exponent, 
     :     r1, r2, r3, r4, pass, verbos ) 

#include <f77/iounit.h>

      integer     nsamp, ntrc, nrec

      real        dt, dx, dy, dz
      real        v1, v2, v3, v4
      real        a1, a2, a3, a4
      real        f1, f2, f3, f4, Exponent 
      real        r1, r2, r3, r4

      character   ntap*(*), otap*(*)

      logical     pass, verbos
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' Cross-line spacing    =  ', dy
      write(LERR,*) ' In-line spacing       =  ', dx
      if ( abs(dz) .lt. 1.e-30 ) then
         write(LERR,*) ' Sample Interval       =  ', dt, 'Seconds'
      else
         write(LERR,*) ' Sample Interval       =  ', dz, 'M or FT'
      endif
      if ( pass ) then
         write(LERR,*)' Data will be passed between following limits:'
      else
         write(LERR,*)' Data will be rejected between following limits:'
      endif
      write(LERR,*)' '
      write(LERR,*)' Velocity Parameters '
      write(LERR,*)' '
      write(LERR,*) ' v1  =  ', v1
      write(LERR,*) ' v2  =  ', v2
      write(LERR,*) ' v3  =  ', v3
      write(LERR,*) ' v4  =  ', v4
      write(LERR,*)' '
      write(LERR,*)' Azimuthal Parameters '
      write(LERR,*)' '
      write(LERR,*) ' a1  =  ', a1
      write(LERR,*) ' a2  =  ', a2
      write(LERR,*) ' a3  =  ', a3
      write(LERR,*) ' a4  =  ', a4
      write(LERR,*)' '
      write(LERR,*)' Temporal Frequency Parameters '
      write(LERR,*)' '
      write(LERR,*) ' f1  =  ', f1
      write(LERR,*) ' f2  =  ', f2
      write(LERR,*) ' f3  =  ', f3
      write(LERR,*) ' f4  =  ', f4
      if ( abs(Exponent) .gt. 1.e-30 )
     :write(LERR,*) ' Powering Exponent   =  ', Exponent
      write(LERR,*)' '
      write(LERR,*)' Dispersive Filter Parameters '
      write(LERR,*)' '
      write(LERR,*) ' r1  =  ', r1
      write(LERR,*) ' r2  =  ', r2
      write(LERR,*) ' r3  =  ', r3
      write(LERR,*) ' r4  =  ', r4
      write(LERR,*)' '
      if (verbos) write(LERR,*)' Verbos printout requested'
      write(LERR,*)' '
 
      return
      end
