C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Neighbors(X_sorted, Y_sorted, X, Y, neighborhood, 
     :     weight, Nfound, X_pointer, Y_pointer, radius, 
     :     nfunc, Cosine, PIby2, xlower, ylower, min_num_desired,
     :     exponent, scoping )

c this is a replacement for the venerable subroutine amneb() which
c ran for many years but was completely unservicable
c as nobody could figure out what the hell it did or how it did it.
c The original routine was keypunched on cards with so many archaic
c if tests, do tests and statement numbers that no human could follow the
c logic.  The original authors must really have been computer scientists.
c Hopefully anyone can follow this logic.  At least for the next few
c years or as long as the company lasts [whichever comes first].

c basically a rectilinear neighborhood is found quickly then searched
c in detail for points that fall inside a circle of the radius 
c desired.  Once found a weight is calculated and the original index
c is stored in the neighborhood array.  Upone return from this routine
c there will be Nfound entries in both neighborhood[] and weight[].  
c neighborhood[] will contain the index associated with a given X,Y 
c point in the original X and Y [unsorted] arrays which are in sync
c with the input velocity data thus allowing the extraction of the
c function from that location.  weight[] has the un-normalized 
c weight calculated for each function. 

c should no points be found within the radius of investigation, the
c radius will be expanded until at least min_num_desired number of
c points have been included in neighborhood[].

c if scoping is selected then dead traces are allowed in output if
c Nfound = 0 on first search within the original radius.

c declare variables passed from calling routine

      integer Nfound, nfunc
      integer neighborhood( nfunc) 
      integer X_pointer(nfunc), Y_pointer(nfunc)
      integer xlower, ylower
      integer min_num_desired

      real X_sorted(nfunc), Y_sorted(nfunc)
      real weight( nfunc), X, Y, radius
      real PIby2, exponent

      logical Cosine, scoping

c declare local variables

      integer x_index, y_index, i, Num_X, Num_Y

      real test, searchradius

      logical DoneX, DoneY

c initialize variables

      Nfound = 0
      Num_X = 0
      Num_Y = 0

c bracket X and Y in sorted coordinate arrays 

      xlower = 1
      ylower = 1
      call locate ( X_sorted, nfunc, X, xlower, x_index )
      call locate ( Y_sorted, nfunc, Y, ylower, y_index )

c determine search range to use in the sorted arrays. In other
c words find the range of X_sorted where all values are within
c the radius of investigation.  Do the same for Y then do the 
c pointwise search within these limits.  This will save time 
c search all Y_sorted for each X_sorted value identified.

      IF ( x_index .gt. 0 .and. x_index .lt. nfunc ) then

c find lower xlimit
   
         DoneX = .false.
         i = 1
 
         do while ( .not. DoneX )
            if ( ( x_index - i ) .ge. 1  ) then
               test = abs( X - X_sorted ( x_index - i) )
               if ( test .gt. radius ) DoneX = .true.
               if ( .not. DoneX ) i = i + 1
            else
               DoneX = .true.
            endif
         enddo
         
         xlower = x_index - i + 1
         Num_X = i

c  find upper xlimit

         DoneX = .false.
         i = 0
         
         do while ( .not. DoneX )
            i = i + 1
            if ( ( x_index + i ) .lt. nfunc  ) then
               test = abs( X - X_sorted ( x_index + i ) )
               if ( test .gt. radius ) DoneX = .true.
            else
               DoneX = .true.
            endif
         enddo
         
         Num_X = Num_X + i - 1
         
      ELSEIF ( x_index .eq. 0 ) then
         
c find upper limit only
         
         DoneX = .false.
         i = 0
         
         do while ( .not. DoneX )
            i = i + 1
            if ( ( x_index + i ) .lt. nfunc  ) then
               test = abs( X - X_sorted ( i ) )
               if ( test .gt. radius ) DoneX = .true.
            else
               DoneX = .true.
            endif
         enddo
         
         xlower = 1
         Num_X = i - 1
         
      ELSEIF ( x_index .eq. nfunc ) then

c find lower limit only

         DoneX = .false.
         i = 0
         
         do while ( .not. DoneX )
            i = i + 1
            if ( ( x_index - i + 1 ) .ge. 1  ) then
               test = abs( X - X_sorted ( x_index - i + 1 ) )
               if ( test .gt. radius ) DoneX = .true.
            else
               DoneX = .true.
               i = i - 1
            endif
         enddo
         
         xlower = x_index - i + 1
         Num_X = i - 1
         
      ENDIF
      
      
      IF ( y_index .gt. 0 .and. y_index .lt. nfunc ) then

c find lower ylimit
   
         DoneY = .false.
         i = 1
 
         do while ( .not. DoneY )
            
            if ( ( y_index - i ) .ge. 1  ) then
               test = abs( Y - Y_sorted ( y_index - i ) )
               if ( test .gt. radius ) DoneY = .true.
               if ( .not. DoneY ) i = i + 1
            else
               DoneY = .true.
            endif
         enddo
         
         ylower = y_index - i + 1
         Num_Y = i
         
c  find upper ylimit

         DoneY = .false.
         i = 0
 
         do while ( .not. DoneY )
            i = i + 1
            if ( ( y_index + i ) .lt. nfunc  ) then
               test = abs( Y - Y_sorted ( y_index + i ) )
               if ( test .gt. radius ) DoneY = .true.
            else
               DoneY = .true.
            endif
         enddo
         
         Num_Y = Num_Y + i - 1
         
      ELSEIF ( y_index .eq. 0 ) then
         
c find upper limit only

         DoneY = .false.
         i = 0
 
         do while ( .not. DoneY )
            i = i + 1
            if ( ( y_index + i ) .lt. nfunc  ) then
               test = abs( Y - Y_sorted ( i ) )
               if ( test .gt. radius ) DoneY = .true.
            else
               DoneY = .true.
            endif
         enddo
         
         ylower = 1
         Num_Y = i - 1
         
      ELSEIF ( y_index .eq. nfunc ) then
         
c find lower limit only
         
         DoneY = .false.
         i = 0
 
         do while ( .not. DoneY )
            i = i + 1
            
            if ( ( y_index - i + 1 ) .ge. 1  ) then
               test = abs( Y - Y_sorted ( y_index - i + 1) )
               if ( test .gt. radius ) DoneY = .true.
            else
               DoneY = .true.
               i = i - 1
            endif
         enddo
         
         ylower = y_index - i + 1
         Num_Y = i - 1
         
      ENDIF

c make sure that if we are off the grid that the closest X,Y element
c gets choosen.

      if ( Num_X .eq. 0 ) Num_X = 1
      if ( Num_Y .eq. 0 ) Num_Y = 1

c determine all neighbors with radius and fill out neighborhood[] with
c Nfound neighbors. 

      DO 10 i = xlower, xlower + Num_X - 1
         
         DO j = ylower, ylower + Num_Y - 1

            if ( Y_Pointer(j) .eq. X_Pointer(i) ) then

c found a point to test, test radius, if pass then assign to neighborhood
c and assign weight based on distance

               test = sqrt ( (X - X_sorted(i))**2 + 
     :              (Y - Y_sorted(j))**2 )
               if ( test .le. radius ) then
                  Nfound = Nfound + 1
                  neighborhood(Nfound) = X_Pointer(i)
                  if ( Cosine ) then
                     weight(Nfound) = cos ( PIBy2 * test /radius ) 
                  elseif ( exponent .gt. 1.e-32 ) then
                     if ( test .gt. 1.0 ) then
                        weight(Nfound) = 
     :                       1./ ( ( test * 100.) / 
     :                       radius )**exponent 
                     else
                        weight(Nfound) = 1./
     :                       (100./radius )**exponent
                     endif
                  else
                     weight(Nfound) = (radius - test) / radius
                  endif
                  goto 10
               endif
            endif
         ENDDO
 10   CONTINUE

c if nothing is found then expand the search radius and try again until
c at least min_num_desired entries are found.  This will occur around the 
c boundaries of controled areas or with a sparsely controlled area. The 
c simple expanding radius search should do quite nicely.  Another wrinkle
c I may add in one day is to move the weighting center to the closest 
c point found within the radius which would increase it's weight in the
c estimate.

      if ( Nfount .eq. 0  .and. scoping ) return

c if scoping has been selected then we definitely do not want to do this
c as the expanding radius search can be quite time consuming.


c the Nfound = to at least 3 is required in order to do median stuff 
c if chosen in the section above.  Should mention in the man page that
c the only way to get a -num[] less than 3 is to turn on -scoping

      if ( Nfound .lt. min_num_desired ) then

         searchradius = radius
         
         DO while ( Nfound .lt. min_num_desired )

            searchradius = searchradius + 0.25 * radius

            Num_X = 0
            Num_Y = 0
            Nfound = 0

c determine search range to use in the sorted arrays.  In other
c words find the range of X_sorted where all values are within
c the radius of investigation.  Do the same for Y then do the 
c pointwise search within these limits.  This will save time 
c search all Y_sorted for each X_sorted value identified.

            IF ( x_index .gt. 0 .and. x_index .lt. nfunc ) then

c find lower xlimit
   
               DoneX = .false.
               i = 1
 
               do while ( .not. DoneX )
                  if ( ( x_index - i ) .ge. 1  ) then
                     test = abs( X - X_sorted ( x_index - i) )
                     if ( test .ge. searchradius ) DoneX = .true.
                     if ( .not. DoneX ) i = i + 1
                  else
                     DoneX = .true.
                  endif
               enddo
         
               xlower = x_index - i + 1
               Num_X = i

c  find upper xlimit

               DoneX = .false.
               i = 0
         
               do while ( .not. DoneX )
                  i = i + 1
                  if ( ( x_index + i ) .lt. nfunc  ) then
                     test = abs( X - X_sorted ( x_index + i ) )
                     if ( test .ge. searchradius ) DoneX = .true.
                  else
                     DoneX = .true.
                  endif
               enddo
         
               Num_X = Num_X + i - 1
         
            ELSEIF ( x_index .eq. 0 ) then
         
c find upper limit only
         
               DoneX = .false.
               i = 0
         
               do while ( .not. DoneX )
                  i = i + 1
                  if ( ( x_index + i ) .lt. nfunc  ) then
                     test = abs( X - X_sorted ( i ) )
                     if ( test .ge. searchradius ) DoneX = .true.
                  else
                     DoneX = .true.
                  endif
               enddo
         
               xlower = 1
               Num_X = i - 1
         
            ELSEIF ( x_index .eq. nfunc ) then

c find lower limit only

               DoneX = .false.
               i = 0
         
               do while ( .not. DoneX )
                  i = i + 1
                  if ( ( x_index - i + 1 ) .ge. 1  ) then
                     test = abs( X - X_sorted ( x_index - i + 1 ) )
                     if ( test .ge. searchradius ) DoneX = .true.
                  else
                     DoneX = .true.
                     i = i - 1
                  endif
               enddo
         
               xlower = x_index - i + 1
               Num_X = i - 1
         
            ENDIF
      
      
            IF ( y_index .gt. 0 .and. y_index .lt. nfunc ) then

c find lower ylimit
   
               DoneY = .false.
               i = 1
 
               do while ( .not. DoneY )
            
                  if ( ( y_index - i ) .ge. 1  ) then
                     test = abs( Y - Y_sorted ( y_index - i ) )
                     if ( test .ge. searchradius ) DoneY = .true.
                     if ( .not. DoneY ) i = i + 1
                  else
                     DoneY = .true.
                  endif
               enddo
         
               ylower = y_index - i + 1
               Num_Y = i
         
c  find upper ylimit

               DoneY = .false.
               i = 0
 
               do while ( .not. DoneY )
                  i = i + 1
                  if ( ( y_index + i ) .lt. nfunc  ) then
                     test = abs( Y - Y_sorted ( y_index + i ) )
                     if ( test .ge. searchradius ) DoneY = .true.
                  else
                     DoneY = .true.
                  endif
               enddo
               
               Num_Y = Num_Y + i - 1
               
            ELSEIF ( y_index .eq. 0 ) then
               
c find upper limit only

               DoneY = .false.
               i = 0
 
               do while ( .not. DoneY )
                  i = i + 1
                  if ( ( y_index + i ) .lt. nfunc  ) then
                     test = abs( Y - Y_sorted ( i ) )
                     if ( test .ge. searchradius ) DoneY = .true.
                  else
                     DoneY = .true.
                  endif
               enddo
         
               ylower = 1
               Num_Y = i - 1
         
            ELSEIF ( y_index .eq. nfunc ) then
         
c find lower limit only
         
               DoneY = .false.
               i = 0
 
               do while ( .not. DoneY )
                  i = i + 1
            
                  if ( ( y_index - i + 1 ) .ge. 1  ) then
                     test = abs( Y - Y_sorted ( y_index - i + 1) )
                     if ( test .ge. searchradius ) DoneY = .true.
                  else
                     DoneY = .true.
                     i = i - 1
                  endif
               enddo
         
               ylower = y_index - i + 1
               Num_Y = i - 1
         
            ENDIF

c make sure that if we are off the grid that the closest X,Y element
c gets choosen.

            if ( Num_X .eq. 0 ) Num_X = 1
            if ( Num_Y .eq. 0 ) Num_Y = 1

c determine all neighbors with radius and fill out neighborhood[] with
c Nfound neighbors. 

            DO 20 i = xlower, xlower + Num_X - 1
         
               DO j = ylower, ylower + Num_Y - 1

                  if ( Y_Pointer(j) .eq. X_Pointer(i) ) then

c found a point to test, test radius, if pass then assign to neighborhood
c and assign weight based on distance

                     test = sqrt ( (X - X_sorted(i))**2 + 
     :                    (Y - Y_sorted(j))**2 )
                     if ( test .le. searchradius ) then
                        Nfound = Nfound + 1
                        neighborhood(Nfound) = X_Pointer(i)
                        if ( Cosine ) then
                           weight(Nfound) = 
     :                          cos ( PIBy2 * test /searchradius ) 
                        elseif ( exponent .gt. 1.e-32 ) then
                           if ( test .gt. 1.0 ) then
                              weight(Nfound) = 
     :                             1./ ( ( test * 100.) / 
     :                             searchradius )**exponent 
                           else
                              weight(Nfound) = 1./
     :                             (100./searchradius )**exponent
                           endif
                        else

c simple 1/r type weight
                           weight(Nfound) = 
     :                          (searchradius - test) / searchradius
                        endif
                        goto 20
                     endif
                  endif
               ENDDO
 20         CONTINUE
         ENDDO
      endif

      return
      end
