C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine locate (xx,n,x,jl,j)

c search an ordered table from Numerical Recipies [pp. 111]

c Given an array xx[1:n] and a given value of x, return j such
c that x is between xx[j] and xx[j+1].  xx[1:n] must be monotonic
c increasing or decreasing.  j=0 or j=n is returned if x is out
c of range.

c declare variables passed from calling routine

      integer j, n, jl
      
      real x, xx(n)

c local variables

      integer jm, ju

c initialize variables [upper and lower limits]

c      jl = 0 initialize upper limit only.  Lower limit is 
c             going to be reset from the calling routine
c             for increased efficiency

      ju = n + 1


c if not done yet, compute a mid point and replace either
c the upper or lower limit as required by order of xx[1:n]

 10   if ( ( ju-jl ) .gt. 1 ) then
         
         jm = ( ju + jl ) / 2

         if ( ( xx(n) .gt. xx(1) ) .eqv. ( x .gt. xx(jm) ) ) then
            jl = jm
         else
            ju = jm
         endif
      
         goto 10
      endif

      j = jl

      return
      end

      

      

  
