C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MED( velocity_fcns, MAXVEL, neighborhood, 
     :     MaxNumFunctions, Nfound, nsampo, work, USP_trace, 
     :     vel_scalar )

      implicit none

#include <f77/lhdrsz.h>

C     ABSTRACT: calculate samplewise median output trace from input neighborhood of traces 
C 
C                WHERE: velocity_fcns - array containing all input control 
c                                       velocity functions
C                       MAXVEL  -  maximum size of "velocity_fcns" 
C                       neighborhood  - array of neighbor functions
C                       MaxNumFunctions -  maximum size of "neighborhood" 
C                       Nfound - number of neighbors 
C                       nsampo - number of output samples
C                       work - work space array
C                       USP_trace - array to contain output trace
C 


c declare variables passed from calling routine

      integer MAXVEL, MaxNumFunctions, Nfound, nsampo
      integer neighborhood( MaxNumFunctions ) 

      real velocity_fcns( MAXVEL) 
      real work( nsampo ), USP_trace( nsampo )
      real vel_scalar

c declare local variables

      integer i, j, trndx

      real velocity

c initialize variables

      call vclr ( USP_trace, 1, nsampo )

      do i = 1, nsampo
         
         call vclr ( work, 1, Nfound )

         do j = 1, Nfound

c get all values for this sample

            trndx = ( neighborhood(J) - 1 ) * nsampo + i
            work(j) = velocity_fcns( trndx )

         enddo

         call mdian ( Nfound, work, velocity )
         USP_trace(i) =  vel_scalar * velocity

      enddo

      return
      end
