C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Read_MC3D ( luin, minLI, maxLI, minDI, maxDI, 
     :     LIincr, DIincr, tol, cell_Y, cell_X, 
     :     MaxNumElements, MaxNumFunctions , gamma, si)

c subroutine to read the 1MC3D card [if present] and return values 
c not already read on the command line

#include <f77/iounit.h>

c dimension variables passed from calling routine

      integer luin
      integer minLI, minDI, maxLI, maxDI, LIincr, DIincr
      integer MaxNumElements, MaxNumFunctions

      real tol, cell_X, cell_Y

c dimension local variables

      integer card_number, number_elements

      integer temp_minDI, temp_minLI, temp_maxDI, temp_maxLI
      integer temp_LIincr, temp_DIincr

      real temp_tol, temp_cell_Y, temp_cell_X, si

      character test*5, card*80, tag * 1

      logical MC3D, gamma, dummy

      dummy = .false.

c initialize variables

      test='1MC3D'

c read first card in attached velocity function file and determine if
c an MC3D card is present

      MC3D = .true.
      read(luin,'(a80)', end=991, err=990 ) card
      if ( card(1:5) .ne. test ) MC3D = .false.

c----
c   check to see if we have a bogus unfilled out MC3D card. If we do
c   then we attempt to declare it "dummy" and rely on cmd line arg
c   input. Note that no "gamma" function input will ever have such a
c   bogus card but we can utilize the gamma "read over tag" logic to
c   bypass the bogus card in the non-gamma case
c----
      if ( MC3D ) then

         if (card(21:25).eq.'Maxli' .AND. card(31:35).eq.'Maxdi' .AND.
     1       card(46:50).eq.'Radus' .AND. card(57:66).eq.'CldimIldim'
     2      ) then

            write (LERR,*)' '
            write (LERR,*)'WARNING from vi3d:'
            write (LERR,*)'Detected dummy 1MC3D card at top of input'
            write (LERR,*)'file. Will attempt to ignore it and use cmd'
            write (LERR,*)'line arguments (beware if cmd line args are'
            write (LERR,*)'not valid)'
            write (LER ,*)' '
            write (LER ,*)'WARNING from vi3d:'
            write (LER ,*)'Detected dummy 1MC3D card at top of input'
            write (LER ,*)'file. Will attempt to ignore it and use cmd'
            write (LER ,*)'line arguments (beware if cmd line args are'
            write (LER ,*)'not valid)'
            MC3D  = .false.
            dummy = .true.
         endif
      endif

      if ( MC3D ) then

         rewind(luin)
         if (gamma) read (luin, '(a1)') tag

         read (luin,10) test, temp_minLI, temp_maxLI, temp_minDI, 
     :        temp_maxDI, temp_LIincr, temp_DIincr, temp_tol, 
     :        temp_cell_Y, temp_cell_X

 10      format( a5, 1x, 5x, 3x, 1x, 6i5, f5.0, 5x, 1x, 2f5.0 )

c assign values to variables not included on the command line

         if ( minDI .eq. -9999 ) minDI = temp_minDI
         if ( minLI .eq. -9999 ) minLI = temp_minLI
         if ( maxDI .eq. -9999 ) maxDI = temp_maxDI
         if ( maxLI .eq. -9999 ) maxLI = temp_maxLI
         if ( abs(tol) .lt. 1.e-30 ) tol = temp_tol
         if ( abs(cell_Y) .lt. 1.e-30 ) cell_Y = temp_cell_Y
         if ( abs(cell_X) .lt. 1.e-30 ) cell_X = temp_cell_X
         if ( temp_LIincr .ne. 0 .and. LIincr .eq. -9999) 
     :        LIincr = temp_LIincr
         if ( temp_DIincr .ne. 0 .and. DIincr .eq. -9999) 
     :        DIincr = temp_DIincr
      else
         
         rewind(luin)
         if (gamma .or. dummy) read (luin, '(a1)') tag

      endif

c now count the number of functions and determine the maximum number of 
c elements per function so that we can allocate memory appropriately.

      number_elements = 0

      do while ( 1 .eq. 1 )

         read ( luin, '(i1)', end=999, err=990 ) card_number

         if ( card_number .eq. 9 ) then
            number_elements = number_elements + 7
            if ( number_elements .gt. MaxNumElements ) 
     :           MaxNumElements = number_elements
            MaxNumFunctions = MaxNumFunctions + 1
            number_elements = 0
         else
            number_elements = number_elements + 7
         endif

      enddo

 999  continue

      rewind (luin)
      if (gamma .or. dummy) read (luin, '(a1)') tag

c skip past the 1MC3D card if present and position the pointer
c to read in the TDFN functions.

      if ( MC3D ) read (luin,'(i1)') card_number
      return

 990  continue

      write(LER,*)' '
      write(LERR,*)' Error reading input TDFN function file'
      write(LERR,*)' Check file contents and resubmit'
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' VI3D: Error reading input TDFN function file'
      write(LER,*)'       Check file contents and resubmit'
      write(LER,*)' FATAL'
      stop
 991  continue

      write(LER,*)' '
      write(LERR,*)' Empty  TDFN function file'
      write(LERR,*)' Check file contents and resubmit'
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' VI3D: Empty  TDFN function file'
      write(LER,*)'       Check file contents and resubmit'
      write(LER,*)' FATAL'
      stop
      end
