C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, minLI, maxLI, minDI, maxDI, 
     :     LIincr, DIincr, tol, cell_Y, cell_X, tdfn, nsi, trace_length,
     :     nrec, ntrc, nsampo, verbos , gamma, TrcNum_start, 
     :     RecNum_start, delta_TrcNum, delta_RecNum, 
     :     Cosine, min_num_desired, vel_scalar, exponent, median,
     :     scoping )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer  minLI, maxLI, minDI, maxDI, LIincr, DIincr
      integer  nsi, trace_length, nrec, ntrc, nsampo
      integer  TrcNum_start, RecNum_start, min_num_desired
      integer  delta_TrcNum, delta_RecNum

      real  tol, cell_Y, cell_X, vel_scalar, exponent

      character  ntap*(*), otap*(*)

      logical tdfn, verbos, gamma, Cosine, median, scoping

c declare local variables

      integer length

      write(LERR,*)' '
      length = lenth(ntap)

      if ( tdfn ) then
         write(LERR,*)' '
         write(LERR,*)' Input TDFN Velocity Parameters'
         write(LERR,*)' ----------------------------- '
         write(LERR,*)' '
	 if (length .gt. 0) then
           write(LERR,*)' Input TDFN filename = ', ntap(1:length)
	 else
           write(LERR,*)' Input TDFN filename = stdin'
	 endif
         write(LERR,*)' sample interval = ', nsi
         write(LERR,*)' trace length    = ', trace_length
         if (gamma)
     1   write(LERR,*)' Dealing with scaled gamma data (scaled by 1000)'
         write(LERR,*)' '
      else
         write(LERR,*)' Input USP Velocity Parameters'
         write(LERR,*)' ----------------------------- '
         write(LERR,*)' '
         write(LERR,*)' Data set name  = ', ntap(1:length)
         write(LERR,*)' Number of records           = ', nrec
         write(LERR,*)' Number of traces per record = ', ntrc
         write(LERR,*)' Number of samples per trace = ', nsampo
         write(LERR,*)' Sample interval             = ', nsi
         write(LERR,*)' '
      endif

      write(LERR,*)' '
      write(LERR,*)' Output Parameters'
      write(LERR,*)' -----------------'
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
      	write(LERR,*)' Output data set name  =  ', otap(1:length)
      else
        write(LERR,*)' Output data set name  =  stdout'
      endif
      write(LERR,*)' minimum LI  = ', minLI
      write(LERR,*)' maximum LI  = ', maxLI
      write(LERR,*)' minimum DI  = ', minDI
      write(LERR,*)' maximum DI  = ', maxDI
      write(LERR,*)' LI increment = ', LIincr
      write(LERR,*)' DI increment = ', DIincr
      write(LERR,*)' LI cell dimension = ', cell_Y
      write(LERR,*)' DI cell dimension = ', cell_X
      write(LERR,*)' Velocity Scalar Percentage = ',vel_scalar
      write(LERR,*)' Radius of investigation = ', tol
      write(LERR,*)' Number of functions in extrapolation zone = ', 
     :     min_num_desired
      if ( Cosine ) then
         write(LERR,*)' using Cosine Bell weighting of velocities'
         write(LERR,*)' within radius of investigation'
      elseif ( exponent .gt. 1.e-32 ) then
         write(LERR,*)' using 1/r**n weightingusing an exponent'
         write(LERR,*)' of ',exponent
      else
         write(LERR,*)' using distance weighted average of velocities' 
         write(LERR,*)' within radius of investigation'
      endif

      if ( median ) 
     :     write(LERR,*)' using median within radius of investigation'
      write(LERR,*)' '
      if ( TrcNum_start .ne. -9999 .or. RecNum_start .ne. -9999 ) then
         write(LERR,*)' RecNum, TrcNum output numbering override is in'
         write(LERR,*)' effect.'
         write(LERR,*)' Starting RecNum value = ',RecNum_start
         write(LERR,*)' RecNum increment used = ', delta_RecNum
         write(LERR,*)' Starting TrcNum value = ',TrcNum_start
         write(LERR,*)' TrcNum increment used = ', delta_TrcNum
      endif

      if ( scoping ) write(LERR,*)' scoping interpolation requested'
      if ( verbos ) write(LERR,*)' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)' '
      return
      end
