C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine digicon (luin, luout, ivel, itim, IX1, IY1,
     1                    XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                    DX, DY, NDI, NLI, minli, maxli,
     3                    mindi, maxdi, key, itmp, verbos,
     4                    RC, scl, tscl, itmax)

#include <f77/iounit.h>

      integer     itim (*), ivel (*), key (*), itmp (*)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     minli, maxli, mindi, maxdi, li, di
      character   card * 80, tag * 4
      logical     verbos,got,EOF,RC

      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9

C**********************************************************************C
C     read input vel file
C**********************************************************************C
      ixlst  = 0
      iylst  = 0
      if = 0
      nf = 0
      got = .false.
 
      DO while (1.eq.1)
 
         read (luin, '(a80)', end=10, err=666) card
 
         go to 12
c----
c   last function read hit end of input file
c----
10       continue
 
c----
c   if we've already written out last valid function then exit routine
c   otherwise we need to jump into that part of the "IF" below that
c   builds the TDFN output and tell the program this will be the last
c   function.
c   also if there are less than 2 entries in the last cards read it is
c   not a valid function and so exit
c----
         ixlst = 0
         iylst = 0
         got = .true.
         EOF = .true.
 
         if (if .le. 1) go to 999
         if (got) go to 12

 
         go to 13
 
12       continue
 
c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c----
         call fsscnf (card,'%d %d %d %d %f %f',
     1                nline,ixline,ICX,ICY,time,vel)

         IF ( RC ) THEN
            ICX = nline
            ICY = ixline
         ENDIF
 
13       continue

c----
c   assuming each function is together in the file determine end of function
c   by sensing when either the X or Y coordinate changes. got=true means we
c   have sensed a change in the X or Y coords and therefore have a complete
c   function in itim & ivel vectors. got=false means we are still reading the 
c   current function.
c----
         IF (ICX .ne. ixlst .OR. ICY .ne. iylst) THEN
 
c----
c   end of current function sensed: we need to write out old function
c   and then determine if upcoming function lies within box defined on
c   cmd line
c   we have a valid function ONLY if there are more than 2 entries
c----
            if (got) then
 
c----
c   for completed valid function:
c   sort in case times are not in ascending order
c----
               if ( if .gt. 1) then

                  iff = 0
                  do  i = 1, if
                      itimi = nint (tscl * itim(i))
                      if (itimi .lt. itmax .AND. ivel(i) .gt. 0) then
                         iff = iff + 1
                         ivel (iff) = ivel (i)
                         itim (iff) = itimi
                      endif
                  enddo
                  if = iff
                  call sort (itim, key, if)
                  do  i = 1, if
                      itmp (i) = ivel (key(i))
                  enddo
                  do  i = 1, if
                      ivel (i) = itmp (i)
                  enddo

c----
c   build TDFN input for vi3d
c----
                  nf = nf + 1
                  xcards = float (if) / 7.0
                  ncards = ifix  (xcards - .001)
                  left = if - 7 * ncards
                  i1 = 7 * ncards + left + 1
                  i2 = 7 * (ncards + 1) 
                  do  i = i1, i2
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
    
                  write (luout,555) ir0, tag, li, di
555               format (i1, a4, 2i5)
 
                  ih = -7
                  itag = 0
                  if (ncards .gt. 0) then
                     do  i = 1, ncards
                         itag = itag + 1
                         if (itag .ge. 9) itag = 1
                         ih = (i-1) * 7
                         write (luout,777) itag, tag,
     1                   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
                     enddo
                  endif
                  ih = ih + 7
                  write (luout,777) i9, tag,
     1            (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
777               format (i1, a4, 7(I4,I5), 7X, I5)
 
c----
c   clear velocity & time arrays. If this is really the last function
c   then we don't want to jump up to read another card - we need to exit
c----
                  do  i = 1, if
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
                  if (EOF) go to 999
 
               endif

            endif

c----
c   see if upcoming function lies with defined box (also pick up first
c   read T-V pair and put into time & velocity arrays in case).
c----
            if = 1
            ivel (if) = nint (vel)
            itim (if) = nint (time)

            IF ( RC ) THEN

               LI = ICX
               DI = ICY

            ELSE

               CX = ICX * scl
               CY = ICY * scl
               IWRN = 0
               CALL XFMFWD (CX, CY, LI, DI, CXT, CYT,BXT,BYT, IWRN,
     1                      IX1, IY1, XX, XY, YX, YY, XXT, XYT,YXT,YYT,
     2                      DX, DY, NDI, NLI)
            ENDIF
 
            IF (LI .LT. MINLI) IWRN = 1
            IF (LI .GT. MAXLI) IWRN = 1
            IF (DI .LT. MINDI) IWRN = 1
            IF (DI .GT. MAXDI) IWRN = 1

            if (IWRN .eq. 1) then
            write(LERR,*)'Function located at ',ICX,ICY,' out of bounds'
            else
            write(LERR,*)'Function located at ',ICX,ICY,' inside box'
            endif
 
c----
c   if function lies within box set got=true to say we have a valid function
c   being read; set the ixlst,iylst to the current X,Y so we will be able to
c   sense when this function ends. then drop out og the "IF" and back to
c   read the next function.
c----
            if (IWRN .eq. 0) then
               got = .true.
               ixlst = ICX
               iylst = ICY
c----
c   if function does not lie within the box set got=false and set ixlst,iylst
c   to zero. This will cause the next card to be read, and its XY checked for
c   position in the box. If this is still part of the current outside function
c   then the flow control will return to this point. The cycle repests until
c   a function lying within the box is found.
c----
            else
               got = .false.
               ixlst = 0
               iylst = 0
            endif
 
c----
c   while reading current function values we need to check the possibility
c   that there are XY entries that contain "null" velocity entries (added
c   to work on geostat output). "if" will be the total number of entries
c   in current function.
c----
         ELSE
 
            if (vel .gt. 0.0) then
               if = if + 1
               ivel (if) = nint (vel)
               itim (if) = nint (time)
            endif
 
         ENDIF
 
 
 
 
      ENDDO

      if (nf .eq. 0) go to 667

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card

      go to 999
 
667   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din:'
      write(LERR,*)'Yikes! no valid functions read from file. Check'
      write(LERR,*)'to see if corner coords are correct; check XYs'
      write(LERR,*)'in input file; is each funtion together not'
      write(LERR,*)'scattered throughout input file?'
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din:'
      write(LER ,*)'Yikes! no valid functions read from file. Check'
      write(LER ,*)'to see if corner coords are correct; check XYs'
      write(LER ,*)'in input file; is each funtion together not'
      write(LER ,*)'scattered throughout input file?'

 
999   continue

      return
      end
