C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ta2ti( rt, rv, nn)

c ta2ti converts an input AVERAGE velocity function to INTERVAL velocity
c using Dix Equation. 
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = AVERAGE velocity in units/second
c
c on output rv() = INTERVAL velocity in units/second
c velocity is referenced to the bottom of the interval

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer nn, i

      real rt(*), rv(*), vint(SZLNHD)
      real IntervalTime(SZLNHD)

c initialize memory

      call vclr ( vint, 1, SZLNHD )
      call vclr ( IntervalTime, 1, SZLNHD )

c initialize Depth and set first interval velocity 

      vint(1) = rv(1)
      Depth = 0.

c assign IntervalTime[1]

      IntervalTime(1) = rt(1)/2.0

      DO i = 2, nn
         IntervalTime(i) = ( rt(i) - rt(i-1) ) / 2.
         Depth = Depth + vint(i-1) * IntervalTime(i-1)
         vint(i) = ( rv(i) * rt(i) / 2. - Depth ) / IntervalTime(i)
      ENDDO

      IF ( rt(1) .gt. 1.e-20 ) then

c bump rt() array values up one slot to make room for zero entry

         do i = nn + 1, 2, -1
            rt(i) = rt(i-1)
         enddo

c assign zero time value

         rt(1) = 0.

c load interval velocities

         call vmov ( vint, 1, rv(2), 1, nn )
         rv(1) = rv(2)
         nn = nn+1
      ELSE

c load interval velocities

         call vmov ( vint, 1, rv, 1, nn )

      ENDIF   
         
      return
      end
