C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- Routine Multlay ----- ----- ----- ----- -----
C Program to generate XSD PICK FILES containing multiple event overlays
C in nmo (no dip term) and smo (user choice) format.  Must first have   
C run program TVD to generate the required TRUEDIP and RGnn or RRnn     
C files.                                                                
C-----------------------------------------------------------------------
C   Written by D.D. Haun, December 1990, Cairo                
c   Modified from P.G.A. Garossino's "sunlay" code
c

#include <f77/iounit.h>
      INTEGER I,J,K,INTF2,INTF3,FAROFF,SEG,NTR,le1,le2,oflag 
      integer argis
      REAL T(100),DP(100),V(100),D(100),TP(100),DT(100),TOUT(100)       
      REAL GI,GAP,RECORD,Tnmo(100),DELTAT,maxtim                               
      CHARACTER*80 AJUNK                                                
      CHARACTER*36 HEAD                                                 
      CHARACTER*10 SEGMNT                                               
      CHARACTER*1 DOMAIN,DIRECT,TRACE1,mchar                            
      CHARACTER*8 smo,SP
      character*100 nmo 
      character*2 fprefix
      character fntrue*100,fntwek*100,lname*100, name*8                              
      logical query, model

C INTEGER VARIABLES:                                                    

c oflag :  0  =  NMO only, 1 =  SMO only, 2  =  both 
C INTF2  SP NUMBER FROM TRUEDIP FILE                                    
C INTF3  SP NUMBER FROM TVD OUTPUT FILE                                 
C I,J,K  LOOP PARAMETERS                                                
C FAROFF CONTAINS FAR OFFSET                                            
C SEG IS A COUNTER FOR SEGMENT NUMBER                                   
C NTR CONTAINS NUMBER OF TRACES                                         
C RC CONTAINS RETURN CODE FROM CALL TO FCMS FUNCTION                    

C REAL VARIABLES:                                                       

C T(I)   TIME AT ZERO OFFSET ARRAY                                      
C DP(I)  PRIMARY DIP ARRAY                                              
C D(I)   TWEAK DIP ARRAY                                                
C V(I)   PRIMARY VELOCITY ARRAY                                         
C TOUT(I) OUTPUT TWEAKED PRIMARY TIME ARRAY                             
C TP(I)  UNCORRECTED ARRIVAL TIME OF PRIMARY EVENT                      
C DT(I)  UNCORRECTED ARRIVAL TIME OF TWEAK EVENT                        
C Tnmo(I) nmo CORRECTED TIME ARRAY (NO DIP TERM....USED IN SUNLAY PRGM) 
C GI CONTAINS GROUP INTERVAL                                            
C GAP CONTAINS NEAR TRACE GAP                                           
C RECORD CONTAINS OUTPUT OPERS SEQUENTIAL RECORD NUMBER                 
C DELTAT CONTAINS SAMPLE INCREMENT OF PROCESSED DATA                    

C CHARACTER VARIABLES:                                                  

C AJUNK  *80 VARIABLE USED TO READ PAST HEADER DATA                     
C HEAD   *36 VARIABLE USED FOR OUTPUT HEADER                            
C SEGMNT *10 VARIABLE USED TO CONTAIN SEGMENT HEADER                    
C nmo    *8  VARIABLE USED FOR FILE I/O (FILETYPE OF nmo FILE)          
C smo    *8  VARIABLE USED FOR FILE I/O (FILETYPE OF smo FILE)          
C SP     *8  VARIABLE USED TO CONTAIN SP DATA TO CONCAT WITH smo, nmo   
C DOMAIN *1 VARIABLE TO HOLD DOMAIN REQUESTED                           
C DIRECT *1 VARIABLE TO HOLD SHOOTING DIRECTION                         
C TRACE1 *1 VARIABLE USED TO FLAG TRACE ONE AS NEAR OR FAR TRACE 

c initialize variables

      data name/'MULTLAY'/

c PROGRAM START

      query = ( argis ( '-?' ) .gt. 0 .or. argis ('-h') .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c open printout file

#include <f77/open.h>

C INITIALIZE DATA                                                       

      HEAD = 'Units     1.000000     1.000000     '                     
      SEGMNT = 'Segment = '                                             
      RECORD=1.
      data fntrue/' '/
      data fntwek/' '/

c get command line arguments

      call cmdln(fntrue,le1,fntwek,le2,lname,le5,oflag,DELTAT,TRACE1,
     :     maxtim,mul,mode, model )

      write(LERR,*)' '
      write(LERR,*)'Command line Parameters'
      write(LERR,*)' '
      write(LERR,*)'Truedip file = ',fntrue
      write(LERR,*)'Tweak file = ',fntwek
      if ( oflag .eq. 0 ) then
         write(LERR,*)'Nmo overlay requested'
      elseif ( oflag .eq. 1 ) then
         write(LERR,*)'Tweak overlay requested'
      elseif ( oflag .eq. 2 ) then
         write(LERR,*)'Both Nmo and Tweak overlays requested'
      endif
      write(LERR,*)'Input delta T = ',deltat,' milliseconds'
      write(LERR,*)'Maximum time of dataset is = ',maxtim, 'seconds'
      if ( trace1 .eq. 'n' ) then
         write(LERR,*)'Sequential trace 1 is the near offset'
      elseif ( trace1 .eq. 'f' ) then
         write(LERR,*)'Sequential trace 1 is the far offset'
      endif
      write(LERR,*)'Order of multiple =',mul
      if (mode .eq. 0 ) then
         write(LERR,*)'Will generate only the multiple order requested'
      elseif (mode .eq. 1 ) then
         write(LERR,*)'Will generate up to and including the multiple '
         write(LERR,*)'order requested'
      endif
      write(LERR,*)
      write(LERR,*)' '

C OPEN INPUT FILES AS UNITS 2 AND 3 WHERE:                              
C    UNIT 2 IS the truedip file                                
C    UNIT 3 IS the desired tweak file   
                               
     	open(2,file=fntrue(1:le1),status='old',err=990)
     	open(3,file=fntwek(1:le2),status='old',err=991)


C get additional setup data from input files 

      READ(2,10) DOMAIN,DIRECT,NTR,GI,SI,GAP                            
 10   FORMAT(//,20X,A1,/,22X,A1,/,28X,I4,/,20X,F8.2,/,19x,f8.2,/,15X,F10
     &.2)

      if(domain.eq.'R')gi=si      
      FAROFF=NINT(FLOAT(NTR-1)*GI+GAP)                                  

c output tvd file header information to printout file

      write(LERR,*)' TVD output file header information'
      write(LERR,*)'  '
      if ( DOMAIN .eq. 'S' ) then
         write(LERR,*)'Shot Domain Solution Requested'
      elseif ( DOMAIN .eq. 'R' ) then
         write(LERR,*)'Receiver Domain Solution Requested'
      endif
      write(LERR,*)'Number of traces per record = ',ntr
      write(LERR,*)'Group interval = ',gi
      write(LERR,*)'Source interval = ',si
      write(LERR,*)'Mid source to mid near group gap = ',gap
      write(LERR,*)'Far offset = ',faroff
      write(LERR,*)'  '

C REWIND FILE  

      REWIND 2  

C START OF MAIN PROGRAM                                             

C READ PAST HEADERS IN BOTH INPUT FILES                                 

      READ(2,'(A80)') (AJUNK,I=1,16)                                         
      READ(3,'(A80)') (AJUNK,I=1,16)                                         

C READ SHOT POINT NUMBER AND ASSIGN IT TO INTERFACE                     

 30   READ(2,'(/,11X,I8,///)',END=9999) INTF2 
      READ(3,'(/,11X,I8,///)',END=9999) INTF3
      if(model)RECORD = INTF2

C RESET SEG TO ZERO FOR EACH FILE                                       

      SEG = 10*mul                                                      

C OPEN smo AND nmo OUTPUT PIC FILES                                     

      WRITE(SP,'(I5)') INTF2                                              
      WRITE(mchar,'(I1)') mul                                             

      if(mode.eq.0)then
         numchar=1
         fprefix='m '
      else
         numchar=2
         fprefix='mm' 
      endif  
                                                    
      IF(SP(4:4).EQ.' ') THEN                                           
         nmo = lname(1:le5) // fprefix(1:numchar) // mchar(1:1) // '_' 
     :        // SP(5:5)
         smo = 'smo' // SP(5:5)                                           
      ELSE                                                              
         IF(SP(3:3).EQ.' ') THEN                                        
            nmo = lname(1:le5) // fprefix(1:numchar) // mchar(1:1) // 
     :           '_' // SP(4:5)
            smo = 'smo' // SP(4:5)                               
         ELSE                                                 
            IF(SP(2:2).EQ.' ') THEN                                   
               nmo = lname(1:le5) // fprefix(1:numchar) // mchar(1:1) 
     :              // '_' // SP(3:5)
               smo = 'smo' // SP(3:5)                                    
            ELSE                                                      
               IF(SP(1:1).EQ.' ') THEN                              
                  nmo = lname(1:le5) // fprefix(1:numchar) // 
     :                 mchar(1:1) // '_' // SP(2:5)
                  smo = 'smo' // SP(2:5)                               
               ELSE                                                 
                  write(LERR,*)' '
                  write(LERR,*)' '
                  write(LERR,*)' '
                  write(LERR,*)'MULTLAY: Shot point too large for '
                  write(LERR,*)'program logic, call Garossino at 3932 '
                  write(LERR,*)'FATAL'
                  STOP                                             
               ENDIF                                                
            ENDIF                                                     
         ENDIF                                                          
      ENDIF

C WRITE OUTPUT HEADER                                                   

      if((oflag.eq.1).or.(oflag.eq.2)) then 
         open(40,FILE=smo,STATUS='UNKNOWN')
         WRITE(40,'(A36,F7.5)')HEAD,DELTAT                                                   
      endif

      if((oflag.eq.0).or.(oflag.eq.2)) then 
         open(50,FILE=nmo,STATUS='UNKNOWN')
         WRITE(50,'(A36,F7.5)')HEAD,DELTAT 
      endif

C TEST FOR FILE COMPATABILITY                                           

      IF(INTF2.NE.INTF3)THEN                                            
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)'MULTLAY:  Shot point data in input files does '
         write(LERR,*)'           not match, Correct and rerun'
         write(LERR,*)'FATAL'
         STOP                                                           
      ENDIF                                                             

C READ IN TRUE DIP DATA 

      I=1                                                               
 60   READ(2,'(F6.3,F6.0,F8.0)')T(I), DP(I), V(I)                                         
      I=I+1                                                             
      IF(T(I-1).LT.maxtim)GOTO 60                                         

C READ IN TWEAK DIP DATA 

      I=1                                                               
 80   READ(3,'(F6.3,F6.0,F8.0)')T(I), D(I), V(I)                                          
      I=I+1                                                             
      IF(T(I-1).LT.maxtim)GOTO 80 

c Start Outer Loop for -mode Implementation

c
      if(mode.eq.0) then
         maxmode=1
         seg=mul*10
      else
         maxmode=mul+1
      endif
      
      DO imode=1,maxmode
         if(mode.eq.1)then
            seg=(imode-1)*10
            mul=imode-1
         else
            seg=mul*10
         endif       
                                         
C test for sign of x required                                           

C POSITIVE X AXIS 

         IF ( ( (DOMAIN.EQ.'S') .AND. (DIRECT.EQ.'R') ) .OR. 
     :        ( (DOMAIN.EQ.'R') .AND. (DIRECT.EQ.'L') ) ) THEN                                             

C CALCULATE T-DT AND OFFSET FOR OUTPUT                                  
C SKIP ZERO AND 5.0 SECOND TIMES                                     

C OUTER LOOP INCREMENTS ON DIGITIZED EVENTS AT THIS LOCATION     
C SKIPPING ZERO AND MAX TIME EVENTS                              
                                                                        
            DO 100 J=2,I-2                                                    

               SEG=SEG+1
                                                                        
               tj=(mul+1)*t(j)
               dpj=(mul+1)*dp(j)
      
               if(nint(tj).gt.maxtim)goto 100
                                                                        
c writing segment header                                          

               if((oflag.eq.1).or.(oflag.eq.2)) 
     :              WRITE(40,90) SEGMNT,SEG,mul+1 
 90            FORMAT(A10,I2,5x,'color = ',i2)                                   
               if((oflag.eq.0).or.(oflag.eq.2)) 
     :              WRITE(50,90) SEGMNT,SEG,mul+1
 
c code inserted to compute MUL order multiple

               do l=1,i-2
                  if((tj.ge.t(l)).and.(tj.le.t(l+1)))then
                     vj= (tj-t(l))/(t(l+1)-t(l))*(v(l+1)-v(l))+v(l)
                     goto 1002
                  else
                  endif
               enddo
               vj=v(i-1)
 1002          continue

C INNER LOOP.... INCREMENTS ON OFFSET .... 10 SAMPLES OVER SPREAD 
          
               DO K=NINT(GAP),FAROFF,NINT(GI*FLOAT(NTR-1)/10.)            
           
                  TP(J) = SQRT ( tj**2 + (FLOAT(K) / V(J))**2 + 2. * tj 
     :                 * FLOAT(K) * SIN(dpj / 57.29578) / V(J) )     
                  DT(J) = SQRT( tj**2 + (FLOAT(K) / V(J))**2 + 2. * tj *
     :                 FLOAT(K) * SIN(D(J) / 57.29578) / V(J)) 
                  TOUT(J) = tj -(DT(J) - TP(J))                                       
                  Tnmo(J) = tj -(SQRT( (tj**2 + (FLOAT(K) / vj)**2) ) - 
     :                 TP(J))              
         
C OUTPUT DATAPOINT FORMAT, MULTIPLY TIMES BY 1000 FOR MS                
C K IS THE OFFSET AND J IS THE HORIZON NUMBER                           
C TRACE = 1+NINT((FLOAT(K)-GAP)/GI)  OR FLOAT(NTR)-(FLOAT(K)-GAP)/GI)   
C DEPENDING ON WHETHER TRACE1 IS THE NEAR OR FAR TRACE.                 

                  IF(TRACE1.EQ.'n') THEN                                            
                     if((oflag.eq.1).or.(oflag.eq.2))      
     :                    WRITE(40,'(3F13.6)') RECORD, 
     :                    1.0+(FLOAT(K)-GAP)/GI, TOUT(J)*1000.
                     if((oflag.eq.0).or.(oflag.eq.2))      
     :                    WRITE(50,'(3F13.6)') RECORD, 
     :                    1.0+(FLOAT(K)-GAP)/GI, Tnmo(J)*1000. 
                  ELSE                                                              
                     if((oflag.eq.1).or.(oflag.eq.2))            
     :                    WRITE(40,'(3F13.6)') RECORD, 
     :                    FLOAT(NTR)-(FLOAT(K)-GAP)/GI, TOUT(J)*1000.
                     if((oflag.eq.0).or.(oflag.eq.2))               
     :                    WRITE(50,'(3F13.6)') RECORD, 
     :                    FLOAT(NTR)-(FLOAT(K)-GAP)/GI, Tnmo(J)*1000. 
                  ENDIF                                                             

C END OF INNER LOOP                                                 

               ENDDO

C END OF OUTER LOOP                                                 

 100        CONTINUE                                                          

         ELSE                                                              
         
C REQUIRE NEGATIVE X AXIS SOLUTION                                      

C FOLLOWING ACCOUNTS FOR DISCO UNSIGNED DISTANCE DIP REVERSAL IN -X DIR 
C WARNING#########what is this???  I don't remember why this is here.  Must
c check out the implications in the USP world

            DO J=1,I 
               D(J)=(-1.)*D(J)                                                 
            ENDDO

C CALCULATE T-DT AND OFFSET FOR OUTPUT                                  
C    SKIP ZERO AND 5.0 SECOND TIMES                                     

            DO 160 J=2,I-2                                                    

C INCREMENT SEGMENT COUNTER (SEG)                                       

               SEG=SEG+1                                                         
      
               tj=(mul+1)*t(j)
               dpj=(mul+1)*dp(j)
      
               if(nint(tj).gt.maxtim)goto 160

C WRITING SEGMENT HEADER.....MAY NEED LEFT JUSTIFIED NUMBER......       

               if((oflag.eq.1).or.(oflag.eq.2))
     :              WRITE(40,90) SEGMNT,SEG,mul+1
               if((oflag.eq.0).or.(oflag.eq.2)) 
     :              WRITE(50,90) SEGMNT,SEG,mul+1

c code inserted to compute MUL order multiple, ddh 12/9/90     

               tj=(mul+1)*t(j)
               dpj=(mul+1)*dp(j)

               do l=1,i-2
                  if((tj.ge.t(l)).and.(tj.le.t(l+1)))then
                     vj= (tj-t(l))/(t(l+1)-t(l))*(v(l+1)-v(l))+v(l)
                     goto 1004
                  else
                  endif
               enddo

               vj=v(i-1)
 1004          continue

c end multiple code, ddh

               DO K=NINT(GAP),FAROFF,NINT(GI*FLOAT(NTR-1)/10.)            

                  TP(J)=SQRT(tj**2 + (FLOAT(K)/V(J))**2 - 2. * tj * 
     :                 FLOAT(K) * SIN(dpj/57.29578) / V(J))
                  DT(J)=SQRT(T(J)**2 + (FLOAT(K)/V(J))**2 -2. * T(J) * 
     :                 FLOAT(K) * SIN(D(J)/57.29578) / V(J))  
                  TOUT(J)=tj - (DT(J) - TP(J))                                       
                  Tnmo(J)=tj - (SQRT( ( tj**2 + (FLOAT(K)/vj)**2) ) - 
     :                 TP(J))              

C OUTPUT DATAPOINT FORMAT, MULTIPLY TIMES BY 1000 FOR MS                
C K IS THE OFFSET AND J IS THE HORIZON NUMBER                           
C TRACE = 1+NINT((FLOAT(K)-GAP)/GI)                                     

                  IF(TRACE1.EQ.'n') THEN                                            
                     if((oflag.eq.1).or.(oflag.eq.2))      
     *                    WRITE(40,'(3F13.6)')RECORD,1.0+(FLOAT(K)-GAP)/
     :                    GI,TOUT(J)*1000.
                     if((oflag.eq.0).or.(oflag.eq.2))      
     *                    WRITE(50,'(3F13.6)')RECORD,1.0+(FLOAT(K)-GAP)/
     :                    GI,Tnmo(J)*1000.        
                  ELSE                                                              
                     if((oflag.eq.1).or.(oflag.eq.2))            
     *                    WRITE(40,'(3F13.6)')RECORD,
     :                    FLOAT(NTR)-(FLOAT(K)-GAP)/GI,TOUT(J)*1000. 
                     if((oflag.eq.0).or.(oflag.eq.2))               
     *                    WRITE(50,'(3F13.6)')RECORD,
     :                    FLOAT(NTR)-(FLOAT(K)-GAP)/GI,Tnmo(J)*1000. 
                  ENDIF                                                             
               ENDDO
 160        CONTINUE                                                          
            
C END OF IF LOOP                                        

         ENDIF 
      ENDDO

C CLOSE SHOT POINT FILES AND GO TO NEXT SHOT POINT                      

      if((oflag.eq.1).or.(oflag.eq.2)) CLOSE(40) 
      if((oflag.eq.0).or.(oflag.eq.2)) CLOSE(50) 
      GOTO 30                                                           

C TERMINATE PROGRAM                                                     

990	write(*,*) ' Error opening truedip input file: ',fntrue(1:le1)
        write(*,*)' '
	stop
991	write(*,*) ' Error opening tweak input file: ',fntwek(1:le1)
        write(*,*)' '
	stop	

9999  if((oflag.eq.1).or.(oflag.eq.2)) CLOSE(40) 
      if((oflag.eq.0).or.(oflag.eq.2)) CLOSE(50) 
      close(2)
      close(3)
      write(LER,*) 'MULTLAY Normal Termination'
      write(LERR,*) 'Normal Termination'
      STOP                                                              
      END 

c subroutine cmdln -----

      subroutine cmdln(line1,le1,line2,le2,lname,le5,oflag,delt,trac1,
     &     max,mul,mode,model)

#include <f77/iounit.h>

      integer           le1,le2,oflag,mul,argis
      real*4		delt,max
      character         line1*(*),line2*(*),lname*(*)
      character*1	trac1
      logical           model
 
c------------------------------------------------
c  get line id & find string length

      call argr4('-dt',delt,8.,8.)
      call argi4('-flg',oflag,0,0)
      model =   (argis('-model') .gt. 0)
      call argi4('-mode',mode,0,0)
      call argi4('-mult',mul,1,1)
      call argr4('-mt',max,5.0,5.0)
      call argstr ('-N1',line1,' ',' ')
      le1 = lenth(line1)
      call argstr ('-N2',line2,' ',' ')
      le2 = lenth(line2)
      call argstr ('-O',lname,' ',' ')
      le5 = lenth(lname)
      call argstr ('-tr1',trac1,'n','n')
c
c ----- Check for all args entered, if not prompt or notify of default.
c
      if(line1 .eq. ' ') then
         write(*,*)'-N1 blank, Please Enter ______.truedip File'
         read(*,1005)line1
1005     format(a100)
         write(*,*)' '
         le1=lenth(line1)
             if(line1.eq.' ')then
             write(LOT,*)'-N1 Blank, FATAL'
             write(*,*)' '
             stop
             else
             endif
      else
      endif
      if(line2 .eq. ' ') then
         write(*,*)'-N2 blank, Please Enter _____.__ Any TVD Output Twea
     &k File'
         read(*,1005)line2
         write(*,*)' '
         le2=lenth(line2)
             if(line2.eq.' ')then
             write(LOT,*)'-N2 Blank, FATAL'
             write(*,*)' '
             stop
             else
             endif
      else
      endif
            if((mode .ne. 0).and.(mode .ne. 1))then
         write(*,*)'FATAL ERROR'
         write(*,*)'-mode parameter must be {0 or 1}'
         stop
         else
      endif
      
      return
      end
c ----------------------------------------------------------------------
c
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'----------------------------------------------------------------'
        write(LER,*) ' '
        write(LER,*)
     :'multlay generates primary and nth order multiple overlays in '
        write(LER,*)
     :'xsd pick file format:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman multlay )'
        write(LER,*)' '
        write(LER,*)
     :'execute multlay by typing multlay and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N1 [truedip](no default)       : tvd output truedip file'
        write(LER,*)
     :' -N2 [tweak]  (no default)       : tvd output tweak file'
        write(LER,*)
     :' -flg [oflag] (default = 0)      : 0:nmo,1:smo,2:both'
        write(LER,*)
     :' -dt [time]   (default = 8)      : sample rate(ms) of datafile'
        write(LER,*)
     :' -tr1 [n]     (default = n)      : n:trace 1 is near offset'
        write(LER,*)
     :'                                 : f:trace 1 is far offset'
        write(LER,*)
     :' -mt [time]   (default = 4.8)    : max time(sec) of functions'
        write(LER,*)
     :' -mult[order] (default = 1)      : order of multiples desired'
        write(LER,*)
     :' -mode[mode]  (default = 0): 0 = generate order specified'
        write(LER,*)
     :'                           : 1 = generate upto order specified'
        write(LER,*)
     :' -model  : include -model on the command line to output pick '
        write(LER,*)
     :'           files with the record number indexed to the dataset' 
        write(LER,*)
     :'           shot point location.'
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)
     :'usage:   multlay -N1[truedip] -N2[tweak] -flg[oflag] -dt[time]'
        write(LER,*)
     :'                 -tr1[n] -mt[time] -mult[] -mode[] [-model]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end

