C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine RedFlag(rec,trace,nsi,fmax,map_trace,nsampo)

#include <f77/iounit.h>

      integer nsi,nsampo,i,rec,trace

      real map_trace(*),fmax,nsi_psdm,nyquist_psdm

c
c ----- determine if temporal sample theorem is being violated for -----
c       given fmax.
c

      do i=2,nsampo

         nsi_psdm = map_trace(i) - map_trace(i-1)
         nyquist_psdm = 1./(2.*nsi_psdm*1.e-3)

         if(nyquist_psdm.lt.fmax)then

           write(LERR,*)'WARNING.....record ',rec,' trace ',trace
           write(LERR,*)'Input from samples ',map_trace(i-1),' to ',
     *           map_trace(i)
           write(LERR,*)'has been squeezed between output samples'
           write(LERR,*)i-1,' and ', i,' when this squeeze is removed'
           write(LERR,*)'temporal aliasing below ',fmax,' hz will occur'

         endif
         
      enddo
      
      return
      end
