C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  -----                          psdm                                -----
c
c     Changes:
c
c     Feb 99 Garossino: Added -cep option for Steve Harris to allow 
c                       prestack application to emulate CEP Demult
c
c Original concept by Steve L. Harris, prototype code by  Dennis A. Yanchak
c USP Code by P.G.A. Garossino 
c
c psdm reads data in USP format one trace at a time, applies/removes
c a time variant stretch/squeeze and outputs data with updated line header.  
c
c  -----                          ----                                -----
c
c get machine dependent parameters
c

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 

      integer     lhed(SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin, lbytes, nbytes, obytes
      integer     argis, irs, ire, ns, ne
      integer     JJ, KK, i

      real        tri(SZLNHD)

      character   name*4, ntap*255, otap*255

      logical     verbos

c ----- integer USP variables -----
c
c       lhed()     : input data block
c       nsamp      : number of samples of input trace
c       nsi        : input sample interval
c       ntrc       : input traces/record
c       nrec       : input number of records
c       iform      : format of data
c       luin       : input device
c       lbytes     : number of bytes in lineheader
c       nbytes     : number of input bytes when trace is read
c       obytes     : number of bytes to output when processed trace is written
c       argis      : function returns 1 if element requested is present, 0 if not
c       irs        : processing record start [all data is passed outside limits]
c       ire        : processing record end
c       ns         : processing trace start
c       ne         : processing trace end
c       JJ, KK     : loop counters
c
c ----- real USP variables -----
c
c	tri()      : trace time series   
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	ntap       : input file name 
c       otap       : output file name
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c

c variables used with dynamic memory allocation

      integer     errcd1, errcd2, errcd3, errcd4
      integer     abort

      real        MapTrace, rectrc, picks, samps

      pointer     ( mem_MapTrace, MapTrace(2000000) )
      pointer     ( mem_picks,    picks(2000000) )
      pointer     ( mem_rectrc,   rectrc(2000000) )
      pointer     ( mem_samps,    samps(2000000) )

c psdm specific variables

      integer     lupick, nsegs, le1, total_picks, index(5000,1)
      integer     hpicks

      real        work(SZLNHD)
      real        fmax

      character   pickfile*255

      logical     remove, record, linear, cep

c ----- integer program variables -----
c
c     lupick          : logical unit for psdm pick file
c     nsegs           : number of segments in pick file
c     le1             : number of characters in name of pick file
c     total_picks     : number of picks in pick file
c     index(seg,elem) : array containing number of elements per segment data
c     errcd1-4        : error flag from galloc
c
c ----- real program variables -----
c
c     work()      : working space for intermediate time series
c     MapTrace() : psdm mapping function time series
c     rectrc()    : record or trace numbers from input pick file
c     picks()     : pick values (times/samples/whatever) from input pick file
c     fmax()      : max frequency of interest in input dataset
c     samps()     : array used as index for cubic spline interpolation
c
c ----- pointer program variables -----
c
c     mem_MapTrace    : memory pointer
c     mem_picks       : memory pointer
c     mem_rectrc      : memory pointer
c     mem_samps       : memory pointer
c
c ----- character program variables -----
c
c     pickfile : name of input pick file
c
c ----- logical program variables -----
c
c     remove  : application/removal flag for psdm
c     record  : record/trace wise application flag
c     linear  : interpolation flag
c
c initialize necessary variables

      data name/'PSDM'/
      data luin/1/
      data lbytes/0/
      data abort/0/

      remove = .false.
      linear = .false.

c get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0.or. 
     :     argis('-help') .gt. 0) then
           call help ()
           stop
      endif

c open printout files

#include <f77/open.h>

c get command line parameters 

      call cmdln( ntap, otap, pickfile, le1, irs, ire, ns, ne, fmax,
     :     remove, linear, cep, verbos )

c open input and output binary datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c open xsd pickfile dataset

      call alloclun(lupick)

      open ( lupick, file=pickfile(1:le1), status='old', err=990 )

c read line header, check to see if input empty

      call rtape(luin,lhed,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'PSDM: no line header read on ',ntap
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'PSDM: no line header read on ',ntap
         write(LER,*)'FATAL'
         stop
      endif

c historical line header and print to printout file 

      call hlhprt (lhed, lbytes, name, 4, LERR)

c save key line header parameters

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      if ( nsamp .gt. SZLNHD ) nsamp =SZLNHD

c ensure that command line values are compatible with data set

      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )

c set record start and end defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec

c determine number of output bytes in a trace block

      obytes = SZTRHD + nsamp * SZSMPD

c adjust historical line header & write header

      call savhlh ( lhed, lbytes, lbyout )
      call wrtape ( luout, lhed, lbyout )

c determine if input dataset is single record multi-trace or
c single trace, multi-record.  This is required to know which
c column of the pick file should be used for indexing.  If record
c then the first column containing record number will be used.  If
c .not. record then the second column containing trace number will be
c used

      if ( nrec .eq. 1 ) then
         record = .false.
      elseif ( ntrc .eq. 1 ) then
         record = .true.
      elseif ( .not. cep ) then
         write(LERR,*)' '
         write(LERR,*)' PSDM: Something fishy with input file.  It'
         write(LERR,*)'       does not look like a stacked dataset.'
         write(LERR,*)'       You must be up to something that requires'
         write(LERR,*)'       additional program logic.  Better call'
         write(LERR,*)'       the USP shop for consultation.'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)' PSDM: Something fishy with input file.  It'
         write(LER,*)'       does not look like a stacked dataset.'
         write(LER,*)'       You must be up to something that requires'
         write(LER,*)'       additional program logic.  Better call'
         write(LER,*)'       the USP shop for consultation.'
         write(LER,*)'FATAL'
         goto 999
      endif

      if ( cep ) record = .true.

c echo key parameters to printout file -----

      call verbal ( nsamp, nsi, ntrc, nrec, iform, ns, ne, irs, ire, 
     :     fmax, remove, record, linear, cep )

c perform quality control check on input xsd pick file

      call pick_count ( lupick, total_picks )

c dynamic memory allocation

      call galloc ( mem_MapTrace, nsamp*SZSMPD, errcd1, abort)
      call galloc ( mem_picks, total_picks*SZSMPD, errcd2, abort)
      call galloc ( mem_rectrc, total_picks*SZSMPD, errcd3, abort)
      call galloc ( mem_samps, nsamp * SZSMPD, errcd4, abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2 * nsamp * SZSMPD,'  bytes'
         write(LERR,*) 2 * total_picks * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2 * nsamp * SZSMPD,'  bytes'
         write(LER,*) 2 * total_picks * SZSMPD,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2 * nsamp * SZSMPD,'  bytes'
         write(LERR,*) 2 * total_picks * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( MapTrace, 1, nsamp )
      call vclr ( picks, 1, total_picks )
      call vclr ( rectrc, 1, total_picks )
      call vclr ( samps, 1, nsamp )

c load index(index,npnts), rectrc() and picks() arrays
c readpick assumes input picks are in horizon, datum pairs.

      call readpick ( lupick, nsegs, index, rectrc, picks, record, 
     :     total_picks )

c form sample index array for cubic spline interpolation
c This is done here for performance.  If done in the subroutine
c it would run nrec*ntrc number of times which is onerous on runtime

      do i=1,nsamp
         samps(i) = float(i)
      enddo

c read down to start record passing all records along the way

      call recrw ( 1, irs-1, luin, ntrc, lhed, luout, nbytes )

      IF ( cep ) then

         DO JJ = irs, ire

c create MapTrace containing desired position of input samples
                 
            call vclr( MapTrace, 1, nsamp )
            call PsdmMap ( JJ, MapTrace, index, rectrc, picks, 
     :           nsegs, nsamp, remove, nsi, total_picks, hpicks )

c read down to desired trace passing all traces along the way

            call trcrw ( JJ, 1, ns-1, luin, ntrc, lhed, luout, nbytes )

            DO KK = ns, ne

c read trace

               nbytes = 0
               call rtape(luin,lhed,nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',KK
                  go to 999
               endif
               
               call vmov ( lhed(ITHWP1), 1, tri(1), 1, nsamp )
               call vclr( work, 1, nsamp )

               if ( hpicks .ne. 0 ) then

c examine MapTrace for temporal sample theorem violations

                  if ( fmax .gt. 0.0 ) call RedFlag ( JJ, KK, nsi, fmax, 
     :                 MapTrace, nsamp )

c apply/remove psdm stretch/squeeze to input trace

                  call PsdmApply ( tri, work, MapTrace, nsamp, samps, 
     :                 linear )

c move psdm'd trace from work space to output time series otherwise
c trace still in lhed  will be output unchanged.

                  call vmov ( work(1), 1, lhed(ITHWP1), 1, nsamp )

               endif

c write out trace

               call wrtape(luout,lhed,obytes)

            ENDDO
c pass data to end of record

            call trcrw ( JJ, ne+1, ntrc, luin, ntrc, lhed, luout, 
     :           nbytes )

         ENDDO

      ELSE

         DO JJ = irs, ire

c read down to desired trace passing all traces along the way

            call trcrw ( JJ, 1, ns-1, luin, ntrc, lhed, luout, nbytes )

            DO KK = ns, ne

c read trace

               nbytes = 0
               call rtape(luin,lhed,nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',KK
                  go to 999
               endif
               
               call vmov ( lhed(ITHWP1), 1, tri(1), 1, nsamp )

c clear work space and stretch-squeeze mapping array for this trace

               call vclr( work, 1, nsamp )
               call vclr( MapTrace, 1, nsamp )

c create MapTrace containing desired position of input samples
                 
               if(record)then
                  call PsdmMap ( JJ, MapTrace, index, rectrc, picks, 
     :                 nsegs, nsamp, remove, nsi, total_picks, hpicks )
               else
                  call PsdmMap( KK, MapTrace, index, rectrc, picks, 
     :                 nsegs, nsamp, remove, nsi, total_picks, hpicks )
               endif

               if ( hpicks .ne. 0 ) then

c examine MapTrace for temporal sample theorem violations

                  if ( fmax .gt. 0.0 ) call RedFlag ( JJ, KK, nsi, fmax, 
     :                 MapTrace, nsamp )

c apply/remove psdm stretch/squeeze to input trace

                  call PsdmApply ( tri, work, MapTrace, nsamp, samps, 
     :                 linear )

c move psdm'd trace from work space to output time series otherwise
c trace still in lhed  will be output unchanged.

                  call vmov ( work(1), 1, lhed(ITHWP1), 1, nsamp )

               endif

c write out trace

               call wrtape(luout,lhed,obytes)

            ENDDO

c pass data to end of record

            call trcrw ( JJ, ne+1, ntrc, luin, ntrc, lhed, luout, 
     :           nbytes )

         ENDDO

      ENDIF

c pass rest of dataset
      
      call recrw ( ire+1, nrec, luin, ntrc, lhed, luout, nbytes )

c normal termination

      call lbclos(luin)
      call lbclos(luout)
      close (lupick)
      write(LERR,*)'Normal Termination'
      write(LER,*)'prgm: Normal Termination'
      stop

 990  continue

       write(LERR,*)' '
       write(LERR,*)'Could not open psdm pick file',pickfile
       write(LERR,*)'Check existence'
       write(LERR,*)'FATAL ...............'
       write(LER,*)' '
       write(LER,*)'PSDM: Could not open pick file',
     :      pickfile(1:le1)
       write(LER,*)'      Check spelling/existence'
       write(LER,*)'FATAL'
       stop

 999  continue

c abnormal termination

      call lbclos(luin)
      call lbclos(luout)
      close (lupick)

      write(LERR,*)'Abnormal Termination'
      write(LER,*)'prgm: Abnormal Termination'

      stop
      end
