C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine BuildShotArrays ( Model_NumShots, Model_ShotIncrement, 
     :     Model_InitialShot, ShotInterval, sp, x )

c build the sp(), rsp() and x() arrays used to associate any given
c shot within the model to a horizontal X dimension.  The units used
c are defined by the user entry of ShotInterval and should be consistent
c with the velocity used.  This is a user controlled source of error and
c will be mentioned in the upgraded man pages.

c Model_NumShots      -  I  -  number shots in zero offset section
c Model_InitialShot           -  I  -  first shot point number
c Model_ShotIncrement          -  R  -  shot point number increment
c ShotInterval  -  R  -  horizontal interval (shot, cdp)
c sp            -  I  -  vector of shot point numbers
c x             -  R8 -  double float vector of horizontal distances

#include  <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer Model_NumShots, Model_InitialShot, sp(SZLNHD)

      real Model_ShotIncrement

      real*8  x(SZLNHD)
      real*8  ShotInterval

c declare local variables

      real rsp

c flush out shot point and x distance arrays

      do  i = 1, Model_NumShots
         rsp = float( Model_InitialShot ) + Model_ShotIncrement * 
     :        float( i - 1 )
         sp(i) = nint( rsp )
         x(i) = ShotInterval * dble( rsp - 1.0 )
      enddo

      write(LERR,*)' '
      write(LERR,*)'   Model Shotpoint Indexing '
      write(LERR,*)' '
      write(LERR,*)'Shotpoint            X Coordinate'
      write(LERR,*)'---------------------------------'
      write(LERR,*)' '
         do i = 1, Model_NumShots
            write(LERR,*)sp(i), sngl( x(i) )
         enddo
      write(LERR,*)' '
      
      return
      end
