C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine HorizonRead ( lu_mfile, xsd_NumSegs, xsd_NumPoints, 
     :     xsd_size, xsd_x_coords, xsd_horizon_times, ShotInterval,
     :     Model_SmoothingOrder, verbos )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer lu_mfile, xsd_NumSegs, xsd_size, Model_SmoothingOrder 
      integer xsd_NumPoints(SZLNHD) 

      real xsd_x_coords(xsd_size), xsd_horizon_times(xsd_size)

      real*8 ShotInterval

      logical verbos

c declare local variables

      integer array_count, nrec, ntrc, nsmp, pointer

      real recunit, trcunit, smpunit, recoff, trcoff, smpoff

      character junk*1

c initialize variables

      array_count = 0

c read pickfile header 

      read ( lu_mfile, 100, end=900, err = 910 ) recunit, trcunit, 
     :     smpunit, nrec, ntrc, nsmp, recoff, trcoff, smpoff
 100  format(6x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,7x,f12.6,1x,
     :     f12.6,1x,f12.6)

c read segments

      do i = 1, xsd_NumSegs

c read past segment header

         read ( lu_mfile, '(a1)' ) junk

c read segment

         do  j = 1, xsd_NumPoints(i)
            
            array_count = array_count + 1

            read ( lu_mfile, '(f12.6,14x,f12.6)', err = 910 ) 
     :           xsd_x_coords(array_count), 
     :           xsd_horizon_times(array_count)


            xsd_x_coords(array_count) = 
     :            ( xsd_x_coords(array_count) - 1. ) * 
     :           sngl ( ShotInterval )

c convert horizon times to seconds from milliseconds
c may need to put in a time units entry on the command line
c if we start getting microsecond models etc....Garossino

            xsd_horizon_times(array_count) = 
     :           xsd_horizon_times(array_count) / 1000.

         enddo

      enddo

c sort to increasing x coordinate order

      call PickSort ( xsd_size, xsd_x_coords, xsd_horizon_times,  
     :     xsd_NumPoints, xsd_NumSegs )

c smooth horizons if requested

      if ( Model_SmoothingOrder .gt. 0 ) then

         do i = 1, xsd_NumSegs

            if ( i .eq. 1 ) then
               pointer = 1
            else
               pointer = pointer + xsd_NumPoints(i-1)
            endif
            
            call SmoothFit ( xsd_horizon_times(pointer), 
     :           xsd_NumPoints(i), Model_SmoothingOrder )
         enddo
      endif

c verbos printout of model if requested

      if (verbos ) then

         array_count = 0
         
         write(LERR,*)' '
         write(LERR,*)' Input Model Sorted '
         write(LERR,*)' ------------------ '
         write(LERR,*)' '
            
         do i = 1, xsd_NumSegs

            write(LERR,*)' Segment ', i

            do j = 1, xsd_NumPoints(i)

               array_count = array_count + 1
               write(LERR,*) xsd_x_coords(array_count), 
     :              xsd_horizon_times(array_count)

            enddo

            write(LERR,*)' '

         enddo
      endif
            
      return

 900  continue
      write(LERR,*)' TVD: empty input xsd pick file'
      write(LERR,*)' FATAL '
      write(LER,*)' '
      write(LER,*)' TVD: empty input xsd pick file'
      write(LER,*)' FATAL '
      write(LER,*)' '
      stop

 910  continue
      write(LERR,*)'TVD: error reading xsd pick file'
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'TVD: error reading xsd pick file'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop

      end

