C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dfltpl ( n, x, u, ugrd, f0, itype, slim, ilim, space, 
     :     itrial, ierr, c, nchan )
                                                          
#include <f77/lhdrsz.h>

C***********************************************************************
C     THIS SUBROUTINE DETERMINES THE GREATEST OR LEAST VALUE OF A       
C     FUNCTION USING FLETCHER AND POWELL'S METHOD OF GRADIENT SEARCH.   
C     SEE FLETCHER, R AND POWELL, M.J.D., 1963 "A RAPIDLY CONVERGENT    
C     DESCENT METHOD FOR MINIMIZATION," THE COMPUTER JOURNAL, VOL. 6,   
C     PAGE 163.                                                         
C     THE SUBROUTINE IS INTENDED FOR USE IN PROBLEMS OF NON-LINEAR      
C     OPTIMISATION.                                                     
C*****SUBROUTINE INPUTS.                                                
C     N = THE NUMBER OF INDEPENDENT VARIABLES.                          
C     X = THE ARRAY OF INITIAL VALUES OF THE INDEPENDENT VARIABLES.     
C     NC = THE NUMBER OF CONSTANTS IN THE FUNCTION, U                   
C     C = THE ARRAY OF CONSTANTS USED IN THE FUNCTION, U                
C     U = THE FUNCTION TO BE OPTIMISED. THIS IS AN EXTERNAL PROCEDURE   
C         NAME IN THE MAIN PROGRAM.                                     
C     UGRD = THE NAME OF THE SUBROUTINE THAT COMPUTES THE GRADIENT OF U.
C            THIS IS AN EXTERNAL PROCEDURE NAME IN THE MAIN PROGRAM.    
C     F0 = THE EXPECTED MINIMUM OR MAXIMUM VALUE OF THE FUNCTION, U.    
C     ITYPE = TYPE OF OPTIMISATION REQUIRED :-                          
C             ITYPE = 1 FOR MAXIMISING                                  
C             ITYPE = -1 FOR MINIMISING                                 
C     SLIM = THE DESIRED LIMIT OF THE PREDICTED ABSOLUTE DISTANCE FROM  
C            THE OPTIMUM.                                               
C     ILIM = THE MAXIMUM NUMBER OF TRIALS ALLOWED BEFORE TERMINATION.   
C*****SUBROUTINE OUTPUTS.                                               
C     X = THE ARRAY OF VALUES OF THE INDEPENDENT VARIABLES THAT OPTIMISE
C         THE FUNCTION.                                                 
C     SPACE = WORKING SPACE - (3 * N * (N + 2)) ELEMENTS.               
C     ITRIAL = THE NUMBER OF TRIALS.                                    
C     IERR = COMPLETION CODE:-                                          
C            IERR = 0        NORMAL COMPLETION. DISTANCE FROM OPTIMUM IS
C                            LESS THAN SLIM.                            
C            IERR = 1        ITYPE IS NOT 1 OR -1.                      
C            IERR = 2        MAXIMUM NUMBER OF TRIALS HAS BEEN EXCEEDED.
C*****PARTITION OF WORKING SPACE                                        
C     SPACE(1 TO N) = GX, THE ARRAY OF PARTIAL DERIVATIVES OF THE       
C                     FUNCTION AT THE POINT, X.                         
C     SPACE((N + 1) TO (2 * N)) = XNEXT, THE NEW VALUE OF X IN THE THE  
C                                 DIRECTION OF ADVANCE.                 
C     SPACE((2 * N + 1) TO (3 * N)) = GNEXT, THE ARRAY OF PARTIAL       
C                                     DERIVATIVES AT THE POINT, XNEXT.  
C     SPACE((3 * N + 1) TO (4 * N)) = Y, THE ARRAY OF DIFFERENCES       
C                                     BETWEEN THE PARTIAL DERIVATIVES AT
C                                     X AND XNEXT.                      
C     SPACE((4 * N + 1) TO (5 * N)) = S, THE ARRAY OF COMPONENTS OF THE 
C                                     DIRECTION OF SEARCH.              
C     SPACE((5 * N + 1) TO (6 * N)) = SIGMA, THE ARRAY OF DISTANCES     
C                                     MOVED IN THE DIRECTION OF SEARCH. 
C     SPACE((6 * N + 1) TO (6 * N + N * N)) = THE ARRAY, H OF THE       
C                                             PSEUDO-INVERSE OF THE     
C                                             ARRAY OF SECOND PARTIAL   
C                                             DERIVATIVES.              
C     SPACE((6 * N + N * N + 1) TO (6 * N + 2 * N * N)) = THE ARRAY, A  
C                                                         THE FIRST     
C                                                         UPDATE        
C                                                         COMPONENT OF H
C     SPACE((6 * N + 2 * N * N + 1) TO (6 * N + 3 * N * N)) = THE ARRAY,
C                                                             B THE     
C                                                             SECOND    
C                                                             UPDATE    
C                                                             COMPONENT 
C                                                             OF H.     
C     SPACE(1 TO N) = THE ARRAY, TEMP, OF TEMPORARY STORAGE.            
C                     (USES THE SAME LOCATIONS AS GX).                  
C     SPACE((6 * N + N * N + 1) TO (10 * N + N * N)) = SPACE FOR        
C                                                      SUBROUTINE DCBINT
C                                                      (USES THE SAME   
C                                                      LOCATIONS AS A)  
C*****SUBROUTINES REQUIRED                                              
C     DZERO                                                             
C     DMMOVE                                                            
C     DMMULT                                                            
C     DMTMUL                                                            
C     DSCAL1                                                            
C     DSCAL2                                                            
C     DMXADD                                                            
C     DMXSUB                                                            
C     DDDOT                                                             
C     DCBINT                                                            
C***********************************************************************
C     THIS SUBROUTINE WAS WRITTEN BY M.D. BUSH, 1988                    
C***********************************************************************
      external u, ugrd              
                                     
      integer itype, ilim, itrial, ierr, igx, ixnext, ignext, iy, is 
      integer isigma, ih  
      integer ia, ib, itemp, icbint, i, ii, nn, nchan, n  
                        
      real*8 x(n), space(3 * n * (n + 2)), c(SZLNHD)                          
      real*8 u, dprod, sroot, fx, alpha, slim, f0  
                           
C***********************************************************************
C     SET THE NUMBER OF TRIALS TO ZERO AT THE START OF THE PROCEDURE.   
C     CHECK TO SEE IF THE CORRECT CODE HAS BEEN INPUT FOR THE TYPE OF   
C     OPTIMISATION REQUIRED. IF THE CODE IS INCORRECT THE SUBROUTINE    
C     WILL EXIT.                                                        
C***********************************************************************
      ITRIAL = 0                                                        
      IERR = 0                                                          
      IF(IABS(ITYPE).NE.1) THEN                                         
        IERR = 1                                                        
        RETURN                                                          
      ENDIF                                                             
C***********************************************************************
C     SET THE INITIAL ELEMENTS OF THE PARTITIONS OF THE WORKING SPACE TO
C     FIT THE ARRAYS THAT ARE TO BE USED.                               
C***********************************************************************
      NN = N * N                                                        
      IGX = 1                                                           
      IXNEXT = N + 1                                                    
      IGNEXT = IXNEXT + N                                               
      IY = IGNEXT + N                                                   
      IS = IY + N                                                       
      ISIGMA = IS + N                                                   
      IH = ISIGMA + N                                                   
      IA = IH + NN                                                      
      IB = IA + NN                                                      
      ITEMP = IGX                                                       
      ICBINT = IA                                                       
C***********************************************************************
C     PUT THE UNIT MATRIX INTO H TO START THE PROCEDURE                 
C***********************************************************************
      CALL DZERO(NN,SPACE(IH))                                          
      DO 1 I = 1,N                                                      
        II = (I - 1) * N + I                                            
        SPACE(IH + II - 1) = DBLE(1.0)                                  
    1 CONTINUE                                                          
C***********************************************************************
C     COMPUTE THE PARTIAL DERIVATIVES OF THE FUNCTION AT THE POINT X.   
C     COMPUTE THE VALUE OF THE FUNCTION AT THE POINT X.                 
C     COMPUTE THE COMPONENTS OF THE DIRECTION OF ADVANCE.               
C***********************************************************************
      FX = U(C,X,NCHAN)                                                 
    2 IF(ITRIAL.EQ.0) THEN                                              
        CALL UGRD(C,X,SPACE(IGX),NCHAN)                                 
        ELSE                                                            
        CALL DMMOVE(N,SPACE(IGNEXT),SPACE(IGX))                         
      ENDIF                                                             
      CALL DMMULT(SPACE(IH),SPACE(IGX),SPACE(IS),N,1,N)                 
      IF(ITYPE.EQ.-1) CALL DSCAL1(SPACE(IS),N,DBLE(-1.0))               
C***********************************************************************
C     COMPUTE THE SCALAR ALPHA IN THE DIRECTION OF ADVANCE              
C***********************************************************************
      CALL DCBINT(N,X,U,UGRD,SPACE(IGX),SPACE(IS),FX,F0,ITYPE,SPACE(ICBI
     *NT),ALPHA,C,NCHAN)                                                
C***********************************************************************
C     DETERMINE THE NEW POINT FOR X                                     
C***********************************************************************
      CALL DMMOVE(N,SPACE(IS),SPACE(ISIGMA))                            
      CALL DSCAL1(SPACE(ISIGMA),N,ALPHA)                                
      CALL DMXADD(X,SPACE(ISIGMA),SPACE(IXNEXT),N,1)                    
C***********************************************************************
C     CALCULATE THE FUNCTION VALUE AND ITS GRADIENT AT THE NEW POINT.   
C     CALCULATE THE COMPONENTS OF THE MOVE VECTOR.                      
C***********************************************************************
      FX = U(C,SPACE(IXNEXT),NCHAN)                                     
      CALL UGRD(C,SPACE(IXNEXT),SPACE(IGNEXT),NCHAN)                    
      CALL DMXSUB(SPACE(IGNEXT),SPACE(IGX),SPACE(IY),N,1)               
C***********************************************************************
C     CALCULATE THE MATRIX, A, GIVEN BY FLETCHER AND POWELL.            
C***********************************************************************
      CALL DMTMUL(SPACE(ISIGMA),N,1,1,0,0,SPACE(IA),IERR)               
      CALL DDDOT(N,SPACE(ISIGMA),SPACE(IY),DPROD)                       
      IF(DABS(DPROD).EQ.DBLE(0.0).OR.DABS(DPROD).LT.DBLE(1.E-78)) GOTO 3
      CALL DSCAL2(SPACE(IA),NN,DPROD)                                   
C***********************************************************************
C     CALCULATE THE MATRIX, B, GIVEN BY FLETCHER AND POWELL.            
C***********************************************************************
      CALL DMMULT(SPACE(IH),SPACE(IY),SPACE(ITEMP),N,1,N)               
      CALL DMTMUL(SPACE(ITEMP),N,1,1,0,0,SPACE(IB),IERR)                
      CALL DDDOT(N,SPACE(IY),SPACE(ITEMP),DPROD)                        
      IF(DABS(DPROD).EQ.DBLE(0.0).OR.DABS(DPROD).LT.DBLE(1.E-78)) GOTO 3
      CALL DSCAL2(SPACE(IB),NN,DBLE(-1.0) * DPROD)                      
C***********************************************************************
C     PUT H = H + A + B.                                                
C***********************************************************************
      CALL DMXADD(SPACE(IH),SPACE(IA),SPACE(IH),N,N)                    
      CALL DMXADD(SPACE(IH),SPACE(IB),SPACE(IH),N,N)                    
C***********************************************************************
C     CHECK FOR EXIT LIMITS.                                            
C***********************************************************************
    3 ITRIAL = ITRIAL + 1                                               
      CALL DMMOVE(N,SPACE(IXNEXT),X)                                    
      IF(ITRIAL.LT.N) THEN                                              
        GOTO 2                                                          
        ELSE                                                            
        CALL DDDOT(N,SPACE(IS),SPACE(IS),SROOT)                         
        CALL DDDOT(N,SPACE(ISIGMA),SPACE(ISIGMA),DPROD)                 
        IF(DSQRT(SROOT).LE.SLIM.OR.DSQRT(DPROD).LE.SLIM) THEN           
          RETURN                                                        
          ELSE IF(ITRIAL.LE.ILIM) THEN                                  
          GOTO 2                                                        
        ENDIF                                                           
      ENDIF                                                             
      IERR = 2                                                          
      RETURN                                                            
      END                                                               
