C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DMTMUL(A,M,N,ITYPE,ITRI,ISTOR,C,IERR)                  SUN04260
C***********************************************************************SUN04270
C     THIS SUBROUTINE MULTIPLIES A MATRIX A, BY ITS TRANSPOSE TO GIVE   SUN04280
C     THE SYMMETRIC MATRIX, C. THE TRANSPOSE MATRIX IS NOT OUTPUT BY    SUN04290
C     THIS SUBROUTINE.                                                  SUN04300
C     NOTE THAT A * A(T) DOES NOT EQUAL A(T) * A.                       SUN04310
C     THIS IS THE DOUBLE PRECISION VERSION OF SUBROUTINE MTMUL.         SUN04320
C*****SUBROUTINE INPUTS.                                                SUN04330
C     A = THE MATRIX TO BE MULTIPLIED                                   SUN04340
C     M = THE NUMBER OF ROWS IN A                                       SUN04350
C         THE NUMBER OF COLUMNS IN C    IF ITYPE = 1                    SUN04360
C         THE NUMBER OF ROWS IN C       IF ITYPE = 1                    SUN04370
C     N = THE NUMBER OF COLUMNS IN A                                    SUN04380
C         THE NUMBER OF COLUMNS IN C    IF ITYPE = -1                   SUN04390
C         THE NUMBER OF ROWS IN C       IF ITYPE = -1                   SUN04400
C     ITYPE = MULTIPLICATION ORDER FLAG                                 SUN04410
C             ITYPE =  1     C = A * A(T)                               SUN04420
C             ITYPE = -1     C = A(T) * A                               SUN04430
C     ITRI = THE TYPE OF TRIANGULAR MATRIX.                             SUN04440
C             ITRI = 0  C IS UPPER TRIANGULAR OR STORED IN FULL FORM.   SUN04450
C             ITRI = 1  C IS LOWER TRIANGULAR                           SUN04460
C     ISTOR = THE METHOD OF STORING THE COEFFICIENTS OF ARRAY, C.       SUN04470
C             ISTOR = 0 THE MATRIX C IS STORED AS A FULL MATRIX.        SUN04480
C             ISTOR = 1 THE MATRIX C IS STORED IN TRIANGULAR FORM.      SUN04490
C*****SUBROUTINE OUTPUTS.                                               SUN04500
C     C = THE MATRIX PRODUCT.                                           SUN04510
C     IERR = ERROR CODE ON RETURN                                       SUN04520
C            IERR = 0  NORMAL COMPLETION                                SUN04530
C            IERR = 1  INCORRECT ITYPE.                                 SUN04540
C            IERR = 2  INCORRECT ITRI                                   SUN04550
C            IERR = 3  INCORRECT ISTOR                                  SUN04560
C***********************************************************************SUN04570
      REAL*8 A(M*N),C(M*M)                                              SUN04580
      INTEGER M,N,ITYPE,ITRI,ISTOR,IERR,L1,L2,L3,I,J,IJ,JI,IA,IAT
C***********************************************************************SUN04600
C     INITIALISE ERROR CODE, IERR AS ZERO                               SUN04610
C***********************************************************************SUN04620
      IERR = 0                                                          SUN04630
      IF(IABS(ITYPE).NE.1) THEN                                         SUN04640
        IERR = 1                                                        SUN04650
        RETURN                                                          SUN04660
        ELSE IF(ITRI.LT.0.OR.ITRI.GT.1) THEN                            SUN04670
        IERR = 2                                                        SUN04680
        RETURN                                                          SUN04690
        ELSE IF(ISTOR.LT.0.OR.ISTOR.GT.1) THEN                          SUN04700
        IERR = 3                                                        SUN04710
        RETURN                                                          SUN04720
      ENDIF                                                             SUN04730
C***********************************************************************SUN04740
C     SET LOOP LIMITS.                                                  SUN04750
C***********************************************************************SUN04760
      IF(ITYPE.GT.0) THEN                                               SUN04770
        L1 = M                                                          SUN04780
        L2 = M                                                          SUN04790
        L3 = N                                                          SUN04800
        ELSE                                                            SUN04810
        L1 = N                                                          SUN04820
        L2 = N                                                          SUN04830
        L3 = M                                                          SUN04840
      ENDIF                                                             SUN04850
C***********************************************************************SUN04860
C     BEGIN THE MULTIPLICATION                                          SUN04870
C***********************************************************************SUN04880
      DO 3 I = 1,L1                                                     SUN04890
        DO 2 J = I,L2                                                   SUN04900
          IJ = (J - 1) * L1 + I                                         SUN04910
          JI = (I - 1) * L1 + J                                         SUN04920
C***********************************************************************SUN04930
C      SET STORAGE LOCATIONS FOR TRIANGULAR STORAGE OF MATRIX,C.        SUN04940
C***********************************************************************SUN04950
          IF(ISTOR.EQ.1) THEN                                           SUN04960
            IF(ITRI.EQ.0) THEN                                          SUN04970
              IJ = IJ - (J - 1) * (L1 - J) - J * (J - 1) / 2            SUN04980
              ELSE                                                      SUN04990
              IJ = JI - I * (I - 1) / 2                                 SUN05000
            ENDIF                                                       SUN05010
          ENDIF                                                         SUN05020
          C(IJ) = DBLE(0.0)                                             SUN05030
C***********************************************************************SUN05040
C      FORM THE VALUES OF THE ELEMENTS OF THE OUTPUT MATRIX,C.          SUN05050
C***********************************************************************SUN05060
          DO 1 K = 1,L3                                                 SUN05070
            IF(ITYPE.GT.0) THEN                                         SUN05080
              IA = (K - 1) * L1 + I                                     SUN05090
              IAT = (K - 1) * L1 + J                                    SUN05100
              ELSE                                                      SUN05110
              IA = (I - 1) * L3 + K                                     SUN05120
              IAT = (J - 1) * L3 + K                                    SUN05130
            ENDIF                                                       SUN05140
C***********************************************************************SUN05150
C     CHECKS TO VERIFY WHETHER AN UNDER FLOW ERROR WILL OCCUR OWING     SUN05160
C     TO THE PRESENCE OF LARGE NEGATIVE EXPONENTS. THE LIMIT ON THE     SUN05170
C      IBM 370 IS 10E-78. NUMBERS SMALLER THAN THIS ARE SET TO ZERO.    SUN05180
C***********************************************************************SUN05190
            IF(A(IA).EQ.DBLE(0.0).OR.A(IAT).EQ.DBLE(0.0)) GOTO 1        SUN05200
            IF(DLOG10(DABS(A(IA)))+DLOG10(DABS(A(IAT))).LE.DBLE(-78.)) GSUN05210
     *OTO 1                                                             SUN05220
            C(IJ) = C(IJ) + A(IA) * A(IAT)                              SUN05230
    1     CONTINUE                                                      SUN05240
          IF(ISTOR.EQ.0) C(JI) = C(IJ)                                  SUN05250
    2   CONTINUE                                                        SUN05260
    3 CONTINUE                                                          SUN05270
      RETURN                                                            SUN05280
      END                                                               SUN05290
