C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine header ( c, nchan, BoatDirection, c_domain, 
     :     Analysis_InitialShot, Analysis_ShotIncrement, line, 
     :     lu_sred, lu_rred, lu_sgreen, lu_rgreen, lu_truedip )

#include <f77/lhdrsz.h>

C ROUTINE TO build headers for output files
c
c I will rebuild this header for today type applications once I get
c into the runtime debug of this code
c  
c Garossino

c declare variables passed from calling routine

      integer nchan, Analysis_InitialShot, Analysis_ShotIncrement
      integer lu_sred, lu_rred, lu_sgreen, lu_rgreen, lu_truedip
                                               
      real BoatDirection
                                        
      real*8 c(SZLNHD)  
       
      character line*256, c_domain*14 

c declare local variables

      character*14  shtdir
                                  
      if ( BoatDirection .gt. 0. ) then                                                
         shtdir='Left to Right'                                         
      else                                                              
         shtdir='Right to Left'                                         
      endif                                                             

      if ( c_domain .eq. 'shot' ) then                                                

c write shot domain headers

         write(lu_sred,10) line, c_domain, shtdir, nchan, c(10), 
     :        c(16), c(11), Analysis_InitialShot, 
     :        Analysis_ShotIncrement, c(20) * 1000., c(25) * 100.

         write(lu_sgreen,10) line, c_domain, shtdir, nchan, c(10),
     :        c(16), c(11), Analysis_InitialShot, 
     :        Analysis_ShotIncrement, c(20) * 1000., c(25) * 100.

         write(lu_truedip,10) line, c_domain, shtdir, nchan, c(10),
     :        c(16), c(11), Analysis_InitialShot,  
     :        Analysis_ShotIncrement, c(20) * 1000.,c(25) * 100.

 10      format(' TVD Parameters for line',2X,A14,/,'-------------------
     :-------------------',/,' Domain Requested:',2X,A14,/,' Shooting Di
     :rection:',2X,A14,/,' Number of Channels:',2X,I10,/,' Group Interva
     :l:',2X,F10.2,/,' Shot Interval:',2X,F10.2,/,' Gap:',10X,F10.2,/,' 
     :Analysis Start:',2X,I12,/,' Analysis Interval:',2X,I12,/,
     :' TWEAK Requested:',2X,F10.2,/,
     :' Percent of Spread for Dip Estimation:',2X,F10.2,/,'-------------
     :------------------------------------------------------------')   
                                            
            WRITE(lu_sred,11)                                              
            WRITE(lu_sgreen,11)                                              
            WRITE(lu_truedip,11)                                              
 11         format(' Output using SIGNED DISTANCE ',/,'-----------------
     :--------------------------------------------------------',/)
    
      else                                                              

c fill out receiver domain headers as required

         write(lu_rred,10) line, c_domain, shtdir, nchan, c(10),
     :        c(16), c(11), Analysis_InitialShot,  
     :        Analysis_ShotIncrement, c(20) * 1000., c(25) * 100.

         write(lu_rgreen,10) line, c_domain, shtdir, nchan, c(10), 
     :        c(16), c(11), Analysis_InitialShot,  
     :        Analysis_ShotIncrement, c(20) * 1000., c(25) * 100.

         write(lu_truedip,10) line, c_domain, shtdir, nchan, c(10), 
     :        c(16), c(11), Analysis_InitialShot,  
     :        Analysis_ShotIncrement, c(20) * 1000., c(25) * 100.
                                          
c signed distance flag [again may not need this .... see above ]

            write(lu_rred,11)                                              
            write(lu_rgreen,11)                                              
            write(lu_truedip,11)                                              

      endif     

      return                                                            
      end                                                               
