C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine minmax ( tout, d, v, c, u, Analysis_NumHorizons, dp, 
     :     vp, v0, Data_MaxTime )

#include <f77/lhdrsz.h>

c routine to provide a zero and maxtime entry to the (t,d,v)
c function

c declare variables passed from calling routine

      integer Analysis_NumHorizons

      real*8 v0, Data_MaxTime
      real*8 d(SZLNHD), v(SZLNHD), u(SZLNHD)
      real*8 tout(SZLNHD), dp(SZLNHD), vp(SZLNHD)

      character*1 c(SZLNHD)

c declare local variables

      integer i

      character*1 ctemp(SZLNHD)

      real*8 ttemp(SZLNHD), dtemp(SZLNHD), vtemp(SZLNHD)
      real*8 utemp(SZLNHD), dptemp(SZLNHD), vptemp(SZLNHD)

c c(i) is an array containing function color
c ctemp(i) is an array containing function color
c Analysis_NumHorizons is number of horizons input
c i is a counter
c t(i) contains  times
c d(i) contains  dips
c v(i) contains velocities
c ttemp(i) contains times
c dtemp(i) contains dips
c vtemp(i) contains velocities
c u(i) contains functions minimum times in ms
c utemp(i) contains functions minimum times in ms

c initialize variables

      Analysis_NumHorizons = Analysis_NumHorizons - 1

      do i = 1, Analysis_NumHorizons + 2
         ttemp(i) = 0.
         dtemp(i) = 0.
         vtemp(i) = 0.
         ctemp(i) = 'Z'
         utemp(i) = 0.
         dptemp(i) = 0.
         vptemp(i) = 0.
      enddo

c load arrays into temporary storage leaving room for zero and water
c bottom pick

      do i = 1, Analysis_NumHorizons

         ttemp(i+1) = tout(i)

c check to see if model digitized greater than maximum time of data
c although I am not sure why this is such a problem....will check
c it out at run time debug time.

         if ( tout(i) .gt. Data_MaxTime ) then

           print*,'Horizon time= ',tout(i),' greater than trace length= 
     *',Data_MaxTime,' (sec)'
           print*,'Rerun tvd with longer trace length or delete 1 or '
           print*,'deep horizons'
           stop

         endif

         dtemp(i+1) = d(i)
         vtemp(i+1) = v(i)
         ctemp(i+1) = c(i)
         dptemp(i+1) = dp(i)
         vptemp(i+1) = vp(i)
         utemp(i+1) = u(i)

      enddo

c assign time zero and start time

      utemp(1) = 0.
      ttemp(1) = 0.
      ctemp(1) = c(1)

c assign dip(1) for zero time

      dtemp(1) = dtemp(2)
      dptemp(1) = dptemp(2)

c assign v(0) to zero time velocity entry

      vtemp(1) =  v0

c look at this at debug time....I cannot tell why I did not
c do the same for the primary velocity....maybe it does not
c get used for anything....Garossino

      vptemp(1) = vptemp(2)

c handle entry at max time

      ttemp(Analysis_NumHorizons + 2) =  Data_MaxTime
      dtemp(Analysis_NumHorizons + 2) = dtemp(Analysis_NumHorizons + 1)

c look at this as well....I cannot tell why I thought 
c adding an incremental velocity was such a good idea
c and why this amount I have no idea....Garossino

      vtemp(Analysis_NumHorizons + 2) = vtemp(Analysis_NumHorizons + 1) 
     :     + .17 * vtemp( Analysis_NumHorizons + 1 )

      ctemp(Analysis_NumHorizons + 2) = ctemp(Analysis_NumHorizons + 1)
      utemp(Analysis_NumHorizons + 2) = 0.
      dptemp(Analysis_NumHorizons + 2) = 
     :     dptemp(Analysis_NumHorizons + 1)
      vptemp(Analysis_NumHorizons + 2) = 
     :     vptemp(Analysis_NumHorizons + 1) + .17 * 
     :     vptemp(Analysis_NumHorizons + 1)

c reload arrays for output

      do i = 1, Analysis_NumHorizons + 2

         tout(i) = ttemp(i)
         d(i) = dtemp(i)
         v(i) = vtemp(i)
         c(i) = ctemp(i)
         u(i) = utemp(i)
         dp(i) = dptemp(i)
         vp(i) = vptemp(i)

      enddo

c advance Analysis_NumHorizons to account for the extra values added

      Analysis_NumHorizons  =  Analysis_NumHorizons + 2

      return
      end
