C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      DOUBLE PRECISION FUNCTION NEGIF(C,VAR,NCHAN)
C**********************************************************************
      INTEGER NCHAN,STEP
C**********************************************************************
      REAL*8 C(99),VAR(99),XVP,XVNMO,TP,TNMOP,SUM,TEMP
#include <f77/iounit.h>
C**********************************************************************
C THIS FUNCTION STAMENT CALCULATES VALUES OF TP-TNMOP AND RETURNS THE
C VALUES TO FORCE.
C
C EQUATIONS USED
C --------------
C
C T(X) = DSQRT(TO**2+(X/V)**2-2*TO*X*SIN(D)/V)
C TNMO(X) = DSQRT(TO**2+(X/VAR(1))**2-2*TO*X*SIN(VAR(2))/VAR(1))
C
C**********************************************************************
      SUM=0.
      IF(C(7).LE.C(20)) VAR(2) = C(8)
      STEP=NINT(FLOAT(NCHAN)/10.)
      DO 10 I=1,NCHAN+1,STEP
         C(9)=C(11)+DFLOAT(I-1)*C(10)
         XVP=C(9)/C(6)
         XVNMO=C(9)/(VAR(1))
         TP=(2.*C(5)/C(6))**2+XVP**2-4.*C(5)*C(9)*DSIN(C(8))/C(6)**2
      TNMOP=(2.*C(5)/C(6))**2+XVNMO**2-4.*C(5)*C(9)*DSIN(VAR(2))/(C(6)*V
     *AR(1))
c         if(tp.lt.dble(0.))write(LOT,*)'tp negative'
c         if(tnmop.lt.dble(0.))write(LOT,*)'tnmop negative'
         TEMP=DSQRT(TP)-DSQRT(TNMOP)
         SUM=SUM+TEMP
10    CONTINUE
C**********************************************************************
      NEGIF=(C(20)-C(21)*SUM/10.)**2
C**********************************************************************
      RETURN
      END
