C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      double precision function negip(c,var,nchan)

#include <f77/lhdrsz.h>

      integer nchan, step

      real*8 c(SZLNHD),var(SZLNHD),xvp,xvnmo,tp,tnmop,sum,temp

c this function stament calculates values of tp-tnmop and returns the
c values to force.
c
c equations used
c --------------
c
c t(x) = dsqrt(to**2+(x/v)**2-2*to*x*sin(d)/v)
c tnmo(x) = dsqrt(to**2+(x/var(1))**2-2*to*x*sin(var(2))/var(1))
c

      sum=0.
      step=nint(float(nchan)/10.)
      do 10 i=1,nchan+1,step
         c(9)=c(11)+dfloat(i-1)*c(10)
         xvp=c(9)/c(6)
         xvnmo=c(9)/(var(1))
         tp=(2.*c(5)/c(6))**2+xvp**2-4.*c(5)*c(9)*dsin(c(8))/c(6)**2
      tnmop=(2.*c(5)/c(6))**2+xvnmo**2-4.*c(5)*c(9)*dsin(var(2))/(c(6)*v
     *ar(1))
         temp=dsqrt(tp)-dsqrt(tnmop)
         sum=sum+temp
10    continue

      negip=sum/10.d0

      return
      end
