C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine BuildTrace( NumEntries, time, value, nsamp, 
     :        nsi, UnitSC, trace )

c declare variables passed from calling routine

      integer NumEntries, nsamp, nsi

      real UnitSC

      real time(NumEntries), value(NumEntries), trace(nsamp)

c declare local variables

      integer i, j

      real t, dt, dv, slope

      logical done

c initialize variables

      call vclr ( trace, 1, nsamp )

c interpolate / extrapolate trace

      do i = 1, nsamp

         t = float ( (i - 1) * nsi ) * UnitSc

         if ( t .le. time(1) ) then
            trace(i) = value(1)
         elseif ( t .ge. time(NumEntries) ) then
            trace(i) = value(NumEntries)
         else

            done = .false.
            j = 2

            do while ( .not. done )

               if ( t .le. time(j) ) then
                  dt = time(j) - time(j-1)
                  dv = value(j) - value(j-1)
                  slope = dv / dt
                  trace(i) = value(j-1) + ( t - time(j-1) ) * slope
                  done = .true.
               else
                  j = j + 1
                  if ( j .gt. NumEntries ) done = .true.
               endif
            enddo
         endif

      enddo

      return
      end
