C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tvd_Init( lu_tvd, NumFcns, MaxEntries )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer lu_tvd, NumFcns, MaxEntries

c declare local variables

      integer count

      character junk*1

c initialize variables

      NumFcns = 0
      MaxEntries = 0

c read past header

      read ( lu_tvd, '(///////////////)', end=900, err=901 )

c count the number of functions and the number of elements in 
c each keeping track of the biggest for memory allocation 
c purposes

      do while ( 1 .eq. 1 )

         read ( lu_tvd, '(1x,a1)', end=902, err=901 ) junk
         
         if ( junk .eq. 'L' ) then
         
            NumFcns = NumFcns + 1

c read past function header
         
            read ( lu_tvd, '(///)', err=901 )
            junk = ' '

c count elements

            count = 0
         
            do while ( junk .ne. 'L' )
               
               read (lu_tvd, '(1x,a1)', end=903, err=901 ) junk
               count = count + 1

            enddo

            backspace ( lu_tvd )
            count = count - 1
            if ( count .gt. MaxEntries ) MaxEntries = count

         endif

      enddo

c conditions

 900  continue

c empty input tvd file

      write(LERR,*)' '
      write(LERR,*)' Your input tvd function file appears'
      write(LERR,*)' to be empty.  Have hit an EOF prior'
      write(LERR,*)' to reading the first function'
      write(LERR,*)'FATAL '
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'TVDIN: '
      write(LER,*)' Your input tvd function file appears'
      write(LER,*)' to be empty.  Have hit an EOF prior'
      write(LER,*)' to reading the first function'
      write(LER,*)'FATAL '
      write(LER,*)' '
      stop

 901  continue

c some type of error reading tvd file...usually format related
 
      write(LERR,*)' '
      write(LERR,*)' error reading t,v,d, input function'
      write(LERR,*)' verify integrity of file and resubmit'
      write(LERR,*)'FATAL '
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'TVDIN: '
      write(LER,*)' error reading t,v,d, input function'
      write(LER,*)' verify integrity of file and resubmit'
      write(LER,*)'FATAL '
      write(LER,*)' '
      stop

 902  continue

c probably a legal exist unless we get here on the first read of 
c the first function

      if ( NumFcns .lt. 1 ) then

         write(LERR,*)' '
         write(LERR,*)' Your input tvd function file appears'
         write(LERR,*)' to be empty.  Have hit an EOF prior'
         write(LERR,*)' to reading the first function'
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVDIN: '
         write(LER,*)' Your input tvd function file appears'
         write(LER,*)' to be empty.  Have hit an EOF prior'
         write(LER,*)' to reading the first function'
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop

      else

         return

      endif

 903  continue

c again all may be well or we may have a corrupt input tvd function file
c if we have hit an eof in the middle of a function read....

      if ( count .eq. 0 ) then
        
         write(LERR,*)' '
         write(LERR,*)' Your input tvd function file appears'
         write(LERR,*)' to be corrupt.  Have hit an EOF in'
         write(LERR,*)' mid-function.  Verify integrity of '
         write(LERR,*)' input file and resubmit. '
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVDIN: '
         write(LER,*)' Your input tvd function file appears'
         write(LER,*)' to be corrupt.  Have hit an EOF in'
         write(LER,*)' mid-function.  Verify integrity of '
         write(LER,*)' input file and resubmit. '
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop

      else

         if ( count .gt. MaxEntries ) MaxEntries = count
         return

      endif

      end
