C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
c       program tvdin: time, velocity / dip interpolation 
c       purpose: Enter RMS velocity-dip model for NMO correction
C       for use with tvd & tvdnmo
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <save_defs.h>

c standard USP variables

      integer nsamp, nsi, ntrc, nrec
      integer luin, luout, lbytes, nbytes, obytes
      integer  argis
      integer itr ( SZLNHD )

      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum

      character   ntap*255, otap*255, name*5

c variables used in dynamic memory allocation

      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, abort
      integer tvd_index, usp_record_index, NumEntries, size

      real time, dip, velocity

      pointer ( mem_usp_record_index, usp_record_index(1) )
      pointer ( mem_tvd_index, tvd_index(1) )
      pointer ( mem_time, time(1) )
      pointer ( mem_dip, dip(1) )
      pointer ( mem_NumEntries, NumEntries(1) )
      pointer ( mem_velocity, velocity(1) )

c local static variables

      integer usp_initial_index, lu_tvd
      integer ifmt_word, l_word, ln_word
      integer NumFcns, MaxEntries

      real vel_trace ( SZLNHD ), dip_trace ( SZLNHD )

      character tvdtap*255, c_word*6

      logical single, verbos, src, regular

c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'TVDIN'/
      data abort/0/

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

C open printout files

#include <f77/open.h>

C read command line parameters 

      call cmdln ( ntap, otap, tvdtap, c_word, regular, src, 
     :     verbos )

c get logical units

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c verify that usp dataset is available

      lbytes = 0
      call rtape ( luin, itr, lbytes )

      if ( lbytes .eq. 0 ) then
         length = lenth(ntap)
	 if (length .gt. 0) then
           write(LERR,*)' No line header read on ', ntap(1:length)
	 else
           write(LERR,*)' No line header read on stdin'
	 endif
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'TVDIN: '
	 if (length .gt. 0) then
           write(LER,*)' No line header read on ',ntap(1:length)
	 else
           write(LER,*)' No line header read on stdin'
	 endif
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

c print historical line header to printout file

      call hlhprt ( itr, lbytes, name, 5, LERR)

c extract usual line header parameters

      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)

      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      obytes = nsamp * SZSMPD + SZTRHD

c verify that tvd dataset is available

      if ( tvdtap .ne. ' ' ) then

         call alloclun ( lu_tvd ) 
         length = lenth(tvdtap)
         open(unit=lu_tvd, file=tvdtap(1:length), status='old', 
     :        iostat=ierr )

         if(ierr .ne. 0) then
            write(LERR,*)' '
            write(LERR,*)'Could not open tvd file', 
     :           tvdtap(1:length)
            write(LERR,*)'Check existence'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'TVDIN: '
            write(LER,*)' Could not open tvd file', 
     :           tvdtap(1:length)
            write(LER,*)' Check spelling / existence'
            write(LER,*)'FATAL'
            stop
         endif
      else
         write(LERR,*)' '
         write(LERR,*)' You must attach an output file from tvd'
         write(LERR,*)' in order to generate a velocity/dip '
         write(LERR,*)' dataset.  Enter the appropriate entry'
         write(LERR,*)' at -v on the command line and rerun'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVDIN: '
         write(LER,*)' You must attach an output file from tvd'
         write(LER,*)' in order to generate a velocity/dip '
         write(LER,*)' dataset.  Enter the appropriate entry'
         write(LER,*)' at -v on the command line and rerun'
         write(LER,*)'FATAL'
         stop
      endif

c read through tvd dataset, determine memory requirements 
c allocate memory and load t,v,d information

      call tvd_Init ( lu_tvd, NumFcns, MaxEntries )

      size = NumFcns * MaxEntries

      call galloc ( mem_tvd_index, NumFcns * SZSMPD, errcd1, abort )
      call galloc ( mem_time, size * SZSMPD, errcd2, abort )
      call galloc ( mem_velocity, size * SZSMPD, errcd3, abort )
      call galloc ( mem_dip, size * SZSMPD, errcd4, abort )
      call galloc ( mem_NumEntries, NumFcns * SZSMPD, errcd5, abort )

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 3 * Size * SZSMPD, '  bytes'
         write(LERR,*) 2 * NumFcns * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 3 * Size * SZSMPD, '  bytes'
         write(LER,*) 2 * NumFcns * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3 * Size * SZSMPD, '  bytes'
         write(LERR,*) 2 * NumFcns * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c allocate memory for usp_record_index array

      call galloc ( mem_usp_record_index, nrec * SZSMPD, errcd6, abort )

      if ( errcd6 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) nrec * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) nrec * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) nrec * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( time, 1, size )
      call vclr ( velocity, 1, size )
      call vclr ( dip, 1, size )

      do i = 1, NumFcns
         tvd_index(i) = 0
         NumEntries(i) = 0
      enddo

      do i = 1, nrec
         usp_record_index(i) = 0
      enddo

c load t,v,d,tvd_index data

      call tvd_Load ( lu_tvd, NumFcns, NumEntries, size, time, velocity,
     :     dip, tvd_index, verbos )

c set up pointers to traceheader entries required for processing

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )
      call savelu ( c_word, ifmt_word, l_word, ln_word, TRACEHEADER )
      
c build output lineheader

      call savew ( itr, 'NumTrc', 2, LINHED )

      if ( NumFcns .gt. 1 ) then
         call savew ( itr, 'NumRec', nrec, LINHED)
      else
         call savew ( itr, 'NumRec', 1 , LINHED)
         single = .true.
      endif
      
c update the historical line header

      call savhlh ( itr, lbytes, lbyout )

c write output lineheader

      call wrtape ( luout, itr, lbyout )

c generate t,v,d, output velocity / dip file

      nbytes = 0

c if regular is flagged then sequential numbering is expected and no
c header interrogation will be attempted.  This greatly speeds up the
c output on large, sequentially numbered datasets, but implies that the
c user has arranged for the input velocity control file to also be 
c sequential [or a single function] starting from the same starting point 
c or the velocity,dip
c field will be out of sync with the data.  If regular is not flagged
c then each input trace will be investigated and a dip,vel output pair
c will be interpolated/ extrapolated from the control dataset.
      
      IF ( .not. regular ) THEN

c read through input USP dataset and glean the record numbering
c requested by the user
         
         DO JJ = 1, nrec

            call rtape( luin, itr, nbytes )

            if ( nbytes .eq. 0 .and. jj .eq. 1 ) then

               length = lenth(ntap)
               write(LERR,*)' '
               write(LERR,*)' Encountered an End of File prior to'
	       if (length .gt. 0) then
                 write(LERR,*)' the first trace of the input file', 
     :              ntap(1:length)
	       else
                 write(LERR,*)' the first trace of the input file', 
     :              ' on stdin'
	       endif
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'TVDIN: '
               write(LER,*)' Encountered an End of File prior to'
	       if (length .gt. 0) then
                 write(LER,*)' the first trace of the input file', 
     :              ntap(1:length)
	       else
                 write(LER,*)' the first trace of the input file', 
     :              ' on stdin'
	       endif
               write(LER,*)'FATAL'
               stop

            elseif ( nbytes .eq. 0 ) then

               write(LERR,*)' '
               write(LERR,*)' Unexpected End of File encountered at ' 
               write(LERR,*)' sequential record = ',jj
               write(LERR,*)'WARNING '
               write(LERR,*)' '

               nrec = jj - 1
               go to 21

            endif
            
            if (src) then

               call saver2 ( itr, ifmt_word, l_word, ln_word, 
     :              usp_record_index(jj), TRACEHEADER )

               usp_record_index(jj) = usp_record_index(jj) / 10

            else

               call saver2 ( itr, ifmt_word, l_word, ln_word, 
     :              usp_record_index(jj), TRACEHEADER)

            endif

c skip to beginning of next record after read, watch out for what 
c happens when we hit the end of input data

            if ( ntrc .gt. 1 ) 
     :           call trcskp ( JJ, ntrc+1, ntrc, luin, ntrc, itr )

         ENDDO

 21      continue

      ELSE
         
         call rtape ( luin, itr, nbytes )

         if ( nbytes .eq. 0 ) then

            length = lenth(ntap)
            write(LERR,*)' '
            write(LERR,*)' Encountered an End of File prior to'
	    if (length .gt. 0) then
              write(LERR,*)' the first trace of the input file', 
     :           ntap(1:length)
	    else
              write(LERR,*)' the first trace of the input file', 
     :           ' on stdin'
	    endif
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'TVDIN: '
            write(LER,*)' Encountered an End of File prior to'
	    if (length .gt. 0) then
              write(LER,*)' the first trace of the input file', 
     :           ntap(1:length)
	    else
              write(LER,*)' the first trace of the input file', 
     :           ' on stdin'
	    endif
            write(LER,*)'FATAL'
            stop

         endif

         if (src) then

            call saver2 ( itr, ifmt_word, l_word, ln_word, 
     :           usp_initial_index, TRACEHEADER)

            usp_initial_index = usp_initial_index / 10

         else

            call saver2 ( itr, ifmt_word, l_word, ln_word, 
     :           usp_initial_index, TRACEHEADER)

         endif
         
         DO  JJ = 1, nrec
            usp_record_index(JJ) = usp_initial_index + JJ - 1
         ENDDO
         
      ENDIF

c verbos output of usp record indexing to be used if requested

      if ( verbos ) then

         write(LERR,*)' '
         write(LERR,*)' Input USP dataset indexing used'
         write(LERR,*)' '
         write(LERR,*)' Sequential Record      Index'
         write(LERR,*)' ----------------------------'
         write(LERR,*)' '
         do i = 1, nrec
            write(LERR,*) i, usp_record_index(i)
         enddo
         write(LERR,*)' '

      endif

c make sure we do not output dead traces by mistake

      StaCor = 0
      call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :     TRACEHEADER )
      
c the idea here is to define the nmo velocity-dip two way travel
c time functions for each record of a seismic section

      IF ( single ) then

c create single velocity-dip function as we only
c have one input control function in the attached
c tvd dataset. tvdnmo will use this single function
c for the entire dataset should only one record be present
c in the vel,dip input file

         call Get_Vel_Dip_traces ( vel_trace, dip_trace, nsamp, nsi, 
     :        unitsc, usp_record_index(1), NumFcns, NumEntries, size, 
     :        time, velocity, dip, tvd_index, verbos )

         call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :        usp_record_index(1), TRACEHEADER )
         call savew2 ( itr, ifmt_word, l_word, ln_word, 
     :        usp_record_index(1), TRACEHEADER )
         call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :        1, TRACEHEADER )

c  write out velocity trace

         call vmov ( vel_trace, 1, itr(ITHWP1), 1, nsamp )
         call wrtape ( luout, itr, obytes )

c  write out dip trace

         call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :        2, TRACEHEADER )

         call vmov ( dip_trace, 1, itr(ITHWP1), 1, nsamp )
         call wrtape ( luout, itr, obytes )

      ELSE
             
c create multiple velocity-dip functions

         do i = 1, nrec

            call Get_Vel_Dip_traces ( vel_trace, dip_trace, nsamp, nsi, 
     :           unitsc, usp_record_index(i), NumFcns, NumEntries, size, 
     :           time, velocity, dip, tvd_index, verbos )

            call savew2 ( itr, ifmt_RecNum, l_RecNum,  
     :           ln_RecNum, usp_record_index(i), TRACEHEADER )
            call savew2 ( itr, ifmt_word, l_word,  
     :           ln_word, usp_record_index(i), TRACEHEADER )

c output velocity trace

            call savew2 ( itr, ifmt_TrcNum, l_TrcNum,  
     :           ln_TrcNum, 1, TRACEHEADER )
            call vmov ( vel_trace, 1, itr(ITHWP1), 1, nsamp )
            call wrtape(luout,itr,obytes)

c output dip trace

            call savew2 ( itr, ifmt_TrcNum, l_TrcNum, 
     :           ln_TrcNum, 2, TRACEHEADER )
            call vmov (dip_trace,1,itr(ITHWP1),1,nsamp)
            call wrtape(luout,itr,obytes)
               
         enddo
         
      ENDIF

c Normal Termination

      close (lu_tvd)
      call lbclos ( luout )
      call lbclos (luin)
         
      write(LERR,*)' Normal Termination'
      write(LER,*)'tvdin: Normal Termination'
      stop
      
 999  continue

c Abnormal Termination

      close (lu_tvd)
      call lbclos (luin)
      call lbclos ( luout )
      write(LERR,*)' Abnormal Termination'
      write(LER,*)'tvdin: Abnormal Termination'
      stop
      END
