C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------TVDNMO--------------------------------72
c
c Author>Paul G. A. Garossino (TRC:2F04:3192) 5/30/91
c
c tvnmo accesses both seismic amplitude and velocity sis trace files
c and either applies or removes normal moveout (with dip term) using
c the full tvd nmo map or alternately the portion before or after the 
c last velocity cross-over in the tvd nmo map.
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 
c
c ----- dimension standard USP variables -----
c

      integer itr ( SZLNHD ), ntr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec,nrecc, iform
      integer     nsampv, nsiv, ntrcv, nrecv, iformv
      integer     luin,luout,luvel
      integer     nbytes,obytes,lbytes,lbyout
      integer     nvbytes,lvbytes
      integer     irs,ire,ns,ne,jtr
      integer     vrs,vre,vst,ved
      integer     argis,pipe

      real        tri( SZSMPM ), xtr( SZSMPM )

c
c ----- dynamic memory allocation -----
c

      integer errcd1, errcd2, errcd3, abort

      real        v,d,z

      pointer     (wkadr1, v(1))
      pointer     (wkadr2, d(1))
      pointer     (wkadr3, z(1))

c
c ----- dimension program specific variables -----
c

      integer     vflag, i,kk,kv,jj,nn,luXY

      integer     ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer     ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer     ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer     ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum

      real        dscle, dt, rad, dmax, unitsc, vdot
      real        rnum(SZSMPM), work(SZSMPM)

      character   ntap * 255, otap * 255, name*6, vtap * 255

      logical     verbos
      logical     stat,remove,reverse,top,bot,XY,XY_first

c
c ----- initialize necessary variables -----
c

      data lbytes/0/
      data nbytes/0/
      data name/'TVDNMO'/
      data lvbytes/0/
      data nvbytes/0/
      data lbyout/0/
      data pipe/3/
      data vst/1/
      data ved/1/
      data rad/.0174532/
      data top /.false./
      data bot /.false./
      data XY /.false./
      data XY_first /.true./
      data verbos /.false./
      data abort /0/
c
c ----- read program parameters from command line card image file -----
c

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0.or. 
     :     argis ( '-help' ) .gt. 0) then
         call help()
         stop
      endif
 
c-----
c     open printout files

#include <f77/open.h>
 
      call cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,dscle,remove,
     1             reverse,top,bot,nn,verbos)

c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c
c ----- if nn.gt.0 open xgraph input file and write header
c

      if(nn.gt.0) then
         luXY = 4
         open(luXY,file='tvdnmo_fcn',status='unknown',err=990)
      endif

      if (vtap .ne. ' ') then
         call getln(luvel,vtap,'r',-1)
      else
         write(LERR,*)'tvdnmo assumed to be running inside IKP'
         if (reverse) then
            write(LERR,*)'velocity-dip is in a pipe and -B option'
            write(LERR,*)'(reverse) option cannot be used.  If this'
            write(LERR,*)'option must be used -v[] with a disk file'
            go to 999
         endif
         call sisfdfit (luvel, pipe)
      endif
      if  (luvel .lt. 0)   then
         write(LERR,*)'velocity-dip file -v not accessible'
         stop
      endif

c-----
c     read line header of input
c     save certain parameters

      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'TVDNMO: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c build pointers to header entries

      call savelu ( 'DstSgn', ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     TRACEHEADER )
      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )

      call hlhprt (itr, lbytes, name, 6, LERR)

c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c
c ----- malloc only space we're going to use -----
c
      item1 = nsamp

      call galloc (wkadr1, item1*SZSMPD, errcd1, abort)
      call galloc (wkadr2, item1*SZSMPD, errcd2, abort)
      call galloc (wkadr3, item1*SZSMPD, errcd3, abort)

      if ( errcd1 .ne. 0. .or.
     :     errcd2 .ne. 0. .or.
     :     errcd3 .ne. 0. ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 3 * item1* SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 3 * item1* SZSMPD,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3 * item1* SZSMPD,'  bytes'
         write(LERR,*)' '
      endif


c
c ----- modify line header to reflect actual number of traces output -----
c

      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)

c
c ----- number output bytes -----
c

      obytes = SZTRHD + nsamp * SZSMPD

      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

#include <f77/saveh.h>

c
c ----- velocity data -----
c

      vflag=1
      lvbytes=0

      call rtape(luvel,ntr,lvbytes)

      if(lvbytes .eq. 0) then
         write(LERR,*)'TVDNMO: no header read on velocity unit ',luvel
         write(LERR,*)'FATAL'
         stop
      endif

      call saver(ntr, 'NumSmp', nsampv, LINHED)
      call saver(ntr, 'SmpInt', nsiv  , LINHED)
      call saver(ntr, 'NumTrc', ntrcv , LINHED)
      call saver(ntr, 'NumRec', nrecv , LINHED)
      call saver(ntr, 'Format', iformv, LINHED)

      if(mod(ntrcv,2) .ne. 0) then
         write(LERR,*)'Number velocity traces/rec must be even'
         write(LERR,*)'the traces must be laid out in pairs of'
         write(LERR,*)'velocity-dip'
         write(LERR,*)'Check tvdin run'
         stop
      endif

      ntrcv = ntrcv/2

c--------------------------------------
c   vflag=0 single velocity function
c   vflag=1 multiple velocity function

      if(nrecv .le. 1) vflag=0

c--------------------------------------

      if(nsampv .lt. nsamp) then
         write(LERR,*)'velocity trace(s) too short; contains ',nsampv,
     &        'samples'
         write(LERR,*)'input data contains ',nsamp,' samples'
         write(LERR,*)'Rerun tvdin job so that trace at least ',
     &        nsi*nsamp,' ms long'
         stop
      endif
 
      call cmdchk(vst,ved,vrs,vre,ntrcv,nrecv)


c ----
c     verbose output of all pertinent information before
c     processing begins
c ----

      if( verbos ) then
         call verbal(nsamp,nsi,ntrc,nrec,nrecv,iform,nsampv,nsiv,
     1        ntrcv,iformv,reverse,vflag,stat,remove,top,bot,
     2        vtap,ntap,otap)
      endif

c
c ----- handle velocity data -----
c

      nvbytes=1

c
c ----- multiple velocity functions -----
c

      if(vflag .eq. 1) then
         if(vrs .le. nrecv) then
            call skprec(1,vrs-1,luvel,2*ntrcv,ntr,lvbytes,nsampv,iformv)
         else
            write(LERR,*)' start record to skip to exceeds number'
            write(LERR,*)' records on velocity file'
            write(LERR,*)' check tvdin run to make sure your velocity'
            write(LERR,*)' model covers the part of the data between'
            write(LERR,*)' records ',vrs,' and ', vre
            stop
         endif

c
c ----- single velocity function :read now and scale dips if necessary -----
c

      elseif(vflag .eq. 0) then
         nvbytes=0
         call rtape(luvel,ntr,nvbytes)
         call vmov(ntr(ITHWP1),1,v,1,nsampv)
         if(verbos) then
            write(LERR,*)'velocity'
            write(LERR,777)(v(i),i=1,nsampv)
         endif
         call rtape(luvel,ntr,nvbytes)
         call vmov(ntr(ITHWP1),1,xtr,1,nsampv)
         call vsmul (xtr,1,dscle,d,1,nsampv)

c
c ----- check for valid velocities -----
c

         call dotpr (v,1,v,1,vdot,nsampv)
         if (abs(vdot) .lt. 1.e-06) then
            write(LERR,*)'Velocity trace contains zeros'
            write(LERR,*)'---    FATAL  ---'
            write(LERR,*)'Check the tvdin step thoroughly'
            go to 999
         endif

c
c ----- check for valid dips -----
c

         call maxmgv (d,1,dmax,indx,nsampv)
         if (dmax .gt. 90.) then
            write(LERR,*)'dips GT 90 deg encountered'
            write(LERR,*)'---    FATAL  ---'
            write(LERR,*)'Check the tvdin step thoroughly'
            go to 999
         endif

c
c ----- precompute some stuff to cut down on statement size for tnmo -----
c       in the bdsub subroutine, also to do this once per record is
c       better that once per trace if done within the subroutine
c


         do i = 1,nsampv
            d(i) = 2. * sin( rad*d(i) )
         enddo

         if(verbos) then
            write(LERR,*)'dips'
            write(LERR,777)(d(i),i=1,nsampv)
 777        format(10f8.2)
         endif

         if(nvbytes .eq. 0) then
            write(LERR,*)'End of file on velocity file: FATAL'
            write(LER,*)'TVDNMO: End of file on velocity file'
            write(LER,*)'FATAL'
            stop
         endif
      endif

c
c ----- read trace -----
c
c   when reading velocity traces make sure that if we run out of vel. traces
c   we use the last vel trace to the end of the line...
c     if necessary, scale dips
c
      kv = 0
      nvbytes=1

c  compute sample interval in secs

      dt = real (nsi) * unitsc

c
c ----- generate random number array for spline routine -----
c       required when leading zeroes on trace data cause
c       ieee underflow errors in spline.
c
      call vrand(911,rnum,1,nsamp)

      do i=1,nsamp
         rnum(i) = rnum(i) * 1.0e-21
      enddo

c
c ----- BEGIN PROCESSING -----
c     skip unwanted records
c

      call recskp(1,irs-1,luin,ntrc,itr)

      DO JJ = irs, ire

         if(vflag.eq.1 .and. nvbytes.ne.0 .and. JJ.le.vre) then

            nvbytes=0

c
c ----- read in reverse order ?
c
            if (reverse) then
               kv = kv + 1
               call skipt (luvel, ntrcv*(vre-kv), idummy)
            endif

c
c ----- read velocity, dip data -----
c

            call rtape(luvel,ntr,nvbytes)
            call vmov (ntr(ITHWP1),1,v,1,nsampv)
              
c
c ----- check for valid data -----
c

            call dotpr (v,1,v,1,vdot,nsampv)
            if (abs(vdot) .lt. 1.e-06) then
               write(LERR,*)'Velocity trace contains zeros'
               write(LERR,*)'---    FATAL  ---'
               write(LERR,*)'Check the tvdin step thoroughly'
               go to 999
            endif

            if(verbos) then
               write(LERR,*)'rec ',JJ,' velocity'
               write(LERR,777)(v(i),i=1,nsampv)
            endif
            
            call rtape(luvel,ntr,nvbytes)
            call vmov (ntr(ITHWP1), 1, xtr, 1, nsampv)
            call vsmul (xtr,1,dscle,d,1,nsampv)
            call maxmgv (d,1,dmax,indx,nsampv)
            
            if(verbos) then
               write(LERR,*)'rec ',JJ,' dips'
               write(LERR,777)(d(i),i=1,nsampv)
            endif

            if ((dmax-90.) .gt. 1.e-4) then
               write(LERR,*)'dips GT 90 deg encountered'
               write(LERR,*)' dmax = ',dmax,' at sample ',indx
               write(LERR,*)'---    FATAL  ---'
               write(LERR,*)'Check the tvdin step thoroughly'
               go to 999
            endif

c
c ----- scale dips to radians and prep for tnmo calculation -----
c       by mult by 2

            do i = 1, nsampv
               d(i) = 2. * sin( rad*d(i) )
            enddo

         endif


c
c ----- skip to start trace -----
c

         call trcskp(JJ,1,ns-1,luin,ntrc,itr)
 
         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',kk
               go to 999
            endif
            call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
            
            call saver2 ( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )
            dist = iabs(DstSgn)
            call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )
            call saver2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )
            call saver2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )
            
            call vclr( work, 1, nsamp )
            
c     
c     ----- if live do vel/dip nmo on trace -----
c     
            
            IF ( StaCor .ne. 30000 ) THEN
               
               StaCor=StaCor/nsi
               if(.not.stat) StaCor=1
               if(StaCor .eq. 0) StaCor=1
               if(StaCor .lt. 0) then
                  StaCor=-StaCor
                  call vmov(tri(StaCor),1,work(1),1,nsamp)
               else
                  call vmov(tri(1),1,work(StaCor),1,nsamp)
               endif
               
c
c ----- set XY flag to true if trace is nn -------
c

               if(kk.eq.nn)then
                  if(XY_first)then
                     XY_first = .false. 
                  else
                     write(luXY,8787)
 8787                format()
                     XY_first = .false.
                  endif
                  write(luXY,*)'"trace ',nn,' record ',JJ
                  XY = .true.
               endif
               
               call bdsub ( work, dt, nsamp, dist, v, d, remove, z, top,
     :              bot, rnum, XY, luXY  )
               
               call vmov(z(1),1,itr(ITHWP1),1,nsamp)
               
            ENDIF

            call wrtape (luout,itr, obytes)
            
         ENDDO
 
c
c ----- skip to end of record -----
c

         call trcskp(JJ,ne+1,ntrc,luin,ntrc,itr)
 
      ENDDO

c Normal Completion

      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )

      write(LERR,*)' Normal Completion'
      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)' tvdnmo: Normal Completion'
      stop

c
c ----- unable to open xgraph data output file -----
c

 990  write(LERR,*)' Unable to open tvdnmo_fcn xgraph output file'
      stop

c Abnormal Completion

 999  continue
      
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )

      write(LERR,*)' Abnormal Completion'
      write(LER,*)' tvdnmo: Abnormal Completion'
      stop
      end

C***********************************************************************
C                       SUBROUTINES
C***********************************************************************

      subroutine help

#include <f77/iounit.h>
         write(LER,*)
     :'----------------------------------------------------------------'
        write(LER,*) ' '
        write(LER,*)
     :'tvdnmo performs normal moveout correction utilizing quadratic '
        write(LER,*)
     :'interpolation, reverse floating point sample, amplitude mapping'
        write(LER,*)
     :'and user controlled nmo map choice.  See manual pages for '
        write(LER,*)
     :'details (online by typing uman tvdnmo or use xman browser)'
        write(LER,*)' '
        write(LER,*)
     :'Execute tvdnmo by typing tvdnmo and the program parameters.'
        write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'Enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)     : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)     : output data file name'
        write(LER,*)
     :' -v [vtap]    (no default)     : input velocity/dip file name'
        write(LER,*)
     :' -rs[irs]     (default = first): start record number'
        write(LER,*)
     :' -re[ire]     (default = last) : end record number'
        write(LER,*)
     :' -ns[ns]      (default = first): start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last) : end trace number'
        write(LER,*)
     :' -sv[vrs]     (default = first): start vel record number'
        write(LER,*)
     :' -ev[vre]     (default = last) : last vel record number'
        write(LER,*)
     :' -d[dscle]    (default = 1)    : dip angle multiplier'
        write(LER,*)
     :' -T                            : use top of tvd nmo map'
        write(LER,*)
     :' -E           (the default)    : use bottom of tvd nmo map'
        write(LER,*)' '
        write(LER,*)
     :' -S                            : apply trace header statics'
        write(LER,*)
     :' -R                            : remove tvd nmo'
      write(LER,*)
     :' -B                            :read vel/dips in reverse order'
      write(LER,*)
     :' -XY[nn]                       :output xgraph data for trace nn'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'Usage: tvdnmo -N[ntap] -O[otap] -v[vtap] -ns[] -ne[] -rs[] -re[]'
         write(LER,*)
     :'             -sv[] -ve[] -d[] -S -R -B -T -E -XY[] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end

c
c ----- ----- -----
c

      subroutine cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,dscle,
     1                 remove,reverse,top,bot,nn,verbos)

c     get command arguments
c
c     ntap  - C*255  input file name
c     otap  - C*255  output file name
c     vtap  - C*255  velocity file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c   dscle   - R      dip scale factor
c    stat   - L      normalize stacked trace by # live traces
c  remove   - L      remove normal moveout
c  reverse  - L      read velocity/dips in reverse order
c     top   - L      use top nmo map
c     bot   - L      use bot nmo map
c      nn   - I      output xgraph data for trace nn
c    verbos - L      verbose output or not

      real        dscle
      integer     ns,ne,irs,ire,vrs,vre,argis,nn
      character   ntap*(*),otap*(*),vtap*(*)
      logical     stat,remove,reverse,verbos,top,bot
      
      call argstr ('-N', ntap, ' ', ' ' )

      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-v',vtap, ' ', ' ')

      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argi4  ('-sv',vrs,1,1)
      call argi4  ('-ev',vre,0,0)
      call argr4  ('-d',dscle,1.,1.)
      top = ( argis ('-T') .gt. 0 )
      bot    = ( argis ('-E') .gt. 0 )
      stat = ( argis ('-S') .gt. 0 )
      remove = ( argis ('-R') .gt. 0 )
      reverse = ( argis ('-B') .gt. 0 )
      call argi4  ('-XY',nn,0,0)

      verbos = ( argis ('-V') .gt. 0 )
c
c ----- if remove then use bot as default -----
c

      if(remove)then
        if(.not.top.and..not.bot) bot = .true. 
      endif

      return
      end

c
c ----- ----- -----
c

      subroutine verbal(nsamp,nsi,ntrc,nrec,nrecv,iform,nsampv,nsiv,
     1                  ntrcv,iformv,reverse,vflag,stat,remove,top,bot,
     2                  vtap,ntap,otap)


c     verbose output of processing parameters
c
c     nsamp   - I*4     number of samples in trace
c     nsampv  - I*4     number of samples in vel/dip trace
c     nsi     - I*4     sample interval in ms
c     nsiv    - I*4     vel/dip sample interval in ms
c     ntrc    - I*4     traces per record
c     ntrcv   - I*4     traces per record vel/dip 
c     nrec    - I*4     number of records per line
c     nrecv   - I*4     number of dip/vel records per line
c     iform   - I*4     format of data
c     iformv  - I*4     format of vel/dip data
c     reverse - Logical	reverse velocity order in file
c     vflag   - I*4     single/multiple vel/dip function flag
c     stat    - Logical trace header statics application flag
c     remove  - Logical apply/remove nmo flag
c     top     - Logical use nmo map from sample 1 to last cross-over
c     bot     - Logical use nmo map from last cross-over to end
c     vtap    - C*255   input vel/dip file name
c     ntap    - C*255   input file name
c     otap    - C*255   output file name

#include <f77/iounit.h>

      integer     nsamp,nsampv,nsi,nsiv,ntrc,ntrcv,nrec,nrecv
      integer     iform,iformv,vflag
      logical     reverse,stat,remove,top,bot
      character   ntap*(*), otap*(*), vtap*(*)
 
            write(LERR,*)' '
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' input vel/dip data set name =  ', vtap
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*)' '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*)' '
            write(LERR,*)' vel/dip header values after default check '
            write(LERR,*)' '
            write(LERR,*) ' # of samples/trace =  ', nsampv
            write(LERR,*) ' sample interval    =  ', nsiv
            write(LERR,*) ' traces per record  =  ', ntrcv
            write(LERR,*) ' records per line   =  ', nrecv
            write(LERR,*) ' format of data     =  ', iformv
            write(LERR,*)' '

      if (vflag.eq.1) then
            write(LERR,*) 'expecting multiple vel/dip functions '
      else
            write(LERR,*) 'expecting single vel/dip function '
      endif

      if ( reverse ) then
            write(LERR,*) 'vel/dip functions in reverse order '
      endif

      if ( stat ) then
            write(LERR,*) 'apply trace header statics '
      endif

      if ( remove ) then
            write(LERR,*) 'remove normal moveout'
      else
            write(LERR,*) 'apply normal moveout'
      endif

      if ( top.or.bot ) then

         if ( top ) then
            write(LERR,*) 'using nmo map from top to cross-over'
         else
            write(LERR,*) 'using nmo map from cross-over to bottom'
         endif

      else

            write(LERR,*) 'using entire nmo map'

      endif

      if ( reverse ) then
            write(LERR,*) 'vel/dip functions in reverse order '
      endif

            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
