C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bdsub ( y, dt, nsamp, x, v, dip, remove, z, top, bot, 
     :     rnum, XY, luXY )
c Author>Paul G. A. Garossino (TRC:2F04:3192) 5/30/91

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c ----7--0---5--------------------------------------------------------72
c       Arguments 
c
c      y = data trace
c      v = velocity trace (velocity vs sample)
c     dt = sample interval
c  nsamp = number samples/trace
c      x = distance
c    dip = dip trace (dip vs sample)
c remove = if true to 'unmormal movelout'
c      z = working array
c    top = use top nmo map
c    bot = use bot nmo map
c   rnum = random number array used to fill out zero data
c     XY = flag for xgraph output
c   luXY = logical unit for output of tvdnmo_fcn data
c
c----------------------------------------------------------------

      integer nsamp,cros_ndx,icount,j
      integer inewcnt,k,luXY
      real y(*), v(*), dip(*), z(*), rnum(*)
      real workx(SZSMPM),worky(SZSMPM),t(SZSMPM)
      real y2(SZSMPM),ypn,yp1,yj
      real x,dt,xvi,xt,tnmo
      real dj,rj
      logical remove,top,bot,XY 

c declare local variables

      integer islpsw, ierr

      real temp(2*SZLNHD), sigma, curv2

      external function curv2

c----------------------------------------------------------------
c      Additional Variables
c
c    cros_ndx = sample value at velocity cross-over
c    icount   = active sample counter
c    inewcnt  = new active sample counter
c    j,k      = index variables
c    workx    = working array of times (tnmo or 1...nsamp)
c    worky    = working array of tnmo or amp (forward or back)
c    t        = array of floating point samples
c    y2       = array of second derivatives
c    ypn      = second derivative at nsamp
c    yp1      = second derivative at 1st sample
c    yj       = interpolated value from splint subroutine
c    dj       = fractional  portion of tnmo
c    rj       = floating point index used as arg to splint
c    rad      = degree to radian conversion factor
c    xt       = distance/sample interval
c    xvi      = xt/velocity
c    tnmo     = floating point sample required for nmo
c    temp1    = working variable for sort algorithm
c    temp2    = working variable for sort algorithm
c
c----------------------------------------------------------------

c
c ----- initialization of variables ----- 
c

      sigma = 0.0
      islpsw = 3

      do  10 i=1,nsamp

        z(i) = 0.
        workx(i) = 0.
        worky(i) = 0.
        t(i) = float(i)

c
c ----- the spline routine hates consecutive zeros in the trace data -----
c       this logic replaces zeros with very small random numbers so 
c       that ieee errors of underflow are not encountered in spline

        if(y(i).lt.1.e-30)then
            y(i)=y(i)+rnum(i)
        endif

c ----- ----- -----

10    continue


c ----- use natural cubic spline -----

      yp1 = 1.e+31
      ypn = 1.e+31

c
c ----- reduce x by delta t which causes time to be calculated when loops
c       incremented by samples
c

      xt = x/dt
c
c ----- reset the tnmo function element counter -----
c

      icount = 0

c
c ----- reset the cross-over index to zero -----
c

      cros_ndx = 0

c
c ----- body of trace -----
c
      do 1000 i = 1,nsamp

            xvi = xt/( v(i) )
            
c
c ----- note -----
c       the dip(i) variable = 2.*sin(rad*d(i)) from input.  This was done
c       in the main routine to save on processing steps.  If done here
c       it would have to be done every trace instead  of every record
c

            tnmo =  sqrt (abs((i-1)**2 + xvi**2 + (i-1)*xvi*dip(i)))+1
            j = tnmo
            dj = tnmo - j
c
c ----- check for bounds -----
c
          if (j .ge. 1 .and. j .le. (nsamp-1)) then

           if (remove) then 

c
c ----- reverse nmo map -----
c

               workx(i) = tnmo
               worky(i) = y(i)
c
c ----- keep track of number of entries in tnmo table -----
c       This will prevent zeros at the start of the function
c       which kills the spline interpolator
c
               icount = icount + 1
c
c ----- output i,tnmo data for qc -----
c       remove for production version
c
               if(XY)then
                 write(luXY,6666)float(i),workx(i)
               endif

           else

c
c ----- forward nmo map -----
c

               workx(i) = float(i) 
               worky(i) = tnmo
               icount = icount + 1
c
c ----- output i,tnmo data for qc -----
c       remove for production version
c
           if(XY) then
                write(luXY,6666)workx(i),worky(i)
 6666            format(f10.4,1x,f10.4)
           endif

           endif
          endif
 1000    continue

c
c ----- split function option -----
c

c ----- examine tnmo from end to start looking for cross-over point -----
c       tag that point and accept the function from below the cross-
c       over point only.
c

      do 2000 j=icount,2,-1
 
        if(remove) then

         if(cros_ndx.eq.0) then

           if(workx(j).lt.workx(j-1))then
              cros_ndx = j
              goto 2500
           endif

         endif

        endif

        if(.not.remove) then

         if(cros_ndx.eq.0) then

           if(worky(j).lt.worky(j-1))then
              cros_ndx = j
              goto 2500
           endif

         endif

        endif

2000  continue

2500  if(remove.and.bot.and.cros_ndx.ne.0) icount = icount - cros_ndx +1   
     
c
c ----- if no cross-over then no top so output zero trace -----
c

      if(top) then
         XY = .false.
         if(cros_ndx.lt.1)return
         icount = cros_ndx
      endif

c
c ----- if forward and bot and no cross-over then set cros_ndx to 1 ----
c       This stops workx(cros_ndx)from being workx(0) which is bad
c

      if(.not.remove.and.bot.and.cros_ndx.lt.1)cros_ndx=1


c
c ----- if bot then move data from below cross-over to top of array -----
c       else just continue with new icount from above
c

      if(remove.and.bot) then

       do 3000 j=1,icount

          if(cros_ndx.gt.0) then

             workx(j) = workx(cros_ndx + j - 1)
             worky(j) = worky(cros_ndx + j - 1)
c
c ----- if 2 consecutive sample indices are equal the second derivative  -----
c       calculation packs it in with a zero divide.. the following code
c       covers for the shitty interpolator.  Note only near the 
c       cross-over do values attempt this miraculous feat
c
            if(j.gt.1)then
             if(abs(workx(j)-workx(j-1)).lt.1.e-3) then

                workx(j)=workx(j)+1.e-3

             endif
            endif

          endif

3000   continue

      endif

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c      REMOVE OPTION
c
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      IF(remove) then
c
c ----- interpolate new output trace -----
c
      if(.not.bot) then
c
c ----- sort tnmo,amplitude arrays -----
c

        call hsort2(icount,workx,worky)
 
c
c ----- reset duplicate entry counter ----
c
        inewcnt = 0
c
c ----- reset icount if duplicate entries found and removed -----
c

3500    icount = icount - inewcnt
        inewcnt = 0

        do 4000 k=2,icount

c
c ----- check for duplicate entry and delete if present -----
c       then advance duplicate entry counter
c
           if(abs(workx(k)-workx(k-1)).lt.1.e-20) then
              workx(k) = workx(icount)
              worky(k) = worky(icount)
              inewcnt = 1
              goto 3500
           endif

4000    continue

      endif
c
c ----- create array of second derivatives (y2) -----
c

c      call spline(workx,worky,icount,yp1,ypn,y2)

      call curv1 (icount, workx, worky, yp1, ypn, islpsw, y2, temp, 
     :     sigma, ierr)

c
c ----- form output trace -----
c
      do 5000 j=1,nsamp

         rj=float(j)

         if(bot) then
          if((rj.lt.workx(2)).or.(rj.gt.workx(icount)))then
c
c ----- if j outside the range of data in transfer function  -----
c       set amplitude to zero, if it didn't go forward it can't
c       come back.
c

           z(j) = 0.

          else
c
c ----- interpolate amplitude at j from tnmo,input amplitude data
c
c           call splint(workx,worky,y2,icount,rj,yj) 

             yj = curv2(rj,icount,workx,worky,y2,sigma)

           z(j) = yj

          endif
         endif

         if(.not.bot) then

          if((rj.lt.workx(2)).or.(rj.gt.workx(icount)))then

c
c ----- if j outside the range of data in transfer function  -----
c       set amplitude to zero, if it didn't go forward it can't
c       come back.
c

             z(j) = 0.

          else
c
c ----- interpolate amplitude at j from tnmo,input amplitude data
c
c             call splint(workx,worky,y2,icount,rj,yj)

             yj = curv2(rj,icount,workx,worky,y2,sigma)
             z(j) = yj

          endif
         endif


5000    continue  
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c     FORWARD NMO
c
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      ELSE

c        call spline(t,y,nsamp,yp1,ypn,y2)
        call curv1 (nsamp, t, y, yp1, ypn, islpsw, y2, temp, 
     :       sigma, ierr)


        do 6000 j=1,nsamp 

         if(top) then
          if((j.lt.ifix(workx(1))).or.(j.gt.ifix(workx(cros_ndx))))
     *goto 6000 
         endif

         if(bot) then
          if((j.lt.ifix(workx(cros_ndx))).or.(j.gt.ifix(workx(icount))))
     *goto 6000
         endif

         if(.not.top.and..not.bot) then 
          if((j.lt.ifix(workx(1))).or.(j.gt.ifix(workx(icount))))
     *goto 6000
         endif

c           call splint(t,y,y2,nsamp,worky(j),yj)
           yj = curv2(worky(j),icount,t,y,y2,sigma)

           z(j) = yj
 
6000    continue

      ENDIF
c
c ----- provide plot parameters for xgraph -----
c       of output trace
c       remove for production version
c
c     write(LERR,*)' output trace'
c     do 10000 j=1,nsamp
c      write(LERR,6664)float(j),z(j)
c6664   format(f10.4,1x,f10.4)
c10000 continue
c---------------------------------------------------------------------
c
c nmo routine completed, return to calling routine
c
      XY = .false.
      return
      end

