C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      	subroutine born0(trace, dmo, vmap, nt, dt, nv, idv,
     1			  xmin, nx, dx, xs, offset, xg, maxdip,
     2			  aliasflag, ampflag, sprdflag, sincs,
     3			  mt, mx, ist, iend)

*****************************************************************
*
* BORN0 - This sub sprays a single trace into its impulse responses 
*	  in the zero-offset stack data panel. 
*
* Parameters:
*    TRACE()	- input data trace ( pre-processed ) 
*    DMO(,)	- DMO'd zero offset data panel ( outdata )
*    VMAP(,)	- RMS velocity map
*    NT		- number of time samples
*    DT		- time sample rate
*    XMIN	- minimum midpoint coordinate in outdata
*    NX		- number of traces ( midpoints ) in outdata
*    DX		- midpoint spacing in outdata
*    XS		- source coordinate for this trace
*    OFFSET	- full offset for this trace
*    XG		- receiver coordinate for this trace
*    MAXDIP	- maximum anticipated reflector dip
*    ALIASFLAG	- flag to allow aliasing
*			0 = no aliasing allowed
*			1 = process all dips, even aliased ones
*    AMPFLAG	- flag to choose amplitude term
*			0 = Born DMO common amp term
*			1 = Born DMO common offset amp term
*			2 = Kinematic DMO common offset amp term
*			    ( plus spreading corrections )
*    SPRDFLAG	- flag to remove zero-offset spreading
*			0 = output includes zero-offset spreading
*			1 = output has had zero-offset spreading removed
*    SINCS()	- sinc interpolation weights
*    MT		- global dimension: max time samples
*    MX		- global dimension: max output traces
*
****************************************************************

*	implicit none
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      	integer aliasflag,	ampflag,	mt,	mx
	integer	nt,	nx,	sprdflag

	real 	dt,	dx,	maxdip,	offset, dmo(mt,mx)
	real	sincs(41),	trace(nt),	vmap(nv,mx)
	real	xmin,	xs,	xg

**
* Local integer variables:
*    IMID	- index of midpoint coord 'mid'
*    IT		- input time sample counter 
*    IX		- local trace index 
*    IXMIN	- index of midpoint coord 'xmin'
*    IXOUT	- output trace index
*    IXV	- vmap trace index 
*    MAXX	- max output trace for spreading 
*    MINX	- min output trace for spreading
*
* Local real variables:
*    ALIAS	-   max allowed operator slope ( in time samples per trace )
*    AMP	-   operator amplitude
*    BG		-   xg - x0 ... distance from receiver to output point
*    BGA	-   abs( bg )
*    BG2	-   bg * bg
*    BS		-   xs - x0 ... distance from source to output point
*    BSA	-   abs( bs )
*    BSBG	-   bs * bg
*    BS2	-   bs * bs
*    MID 	-   midpoint of input trace
*    OFFA 	-   abs( offset )
*    OFF2 	-   offa * offa
*    ONE 	-   1.0
*    PI 	-   pi
*    Q  	-   simplifying term
*    RG		-   vector length from receiver to reflection point
*    RG2	-   rg * rg
*    RS		-   vector length from source to reflection point
*    RSPRG	-   rs + rg
*    RSRG	-   rs * rg
*    RS2	-   rs * rs
*    R0		-   vector length from x0 to reflection point
*    R02	-   r0 * r0
*    SCALE	-   constant scale factor
*    SINTH	-   sin( maxdip )
*    T		-   time on input data ( raw reflection time )
*    TMP	-   temporary variable
*    TSLOPE	-   local slope of operator limb for aliasing treatment
*    TWO	-   2.0
*    TWOPI	-   2.0 * pi
*    T0		-   time on output data ( zero-offset time )
*    T2		-   t * t
*    V		-   velocity ( constant )
*    V2		-   v * v
*    X0		-   midpoint coordinate on output data
*    ZERO	-   0.0
*
**

      	integer imid,	it,	ix,	ixmin,	ixout
      	integer ixv,	maxx,	minx

	real	alias,	amp,	bg,	 bga,	bg2,	bs,	bsa
	real 	bsbg,	bs2,	mid,	offa,	off2,	one,	pi
	real 	q,	rg,	rg2,	rs,	rsprg,	rsrg,	rs2
	real	r0,	r02,	scale,	sinth,	t,	tmp,	tslope
	real	two,	twopi,	t0,	t2,	v,	v2,	x0
	real	zero

        real    velt (SZLNHD)

      	common /const/ zero,	one,	two,	pi,	twopi

c	... 
	scale = one / ( 4.0 * sqrt( twopi ) )

	sinth = sin( maxdip * pi / 180.0 ) 
	alias = dt / dx 

c 	.. calc some indices 
	mid = ( xs + xg ) / 2.0
	imid = mid/dx + 1 
	ixmin = xmin/dx + 1
	off2 = offset * offset 
	offa = abs( offset )

c .. single trace (t,x)-domain algorithm for Born Theory DMO 
	
 
c	.. Loop over input times (raw reflection time) 
        iv = 0
      	do 22 it = 1, nt
	    t  = ( it - 1 ) * dt
	    t2 = t * t

c   	    .. if this sample is zero, there is nothing to spread
c	    .. (a tolerance criteria could be inserted here)
	    if ( trace(it) .eq. 0.0 ) goto 22

c   	    .. only output traces between source and receiver
c	    .. can possibly be involved
c	    .. (and use adhoc 80% max aperture rule)
	    minx = ( mid - .4 * offa ) / dx + one 
	    maxx = ( mid + .4 * offa ) / dx + one	

c   	    .. don't spread IR past edges of outdata
	    if ( minx. lt. ixmin )  minx = ixmin + 1
	    if ( maxx .gt. nx )     maxx = ixmin + nx

            if     (it .eq. 1) then
                    iv  = 1
                    iv1 = 1
                    iv2 = 2
                    d2  = idv
                    d1  = 0.
                    dtt = idv
            elseif (it .gt. 1 .AND. mod(it,idv) .eq. 0) then
                    iv1 = iv
                    iv  = iv + 1
                    iv2 = iv
                    it1 = iv1 * idv
                    if (iv1 .eq. 1) it1 = 1
                    it2 = iv2 * idv
                    dvv = idv
                    dtt = it2 - it1
                    d1  = it - it1
                    d2  = it2 - it
            endif
            do  ix = minx, maxx
                    k = ix - ixmin
                    if (k .ge. 1 .OR. k .le. nx )
     1              velt (k) = (d2 * vmap(iv1,k) + d1 * vmap(iv2,k))/dtt
            enddo

c	    .. Loop over output traces between source and receiver
c	    .. (x0 is the MIDPOINT on the zero offset data)
	    do 23 ix = minx, maxx

		x0 = ( ix - 1 ) * dx

c	    	... find vmap index for this trace
	    	ixv = ix - ixmin
 	if ( ixv .lt. 1 .or. ixv .gt. nx ) goto 23

c	    	... get processing velocity for this sample 
	    	v  = velt(ixv)
	    	v2 = v*v

c	    	.. set up beta terms
		bs   = xs - x0 
		bs2  = bs * bs
		bg   = xg - x0
		bg2  = bg * bg
		bsbg = bs * bg
		bsa  = abs ( bs )
		bga  = abs ( bg )

		if ( bsbg .eq. 0.0 .OR. off2 .eq. 0.0 ) goto 23

		q = one - t2*v2 / off2
 
c		.. find t0: impulse response time-intercept 
c		.. on this output trace
		tmp = bsbg * q
		if ( tmp .le. 0.0 ) goto 23
		t0  = 2.0 * sqrt( tmp ) / v

c		.. local time-slope of operator limb
		tmp = sqrt( q / bsbg )
		tmp = tmp * ( bs + bg ) / v
		tslope = abs ( tmp )

c		.. operator truncation
c		.. 
c		.. 1. to avoid spatial aliasing
		if ( aliasflag .eq. 0 .and. tslope .gt. alias ) then
                    goto 23
                endif

c		.. 2. based on max reflector dip
		if ( tslope .gt. 2.0*sinth/v ) goto 23

c		.. set up the 'r's
		r0    = v  * t0 / 2.0
		r02   = r0  * r0
		tmp   = one - r02 / bsbg
		if ( tmp .le. 0.0 ) goto 23
		tmp   = sqrt(tmp)
		rs    = bsa * tmp
		rs2   = rs  * rs
		rg    = bga * tmp
		rg2   = rg  * rg
		rsprg = rs  + rg
		rsrg  = rs  * rg

c		.. choice of amplitude terms 
c		.. 
c		.. inversion theory common shot amplitude term
		if ( ampflag .eq. 0 ) then
		  tmp = r0 * offa * sqrt( offa )
		  tmp = tmp / ( bg2 * sqrt( v*rs*bga ) )
c		  .. mult by 2 since integration variable
c		  .. is xg and dxg = df ( full offset, not midpoint)
		  tmp = 2.0 * tmp

c		.. inversion theory common offset amplitude term
		else if ( ampflag .eq. 1 ) then
		  tmp = r0 * offa * ( rs2 + rg2 )
		  tmp = tmp / ( rg2 * bs2 )
		  tmp = tmp * sqrt( offa / ( v*rg*bsa ) )

c		.. Berg's Kinematic DMO amplitude term
		else if ( ampflag .eq. 2 ) then
		  tmp = 4.0 * ( mid - x0 ) * ( mid - x0 ) / off2
		  tmp = offa * ( one - tmp ) / 2.0
		  tmp = sqrt( t0 ) / ( twopi * tmp )
c		  .. GS + IGS corrections
		  tmp = ( rs + rg ) * tmp / ( 2 * r0 )
c		  .. common shot form and compensate for scale
		  tmp = 2.0 * tmp / scale

		end if

c		.. option to remove zero offset geometric spreading
		if ( sprdflag .eq. 1 ) then
		  tmp = tmp * 8.0 * pi * r0
		end if

c		.. final amplitude term
		amp = scale * tmp 

c		.. total numerical value for spreading
     		amp = trace(it) * amp * dx

c		... find output midpoint index for this trace
		ixout = ix - ixmin + 1

c		... use eight-point sinc iterpolation to
c		... add this value to the output data 
		call sincit( dmo(1,ixout), amp, t0, ist, iend,
     :				    dt, mt, nt, sincs )

 23          continue

 22	continue

	return
	end

*===========================================================
      	subroutine born1(trace, dmo, vmap, mt, dt, lbyoff, lhed,
     1			  xmin, nx, dx, xs, offset, xg, maxdip,
     2			  aliasflag, ampflag, sprdflag, sincs,
     3			  nt, mx, luout, spread, ngrp, obytes,dxg,
     4                    ifmt_RecNum,l_RecNum,ln_RecNum,
     5                    ifmt_DphInd,l_DphInd,ln_DphInd,vmax,
     6                    ifmt_TrcNum,l_TrcNum,ln_TrcNum,lmin,
     7                    ifmt_StaCor,l_StaCor, ln_StaCor,
     8                    ixmax,first,ist,iend,nv,idv)

*****************************************************************
*
* BORN1 - This sub sprays a single trace into its impulse responses 
*	  in the cdp bins arranged in the order of the spread model
*
* Parameters:
*    TRACE()	- input data trace ( pre-processed ) 
*    DMO(,)	- DMO'd zero offset data panel ( outdata )
*    VMAP(,)	- RMS velocity map
*    NT		- number of time samples
*    DT		- time sample rate
*    XMIN	- minimum midpoint coordinate in outdata
*    NX		- number of traces ( midpoints ) in outdata
*    DX		- midpoint spacing in outdata
*    XS		- source coordinate for this trace
*    OFFSET	- full offset for this trace
*    XG		- receiver coordinate for this trace
*    MAXDIP	- maximum anticipated reflector dip
*    ALIASFLAG	- flag to allow aliasing
*			0 = no aliasing allowed
*			1 = process all dips, even aliased ones
*    AMPFLAG	- flag to choose amplitude term
*			0 = Born DMO common amp term
*			1 = Born DMO common offset amp term
*			2 = Kinematic DMO common offset amp term
*			    ( plus spreading corrections )
*    SPRDFLAG	- flag to remove zero-offset spreading
*			0 = output includes zero-offset spreading
*			1 = output has had zero-offset spreading removed
*    SINCS()	- sinc interpolation weights
*    MT		- global dimension: max time samples
*    MX		- global dimension: max output traces
*
****************************************************************

*	implicit none

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

        real    spread(*)
        integer intbin, lhed(*)
        integer mhed (SZLNHD)

      	integer aliasflag,	ampflag,	mt,	mx
	integer	nt,	nx,	sprdflag,	obytes

	real 	dt,	dx,	maxdip,	offset, dmo(mt,ixmax)
	real	sincs(41),	trace(nt),	vmap(nv,mx)
	real	xmin,	xs,	xg

        integer cdps(SZLNHD), recs(SZLNHD), trcs(SZLNHD)

**
* Local integer variables:
*    IMID	- index of midpoint coord 'mid'
*    IT		- input time sample counter 
*    IX		- local trace index 
*    IXMIN	- index of midpoint coord 'xmin'
*    IXOUT	- output trace index
*    IXV	- vmap trace index 
*    MAXX	- max output trace for spreading 
*    MINX	- min output trace for spreading
*
* Local real variables:
*    ALIAS	-   max allowed operator slope ( in time samples per trace )
*    AMP	-   operator amplitude
*    BG		-   xg - x0 ... distance from receiver to output point
*    BGA	-   abs( bg )
*    BG2	-   bg * bg
*    BS		-   xs - x0 ... distance from source to output point
*    BSA	-   abs( bs )
*    BSBG	-   bs * bg
*    BS2	-   bs * bs
*    MID 	-   midpoint of input trace
*    OFFA 	-   abs( offset )
*    OFF2 	-   offa * offa
*    ONE 	-   1.0
*    PI 	-   pi
*    Q  	-   simplifying term
*    RG		-   vector length from receiver to reflection point
*    RG2	-   rg * rg
*    RS		-   vector length from source to reflection point
*    RSPRG	-   rs + rg
*    RSRG	-   rs * rg
*    RS2	-   rs * rs
*    R0		-   vector length from x0 to reflection point
*    R02	-   r0 * r0
*    SCALE	-   constant scale factor
*    SINTH	-   sin( maxdip )
*    T		-   time on input data ( raw reflection time )
*    TMP	-   temporary variable
*    TSLOPE	-   local slope of operator limb for aliasing treatment
*    TWO	-   2.0
*    TWOPI	-   2.0 * pi
*    T0		-   time on output data ( zero-offset time )
*    T2		-   t * t
*    V		-   velocity ( constant )
*    V2		-   v * v
*    X0		-   midpoint coordinate on output data
*    ZERO	-   0.0
*
**

      	integer imid,	it,	ix,	ixmin,	ixout
      	integer ixv,	maxx,	minx

	real	alias,	amp,	bg,	 bga,	bg2,	bs,	bsa
	real 	bsbg,	bs2,	mid,	offa,	off2,	one,	pi
	real 	q,	rg,	rg2,	rs,	rsprg,	rsrg,	rs2
	real	r0,	r02,	scale,	sinth,	t,	tmp,	tslope
	real	two,	twopi,	t0,	t2,	v,	v2,	x0
	real	zero
        real    velt (SZLNHD)
        logical first

      	common /const/ zero,	one,	two,	pi,	twopi

c----
c   number of bytes in the seismic part of a trace
c----
        nbyt = mt * SZSMPD

c----
c   compute a pi-related scale factor
c----
	scale = 1.0 / ( 4.0 * sqrt( twopi ) )

c----
c   compute sin() of max dip and also compute alias condition
c----
	sinth = sin( maxdip * pi / 180.0 ) 
	alias = dt / dx 

c----
c 	.. calc some indices 
c----
	mid   = ( xs + xg ) / 2.0
	imid  = mid/dx + 1 
	ixmin = xmin/dx + 1
	off2  = offset * offset 
	offa  = abs( offset )
        joff  = intbin (ngrp, dxg, spread, offset)
        if (joff .ge. lmin-1 .AND. joff .le. lmin+1) then
           ampx = 0.25
        else
           ampx = 1.0
        endif
c----
c .. single trace (t,x)-domain algorithm for Born Theory DMO 
c----
c   	    .. only output traces between source and receiver
c	    .. can possibly be involved
c	    .. (and use adhoc 80% max aperture rule)
c----
	    minx = ( mid - .4 * offa ) / dx + 1.0 
	    maxx = ( mid + .4 * offa ) / dx + 1.0	

c     write(LER,*)'offset= ',offset,joff,minx,maxx

c----
c   	    .. don't spread IR past edges of outdata
c----
	    if ( minx. lt. ixmin )  minx = ixmin + 1
	    if ( maxx .gt. nx )     maxx = ixmin + nx

c----
c   yeah!  we now know what traces from out output data volume we need
c   for this input trace, i.e. what traces will be affected by new ampls
c   along the dmo ellipse
c----
        do  j = 1, ixmax
            do  i = 1, nt
                dmo (i,j) = 0.0
            enddo
        enddo

c----
c		... within midpoint find offset position (1<=joff<=ngrp)
c		... put file pointer to just prior to that trace
c		... read whole trace and mov into dmo vector
c----
        do  ix = minx, maxx

            ixout = ix - ixmin + 1
            ixx   = ixout - minx + 1
            ioff = (ixout - 1) * ngrp + joff
                call sisseek (luout, ioff)
                call rtape   (luout, mhed, nbytes)
c               call vmov    (mhed(ITHWP1), 1, dmo(1,ixx), 1, mt)
                call move    (1, dmo(1,ixx), mhed(ITHWP1), nbyt)
                call saver2(mhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                      cdps(ixx)  , 1)
                call saver2(mhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      recs(ixx)  , 1)
                call saver2(mhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      trcs(ixx)  , 1)

        enddo
 
c----
c	.. Loop over input times (raw reflection time) 
c----
        iv = 0
      	DO  22 it = 1, nt
	    t  = ( it - 1 ) * dt
	    t2 = t * t

c----
c   	    .. if this sample is zero, there is nothing to spread
c	    .. (a tolerance criteria could be inserted here)
c----
	    if ( trace(it) .eq. 0.0 ) goto 22

            if     (it .eq. 1) then
                    iv  = 1
                    iv1 = 1
                    iv2 = 2
                    d2  = idv
                    d1  = 0.
                    dtt = idv
            elseif (it .gt. 1 .AND. mod(it,idv) .eq. 0) then
                    iv1 = iv
                    iv  = iv + 1
                    iv2 = iv
                    it1 = iv1 * idv
                    if (iv1 .eq. 1) it1 = 1
                    it2 = iv2 * idv
                    dvv = idv
                    dtt = it2 - it1
                    d1  = it - it1
                    d2  = it2 - it
            endif
            do  ix = minx, maxx
                    k = ix - ixmin
                    if (k .ge. 1 .OR. k .le. nx )
     1              velt (k) = (d2 * vmap(iv1,k) + d1 * vmap(iv2,k))/dtt
            enddo

c----
c	    .. Loop over output traces between source and receiver
c	    .. (x0 is the MIDPOINT on the zero offset data)
c----
	    do 23 ix = minx, maxx

		X0 = ( ix - 1 ) * dx

c----
c	    	... find vmap index for this trace
c----
	    	ixv = ix - ixmin
 	if ( ixv .lt. 1 .or. ixv .gt. nx ) goto 23

c----
c	    	... get processing velocity for this sample 
c----
	    	v  = velt(ixv)
	    	v2 = v*v

c----
c	    	.. set up beta terms
c----
		bs   = xs - x0 
		bs2  = bs * bs
		bg   = xg - x0
		bg2  = bg * bg
		bsbg = bs * bg
		bsa  = abs ( bs )
		bga  = abs ( bg )

		if ( bsbg .eq. 0.0 .OR. off2 .eq. 0.0 ) goto 23

		q = 1.0 - t2*v2 / off2
c----
c		.. find t0: impulse response time-intercept 
c		.. on this output trace
c----
		tmp = bsbg * q
		if ( tmp .le. 0.0 ) goto 23
		t0  = 2.0 * sqrt( tmp ) / v
c----
c		.. local time-slope of operator limb
c----
		tmp = sqrt( q / bsbg )
		tmp = tmp * ( bs + bg ) / v
		tslope = abs ( tmp )
c----
c		.. operator truncation
c		.. 
c		.. 1. to avoid spatial aliasing
c----
		if ( aliasflag .eq. 0 .and. tslope .gt. alias ) then
                    goto 23
                endif
c----
c		.. 2. based on max reflector dip
c----
		if ( tslope .gt. 2.0*sinth/v ) goto 23
c----
c		.. set up the 'r's
c----
		r0    = v  * t0 / 2.0
		r02   = r0  * r0
		tmp   = 1.0 - r02 / bsbg
		if ( tmp .le. 0.0 ) goto 23
		tmp   = sqrt(tmp)
		rs    = bsa * tmp
		rs2   = rs  * rs
		rg    = bga * tmp
		rg2   = rg  * rg
		rsprg = rs  + rg
		rsrg  = rs  * rg
c----
c		.. choice of amplitude terms 
c		.. 
c		.. inversion theory common shot amplitude term
c----
		if ( ampflag .eq. 0 ) then
		  tmp = r0 * offa * sqrt( offa )
		  tmp = tmp / ( bg2 * sqrt( v*rs*bga ) )
c----
c		  .. mult by 2 since integration variable
c		  .. is xg and dxg = df ( full offset, not midpoint)
c----
		  tmp = 2.0 * tmp
c----
c		.. inversion theory common offset amplitude term
c----
		else if ( ampflag .eq. 1 ) then
		  tmp = r0 * offa * ( rs2 + rg2 )
		  tmp = tmp / ( rg2 * bs2 )
		  tmp = tmp * sqrt( offa / ( v*rg*bsa ) )
c----
c		.. Berg's Kinematic DMO amplitude term
c----
		else if ( ampflag .eq. 2 ) then
		  tmp = 4.0 * ( mid - x0 ) * ( mid - x0 ) / off2
		  tmp = offa * ( 1.0 - tmp ) / 2.0
		  tmp = sqrt( t0 ) / ( twopi * tmp )
c----
c		  .. GS + IGS corrections
c----
		  tmp = ( rs + rg ) * tmp / ( 2 * r0 )
c----
c		  .. common shot form and compensate for scale
c----
		  tmp = 2.0 * tmp / scale

		end if
c----
c		.. option to remove zero offset geometric spreading
c----
		if ( sprdflag .eq. 1 ) then
		  tmp = tmp * 8.0 * pi * r0
		end if
c----
c		.. final amplitude term
c----
		amp = scale * tmp 
c----
c		.. total numerical value for spreading
c----
     		amp = trace(it) * amp * ampx * dx
c----
c		... find output midpoint index for this trace
c----
		ixout = ix - ixmin + 1
                ixx   = ixout - minx + 1
c----
c		... use eight-point sinc iterpolation to
c		... add this value to the output data 
c----
		call sincit( dmo(1,ixx), amp, t0, ist, iend,
     :				    dt, mt, nt,  sincs )

 23          continue

 22	CONTINUE

c----
c		... reset pointer to beginning of current trace
c		... & write back to disk with restored critical
c                   headers
c----
        do  ix = minx, maxx
 
            ixout = ix - ixmin + 1
            ixx   = ixout -minx + 1
            ioff = (ixout - 1) * ngrp + joff
                call sisseek (luout, ioff)
c               call vmov    (dmo, 1, lhed(ITHWP1), 1, mt)
                call move    (1,lhed(ITHWP1),dmo(1,ixx),nbyt)
                call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                      cdps(ixx)  , 1)
                call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                      recs(ixx)  , 1)
                call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                      trcs(ixx)  , 1)
                call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          0      , 1)
                call wrtape  (luout, lhed, obytes)
        enddo


	return
	end

*===========================================================


*===========================================================


	subroutine fzero(x, n)

*****************************************************************
*
* FZERO - vector fill with zeros
*
*          not optomized
*
* Parameters:
*    X - vector to be filled with zeros
*    N - number of elements in x
*
****************************************************************

*	implicit none

	integer n
	real x(n)

**
* Local variables:
*    I - loop counter
**

	integer i

	do 1 i = 1, n
 		x(i) = 0.0
 1      continue
	return
	end

*===========================================================


	subroutine init(dmo, nt, dt, nx, w, sincs, mt, mx)

*****************************************************************
*
* INIT - initializations
*
* Parameters:
*	DMO(,)		- output data panel
*	NT		- samples per trace
*	DT		- time sample rate
*	NX		- number of traces in output
*	W()		- frequency vector
*	SINCS()		- vector containing sinc weights
*	MT		- global dimension: max time samples
*	MX		- global dimension: max output traces
*
****************************************************************


*	implicit none

	integer nt,	nx,	mt,	mx,	iw,	ntnyq
	real	dt,	dmo(*),	dw,	sincs(41)
	real 	w(*)

**
* Local integer variables:
*    IW 	- frequency index
*    NTNYQ 	- nyquist frequency index
* Local real variables:
*    DW 	- frequency increment 
*    PI		- pi
*    TWOPI 	- 2 * pi
**

	real	zero,	one,	two,	pi,	twopi
 
      	common /const/ zero,	one,	two,	pi,	twopi

c 	.. zero outdata and vmap
        call fzero(dmo, nt*mx)
 
c 	.. Initialize frequency vector
c
c					Positive frequencies
	ntnyq = mt/2 + 1
	dw = twopi / ( float(mt) * dt )

      	do 13 iw = 1, ntnyq
         	w(iw) = float( iw - int(one) ) * dw
 13   	continue
c					Negative frequencies
      	do 14 iw = ntnyq + 1, mt
         	w(iw) = float( iw - int(one) - mt ) * dw
 14   	continue

c 	.. Initialize sinc interpolation coefficients 
	call tablsinc(sincs)

	return
	end

*===========================================================


      	subroutine iwtrace(trace, nt, dt, itrace, ctrace, w)

*****************************************************************
*
* IWTRACE - process a seismic trace through multiplication by 
*	    sqrt(i*frequency).
*
* Parameters:
*    TRACE(,)	- real input data
*    NT		- time samples on input data
*    DT		- time sample rate of data 
*    POW	- exponent of (i*w) 
*    ITRACE(,) 	- imaginary part of cdata
*    CTRACE(,) 	- complex data
*    W()	- frequency array (read 'omega')
*
****************************************************************

*	implicit none

      	integer nt

      	real trace(nt),	dt,	itrace(nt),	w(nt)

	complex ctrace(nt)

**
* Local integer variables:
*    IW		- frequency counter
*
* Local real variables:
*    POW	- exponent of (i*w) 
*    AMP	- real amp of sqrt(i*w) 
*    ONE	- 1.0
*    PI		- pi 
*    TWO	- 2.0
*    TWOPI	- 2.0*pi
*    ZERO	- 0.0
*
* Local complex variables:
*    CI		- sqrt(-1) 
*    PHASE	- complex phase of sqrt(i*w)
**

      	integer iw

      	real amp,	one,	pi,	two
	real twopi,	zero

	complex ci,	czero,	negphase,	phase,	plusphase

      	parameter (pi=3.14159265)

 
c 	.. Constants
      	zero = 0.0
      	czero = cmplx(zero,zero) 
      	one = 1.0
      	two = 2.0
      	twopi = 2*pi
        nt2 = nt / 2 + 1
	ci = cmplx(zero,one)
 
c 	.. Zero-out itrace and ctrace
        do  i = 1, nt
            ctrace (i) = cmplx (0.,0.)
        enddo
 
c  	.. copy trace and itrace (which is zero) into ctrace
 
c  	.. Fourier Transform: ctrace(t) --> ctrace(w)
c     	call fft(nt,ctrace,1.0,sqrt(1.0/float(nt)))
        call rfftf  (trace, ctrace, nt)
        call rfftsc (ctrace, nt, 3, 1)
 
c  	 .. set up the positive and negative phase terms 
	 plusphase = cexp(   ci*pi / 4.0 )
	 negphase  = cexp( - ci*pi / 4.0 )
 
c  	 .. do the iomega mult
	 do 124 iw = 1, nt2
	  	if ( w(iw) .eq. 0 ) then
			ctrace(iw) = cmplx(zero,zero)
		else
c			   phase = plusphase
			   phase = negphase
			amp = sqrt( abs(w(iw)) )
	 	   	ctrace(iw) = ctrace(iw) * amp * phase
		endif
 124	   continue
 
c  	   	.. Fourier Transform: ctrace(w) --> ctrace(t)
c     	   call fft(nt,ctrace,-1.0,sqrt(1.0/float(nt)))
           call rfftsc (ctrace, nt, -3, 0)
           call rffti  (ctrace, trace, nt)
 

	return
	end

*===========================================================

*===========================================================

	real function sinc(x)

*****************************************************************
*
* SINC   - sinc function
*
*****************************************************************

*	implicit none

	real x

**
* Local real variables:
*    PI     - pi
**

	real pi

	pi = 3.1415926

c
c	This sinc function is zero on integer values of x
c

	if ( x .eq. 0.0 ) then
		sinc = 1.0
	else
		sinc = sin( pi*x ) / ( pi*x )
	end if

	return
	end

*===========================================================


	subroutine sincit(vec, amp, t, ist, iend,
     1                    dt, mt, nt, sincs)

*****************************************************************
*
* SINCIT - add an amplitude value into a vector 
*	   by 8-point sinc interpolation
*
*          resolution is 1/10th of a sample
*
* Parameters:
*    VEC   - data vector 
*    AMP   - value to add into the vector
*    T     - time location of the value to be added
*    DT    - time sample rate
*    NT    - number of samples in vector
*    SINCS - sinc interpolation weights [from tablsinc()] 
*
****************************************************************

*	implicit none
	integer nt
	real amp,	dt,	sincs(41),	t,	vec(mt)

**
* Local variables:
*    IT     - time sample at, or above, 't'
*    ISINC  - temporary sinc weight index
*    ISINC1 - sinc weight index for 'it'
*    K      - temporary time sample index
**

	integer it,	k,	isnc1,	isnc
	
c	.. amp to be added into trace is in interval
c	.. it <= t/dt < it + 1
	it = int( t / dt )

        ist1  = ist + 3
        iend1 = iend - 4
        IF (it .lt. ist1 .OR. it .gt. iend1) RETURN

	isnc1 = ( t/dt - it ) * 10 + 1

c	.. eight point sinc interplotion
        iit = it - ist + 1
	k = iit
 	vec(k) = vec(k) + amp*sincs(isnc1)

	k = iit + 1
	isnc = 11 - isnc1 + 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit + 2
	isnc = 21 - isnc1 + 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit + 3
	isnc = 31 - isnc1 + 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit + 4
	isnc = 41 - isnc1 + 1
 	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit - 1
	isnc = 11 + isnc1 - 1
 	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit - 2
	isnc = 21 + isnc1 - 1
	vec(k) = vec(k) + amp*sincs(isnc)

	k = iit - 3
	isnc = 31 + isnc1 - 1
	vec(k) = vec(k) + amp*sincs(isnc)

	return
	end

*===========================================================


*===========================================================


	subroutine tablsinc(sincs)

*****************************************************************
*
* TABLSINC - table sinc function values
*
* Parameters:
*    SINCS - sinc interpolation weights
*
****************************************************************

*	implicit none

	real sincs(41)

**
* Local integer variables:
*    I      - counter
* 
* Local real variables:
*    SINC   - sinc function 
*    X      - sinc function argument (fractional sample point)
**

	real sinc,	x
	integer i

c	.. table sinc values for interpolation.
c	.. Incremental sample step size is .1 sample.
c	.. 
c	.. numbering system -- *=sample loc ... :=sinc value
c	.. 
c	..  |<----------- dt ------------>|
c	.. 
c	.. 
c	..  +  + 
c	..        +  +
c	..              +  +
c	..                    +
c	..                       +
c	..                          +
c	..                             +
c	..  *--:--:--:--:--:--:--:--:--:--*--:--:--:--:--:--:--:--:--:--*
c	..  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21
c	..                                   +                       +
c	..                                      +  +           +  +
c	..                                            +  +  +

	do 1 i = 1, 41
		x = ( i - 1 ) * .1
		sincs(i) = sinc( x )
 1	continue

	return
	end

*===========================================================

