C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

C
C     PROGRAM MODULE  dmo
C
C**********************************************************************C
C
C dmo READS SEISMIC TRACE DATA FROM AN INPUT FILE, record-by-record,
C performs a dmo operation using Hales common offset kirchhoff algrthm,
C and writes the results to otap
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER * 2 ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis, ordfft
      real        dx, dt, dtw
      integer     nsampo, ns, ne, irs, ire

      real        tabl1 (SZLNHD), tabl2(SZLNHD), zz(4*SZLNHD)
      integer     iz(SZLNHD)

      REAL        xtr( SZLNHD ), tri ( SZLNHD ), data, wrk3, wrk4
      complex     wrk2, wrk5
      integer     itrh
      pointer     (wkaddr, data(1))
      pointer     (wkadr2, wrk2(1))
      pointer     (wkadr3, wrk3(1))
      pointer     (wkadr4, wrk4(1))
      pointer     (wkadr5, wrk5(1))
      pointer     (wkadri, itrh(1))


      CHARACTER   NAME * 29, ntap * 100, otap * 100
#include <f77/pid.h>
      logical     verbos,query,heap,revrse,first
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'DMO:_fast_log_stretch_version'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      DATA first/.true./

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,ns,ne,irs,ire,verbos,
     1            dx,revrse,isamp)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      call rtape ( luin, itr, lbyte )
      lbytes = lbyte
      if(lbytes .eq. 0) then
         write(LERR,*)'DMO: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTE, NAME, 29, LERR        )

c---------------------------------
c  save key header values
#include <f77/saveh.h>

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
      call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
      call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
      call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
      call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
      call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
c----------------------------------
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      if (nsi .le. 32) then
          dt = float(nsi)/1000.
          ist  = ist / nsi
          iend = iend / nsi
      else
          dt = float(nsi)/1000000.
          ist  = 1000 * ist / nsi
          iend = 1000 * iend / nsi
      endif

      nrecc = ire-irs+1
      ntr   = ne - ns + 1
      ntro  = ntr
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
      nsampo=iend-ist+1

      if (isamp .gt. 1) then

         nsampw = nsampo / isamp
         dtw = dt * float(isamp)
         ist = ist / isamp
         if(ist .lt. 1) ist=1

         do  j = 1, SZLNHD
             tabl1(j) = float( j ) * dt
         enddo
 
         do  j = 1, SZLNHD
             tabl2(j) = float( j ) * dtw
         enddo

      else
         nsampw = nsampo
         dtw = dt
      endif

      nu = ordfft( nsampw )
      ntpad = 2 ** nu
      nu = ordfft( ntro )
      nxpad = 2 ** nu
      nside = (nxpad - ntro)/2

c------------------------------------------------------
c  save headers: exchange # traces/rec & # samples/rec
       call savew( itr, 'NumSmp', nsampo, LINHED)
       call savew( itr, 'NumTrc', ntro  , LINHED)
       call savew( itr, 'NumRec', nrecc , LINHED)

c----------------------------------------------------------------
c  change output bytes to reflect change from time to # traces
      obytes = SZTRHD + SZSMPD * nsampo

c---------------------------------
c  verbos printout
c     if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Output # samples   =  ', nsampo
        write(LERR,*) ' Output # traces    =  ', ntr
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' length padded trcs =  ', ntpad
        write(LERR,*) ' # padded traces    =  ', nxpad
        write(LERR,*) ' Input trace space  =  ', dx
        write(LERR,*) ' # traces to pad    =  ', nside
        if (isamp .gt. 1) then
           write(LERR,*) ' Resampled the data to ',isamp*nsi,' ms'
        endif
        if (revrse) then
           write(LERR,*) ' Do reverse DMO'
        else
           write(LERR,*) ' Do forwarde DMO'
        endif
c     endif

c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbyte, lbyout )
 
      call wrtape(luout,itr,lbyout)

c------------------------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.
      nt12 = ntpad/2 + 1
      nx12 = nxpad/2 + 1

      call galloc (wkaddr, ntpad*nxpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr2, 2*ntpad*nxpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr3, nxpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr4, ntpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr5, 2*ntpad*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadri, nxpad*ITRWRD*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) 2*ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) nxpad*SZSMPD,'  bytes'
         write(LERR,*) 2*ntpad*SZSMPD,'  bytes'
         write(LERR,*) nxpad*ITRWRD*SZSMPD,'  bytes'
         go to 999
      else
         write(LERR,*)'Allocated workspace:'
         write(LERR,*) ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) 2*ntpad*nxpad*SZSMPD,'  bytes'
         write(LERR,*) nxpad*SZSMPD,'  bytes'
         write(LERR,*) 2*ntpad*SZSMPD,'  bytes'
         write(LERR,*) nxpad*ITRWRD*SZSMPD,'  bytes'
      endif
c---------------------------------------------------

C**********************************************************************C
C
C     READ RECORD, DO DMO, WRITE OUTPUT RECORD
C
C**********************************************************************C
 
      DO 100 JJ = irs, ire

c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,ns-1,luin,ntrc,itr)

c--------------------------------------------------
c  read record & store
c----------------------
           nlive = 0
           ntro = ntr
           ic = 0
           call vclr (data, 1, ntpad*nxpad)
           iflag = 1

           DO 99 KK = ns, ne

                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'WARNING'
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 59
                 endif
                 call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
                 istatic = itr (l_StaCor)
                 if (istatic .eq. 30000) then
                    call vclr (tri,1,nsamp)
                 else
                    idis = itr(l_DstSgn)
                    nlive = nlive + 1
                 endif

                 if (isamp .gt. 1) then
                    call fcuint (tabl1, tri, nsamp, tabl2, xtr, nsampw,
     1                           iz, zz, iflag)
                    iflag = 0
                 else
                    call vmov (tri, 1, xtr, 1, nsamp)
                 endif

                 ic = ic + 1
c-------------------
c  store record in
c  long vector
                 istrc = (ic-1)* ntpad
                 call vmov (xtr(ist),1, data(istrc+1),1,nsampw)
c-------------------
c  save tr headers
                 ishdr = (ic-1)* ITRWRD
                 call vmov (lhed, 1, itrh(ishdr+1),1,ITRWRD)
 
   99      CONTINUE

   59      ntrk = ic

           if (ntrk .ne. ntr) then
               if (ntrk .eq. 0) go to 999
               write(LERR,*)'WARNING:'
               write(LERR,*)'read ',ntrk,' traces from record ',jj
               write(LERR,*)'instead of ',ntr
               write(LERR,*)'processing continuing'
               ntro = ntrk
           endif
c--------------------------------------------------

       call maxmgv (data, 1, xmax, lmax, ntpad*ntrc)
c-------------------
c   do dmo
           h = .5 * float( iabs( idis ) )
           if (nlive .gt. 2 .AND. h .gt. 0.0) then
                if (revrse) then
                    call logdmo (data,ntpad,dtw,nxpad,dx,h,
     1                             -1,wrk2,wrk3,wrk4,wrk5,first)
                else
                    call logdmo (data,ntpad,dtw,nxpad,dx,h,
     1                             +1,wrk2,wrk3,wrk4,wrk5,first)
                endif
                first = .false.
           endif
c-------------------

c------------------------------------------------
c  extract output
c  data from vector
           iflag = 1

           DO 199 KK = 1, ntro
                 istrc = (kk-1) * ntpad
                 call vmov (data(istrc+1),1,xtr,1,nsampw)

                 if (isamp .gt. 1) then
                    call fcuint (tabl2, xtr, nsampw, tabl1, tri, nsampo,
     1                           iz, zz, iflag)
                    iflag = 0
                 else
                    call vmov (xtr, 1, tri, 1, nsamp)
                 endif

c--------------------
c  get back headers
                 if (kk .le. ntro) then
                     ishdr = (kk-1) * ITRWRD
                     call vmov (itrh(ishdr+1), 1, lhed, 1, ITRWRD)
                 endif
                 itr(l_TrcNum) = kk
                 call vmov (tri, 1, lhed(ITHWP1), 1, nsampo)

                 CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
 
  199      CONTINUE
c------------------------------------------------

           if(verbos) then
              write(LERR,*) 'DMO processed Record=  ',jj
           endif

c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)


  100 CONTINUE

  999 continue

       call lbclos(luin)
       call lbclos(luout)

      END
