C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c------------------------------
c  online help section
c------------------------------
      subroutine  help  
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for DMOFAST: dip moveout'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-s[ist]    -- start time (samples)    (first samp)'
        write(LER,*)'-e[iend]   -- end time (samples)       (last samp)'
        write(LER,*)'-ns[ns]    -- start trace #                (first)'
        write(LER,*)'-ne[ne]    -- end trace #                   (last)'
        write(LER,*)'-rs[irs]   -- start record                 (first)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-dx[dx]    -- input shot spacing, ft or m   (none)'
        write(LER,*)'-fs[fs]    -- working temporal sampling factor (1)'
        write(LER,*)'-R         -- reverse dmo'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        dmofast -N[] -O[] -s[] -e[] -ns[] -ne[]'
        write(LER,*)'             -rs[] -re[] -dx[] -fs[] [-R -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     irs   - I      start record
c     ire   - I      stop end record
c      ns   - I      start trace
c      ne   - I      end trace
c     dx    - R      shot spacing (input)
c    revrse - L      inverse dmo
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,ns,ne,irs,ire,verbos,   
     1            dx,revrse,isamp)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      real       dx
      integer    argis,ist,iend,irs,ire,ns,ne,isamp
      logical    verbos, revrse

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-fs',isamp,1,1)
          call argi4('-s',ist,1,1)
          call argi4('-e',iend,0,0)
          call argi4('-ns',ns,1,1)
          call argi4('-ne',ne,0,0)
          call argi4('-rs',irs,1,1)
          call argi4('-re',ire,0,0)
          call argr4('-dx',dx,0.,0.)
          revrse = (argis('-R') .gt. 0)
          verbos = (argis('-V') .gt. 0)

          if (dx .eq. 0.) then
             write(LERR,*)'Must enter input shot interval - FATAL'
             stop
          endif

          if (isamp .lt. 1) then
             write(LERR,*)'Resample factor must be > 1, rerun'
             stop
          endif

      return
      end
