C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/04/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/22  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      HELP            -                                               *
C      ARGSTR          -                                               *
C      ARGR4           -                                               *
C      MOVE            -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      MIN     GENERIC -                                               *
C      INDEX   INTEGER -                                               *
C  FILES:                                                              *
C      1     ( OUTPUT SEQUENTIAL ) -                                   *
C      55    ( INPUT  SEQUENTIAL ) -                                   *
C      6     ( OUTPUT SEQUENTIAL ) -                                   *
C      LU2   ( INPUT  SEQUENTIAL ) -                                   *
C      LU66  ( OUTPUT DIRECT     ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 4) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 87/03/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 87/03/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      MIN     GENERIC -                                               *
C  FILES:                                                              *
C      LU2   ( INPUT  SEQUENTIAL ) -    line.mxc                       *
C      LU55  ( INPUT  SEQUENTIAL ) -    line.velocity                  *
C      LU66  ( OUTPUT DIRECT     ) -    line.matrix                    *
C      LU1   ( OUTPUT SEQUENTIAL ) -    line.term                      *
C      LU6   ( OUTPUT SEQUENTIAL ) -    line.info                      *
C      LU99  ( OUTPUT SEQUENTIAL ) -    velo.grid                      *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 2) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      DIMENSION FH(52,3000)
      DIMENSION SAVK(50,129)
      DIMENSION TABX(50,129),TABY(50,129)
      INTEGER IVEL(50)
      INTEGER ONE,TWO,THREE,FOUR,FIVE,SIX
      INTEGER SEVEN,EIGHT,NINE,TEN
      INTEGER  CON(3000)
      INTEGER  RCON(3000)
      INTEGER LC(50)
      INTEGER NPC(50),CARD(20)
      REAL LF,RT,TP,BT
      INTEGER I,J,K
      INTEGER L,LC1,MINP
      INTEGER NH,TYP
      DIMENSION ZMIN(50),ZMAX(50),ICLIST(50)
      DIMENSION ZMINC(50),ZMAXC(50),ICCLST(50)
	integer argis
      character jobname*120, line*120
	logical query
      DATA SAVE/1.0/
      DATA ONE,TWO,THREE,FOUR,FIVE,SIX/1,2,3,4,5,6/
      DATA SEVEN,EIGHT,NINE,TEN/7,8,9,10/
 
 
	query = ( argis ( '-?' ) .gt. 0 )
	if ( query ) then
		call help()
		stop
	end if
 
c     call second(t1)
      LU1=1
      LU4=4
C     LU2 IS LOGICAL UNIT (JOBNAME$ DATA (DIGITIZED MODEL BOUNDARIES)
      LU2=2
      LU6=6
      LU66=66
      LU99 = 99
C
C*                                                                  */
C*  EXECUTION BEGINS                                                */
C*                                                                  */
C    READ DX,DZ
C    READ THE VELOCITIES
C
C    GET THE EXTERNAL FILE NAMES
C    first read in the line name (default = 'vmatrix')
      call argstr('-L',line,' ',' ')
	ipos = index(line,' ')
	j = ipos -1
	if (j .eq. 0) then
		print *,'PROGRAM STOP: NO LINE ID GIVEN, SEE MANUAL'
		stop
	end if
      call argstr('-MXC',jobname,line(1:j)//'.mxc',
     :  			line(1:j)//'.mxc')
      OPEN(UNIT=LU2,FILE=jobname)
      call argstr('-t',jobname,line(1:j)//'.term',
     :				line(1:j)//'.term')
      OPEN(UNIT=1  ,FILE=jobname)
      call argstr('-list',jobname,line(1:j)//'.info',
     :				line(1:j)//'.info')
      OPEN(UNIT=6  ,FILE=jobname)
c     call argstr('-grid',jobname,'velo.grid','velo.grid')
c     OPEN(UNIT=lu99 ,FILE=jobname)
      call argstr('-C',jobname,line(1:j)//'.velocity',
     :				line(1:j)//'.velocity')
      OPEN(UNIT=55,FILE=jobname)
      call argstr('-M',jobname,line(1:j)//'.matrix',
     :				line(1:j)//'.matrix')
c     OPEN(UNIT=LU66,FILE=jobname,ACCESS='DIRECT',
c    *recl=16000)
      READ(55,1,END=1111)CARD,NAME,idir,ddx, ddz
    1 FORMAT(20A4,T1,1X,A4,i1,f9.2,F10.2,55X)
	call argr4('-dx',dx,0.0,0.0)
	call argr4('-dz',dz,0.0,0.0)
      WRITE(6,3)DX,DZ,idir
    3 FORMAT(' OUTPUT SPACING IN X DIRECTION = ',F10.2,/,
     *       ' OUTPUT SPACING IN Z DIRECTION = ',F10.2,/,
     *       ' model direction 0=L>R, 1 =R>L = ', i5)
      I=1
   10 READ(55,2,END=1111)CARD,NAME,IRLV
    2 FORMAT(20A4,T1,1X,A4,I5,70X)
      IVEL(I)=IRLV
      IF(IVEL(I).GE.99999)GO TO 5
      I=I+1
      GO TO 10
    5 NOVEL=I-1
      GO TO 1113
 1111 WRITE(6,1112)
 1112 FORMAT(' NO VELOCITY CARDS WERE FOUND--JOB TERMINATED')
      STOP
C*  READ DATASET INTO TEMPORARY VARIABLE                            */
C*  AND CALCULATE NUMBER OF CONTOURS AND NUMBER OF POINTS PER CONTOUR */
C*                                                                  */
 1113 WRITE(6,15)NOVEL
   15 FORMAT(' NUMBER VELOCITIES READ=',I5)
      WRITE(6,1114)(IVEL(I),I=1,NOVEL)
 1114 FORMAT('  REFLECTED VELOCITIES READ:',/,
     1(8I10))
      VMAX = 0.0
      VMIN = 10000000.
      READ(LU2,2000) TYP,NH,LF,RT,TP,BT,NC,IDIRT
 2000 FORMAT(4X,2I5,4F10.3,I5,8X,10X,2X,I1)
c     WRITE(6,8010) ONE
c
C     CALCULATE TABLE WIDTH AND DEPTH
c
      JMAX=(RT-LF)/DX+0.5
      JTOT=JMAX+3
      IMAX=(BT-TP)/DZ+.5
      ZDIM=BT-1.
      IMAX1=ZDIM/DZ+.5
      WRITE (6,*)'Number of cells in x direction = ', JMAX
      WRITE (6,*)'Number of cells in z direction = ', imax1
      WRITE(6,8010) ONE
      NZ=NH+NC
      ZSTART = .005*(BT-TP)
      XSTART = .005*(RT-LF)
      XLIM = RT - XSTART
      ZLIM = BT - ZSTART
      OPEN(UNIT=LU66,FILE=jobname,ACCESS='DIRECT',
     *recl=jmax*SZSMPD)
c
C     Read digitized horizons and store in 2-d array tabx & taby
c
      DO 101 K=1,NZ
        YTE=0.
        DO 102 NSTR=1,501,4
          IF(YTE.LT.0.) GO TO 103
          NSTR3=NSTR+3
          READ(LU2,2001)(TABX(K,J),TABY(K,J),J=NSTR,NSTR3)
          WRITE(6,8030) K,(TABx(K,J),TABY(K,J),J=NSTR,NSTR3)
          YTE=TABX(K,NSTR)
          NSTP=NSTR+4
  102   CONTINUE
  103 CONTINUE
      WRITE(6,8010) THREE
C*                                                                 */
C*  CHECK FOR STRICT INEQUALITY                                    */
C*                                                                 */
       DO 104 J=1,NSTP
          IF(J.EQ.1) GO TO 125
          IF(TABX(K,J).LT.0.000001.AND.TABY(K,J).LT.0.000001) GO TO 105
  125     NPC(K)=J
  104 CONTINUE
  105 CONTINUE
      IF(NPC(K).GT.MINP) MINP=NPC(K)
      WRITE(6,8020) THREE,ONE
  101 CONTINUE
 2001 FORMAT(F8.2,7F10.2)
      NP=MINP+1
      DO 106 I=1,NZ
        NPCI=NPC(I)
          DO 107 J=1,NPCI
             IF(TABX(I,J).GT.XLIM) TABX(I,J)=RT
             IF(TABX(I,J).LT.XSTART) TABX(I,J)=0.0
             IF(TABY(I,J).GT.ZLIM) TABY(I,J)=BT
             IF(TABY(I,J).LT.ZSTART) TABY(I,J)=0.0
  107     CONTINUE
         WRITE(6,8020) THREE,TWO
         IF(I.LE.NH) GO TO 106
         IF(TABX(I,NPCI).EQ.TABX(I,1) .AND.
     1   TABY(I,NPCI).EQ.TABY(I,1)) GO TO 106
         NPCI =NPCI+1
         NPC(I) = NPCI
         TABX(I,NPCI) = TABX(I,1)
         TABY(I,NPCI) = TABY(I,1)
  106 CONTINUE
C*                                                                  */
C*                                                                  */
C*  CALCULATE DISTANCE BETWEEN GRID POINTS IN Z DIRECTION (VERTICAL)*/
C*                                                                  */
C*                                                                  */
C*  PERTURB EXACT POINTS ON GRID LINE                               */
C*                                                                  */
      Z=TP-DZ
      DO 201 K=1,IMAX
      Z=Z+DZ
       DO 202 I=1,NZ
       NPCI=NPC(I)
       DO 202 J=1,NPCI
      IF (I .GT. 50) WRITE (1,9995) I
9995  FORMAT ('     I =',I5)
      IF (J .GT. 129) WRITE (1,9995) J
9996  FORMAT ('     J =',I5)
       IF(TABY(I,J).EQ.Z) TABY(I,J)=TABY(I,J)*1.00001
  202 CONTINUE
  201 CONTINUE
      WRITE(6,8020) THREE,FOUR
      IER=0
C
C     SET ALL INDICES TO '1'  after zeroing out con array
C
      call move(0,con,0,3000*SZSMPD)
      DO 257 JJ=1,JMAX
  257 CON(JJ)=1
C
C*  CALCULATE DISTANCE BETWEEN GRID POINTS IN X DIRECTION (HORIZONTAL)*/
C*                                                                    */
C*                                                                  */
      NH2=NH+2
      NH21=NH2-1
      NH1=NH+1
C*                                                                  */
C*  GENERATE TOP AND BOTTOM OF MODEL                                */
C*                                                                  */
      DO 401 J=1,JMAX
      FH(1,J)=TP
      FH(NH2,J)=BT
  401 CONTINUE
      IF (NH.LE.0)  GO TO 701
      DO 700 I=1,NH
C*                                                                  */
C*  GENERATE LINES FOR 2 POINT HORIZONTAL CONTOURS                  */
C*                                                                  */
C*   IF------
      IF(NPC(I).NE.2.OR.TABY(I,1).NE.TABY(I,2)) GO TO 501
      X=0.
       DO 502 J=1,JMAX
       X=X+DX
       IF(X.GE.TABX(I,1).AND.X.LE.TABX(I,2))
     1 FH(I+1,J)=TABY(I,1)
  502 CONTINUE
      GO TO 700
  501 CONTINUE
C*                                                                   */
C*  GENERATES LINES FOR HORIZONTAL CONTOURS                          */
C*
      X=0.
       DO 601 J=1,JMAX
       FH(I+1,J)=0.
       X=X+DX
       NPCI1=NPC(I)-1
        DO 602 K=1,NPCI1
        IF(X.LT.TABX(I,K).OR.X.GT.TABX(I,K+1)) GO TO 602
        SLOPE=(TABY(I,K)-TABY(I,K+1))/(TABX(I,K)-TABX(I,K+1))
        FH(I+1,J)=SLOPE*(X-TABX(I,K))+TABY(I,K)
  602 CONTINUE
  601 CONTINUE
  700 CONTINUE
  701 CONTINUE
C
C     FIND ZMIN,ZMAX PER CONTOUR
C
      DO 7000 L=1,NH2
      ZMIN(L)=BT
      ZMAX(L)=DZ
      DO 7000 J=1,JMAX
      IF(FH(L,J).GT.ZMAX(L))ZMAX(L)=FH(L,J)
      IF(FH(L,J).LT.ZMIN(L))ZMIN(L)=FH(L,J)
 7000 CONTINUE
 
 
c     WRITE (99,*) JMAX, IMAX1
      WRITE (6,1020) JMAX,IMAX1,DZ
1020  FORMAT (' JMAX = ',I10,'   IMAX1 = ',I10,'   DZ = ',F8.2)
C*                                                                  */
C*  NO CLOSED CONTOURS SECTION                                      */
C*                                                                  */
C*    IF ---NC EQ 0 DO BLOCK IL1
      IF(NC.NE.0) GO TO 800
      Z=-DZ
C*******************************************************************
C*  BLOCK  L1:
C*******************************************************************
      DO 801 I=1,IMAX1
      Z=Z+DZ
      X=LF
C     DETERMINE POTENTIAL CONTOUR NO.'S TO CHECK FOR THIS Z (DEPTH)
C
      KOUNT=0
      DO 7010 L=1,NH21
      IF(Z.LT.ZMIN(L) .OR. Z.GT.ZMAX(L+1))GO TO 7010
      KOUNT=KOUNT+1
      ICLIST(KOUNT)=L
      ICLIST(KOUNT+1)=L+1
 7010 CONTINUE
       DO 802 J=1,JMAX
       X=X+DX
        DO 803 L=1,KOUNT
        IF(Z.GT.FH(ICLIST(L),J).AND.FH(ICLIST(L+1),J).GE.Z)
     1  CON(J)=ICLIST(L)
  803 CONTINUE
  802 CONTINUE
      IERC=0
      IER=0
      NUMVEL=1
      VMIN=100000.
      VMAX=0.0
      ISTART=CON(1)
      DO 3000 J=1,JMAX
         IF(CON(J).EQ.ISTART) GO TO 2999
            NUMVEL=NUMVEL+1
            ISTART=CON(J)
 2999 CONTINUE
         IF(IVEL(CON(J)).GT.VMAX)VMAX=IVEL(CON(J))
         IF(IVEL(CON(J)).LT.VMIN)VMIN=IVEL(CON(J))
 3000 CONTINUE
      CON(JMAX+1)=VMIN
      CON(JMAX+2)=VMAX
      CON(JMAX+3)=NUMVEL
      WRITE(6,2110) I,VMIN,VMAX,NUMVEL,JMAX
 2110 FORMAT(' ROW,MIN,MAX,NUMVEL,SAMPLES',I6,1X,2F10.0,2I6)
  888 CONTINUE
 
C
C     SAMPLE ROW OF VELOCITIES FOR OUTPUT TO SCREEN
C
cshg  WRITE(6,1010)(CON(J),J=1,50)
      JSKIP = (JMAX-1)/80+1
      JSCRN = MIN(80,JMAX/JSKIP)
      ISKIP = (IMAX1-1)/30+1
C
C     LEFT-TO-RIGHT VELOCITY MODEL: WRITE TO LU66
C
 	if (idir .eq. 0) then
            WRITE(LU66,REC = I    )(CON(J),J=1,JMAX)
C
C     LEFT-TO-RIGHT VELOCITY MODEL: WRITE TO SCREEN
C
      IF ((I/ISKIP)*ISKIP .EQ. I) WRITE(1,1010)(CON(J*JSKIP),J=1,JSCRN)
	endif
C
C     RIGHT-TO-LEFT VELOCITY MODEL: WRITE TO LU66
C
      DO 66 J = 1,JMAX
      RCON(J) = CON(JMAX-J+1)
 66    CONTINUE
 	if (idir .eq. 1) then
          WRITE(LU66,REC = I    )(rCON(J),J=1,JMAX)
C
C     RIGHT-TO-LEFT VELOCITY MODEL: WRITE TO SCREEN
C
      IF ((I/ISKIP)*ISKIP .EQ. I) WRITE(1,1010)(rCON(J*JSKIP),J=1,JSCRN)
	end if
1010  FORMAT(80I1)
  801 CONTINUE
C********************************************************************
C* END BLOCK L1;
C********************************************************************
      WRITE(6,8010) SIX
      GO TO 1000
C*                                                                  */
C*  CLOSED CONTOUR SECTION                                          */
C*                                                                  */
  800 CONTINUE
C*  BEGIN BLOCK N1:
C*                                                                  */
C*                                                                  */
C*  SET UP ARRAY TO SAVE CONTOUR CROSSINGS                          */
C*                                                                  */
C*     ALLOCATE SAVK(NC,MINC);
C*
      Z=-DZ
C     FIND ZMINC AND ZMAXC FOR EACH CLOSED CONTOUR
C
      IC=0
      DO 8000 K=NH1,NZ
      IC=IC+1
      ZMINC(IC)=BT
      ZMAXC(IC)=DZ
      NPCK1=NPC(K)-1
      DO 8000 L=1,NPCK1
      IF(TABY(K,L).GT.ZMAXC(IC)) ZMAXC(IC)=TABY(K,L)
      IF(TABY(K,L).LT.ZMINC(IC)) ZMINC(IC)=TABY(K,L)
 8000 CONTINUE
C
C*                                                                  */
C*  FIND IF GRID ROW I CROSSES CONTOUR K IF IT DOES SAVE CROSSING
C*  VALUE */
C*                                                                 */
      DO 902 I=1,IMAX1
      Z=Z+DZ
C     FIND THE POTENTIAL CONTOURS FOR THIS GRID ROW DEPTH
C
      KOUNTC=0
      DO 8022 L=1,NC
      IF(Z.LT.ZMINC(L) .OR. Z.GT.ZMAXC(L))GO TO 8022
      KOUNTC=KOUNTC+1
      ICCLST(KOUNTC)=L
 8022 CONTINUE
       DO 903 KK=1,KOUNTC
       KMNH=ICCLST(KK)
       K=KMNH+NH
       LC(KMNH)=0
       NPCK1=NPC(K)-1
        DO 904 L=1,NPCK1
        IF(TABY(K,L).EQ.TABY(K,L+1)) GO TO 904
        IF(TABY(K,L).LE.Z.AND.TABY(K,L+1).GE.Z) GO TO 905
        IF(TABY(K,L).GE.Z.AND.TABY(K,L+1).LE.Z) GO TO 905
        GO TO 904
  905 CONTINUE
        LC(KMNH)=LC(KMNH)+1
        LCKMNH=LC(KMNH)
        SAVK(KMNH,LCKMNH)=((TABX(K,L)-TABX(K,L+1))/
     1  (TABY(K,L)-TABY(K,L+1)))*(Z-TABY(K,L+1))+TABX(K,L+1)
  904 CONTINUE
  903 CONTINUE
C*                                                                  */
C*  SCAN HORIZONTAL CONTOURS TO FILL ROW I WITH INDEX DERIVED FROM
C* HORIZONTAL CONTOURS   */
C*                                                                  */
      X=LF
C     DETERMINE POTENTIAL CONTOUR NO.'S TO CHECK FOR THIS Z (DEPTH)
C
      KOUNT=0
      DO 7020 L=1,NH21
      IF(Z.LT.ZMIN(L) .OR. Z.GT.ZMAX(L+1)) GO TO 7020
      KOUNT=KOUNT+1
      ICLIST(KOUNT)=L
      ICLIST(KOUNT+1)=L+1
 7020 CONTINUE
       DO 906 J=1,JMAX
       SAV=1.
       CON(J)=1.
       X=X+DX
        DO 907 L=1,KOUNT
        IF(Z.GT.FH(ICLIST(L),J).AND.FH(ICLIST(L+1),J).GE.Z)
     1  CON(J)=ICLIST(L)
  907 CONTINUE
C*                                                                  */
C*  SCAN CLOSED CONTOURS TO REPLACE ELEMENTS OF ROW I WITH CLOSED
C*  CONTOUR INDEX NH+1 IF ELEMENT J IS WITHIN CLOSED CONTOUR K       */
C*                                                                  */
C**   L7:
C     CHECK THE CONTOURS IN REVERSE ORDER, AND QUIT CHECKING
C     CONTOURS WHEN ONE IS FOUND
        KK=KOUNTC
        DO 908 KKM=1,KOUNTC
        K=ICCLST(KK)
        IF(ABS(SAV).LE.0.0000001) GO TO 909
        IF(LC(K).EQ.0) GO TO 910
        LCK=LC(K)
         DO 911 LC1=1,LCK
         IF(ABS(SAV).LE.0.00001)GO TO 912
         SAV=(SAVK(K,LC1)-X)*SAV
         IF(ABS(SAV).LT.(DX/5.)) SAV=0
         IF(ABS(SAV).GT.0.00001) SAV=SAV/ABS(SAV)
  911 CONTINUE
  912 CONTINUE
      IF(SAV.GT.0.0) GO TO 910
      CON(J)=NH+1+K
      GO TO 909
  910 CONTINUE
        SAV=1.0
      KK=KK-1
  908 CONTINUE
  909 CONTINUE
  906 CONTINUE
      IER=0
      IERC=0
      NUMVEL=1
      VMIN=100000.
      VMAX=0.0
      ISTART=CON(1)
      DO 2200 J=1,JMAX
         IF(CON(J).EQ.ISTART) GO TO 2199
            NUMVEL=NUMVEL+1
            ISTART=CON(J)
 2199    CONTINUE
         IF(IVEL(CON(J)).GT.VMAX)VMAX=IVEL(CON(J))
         IF(IVEL(CON(J)).LT.VMIN)VMIN=IVEL(CON(J))
 2200 CONTINUE
      CON(JMAX+1)=VMIN
      CON(JMAX+2)=VMAX
      CON(JMAX+3)=NUMVEL
      WRITE(6,2110) I,VMIN,VMAX,NUMVEL,JMAX
      WRITE(6,2111) I,CON(JMAX+1),CON(JMAX+2),CON(JMAX+3),JMAX
 2111 FORMAT(5I7)
      IERC=0
 2100 IER=0
 
C
C     SAMPLE ROW OF VELOCITIES FOR OUTPUT TO SCREEN
C
      JSKIP = (JMAX-1)/80+1
      JSCRN = MIN(80,JMAX/JSKIP)
      ISKIP = (IMAX1-1)/30+1
 
C
C     LEFT-TO-RIGHT VELOCITY MODEL: WRITE TO LU66
C
 	if ( idir .eq. 0 )   then
             WRITE(LU66,REC = I    )(CON(J),J=1,JMAX)
C
C     LEFT-TO-RIGHT VELOCITY MODEL: WRITE TO SCREEN
C
      IF ((I/ISKIP)*ISKIP .EQ. I) WRITE(1,1010)(CON(J*JSKIP),J=1,JSCRN)
	end if
C
C     RIGHT-TO-LEFT VELOCITY MODEL: WRITE TO LU66
C
      DO 67 J = 1,JMAX
      RCON(J) = CON(JMAX-J+1)
 67    CONTINUE
 	if (idir .eq. 1)  then
            WRITE(LU66,REC = I    )(rCON(J),J=1,JMAX)
C
C     RIGHT-TO-LEFT VELOCITY MODEL: WRITE TO SCREEN
C
      IF ((I/ISKIP)*ISKIP .EQ. I) WRITE(1,1010)(rCON(J*JSKIP),J=1,JSCRN)
	end if
  902 CONTINUE
C
C******************************************************************
C
      WRITE(6,8010) SEVEN
 1000 CONTINUE
C**   END BLOCK N1
C**   END STRUCTF;
 
      CLOSE (UNIT = LU66, STATUS = 'KEEP')
c     call second(t2)
      t3=t2-t1
c     print*,'elapsed time ',t3,' seconds'
 
 8010 FORMAT(2X,'CHECK=',I5)
 8020 FORMAT(2X,'CHECK=',2I5)
 8030 FORMAT(2X,I5,2X,8F10.2)
C
C
c	print *,'vmatrix done'
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP                                                            *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/04/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/07/22  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
 
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Execute VMATRIX by typing vmatrix and a list of program',
     :' parameters.'
      write(LER,*)
      write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
        write(LER,*)
     :'Enter the following parameters, or use the default values:'
        write(LER,*)
        write(LER,*)
     :' -L [line]  : Complete path for INPUT Line ID. : (NO DEFAULT)'
        write(LER,*)
     :'              Enter path name(i.e. /m/trc/zxxx01/data/linexyz)'
        write(LER,*)
     :'              to prefix input and output files.'
        write(LER,*)
       write(LER,*)
     :' -MXC [mxc] : Complete path for INPUT mxc file'
        write(LER,*)
     :'             	 (default = /m/trc/zxxx01/data/linexyz.mxc)'
        write(LER,*)
       write(LER,*)
     :' -C [vel]   : Complete path for INPUT velocity card file'
        write(LER,*)
     :'             	 (default = /m/trc/zxxx01/data/linexyz.vel)'
        write(LER,*)
       write(LER,*)
     :' -t [term]  : Complete path for OUTPUT file to view model'
       write(LER,*)
     :'              on terminal'
        write(LER,*)
     :'             	 (default = /m/trc/zxxx01/data/linexyz.term)'
        write(LER,*)
       write(LER,*)
     :' -M [matrix]: Complete path for OUTPUT velocity matrix file'
        write(LER,*)
     :'             	 (default = /m/trc/zxxx01/data/linexyz.matrix)'
        write(LER,*)
       write(LER,*)
     :' -list [info]:Complete path for OUTPUT listing file(your info)'
        write(LER,*)
     :'             	 (default = /m/trc/zxxx01/data/linexyz.info)'
        write(LER,*)
        write(LER,*)
     :'usage: vmatrix -L[ntap] -MXC[mxc] -t[term] -C[cards] -M[matrix]'
        write(LER,*)
     :'            -list[info]'
         write(LER,*)
     :'***************************************************************'
      return
 
      end
