C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       AVERGE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      AVERGE  (Z,ICOUNT,NFOUND,NBRHD,WEIGHT,INTZ,ZINT)                *
C  ARGUMENTS:                                                          *
C      Z       INTEGER*2  ??IOU*  (ICOUNT) -                           *
C      ICOUNT  INTEGER    ??IOU*           -                           *
C      NFOUND  INTEGER    ??IOU*           -                           *
C      NBRHD   INTEGER*2  ??IOU*  (NFOUND) -                           *
C      WEIGHT  REAL*4     ??IOU*  (NFOUND) -                           *
C      INTZ    INTEGER    ??IOU*           -                           *
C      ZINT    REAL       ??IOU*           -                           *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIGN    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      2 DETECTED                               *
C      REAL*                                                           *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C                                                                       00117000
C     LANGUAGE: FORTRAN                                                 00117100
C                                                                       00117200
C     AUTHOR: ?.?????                                                   00117300
C                                                                       00117400
C     DATE WRITTEN: ??/??/??                                            00117500
C                                                                       00117600
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE 00117700
C                                                                       00117800
C     ABSTRACT: COMPUTE A WEIGHTED AVERAGE.                             00117900
C                                                                       00118000
C     CALLING SEQUENCE: CALL AVERGE(Z     , ICOUNT, NFOUND, NBRHD ,     00118100
C                                   WEIGHT, INTZ  )                     00118200
C                WHERE: Z      - BUFFER OF KNOWN VALUES                 00118300
C                       ICOUNT - NUMBER OF ELEMENTS IN "Z"              00118400
C                       NFOUND - NUMBER OF NEIGHBORS AND WEIGHTS        00118500
C                       NBRHD  - BUFFER OF NEIGHBOR'S INDEXES           00118600
C                       WEIGHT - BUFFER OF WEIGHTS                      00118700
C                       INTZ   - AVERAGED VALUE                         00118800
C                       ZINT   - AVERAGED VALUE (FLOATING POINT)        00118900
C                                                                       00119000
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE                00119100
C                                                                       00119200
C***********************************************************************00119300
C                                                                       00119400
C                                                                       00119500
      SUBROUTINE AVERGE(Z     , ICOUNT, NFOUND, NBRHD , WEIGHT,         00119600
     *                  INTZ  , ZINT  )                                 00119700
C                                                                       00119800
C                                                                       00119900
C-----------------------------------------------------------------------00120000
C                                                                       00120100
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS                      00120200
C                                                                       00120300
C-----------------------------------------------------------------------00120400
C                                                                       00120500
      REAL*4    WEIGHT(NFOUND)                                          00120600
C                                                                       00120700
      INTEGER*2 NBRHD (NFOUND), Z     (ICOUNT)                          00120800
C                                                                       00120900
      SUMWGT            = 0.0                                           00121000
      SUMZ              = 0.0                                           00121100
C                                                                       00121200
C-----------------------------------------------------------------------00121300
C                                                                       00121400
C     CALCULATE THE WEIGHTED AVERAGE                                    00121500
C                                                                       00121600
C-----------------------------------------------------------------------00121700
C                                                                       00121800
      DO 100 I = 1,NFOUND                                               00121900
C                                                                       00122000
         SUMZ           = SUMZ + (Z(NBRHD(I)) * WEIGHT(I))              00122100
         SUMWGT         = SUMWGT              + WEIGHT(I)               00122200
C                                                                       00122300
  100 CONTINUE                                                          00122400
C                                                                       00122500
      ZINT              = (SUMZ / SUMWGT)                               00122600
      INTZ              = ZINT            + SIGN(0.5,SUMZ)              00122700
C                                                                       00122800
C-----------------------------------------------------------------------00122900
C                                                                       00123000
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           00123100
C                                                                       00123200
C-----------------------------------------------------------------------00123300
C                                                                       00123400
      RETURN                                                            00123500
      END                                                               00123600
