C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       INTRP                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      INTRP  (ARRAY,ILAST,DEFALT,IERROR)                              *
C  ARGUMENTS:                                                          *
C      ARRAY   REAL*4   ??IOU*  (ILAST) -                              *
C      ILAST   INTEGER  ??IOU*          -                              *
C      DEFALT  REAL     ??IOU*          -                              *
C      IERROR  INTEGER  ??IOU*          -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE INTRP ( ARRAY, ILAST, DEFALT, IERROR )                 31840004
C***********************************************************************31850004
C                                                                       31860004
C     SUBROUTINE NAME: INTERP  (INTERPOLATION)                          31870004
C                                                                       31880004
C     ENTRY POINTS: NONE                                                31890004
C                                                                       31900004
C     LANGUAGE: FORTRAN                                                 31910004
C                                                                       31920004
C     AUTHOR: E. ANDES (CREATED FROM SUBROUTINE BY G. SHIBA)            31930004
C                                                                       31940004
C     DATE WRITTEN: 12/31/84                                            31950004
C                                                                       31960004
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE 31970004
C                                                                       31980004
C     ABSTRACT: INTERPOLATES MISSING VALUES IN A GIVEN ARRAY.           31990004
C               A VALUE OF "DEFALT" INDICATES A MISSING VALUE.          32000004
C                                                                       32010004
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE                32020004
C                                                                       32030004
C        11/13/86 - GARY MURPHY                                         32040004
C        ADOPTED FROM PROGRAM STAT FOR ANMO.                            32050004
C                                                                       32060004
C***********************************************************************32070004
C                                                                       32080004
      REAL    * 4  ARRAY(ILAST)                                         32090004
C                                                                       32100004
      IERROR  = 0                                                       32110004
C                                                                       32120004
C---- SET STARTING POSITION TO SEARCH                                   32130004
C---- FOR FIRST NON-DEFAULTED ELEMENT                                   32140004
      I1 = 1                                                            32150004
C                                                                       32160004
C---- CHECK TO SEE IF BEGINNING                                         32170004
C---- OF ARRAY HAS BLANKS ("DEFAULT").   IF SO                          32180004
C---- WE WILL EXTRAPOLATE OUT TO THE                                    32190004
C---- FIRST NON-BLANK POSITION USING                                    32200004
C---- THE FIRST NON-BLANK VALUE....                                     32210004
      IF ( ARRAY(I1) .NE. DEFALT ) GO TO 300                            32220004
C                                                                       32230004
C---- FIND FIRST NON-BLANK ENTRY                                        32240004
      DO 50 J = 2,ILAST                                                 32250004
         IF ( ARRAY(J) .NE. DEFALT ) GO TO 150                          32260004
   50 CONTINUE                                                          32270004
C                                                                       32280004
C---- NO NEED TO INTERPOLATE ANY VALUES                                 32290004
      GO TO 700                                                         32300004
C                                                                       32310004
C---- FILL IN LEADING BLANK(S) WITH FIRST                               32320004
C---- VALID ENTRY...                                                    32330004
  150 K = J - 1                                                         32340004
      DO 200 M = 1,K                                                    32350004
         ARRAY(M) = ARRAY(J)                                            32360004
  200 CONTINUE                                                          32370004
C                                                                       32380004
      GO TO 300                                                         32390004
C                                                                       32400004
C---- FIND THE NEXT                                                     32410004
C---- NON-DEFAULTED ELEMENT                                             32420004
  250 I1     = I1 + 1                                                   32430004
  300 ICOUNT = 0                                                        32440004
C                                                                       32450004
C---- FIND NUMBER OF BLANKS                                             32460004
C---- BETWEEN VALID ENTRIES....                                         32470004
      DO 350 I = I1,ILAST                                               32480004
         IF ( ARRAY(I) .NE. DEFALT ) GO TO 400                          32490004
         ICOUNT = ICOUNT + 1                                            32500004
         IF ( I .EQ. ILAST ) GO TO 550                                  32510004
  350 CONTINUE                                                          32520004
C                                                                       32530004
  400 IF ( ICOUNT .EQ. 0 ) GO TO 500                                    32540004
C                                                                       32550004
C---- DETERMINE INTERPOLATION INCREMENT...                              32560004
      SLOPE    = ( ARRAY(I) - ARRAY(I1-1) ) / ( ICOUNT + 1 )            32570004
      I2       = I - 1                                                  32580004
C                                                                       32590004
      DO 450 J = I1,I2                                                  32600004
         ARRAY(J) = ARRAY(J-1) + SLOPE                                  32610004
  450 CONTINUE                                                          32620004
C                                                                       32630004
  500 IF ( I1 .NE. ILAST ) GO TO 250                                    32640004
      GO TO 700                                                         32650004
C                                                                       32660004
C---- FILL IN TRAILING BLANKS WITH LAST                                 32670004
C---- VALID ENTRY...                                                    32680004
  550 K = ILAST - ICOUNT + 1                                            32690004
      DO 600 L = K,ILAST                                                32700004
         ARRAY(L) = ARRAY(K-1)                                          32710004
  600 CONTINUE                                                          32720004
C                                                                       32730004
  700 RETURN                                                            32740004
      END                                                               32750004
