C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SBOS                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SBOS  (KX,XC,NP,X,MP,ISV)                                       *
C  ARGUMENTS:                                                          *
C      KX      INTEGER*2  ??IOU*  (2) -                                *
C      XC      REAL       ??IOU*      -                                *
C      NP      INTEGER    ??IOU*      -                                *
C      X       REAL       ??IOU*  (2) -                                *
C      MP      INTEGER    ??IOU*      -                                *
C      ISV     INTEGER    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C SUBROUTINE ID. SBOS                                                   00175200
C FUNCTION. FIND A LOCATION IN AN ORDERED LIST (LOW TO HIGH) BY         00175300
C   SEARCHING BINARY OR SINGLE STEP.                                    00175400
C AUTHOR. ELDON POWERS                                                  00175500
C DATE WRITTEN. 72-7-1                                                  00175600
C DETAILED DESCRIPTION.                                                 00175700
C   THE LOCATION OF XC IS FOUND IN THE KX ARRAY WHICH POINTS TO         00175800
C     THE X ARRAY.  SEARCH IS BINARY OR SINGLE STEP.                    00175900
C   MP=0 WHEN ISV IS GIVEN AS A STARTING LOCATION AND SINGLE STEP       00176000
C     SEARCH IS USED.                                                   00176100
C   MP.NE.0 WHEN BINARY SEARCH IS USED                                  00176200
C   ISV IS RETURNED AS THE LOCATION IN THE KX(K) ARRAY FOR XC, SUCH     00176300
C     THAT X(KX(ISV)).LE.XC.AND.X(KX(ISV+1)).GE.XC  WHERE KX(ISV) AND   00176400
C     KX(ISV+1) ARE DEFINABLE WITH VALID SUBSCRIPTS.                    00176500
C SUBROUTINES CALLED. NONE                                              00176600
      SUBROUTINE SBOS(KX,XC,NP,X,MP,ISV)                                00176700
      INTEGER*2 KX(2)                                                   00176800
      DIMENSION X(2)                                                    00176900
      IF(MP)801,7015,801                                                00177000
C BEGIN BINARY SEARCH.  NH IS COMPUTED AS STARTING VALUE.               00177100
  801 NH=(NP+1)/2                                                       00177200
      KXI=KX(1)                                                         00177300
      IF(XC-X(KXI  ))603,604,605                                        00177400
C ISV IS RETURNED AS 0 WHEN XC.LT.X(KX(1))                              00177500
  603 ISV=0                                                             00177600
      GO TO 606                                                         00177700
  604 ISV=1                                                             00177800
      GO TO 606                                                         00177900
 1605 NB=1                                                              00178000
      NE=NP                                                             00178100
  611 KXI=KX(NH)                                                        00178200
      IF(XC-X(KXI))607,608,609                                          00178300
  607 NE=NH                                                             00178400
      NH=(NB+NE)/2                                                      00178500
      IF(NB-NH)611,608,611                                              00178600
  608 ISV=NH                                                            00178700
      GO TO 606                                                         00178800
  609 NB=NH                                                             00178900
      NH=(NB+NE+1)/2                                                    00179000
      IF(NE-NH)611,613,611                                              00179100
  613 ISV=NH-1                                                          00179200
      GO TO 606                                                         00179300
  605 KXI=KX(NP)                                                        00179400
      IF(XC-X(KXI   ))1605,1606,1606                                    00179500
C ISV IS RETURNED AS THE VALUE OF NP WHEN XC.GT.X(KX(NP))               00179600
 1606 ISV=NP                                                            00179700
      GO TO 606                                                         00179800
C BEGIN THE SINGLE STEP SEARCH.                                         00179900
 7015 IF(ISV)1,1,2                                                      00180000
    1 ISV=1                                                             00180100
      GO TO 7012                                                        00180200
    2 IF(ISV-NP)7012,7012,3                                             00180300
    3 ISV=NP                                                            00180400
 7012 K=KX(ISV)                                                         00180500
      IF(X(K)-XC)7001,606,7003                                          00180600
 7001 ISV=ISV+1                                                         00180700
      IF(ISV-NP)7004,7004,7005                                          00180800
 7005 ISV=ISV-1                                                         00180900
      GO TO 606                                                         00181000
 7004 K=KX(ISV)                                                         00181100
      IF(X(K)-XC)7001,606,7005                                          00181200
 7003 ISV=ISV-1                                                         00181300
      IF(ISV)606,606,7009                                               00181400
 7009 K=KX(ISV)                                                         00181500
      IF(X(K)-XC)606,606,7003                                           00181600
  606 RETURN                                                            00181700
      END                                                               00181800
