C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SRTIDX                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SRTIDX  (ARRAY,INDEX,KOUNT)                                     *
C      SRTBUF  (IBUF,ICOUNT)                                           *
C  ARGUMENTS:                                                          *
C      ARRAY   REAL*4     ??IOU*  (KOUNT) -                            *
C      INDEX   INTEGER*2  ??IOU*  (KOUNT) -                            *
C      KOUNT   INTEGER    ??IOU*          -                            *
C      IBUF    INTEGER*2  ??IOU*  (1)     -                            *
C      ICOUNT  INTEGER    ??IOU*          -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      2 DETECTED                               *
C      REAL*                                                           *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C     ENTRY POINT:     SRTBUF  (SORT BUFFER)                            00124000
C                                                                       00124100
C     LANGUAGE: FORTRAN                                                 00124200
C                                                                       00124300
C     AUTHOR: ?.?????                                                   00124400
C                                                                       00124500
C     DATE WRITTEN: ??/??/??                                            00124600
C                                                                       00124700
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE 00124800
C                                                                       00124900
C     ABSTRACT: SORTS AN ARRAY OF NUMBERS IN INCREASING ORDER OF        00125000
C               MAGNITUDE. THIS SUBROUTINE SORTS THE INDEXES            00125100
C               POINTING TO THE ELEMENTS IN THE ARRAY ('SRTIDX'),       00125200
C               OR SORTS THE ELEMENTS IN THE ARRAY ('SRTBUF').          00125300
C               SORTING IS PERFORMED USING THE "SHELL SORT".            00125400
C                                                                       00125500
C     CALLING SEQUENCE: CALL SRTIDX(ARRAY, INDEX, KOUNT)                00125600
C                WHERE:    ARRAY - BUFFER OF NUMBERS TO BE SORTED       00125700
C                          INDEX - BUFFER OF SORTED INDEXES POINTING    00125800
C                                  TO "ARRAY"                           00125900
C                          KOUNT - NUMBER OF ELEMENTS IN "ARRAY"        00126000
C                                  & "INDEX"                            00126100
C                                                                       00126200
C     CALLING SEQUENCE: CALL SRTBUF(IBUF, ICOUNT)                       00126300
C                WHERE:   IBUF   - BUFFER OF NUMBERS TO BE SORTED       00126400
C                         ICOUNT - NUMBER OF ELEMENTS IN "IBUF"         00126500
C                                                                       00126600
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE                00126700
C                                                                       00126800
C***********************************************************************00126900
C                                                                       00127000
C                                                                       00127100
      SUBROUTINE SRTIDX(ARRAY, INDEX, KOUNT)                            00127200
C                                                                       00127300
C                                                                       00127400
C-----------------------------------------------------------------------00127500
C                                                                       00127600
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS                      00127700
C                                                                       00127800
C-----------------------------------------------------------------------00127900
C                                                                       00128000
      REAL*4    ARRAY                                                   00128100
C                                                                       00128200
      INTEGER*2 INDEX                                                   00128300
      INTEGER*2 IBUF                                                    00128400
C                                                                       00128500
      DIMENSION ARRAY (KOUNT), INDEX (KOUNT)                            00128600
      DIMENSION IBUF  (    1)                                           00128700
C                                                                       00128800
C-----------------------------------------------------------------------00128900
C                                                                       00129000
C     SET UP BUFFER OF INDEXES IF SORTING BY INDEXES                    00129100
C                                                                       00129200
C-----------------------------------------------------------------------00129300
C                                                                       00129400
      ITYPE             = 0                                             00129500
C                                                                       00129600
      DO 100 I = 1,KOUNT                                                00129700
         INDEX(I)       = I                                             00129800
  100 CONTINUE                                                          00129900
C                                                                       00130000
      GO TO 150                                                         00130100
C                                                                       00130200
C=======================================================================00130300
C                                                                       00130400
C                                                                       00130500
      ENTRY SRTBUF(IBUF, ICOUNT)                                        00130600
C                                                                       00130700
C                                                                       00130800
C=======================================================================00130900
C                                                                       00131000
C     SET FLAG FOR SORTING BUFFER EXACTLY                               00131100
C                                                                       00131200
C-----------------------------------------------------------------------00131300
C                                                                       00131400
      ITYPE             = 1                                             00131500
      KOUNT             = ICOUNT                                        00131600
C                                                                       00131700
C-----------------------------------------------------------------------00131800
C                                                                       00131900
C     PERFORM THE 'SHELL SORT'                                          00132000
C                                                                       00132100
C-----------------------------------------------------------------------00132200
C                                                                       00132300
  150 CONTINUE                                                          00132400
C                                                                       00132500
      N                 = KOUNT                                         00132600
      M                 = N                                             00132700
C                                                                       00132800
  200 CONTINUE                                                          00132900
C                                                                       00133000
      M                 = M / 2                                         00133100
      IF(M .EQ. 0)        GO TO 600                                     00133200
      K                 = N - M                                         00133300
      J                 = 1                                             00133400
C                                                                       00133500
  300 CONTINUE                                                          00133600
C                                                                       00133700
      I                 = J                                             00133800
C                                                                       00133900
  400 CONTINUE                                                          00134000
C                                                                       00134100
C-----------------------------------------------------------------------00134200
C                                                                       00134300
C     SORT THE INDEXES                                                  00134400
C                                                                       00134500
C-----------------------------------------------------------------------00134600
C                                                                       00134700
      IF(ITYPE           .NE.                 0) GO TO 410              00134800
      IF(ARRAY(INDEX(I)) .LE. ARRAY(INDEX(I+M))) GO TO 500              00134900
      ISAVE             = INDEX(I)                                      00135000
      INDEX(I)          = INDEX(I+M)                                    00135100
      INDEX(I+M)        = ISAVE                                         00135200
      GO TO 450                                                         00135300
C                                                                       00135400
C-----------------------------------------------------------------------00135500
C                                                                       00135600
C     SORT THE BUFFER ELEMENTS                                          00135700
C                                                                       00135800
C-----------------------------------------------------------------------00135900
C                                                                       00136000
  410 CONTINUE                                                          00136100
C                                                                       00136200
      IF(IBUF(I) .LE. IBUF(I+M)) GO TO 500                              00136300
      ISAVE             = IBUF(I)                                       00136400
      IBUF(I)           = IBUF(I+M)                                     00136500
      IBUF(I+M)         = ISAVE                                         00136600
C                                                                       00136700
  450 CONTINUE                                                          00136800
C                                                                       00136900
      I                 = I - M                                         00137000
      IF(I .GE. 1)        GO TO 400                                     00137100
C                                                                       00137200
  500 CONTINUE                                                          00137300
C                                                                       00137400
      J                 = J + 1                                         00137500
C                                                                       00137600
      IF(J .GT. K)        GO TO 200                                     00137700
      GO TO 300                                                         00137800
C                                                                       00137900
C-----------------------------------------------------------------------00138000
C                                                                       00138100
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           00138200
C                                                                       00138300
C-----------------------------------------------------------------------00138400
C                                                                       00138500
  600 CONTINUE                                                          00138600
C                                                                       00138700
      RETURN                                                            00138800
      END                                                               00138900
