C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PRINT                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PRINT  (A,NY,NX,NR)                                             *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NX+1)*(NY+1)*(NR)) -                 *
C      NY      INTEGER  ??IOU*                       -                 *
C      NX      INTEGER  ??IOU*                       -                 *
C      NR      INTEGER  ??IOU*                       -                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      26  ( OUTPUT SEQUENTIAL ) -                                     *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      subroutine print(a,ny,nx,nr)
      integer ny,nx,nr
      real a((nx+1)*(ny+1)*(nr))
 
      nxmax = 10
      nymax = 10
      if(nx.lt.nxmax)nxmax=nx
      if(ny.lt.nymax)nymax=ny
 
         k = k + 1
         write(26,*)k
 
      do 100 iy = 1,nymax
          write(26,17)(a((ix-1)*(ny+1)+iy),ix=1,nxmax)
17        format(10(1x,F7.4))
100   CONTINUE
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RDISCO                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RDISCONT  (E,ESUM,NZ,NT)                                        *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)) -                      *
C      ESUM    REAL     ??IOU*  ((NT+1)*(NZ+1)) -                      *
C      NZ      INTEGER  ??IOU*                  -                      *
C      NT      INTEGER  ??IOU*                  -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/11/21  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE RDISCONT(E,ESUM,NZ,NT)
      INTEGER NZ,NT
      REAL E((NT+1)*(NZ+1)),ESUM((NT+1)*(NZ+1))
 
#include "apkr.h"
 
      DO 100 IZ=1,NZ+1
         ITE1=0
         ITESUM1=0
         ITE2=0
         ITESUM2=0
         DO 200 IT=1,NT
	   IE = (IT-1)*ITRSZ+IZ
           IF(ITE1.EQ.0.AND.E(IE).LT.BIGNUM)ITE1=IT
           IF(ITESUM1.EQ.0.AND.ESUM(IE).LT.BIGNUM)ITESUM1=IT
           IF(ITESUM1*ITE1.NE.0)GOTO 201
200      CONTINUE
201      CONTINUE
         DO 300 IT=NT,1,-1
	   IE = (IT-1)*ITRSZ+IZ
           IF(ITE2.EQ.0.AND.E(IE).LT.BIGNUM)ITE2=IT
           IF(ITESUM2.EQ.0.AND.ESUM(IE).LT.BIGNUM)ITESUM2=IT
           IF(ITESUM2*ITE2.NE.0)GOTO 301
300      CONTINUE
301      CONTINUE
C         print*,"IZ=",IZ," ITE1=",ITE1," ITE2=",ITE2,
C     &   " ITESUM1=",ITESUM1," ITESUM2=",ITESUM2
 
C---------------------------------------------------------
         IF(ITE2+1.LT.ITESUM1)THEN
C         print*," 1]DISCONT Z=",IZ,"  ITE2=",ITE2," ITESUM1=",ITESUM1
           IE2 = (ITE2-1)*ITRSZ+IZ
           IESUM1=(ITESUM1-1)*ITRSZ+IZ
           ESUM(IE2)=ESUM(IESUM1)
C         print*,"  ESUM[",ITE2,"]=",ESUM(IE2)
C          DO 400 IT=ITESUM1-1,ITE2+1,-1
C             IE = (IT-1)*ITRSZ+IZ
C             ESUM(IE2) = ESUM(IE2)+E(IE)
C             print*,"   +",E(IE)
C400        CONTINUE
         ENDIF
         IF(ITESUM2.LT.ITE1)THEN
C         print*," 2]DISCONT Z=",IZ," ITESUM2=",ITESUM2," ITE1=",ITE1
           IE1 = (ITE1-1)*ITRSZ+IZ
           IESUM2=(ITESUM2-1)*ITRSZ+IZ
           ESUM(IE1)=ESUM(IESUM2)
C         print*,"  ESUM[",ITE1,"]=",ESUM(IE1)
C           DO 500 IT=ITESUM2,ITE1-1
C             IE = (IT-1)*ITRSZ+IZ
C             ESUM(IE1) = ESUM(IE1)+E(IE)
C             print*,"   +",E(IE)
C500        CONTINUE
         ENDIF
 
100   CONTINUE
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FORDPR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FORDPRT  (E,ETOT,EREC,ERECLAST,NZ,NT,NR,PATHTYPE)               *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR)                     *
C      ETOT    REAL     ??IOU*  ((NT+1)*(NZ+1)*(NR+1))                 *
C      EREC    REAL     ??IOU*  ((NT+1)*(NZ+1))                        *
C      ERECLA  REAL     ??IOU*  ((NT+1)*(NZ+1))                        *
C      NZ      INTEGER  ??IOU*                                         *
C      NT      INTEGER  ??IOU*                                         *
C      NR      INTEGER  ??IOU*                                         *
C      PATHTY  INTEGER  ??IOU*  (4)                                    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR  -                                                         *
C      VMOV  -                                                         *
C      VFILL -                                                         *
C      RDISCO -                                                        *
C      DPRT  -                                                         *
C      VADD  -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/11/21 ==================   *
C      DISCON -                                                        *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE FORDPRT(E,ETOT,EREC,ERECLAST,NZ,NT,NR,PATHTYPE)
      INTEGER NZ,NT,NR
      REAL E((NT+1)*(NZ+1)*NR),ETOT((NT+1)*(NZ+1)*(NR+1))
      INTEGER PATHTYPE(4)
      REAL EREC((NT+1)*(NZ+1)),ERECLAST((NT+1)*(NZ+1))
 
      INTEGER I
 
#include "apkr.h"
 
 
      CALL VCLR(EREC,1,IRECSZ)
      DO 100 IR=2,NR+1
       print*,"RECORD ",IR-1
          I = (IR-2)*IRECSZ+1
          IE = (IR-1)*IRECSZ+1
 
          CALL VMOV(EREC,1,ERECLAST,1,IRECSZ)
          CALL VFILL(BIGNUM,EREC,1,IRECSZ)
          CALL RDISCONT(E(I),ERECLAST,NZ,NT)
          CALL DPRT(E(I),EREC,ERECLAST,NZ,NT,PATHTYPE)
 
C          CALL VADD(ETOT(IE),1,EREC,1,ETOT(IE),1,IRECSZ)
          CALL VADD(ETOT(I),1,EREC,1,ETOT(I),1,IRECSZ)
100   CONTINUE
 
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       REVDPR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      REVDPRT  (E,ETOT,EREC,ERECLAST,NZ,NT,NR,PATHTYPE)               *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR)                     *
C      ETOT    REAL     ??IOU*  ((NT+1)*(NZ+1)*(NR+1))                 *
C      EREC    REAL     ??IOU*  ((NT+1)*(NZ+1))                        *
C      ERECLA  REAL     ??IOU*  ((NT+1)*(NZ+1))                        *
C      NZ      INTEGER  ??IOU*                                         *
C      NT      INTEGER  ??IOU*                                         *
C      NR      INTEGER  ??IOU*                                         *
C      PATHTY  INTEGER  ??IOU*  (4)                                    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR  -                                                         *
C      VMOV  -                                                         *
C      VFILL -                                                         *
C      RDISCO -                                                        *
C      DPRT  -                                                         *
C      VADD  -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE REVDPRT(E,ETOT,EREC,ERECLAST,NZ,NT,NR,PATHTYPE)
      INTEGER NZ,NT,NR
      REAL E((NT+1)*(NZ+1)*NR),ETOT((NT+1)*(NZ+1)*(NR+1))
      INTEGER PATHTYPE(4)
      REAL EREC((NT+1)*(NZ+1)),ERECLAST((NT+1)*(NZ+1))
 
      INTEGER I
 
#include "apkr.h"
 
 
      CALL VCLR(EREC,1,IRECSZ)
      DO 100 IR=NR,1,-1
          I = (IR-1)*IRECSZ+1
          WRITE(*,*)'REVDPRT IR=',IR
 
          CALL VMOV(EREC,1,ERECLAST,1,IRECSZ)
          CALL VFILL(BIGNUM,EREC,1,IRECSZ)
          CALL RDISCONT(E(I),ERECLAST,NZ,NT)
          CALL DPRT(E(I),EREC,ERECLAST,NZ,NT,PATHTYPE)
 
          CALL VADD(ETOT(I),1,EREC,1,ETOT(I),1,IRECSZ)
100   CONTINUE
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DPRT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DPRT  (A,E,ELAST,NZ,NT,PATHTYPE)                                *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)) -                      *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)) -                      *
C      ELAST   REAL     ??IOU*  ((NT+1)*(NZ+1)) -                      *
C      NZ      INTEGER  ??IOU*                  -                      *
C      NT      INTEGER  ??IOU*                  -                      *
C      PATHTY  INTEGER  ??IOU*  (4)             -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/07/30 ==================   *
C      FILES   NUMERIC    ??IOU* -                                     *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE DPRT(A,E,ELAST,NZ,NT,PATHTYPE)
      INTEGER NZ,NT
      REAL A((NT+1)*(NZ+1)),E((NT+1)*(NZ+1)),ELAST((NT+1)*(NZ+1))
      INTEGER PATHTYPE(4)
 
      REAL AA,E0,E1,E2,SINPHI,COSPHI,ETEMP,TR0,R0
      INTEGER IT,IZ,IE,IE1
      REAL SMALLNUM
 
#include "apkr.h"
 
      SMALLNUM = 0
 
      DO 100 IZ=1,NZ
 
CCDIR$ IVDEP
          DO 200 IT=2,NT+1
	      IE = (IT-1)*ITRSZ+IZ
	      IE1 = (IT-2)*ITRSZ+IZ
	      IA = IE1
	      AA = A(IA)
C             --------------------------------------------------------
C	             PATHTYPE 1          0 < COSPHI < COSDGLRT
C	
C             --------------------------------------------------------
	      IF (PATHTYPE(1) .EQ. 1 .AND. AA .GT.SMALLNUM) THEN
		  E1 = ELAST(IE1)
		  E2 = E(IE1)
		  COSPHI = (E2-E1)/(AA*DR)
		
		  IF ( COSPHI .GE. COSDGLRT) THEN
		      ETEMP=E1+AA*DSTDGLRT
		  ELSE IF(COSPHI.LE.0) THEN
		      ETEMP=E2+AA*DT
		  ELSE
		      R0= -DT*COSPHI/SQRT(1.0-COSPHI*COSPHI)
		      E0= (-E1*R0+E2*(DR+R0))*DRINV
		      ETEMP = E0+AA*SQRT(DT2+R0*R0)
		  ENDIF
 
 
C	          -------UPDATE E IF ETEMP IS LESS---------
		  IF (ETEMP.LT.E(IE)) E(IE)=ETEMP
	      ENDIF
 
			
C             --------------------------------------------------------
C	             PATHTYPE 2        0 < SINPHI < SINDGLRT
C	
C             --------------------------------------------------------
	      IF (PATHTYPE(2).EQ.1 .AND. AA.GT.SMALLNUM) THEN
		  E1 = ELAST(IE1)
		  E2 = ELAST(IE)
		  SINPHI = (E2-E1)/(AA*DT)
	
		  IF (SINPHI.LE.0) THEN
		      ETEMP = E2 + AA*DR
		  ELSE IF (SINPHI.GE.SINDGLRT) THEN
		      ETEMP = E1 + AA*DSTDGLRT
		  ELSE
		      TR0 = -DR*SINPHI/SQRT(1.0-SINPHI*SINPHI)
		      E0 = (-E1*TR0+E2*(DT+TR0))*DTINV
		      ETEMP = E0+AA*SQRT(TR0*TR0+DR2)
		  ENDIF
 
C	          -------UPDATE E IF ETEMP IS LESS---------
		  IF (ETEMP.LT.E(IE)) E(IE)=ETEMP
	      ENDIF
 
200	  CONTINUE
 
CCDIR$ IVDEP
	  DO 210 IT=NT,1,-1
	      IE = (IT-1)*ITRSZ+IZ
	      IE1 = IT*ITRSZ+IZ
	      IA = IE
	      AA = A(IA)
 
 
C             --------------------------------------------------------
C	             PATHTYPE 3        SINDGLRT < SINPHI < 0
C	
C             --------------------------------------------------------
	      IF (PATHTYPE(3).EQ.1 .AND. AA.GT.SMALLNUM) THEN
		  E1 = ELAST(IE1)
		  E2 = ELAST(IE)
		  SINPHI = (E1-E2)/(AA*DT)
	
	          IF (SINPHI.GE.0) THEN
		      ETEMP = E2+AA*DR
		  ELSE IF (SINPHI.LE.-SINDGLRT) THEN
		      ETEMP = E1+AA*DSTDGLRT
		  ELSE
		      TR0 = -DR*SINPHI/SQRT(1.0-SINPHI*SINPHI)
		      E0 = (E1*TR0+E2*(DT-TR0))*DTINV
		      ETEMP = E0+AA*SQRT(TR0*TR0+DR2)
		  ENDIF
 
C	          -------UPDATE E IF ETEMP IS LESS---------
		  IF (ETEMP.LT.E(IE)) E(IE)=ETEMP
	      ENDIF
 
 
C             --------------------------------------------------------
C	             PATHTYPE 4        0 < COSPHI < COSDGLRT
C	
C             --------------------------------------------------------
	      IF (PATHTYPE(4).EQ.1 .AND. AA.GT.SMALLNUM) THEN
		  E1 = ELAST(IE1)
		  E2 = E(IE1)
		  COSPHI = (E2-E1)/(AA*DR)
 
	          IF (COSPHI.LE.0) THEN
		      ETEMP = E2+AA*DT
		  ELSE IF (COSPHI.GE.COSDGLRT) THEN
		      ETEMP = E1+AA*DSTDGLRT
		  ELSE
		      R0 = -DT*COSPHI/SQRT(1.0-COSPHI*COSPHI)
		      E0 = (-E1*R0+E2*(DR+R0))*DRINV
		      ETEMP = E0+AA*SQRT(DT2+R0*R0)
		  ENDIF
 
C	          -------UPDATE E IF ETEMP IS LESS---------
		  IF (ETEMP.LT.E(IE)) E(IE)=ETEMP
	      ENDIF
 
210	  CONTINUE
100   CONTINUE
 
      RETURN
      END
 
 
 
 
 
 
