C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       READPI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      READPICK  (LUPICK,PICKNUM,RECPICK,TRPICK,SAMPPICK,NPICK)        *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/08/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C***********************************************************************
c  update history
c  may 27, 1992              gary murphy                   revision 2.2
c  added countpicks subroutine and made readpick read an arbitrary
c  number of cards.  dimensioned arrays to passed length (npick) for
c  compiler assisted bounds checking and debugging.  added some print
c  messages.
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C READPICK reads an xsd pickfile and converts the picks to record
C trace and sample units.
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      subroutine countpicks (lupick, npick)
      CHARACTER*128 CARD
      i = 0
1     continue
      read (lupick, 10, end=999) card
10    format (A128)
         if (card(1:5).ne.'Units' .and. card(1:7).ne.'Segment')then
            i = i + 1
         endif
      goto 1
999   continue
      npick = i
      if (npick .le. 0) then
         print *, 'warning:  no picks read in'
      else
         print *, 'number of picks ', npick
      endif
      rewind (lupick)
      return
      end

      SUBROUTINE READPICK(LUPICK,PICKNUM,RECPICK,TRPICK,
     &                     SAMPPICK,NPICK)
      INTEGER LUPICK,PICKNUM(npick+1),RECPICK(npick+1),TRPICK(npick+1)
      INTEGER SAMPPICK(npick+1),NPICK
      CHARACTER*128 CARD
 
      INTEGER NREC,NTR,NSAMP
      REAL RECUNIT,TRUNIT,SAMPUNIT
 
#include "apkr.h"
 
 
      I=1
10    continue
      READ(LUPICK,77,END=999)CARD
77    FORMAT(A128)
          IF(CARD(1:5).EQ.'Units')THEN
              READ(card,78)RECUNIT,TRUNIT,SAMPUNIT,NREC,
     &          NTR,NSAMP
78             FORMAT(6X,F12.6,1X,F12.6,1X,F12.6,I9,I7,I7)
 
          ELSE IF(CARD(1:7).EQ.'Segment')THEN
              READ(card,79)PICKNUM(I)
79            FORMAT(9X,I7)
              OLDPICKN = PICKNUM(I)
 
          ELSE
              READ(card,80)REC,TR,SAMP
80            FORMAT(F12.6,1X,F12.6,1X,F12.6)
              RECPICK(I)=REC
              TRPICK(I)=TR
              IF(SAMPUNIT.NE.0)SAMPPICK(I)=SAMP/SAMPUNIT
              PICKNUM(I)=OLDPICKN
              I=I+1
          ENDIF
      GOTO 10
999   CONTINUE
      if (npick .ne. i-1) then
         print *, 'warning - number of picks read is ', i-1
         print *, 'expected ', npick
      end if
      RETURN
      END
 
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PICKCN                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PICKCNTL  (A,PICKNUM,RECPICK,TRPICK,SAMPPICK,NPICK,NREC,NTR,    *
C                 NSAMP,FIRSTREC,RECINC,NUMRECS,P1STREC,PRECINC,       *
C                 TOLERNCE)                                            *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  PICKCNTL applies the user picks to the error surface A() by
C  creating barriers of infinite error.  The infinite errors are
C  created by storing negative numbers in the error surface.
C  These negative error values will be interpreted later as
C  infinite errors.
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE PICKCNTL(A,PICKNUM,RECPICK,TRPICK,SAMPPICK,
     &                    NPICK,NREC,NTR,NSAMP,
     &          FIRSTREC,RECINC,NUMRECS,P1STREC,PRECINC,TOLERNCE)
      INTEGER NPICK,NREC,NTR,NSAMP
      REAL A((NTR+1)*(NSAMP+1)*NREC)
      INTEGER PICKNUM(npick+1),RECPICK(npick+1),TRPICK(npick+1)
      INTEGER SAMPPICK(npick+1)
      INTEGER FIRSTREC,RECINC,NUMRECS,P1STREC,PRECINC,TOLERNCE
 
      INTEGER IPICK1,IPICK2,IREC1,IREC2,ITR1,ITR2,ISAMP1,ISAMP2
 
#include "apkr.h"
 
      PICKNUM(NPICK+1)=PICKNUM(NPICK)
      RECPICK(NPICK+1)=RECPICK(NPICK)
      TRPICK(NPICK+1)=TRPICK(NPICK)
      SAMPPICK(NPICK+1)=SAMPPICK(NPICK)
 
 
      jtr1 = 1
      jtr2 = 1
      DO 100 I = 1,NPICK
C         -----beginning point of pick segment--------------------
          IPICK1 =PICKNUM(I)
          IREC1 = ((RECPICK(I)-1)*PRECINC+P1STREC-FIRSTREC)/RECINC+1
          ITR1 = TRPICK(I)
          ISAMP1 = SAMPPICK(I)
C         -----ending point of pick segment-----------------------
          IPICK2 = PICKNUM(I+1)
          IREC2 = ((RECPICK(I+1)-1)*PRECINC+P1STREC-FIRSTREC)/RECINC+1
          ITR2 = TRPICK(I+1)
          ISAMP2 = SAMPPICK(I+1)
C        -----switch order of points if necessary----
          IF(ISAMP2.LT.ISAMP1)THEN
	    ITEMP=ISAMP1
	    ISAMP1=ISAMP2
	    ISAMP2=ITEMP
	    ITEMP=IPICK1
	    IPICK1=IPICK2
	    IPICK2=ITEMP
            ITEMP=IREC1
	    IREC1=IREC2
	    IREC2=ITEMP
            ITEMP=ITR1
	    ITR1=ITR2
            ITR2=ITEMP
          ENDIF
 
          IF(IREC1.LT.1.OR.IREC1.GT.NUMRECS)GOTO 100
C           write(*,*)'r=',IREC1,'(',RECPICK(I),')',
C     &     ' tr=',ITR1,' iz=',ISAMP1
 
C         -----current point---------------
          ITRCNTL = ITR1
 
C         -----handle last point of the current pick number----
          IF(IPICK1.NE.IPICK2)THEN
              IREC2 = IREC1
              ITR2 = ITR1
              ISAMP2 = ISAMP1
          ENDIF
 
C         -----loop over one segment---------------
          DO 200 ISAMP = ISAMP1,ISAMP2
C             .....last point used.....
              ITRLAST = ITRCNTL
C             .....current point and next point.......
              IF(ISAMP2.NE.ISAMP1)THEN
                  ITRCNTL = ITR1 +  (ITR2-ITR1)*(ISAMP-ISAMP1)/
     &                                 (ISAMP2-ISAMP1)
                  IF(ISAMP.LT.ISAMP2) THEN
                  ITRNEXT = ITR1 +  (ITR2-ITR1)*(ISAMP-ISAMP1+1)/
     &                                 (ISAMP2-ISAMP1)
                  ENDIF
              ELSE
                  ITRCNTL = ITR1
                  ITRNEXT = ITR1
              ENDIF
 
C             .....left and right boundaries of barrier.....
              ITRLEFT = ITRCNTL - 1 - TOLERNCE
              IF((ITRNEXT + 1 + TOLERNCE).LE.ITRLEFT)
     &              ITRLEFT=ITRNEXT + TOLERNCE
 
              ITRRIGHT = ITRCNTL + 1 + TOLERNCE
              IF((ITRNEXT-1-TOLERNCE).GE.ITRRIGHT)
     &              ITRRIGHT = ITRNEXT - TOLERNCE
 
C         ----------resolve inconsistent picks on a single record-----
              IA1=(IREC1-1)*IRECSZ    +          ISAMP
              IA2=(IREC1-1)*IRECSZ+(NTR-1)*ITRSZ+ISAMP
C             .....if a barrier already exists....
              IF(A(IA1).LT.0.OR.A(IA2).LT.0)THEN
C                .....find left edge
                 DO 333 ITR=1,NTR
                   IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
                   IF(A(IA).GT.0)THEN
                      JTR1=ITR-1
                      GOTO 334
                   ENDIF
333              CONTINUE
334              CONTINUE
C                .....find right edge
                 DO 444 ITR=NTR,1,-1
                   IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
                   IF(A(IA).GT.0)THEN
                      JTR2=ITR+1
                      GOTO 445
                   ENDIF
444              CONTINUE
445              CONTINUE
                 IF(JTR1.LT.ITRLEFT) ITRLEFT=JTR1
                 IF(JTR2.GT.ITRRIGHT) ITRRIGHT=JTR2
              ENDIF
 
              IF(ITRRIGHT.GT.NTR) ITRRIGHT=NTR+1
              IF(ITRLEFT .LT.0) ITRLEFT=0
 
 
 
C             write(*,*)'itrcntl=',itrcntl,' tolernce=',tolernce,
C     &    ' itrleft=',itrleft,' itrright=',itrright
C             write(*,*)'itrlast=',itrlast,
C     &    ' next=',itrnext
 
 
 
C      -----------set negative values for trace numbers less than ITRLEFT
                  DO 300 ITR = 1,ITRLEFT
                      IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
                      IF(A(IA).GT.0) A(IA) = -A(IA)
300               CONTINUE
 
C      -----------set positive values for trace numbers within fairway
                  DO 350 ITR = ITRLEFT+1,ITRRIGHT-1
                      IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
                      IF(A(IA).LT.0) A(IA) = -A(IA)
350               CONTINUE
 
C      -----------set negative values for trace numbers greater than ITRRIGHT
                  DO 400 ITR = ITRRIGHT,NTR
                      IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
                      IF(A(IA).GT.0) A(IA) = -A(IA)
400               CONTINUE
 
 
200       CONTINUE
 
 
C         ----check inconsistencies at beginning and end of segment-----
          ISAMP=ISAMP1-1
          DO 541 ITR=1,NTR
            IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
            IF(A(IA).GT.0)THEN
              JTR1=ITR
              GOTO 542
            ENDIF
541	  CONTINUE
542	  CONTINUE
          DO 543 ITR=NTR,1,-1
            IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
            IF(A(IA).GT.0)THEN
              JTR2=ITR
              GOTO 544
            ENDIF
543	  CONTINUE
544	  CONTINUE
          IF(JTR1.GT.ITR1)THEN
	     DO 601 ITR=ITR1,JTR1
               IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
               IF(A(IA).LT.0)A(IA)=-A(IA)
601	     CONTINUE
          ENDIF
          IF(JTR2.LT.ITR1)THEN
	     DO 602 ITR=JTR2,ITR1
               IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
               IF(A(IA).LT.0)A(IA)=-A(IA)
602	    CONTINUE
          ENDIF
 
 
C         ----check inconsistencies at beginning and end of segment-----
          ISAMP=ISAMP2+1
          DO 1541 ITR=1,NTR
            IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
            IF(A(IA).GT.0)THEN
              JTR1=ITR
              GOTO 1542
            ENDIF
1541	  CONTINUE
1542	  CONTINUE
          DO 1543 ITR=NTR,1,-1
            IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP
            IF(A(IA).GT.0)THEN
              JTR2=ITR
              GOTO 1544
            ENDIF
1543	  CONTINUE
1544	  CONTINUE
          IF(JTR1.GT.ITR2)THEN
	     DO 1601 ITR=ITR2,JTR1
               IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP-1
               IF(A(IA).LT.0)A(IA)=-A(IA)
1601	    CONTINUE
          ENDIF
          IF(JTR2.LT.ITR2)THEN
	     DO 1602 ITR=JTR2,ITR2
               IA = (IREC1-1)*IRECSZ+(ITR-1)*ITRSZ+ISAMP-1
               IF(A(IA).LT.0)A(IA)=-A(IA)
1602	    CONTINUE
          ENDIF
 
 
 
100       CONTINUE
      RETURN
      END
