C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
      subroutine CalcWeights( CDP_X, CDP_Y, Neighbor_X, Neighbor_Y, dx, 
     :     dy, Weight, mode )

c declare variables passed from calling routine

      real CDP_X, CDP_Y, Neighbor_X(4), Neighbor_Y(4), dx, dy
      real Weight(4)
      character *(*) mode

c declare local variables

      real offset(4), max_offset
      real pi, sum


      IF (mode(1:1) .eq. 'l' .or. mode(1:1) .eq. 'L') then

c Do linear weighting.

        weight(1) = abs((CDP_X-Neighbor_X(3)) * (CDP_Y-Neighbor_Y(2)))
        weight(2) = abs((CDP_X-Neighbor_X(3)) * (CDP_Y-Neighbor_Y(1)))
        weight(3) = abs((CDP_X-Neighbor_X(1)) * (CDP_Y-Neighbor_Y(2)))
        weight(4) = abs((CDP_X-Neighbor_X(1)) * (CDP_Y-Neighbor_Y(1)))
        sum = dx * dy

      ELSE

c Do cosine weighting.
c initialize variables

        do i = 1,4
           offset(i) = 0.
        enddo
        pi =  4. * atan(1.0)
        sum = 0.0

        diagonal = sqrt ( dx**2 + dy**2 )
      
        do i = 1, 4
           offset(i) = sqrt( ( Neighbor_X(i) - CDP_X )**2 + 
     :          ( Neighbor_Y(i) - CDP_Y )**2 )
           if ( i .gt. 1 ) then
              if (offset(i) .gt. offset(i-1)) max_offset = offset(i)
           endif
        enddo

        if (max_offset .gt. diagonal) diagonal = max_offset + diagonal

        do i = 1, 4
           call CosTaper ( offset(i), 0.0, diagonal, weight(i), pi, 1 )
           sum = sum + weight(i)
        enddo

      ENDIF

c normalize

      do i = 1, 4
         weight(i) = weight(i) / sum
      enddo

      return
      end
