C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     call cdpXY_lite ( Vertex_XY_Transformed, NumVertices, CdpInt, 
c    :     CDP_XY_Transformed, nreco, SZLNHD)
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
      subroutine cdpXY_lite (Vertex_XY,NumVertices,CdpInt, 
     :                       CDP_XY,nreco,MaxSize)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C DECLARATIONS, DEFINITIONS, & INITIALIZATIONS

      integer NumVertices, nreco, MaxSize, icount, CDPsOnSeg
      real    Vertex_XY(2,NumVertices), CDP_XY(2,MaxSize)
      real    TotalLength, SegLength, DeltaX, DeltaY
      real    StartupLengthX, StartupLengthY, StartupLength
      real    LeftOverLength

c get total output line length and number of output CDPs

      TotalLength = 0.0

      do i = 2,NumVertices
         DeltaX = Vertex_XY(1,i) - Vertex_XY(1,i-1)
         DeltaY = Vertex_XY(2,i) - Vertex_XY(2,i-1)
         SegLength = sqrt(DeltaX*DeltaX + DeltaY*DeltaY)
         TotalLength = TotalLength + SegLength
      enddo

      nreco = int(TotalLength/CdpInt)+1

c extract cdp x,y pairs one segment at a time

      icount = 0
      LeftOverLength = CdpInt

      do i = 2,NumVertices

         StartupLength  = CdpInt - LeftOverLength

         DeltaX = Vertex_XY(1,i) - Vertex_XY(1,i-1)
         DeltaY = Vertex_XY(2,i) - Vertex_XY(2,i-1)
         SegLength = sqrt(DeltaX*DeltaX + DeltaY*DeltaY)
         CDPsOnSeg = int((SegLength - StartupLength)/CdpInt) +1
         DeltaX = DeltaX / (SegLength/CdpInt)
         DeltaY = DeltaY / (SegLength/CdpInt)

         StartupLengthX = StartupLength/CdpInt * DeltaX
         StartupLengthY = StartupLength/CdpInt * DeltaY

         do j = 1, CDPsOnSeg
            icount = icount + 1
            CDP_XY(1,icount) =  Vertex_XY(1,i-1)
     :                        + StartupLengthX + (j-1)*DeltaX
            CDP_XY(2,icount) =  Vertex_XY(2,i-1)
     :                        + StartupLengthY + (j-1)*DeltaY
         enddo
            
         LeftOverLength =  SegLength - StartupLength
     :                   - float(CDPsOnSeg-1)*CdpInt

      enddo

 600  continue
      RETURN
      END
